/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.analytics.tracking;

import io.conduktor.analytics.tracking.AnalyticsObject;
import io.conduktor.analytics.tracking.ObjectActionKt;
import java.net.URI;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0006\u001a\u00020\t\u001a\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000b2\u0006\u0010\n\u001a\u00020\b\u001a\n\u0010\u000e\u001a\u00020\b*\u00020\b\u001a\n\u0010\u000f\u001a\u00020\b*\u00020\b\u001a*\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000b*\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000b2\u0006\u0010\u0006\u001a\u00020\t\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\u00a8\u0006\u0011"}, d2={"camelRegex", "Lkotlin/text/Regex;", "getCamelRegex", "()Lkotlin/text/Regex;", "snakeRegex", "getSnakeRegex", "origin", "", "", "Lio/conduktor/analytics/tracking/AnalyticsObject;", "url", "", "uri", "Ljava/net/URI;", "camelcase", "kebabcase", "withOrigin", "desktop"})
public final class ObjectActionKt {
    @NotNull
    private static final Regex camelRegex = new Regex("(?<=[a-zA-Z])[A-Z]");
    @NotNull
    private static final Regex snakeRegex = new Regex("_[a-zA-Z]");

    @NotNull
    public static final Regex getCamelRegex() {
        return camelRegex;
    }

    @NotNull
    public static final String kebabcase(@NotNull String $this$kebabcase) {
        String string = camelRegex.replace((CharSequence)$this$kebabcase, (Function1)kebabcase.1.INSTANCE).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        return string;
    }

    @NotNull
    public static final Regex getSnakeRegex() {
        return snakeRegex;
    }

    @NotNull
    public static final String camelcase(@NotNull String $this$camelcase) {
        String string = $this$camelcase.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        return snakeRegex.replace((CharSequence)string, (Function1)camelcase.1.INSTANCE);
    }

    @NotNull
    public static final Map<String, String> origin(@NotNull AnalyticsObject origin) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"origin", (Object)origin.name())};
        return MapsKt.mutableMapOf((Pair[])pairArray);
    }

    @NotNull
    public static final Map<String, String> withOrigin(@NotNull Map<String, String> $this$withOrigin, @NotNull AnalyticsObject origin) {
        return MapsKt.plus((Map)MapsKt.toMutableMap($this$withOrigin), ObjectActionKt.origin(origin));
    }

    @NotNull
    public static final Map<String, String> url(@NotNull String url2) {
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"url", (Object)url2));
    }

    @NotNull
    public static final Map<String, String> url(@NotNull URI uri) {
        return ObjectActionKt.url(uri.toString());
    }
}

