/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.client.util;

import io.confluent.ksql.api.client.ColumnType;
import io.confluent.ksql.api.client.impl.ColumnTypeImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class RowUtil {
    private RowUtil() {
    }

    public static Map<String, Integer> valueToIndexMap(List<String> values) {
        HashMap<String, Integer> valueToIndex = new HashMap<String, Integer>();
        for (int i = 0; i < values.size(); ++i) {
            valueToIndex.put(values.get(i), i + 1);
        }
        return valueToIndex;
    }

    public static List<ColumnType> columnTypesFromStrings(List<String> columnTypes) {
        return columnTypes.stream().map(RowUtil::columnTypeFromString).collect(Collectors.toList());
    }

    private static ColumnType columnTypeFromString(String columnType) {
        int bracketInd = columnType.indexOf(60);
        int parenInd = columnType.indexOf(40);
        String primaryType = columnType.substring(0, Math.min(bracketInd == -1 ? columnType.length() : bracketInd, parenInd == -1 ? columnType.length() : parenInd));
        return new ColumnTypeImpl(primaryType);
    }
}

