/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.atlas.core.util;

import com.netflix.atlas.core.util.UnitPrefix;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class UnitPrefix$
implements Serializable {
    public static final UnitPrefix$ MODULE$ = new UnitPrefix$();
    private static final UnitPrefix one = new UnitPrefix("", "", 1.0);
    private static final UnitPrefix deca = new UnitPrefix("da", "deca", 10.0);
    private static final UnitPrefix hecto = new UnitPrefix("h", "hecto", 100.0);
    private static final UnitPrefix kilo = new UnitPrefix("k", "kilo", 1000.0);
    private static final UnitPrefix mega = new UnitPrefix("M", "mega", 1000000.0);
    private static final UnitPrefix giga = new UnitPrefix("G", "giga", 1.0E9);
    private static final UnitPrefix tera = new UnitPrefix("T", "tera", 1.0E12);
    private static final UnitPrefix peta = new UnitPrefix("P", "peta", 1.0E15);
    private static final UnitPrefix exa = new UnitPrefix("E", "exa", 1.0E18);
    private static final UnitPrefix zetta = new UnitPrefix("Z", "zetta", 1.0E21);
    private static final UnitPrefix yotta = new UnitPrefix("Y", "yotta", 1.0E24);
    private static final UnitPrefix deci = new UnitPrefix("d", "deci", 0.1);
    private static final UnitPrefix centi = new UnitPrefix("c", "centi", 0.01);
    private static final UnitPrefix milli = new UnitPrefix("m", "milli", 0.001);
    private static final UnitPrefix micro = new UnitPrefix("\u03bc", "micro", 1.0E-6);
    private static final UnitPrefix nano = new UnitPrefix("n", "nano", 1.0E-9);
    private static final UnitPrefix pico = new UnitPrefix("p", "pico", 1.0E-12);
    private static final UnitPrefix femto = new UnitPrefix("f", "femto", 1.0E-15);
    private static final UnitPrefix atto = new UnitPrefix("a", "atto", 1.0E-18);
    private static final UnitPrefix zepto = new UnitPrefix("z", "zepto", 1.0E-21);
    private static final UnitPrefix yocto = new UnitPrefix("y", "yocto", 1.0E-24);
    private static final UnitPrefix kibi = new UnitPrefix("Ki", "kibi", 1024.0);
    private static final UnitPrefix mebi = new UnitPrefix("Mi", "mebi", MODULE$.kibi().factor() * 1024.0);
    private static final UnitPrefix gibi = new UnitPrefix("Gi", "gibi", MODULE$.mebi().factor() * 1024.0);
    private static final UnitPrefix tebi = new UnitPrefix("Ti", "tebi", MODULE$.gibi().factor() * 1024.0);
    private static final UnitPrefix pebi = new UnitPrefix("Pi", "pebi", MODULE$.tebi().factor() * 1024.0);
    private static final UnitPrefix exbi = new UnitPrefix("Ei", "exbi", MODULE$.pebi().factor() * 1024.0);
    private static final UnitPrefix zebi = new UnitPrefix("Zi", "zebi", MODULE$.exbi().factor() * 1024.0);
    private static final UnitPrefix yobi = new UnitPrefix("Yi", "yobi", MODULE$.zebi().factor() * 1024.0);
    private static final List<UnitPrefix> binaryPrefixes = (List)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UnitPrefix[]{MODULE$.kibi(), MODULE$.mebi(), MODULE$.gibi(), MODULE$.tebi(), MODULE$.pebi(), MODULE$.exbi(), MODULE$.zebi(), MODULE$.yobi()}));
    private static final double maxValue = 1.0E27;
    private static final double minValue = 1.0E-27;
    private static final List<UnitPrefix> com$netflix$atlas$core$util$UnitPrefix$$decimalBigPrefixes = (List)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UnitPrefix[]{MODULE$.yotta(), MODULE$.zetta(), MODULE$.exa(), MODULE$.peta(), MODULE$.tera(), MODULE$.giga(), MODULE$.mega(), MODULE$.kilo()}));
    private static final List<UnitPrefix> com$netflix$atlas$core$util$UnitPrefix$$decimalSmallPrefixes = (List)List$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UnitPrefix[]{MODULE$.milli(), MODULE$.micro(), MODULE$.nano(), MODULE$.pico(), MODULE$.femto(), MODULE$.atto(), MODULE$.zepto(), MODULE$.yocto()}));
    private static final List<UnitPrefix> binaryBigPrefixes = MODULE$.binaryPrefixes().reverse();

    public UnitPrefix one() {
        return one;
    }

    public UnitPrefix deca() {
        return deca;
    }

    public UnitPrefix hecto() {
        return hecto;
    }

    public UnitPrefix kilo() {
        return kilo;
    }

    public UnitPrefix mega() {
        return mega;
    }

    public UnitPrefix giga() {
        return giga;
    }

    public UnitPrefix tera() {
        return tera;
    }

    public UnitPrefix peta() {
        return peta;
    }

    public UnitPrefix exa() {
        return exa;
    }

    public UnitPrefix zetta() {
        return zetta;
    }

    public UnitPrefix yotta() {
        return yotta;
    }

    public UnitPrefix deci() {
        return deci;
    }

    public UnitPrefix centi() {
        return centi;
    }

    public UnitPrefix milli() {
        return milli;
    }

    public UnitPrefix micro() {
        return micro;
    }

    public UnitPrefix nano() {
        return nano;
    }

    public UnitPrefix pico() {
        return pico;
    }

    public UnitPrefix femto() {
        return femto;
    }

    public UnitPrefix atto() {
        return atto;
    }

    public UnitPrefix zepto() {
        return zepto;
    }

    public UnitPrefix yocto() {
        return yocto;
    }

    public UnitPrefix kibi() {
        return kibi;
    }

    public UnitPrefix mebi() {
        return mebi;
    }

    public UnitPrefix gibi() {
        return gibi;
    }

    public UnitPrefix tebi() {
        return tebi;
    }

    public UnitPrefix pebi() {
        return pebi;
    }

    public UnitPrefix exbi() {
        return exbi;
    }

    public UnitPrefix zebi() {
        return zebi;
    }

    public UnitPrefix yobi() {
        return yobi;
    }

    public List<UnitPrefix> binaryPrefixes() {
        return binaryPrefixes;
    }

    private double maxValue() {
        return maxValue;
    }

    private double minValue() {
        return minValue;
    }

    public List<UnitPrefix> com$netflix$atlas$core$util$UnitPrefix$$decimalBigPrefixes() {
        return com$netflix$atlas$core$util$UnitPrefix$$decimalBigPrefixes;
    }

    public List<UnitPrefix> com$netflix$atlas$core$util$UnitPrefix$$decimalSmallPrefixes() {
        return com$netflix$atlas$core$util$UnitPrefix$$decimalSmallPrefixes;
    }

    private List<UnitPrefix> binaryBigPrefixes() {
        return binaryBigPrefixes;
    }

    public String format(double v, String fmtstr, String scifmt) {
        return this.decimal(v).format(v, fmtstr, scifmt);
    }

    public String format$default$2() {
        return "%.1f%s";
    }

    public String format$default$3() {
        return "%.0e";
    }

    public boolean com$netflix$atlas$core$util$UnitPrefix$$hasExtremeExponent(double v) {
        double d = package$.MODULE$.abs(v);
        return Double.isFinite(v) && (this.isLarge(d) || this.isSmall(d));
    }

    private boolean isLarge(double v) {
        return v >= this.maxValue();
    }

    private boolean isSmall(double v) {
        return v <= this.minValue() && v >= Double.MIN_VALUE;
    }

    public UnitPrefix decimal(double value) {
        double d = package$.MODULE$.abs(value);
        UnitPrefix unitPrefix = this.isNearlyZero(d) ? this.one() : (!Double.isFinite(d) ? this.one() : (d >= this.kilo().factor() ? (UnitPrefix)this.com$netflix$atlas$core$util$UnitPrefix$$decimalBigPrefixes().find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)UnitPrefix$.$anonfun$decimal$1(d, x$1))).getOrElse((Function0 & Serializable)() -> MODULE$.yotta()) : (d < 1.0 ? (UnitPrefix)this.com$netflix$atlas$core$util$UnitPrefix$$decimalSmallPrefixes().find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)UnitPrefix$.$anonfun$decimal$3(d, x$2))).getOrElse((Function0 & Serializable)() -> MODULE$.yocto()) : this.one())));
        return unitPrefix;
    }

    public UnitPrefix binary(double value) {
        double d = package$.MODULE$.abs(value);
        UnitPrefix unitPrefix = this.isNearlyZero(d) ? this.one() : (!Double.isFinite(d) ? this.one() : (d >= this.kibi().factor() ? (UnitPrefix)this.binaryBigPrefixes().find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)UnitPrefix$.$anonfun$binary$1(d, x$3))).getOrElse((Function0 & Serializable)() -> MODULE$.yobi()) : (d < 1.0 ? (UnitPrefix)this.com$netflix$atlas$core$util$UnitPrefix$$decimalSmallPrefixes().find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)UnitPrefix$.$anonfun$binary$3(d, x$4))).getOrElse((Function0 & Serializable)() -> MODULE$.yocto()) : this.one())));
        return unitPrefix;
    }

    public UnitPrefix forRange(double value, double digits) {
        double f = package$.MODULE$.pow(10.0, digits);
        double d = package$.MODULE$.abs(value);
        UnitPrefix unitPrefix = this.isNearlyZero(d) ? this.one() : (!Double.isFinite(d) ? this.one() : (UnitPrefix$.withinRange$1(this.one(), d, f) ? this.one() : (d >= this.kilo().factor() / f ? (UnitPrefix)this.com$netflix$atlas$core$util$UnitPrefix$$decimalBigPrefixes().reverse().find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)UnitPrefix$.withinRange$1(x$5, d, f))).getOrElse((Function0 & Serializable)() -> MODULE$.yotta()) : (d < 1.0 / f ? (UnitPrefix)this.com$netflix$atlas$core$util$UnitPrefix$$decimalSmallPrefixes().find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)UnitPrefix$.withinRange$1(x$6, d, f))).getOrElse((Function0 & Serializable)() -> MODULE$.yocto()) : this.one()))));
        return unitPrefix;
    }

    public UnitPrefix binaryRange(double value, double digits) {
        double f = package$.MODULE$.pow(10.0, digits);
        double d = package$.MODULE$.abs(value);
        UnitPrefix unitPrefix = this.isNearlyZero(d) ? this.one() : (!Double.isFinite(d) ? this.one() : (UnitPrefix$.withinRange$2(this.one(), d, f) ? this.one() : (d >= this.kibi().factor() / f ? (UnitPrefix)this.binaryPrefixes().find((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)UnitPrefix$.withinRange$2(x$7, d, f))).getOrElse((Function0 & Serializable)() -> MODULE$.yobi()) : (d < 1.0 / f ? (UnitPrefix)this.com$netflix$atlas$core$util$UnitPrefix$$decimalSmallPrefixes().find((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)UnitPrefix$.withinRange$2(x$8, d, f))).getOrElse((Function0 & Serializable)() -> MODULE$.yocto()) : this.one()))));
        return unitPrefix;
    }

    private boolean isNearlyZero(double v) {
        return Predef$.MODULE$.double2Double(v).isNaN() || package$.MODULE$.abs(v - 0.0) < 1.0E-12;
    }

    public UnitPrefix apply(String symbol, String text, double factor) {
        return new UnitPrefix(symbol, text, factor);
    }

    public Option<Tuple3<String, String, Object>> unapply(UnitPrefix x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)x$0.symbol(), (Object)x$0.text(), (Object)BoxesRunTime.boxToDouble((double)x$0.factor())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(UnitPrefix$.class);
    }

    public static final /* synthetic */ boolean $anonfun$decimal$1(double x1$1, UnitPrefix x$1) {
        return x$1.factor() <= x1$1;
    }

    public static final /* synthetic */ boolean $anonfun$decimal$3(double x1$1, UnitPrefix x$2) {
        return x$2.factor() <= x1$1;
    }

    public static final /* synthetic */ boolean $anonfun$binary$1(double x1$2, UnitPrefix x$3) {
        return x$3.factor() <= x1$2;
    }

    public static final /* synthetic */ boolean $anonfun$binary$3(double x1$2, UnitPrefix x$4) {
        return x$4.factor() <= x1$2;
    }

    private static final boolean withinRange$1(UnitPrefix prefix, double v, double f$1) {
        double a = package$.MODULE$.abs(v);
        return a >= prefix.factor() / f$1 && a < prefix.factor() * f$1;
    }

    private static final boolean withinRange$2(UnitPrefix prefix, double v, double f$2) {
        double a = package$.MODULE$.abs(v);
        return a >= prefix.factor() / f$2 && a < prefix.factor() * f$2;
    }

    private UnitPrefix$() {
    }
}

