/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.atlas.core.util;

import com.netflix.atlas.core.util.Hash$;
import com.netflix.atlas.core.util.LongIntHashMap$;
import com.netflix.atlas.core.util.PrimeFinder;
import java.io.Serializable;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Builder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001db\u0001\u0002\r\u001a\u0001\u0011B\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\t_\u0001\u0011\t\u0011)A\u0005a!)1\u0007\u0001C\u0001i!1\u0011\b\u0001Q!\niBa!\u0010\u0001!B\u0013q\u0004BB \u0001A\u0003&\u0001\u0007\u0003\u0004A\u0001\u0001\u0006K\u0001\r\u0005\u0006\u0003\u0002!IA\u0011\u0005\u0006\u000b\u0002!IA\u0012\u0005\u0006\u0011\u0002!I!\u0013\u0005\u0006\u001b\u0002!IA\u0014\u0005\u0006'\u0002!I\u0001\u0016\u0005\u0006'\u0002!\tA\u0018\u0005\u0006C\u0002!\tA\u0019\u0005\u0006M\u0002!\ta\u001a\u0005\u0006M\u0002!\t!\u001b\u0005\u0006[\u0002!\tA\u001c\u0005\u0006i\u0002!\t!\u001e\u0005\u0006m\u0002!\ta^\u0004\n\u0003\u000fI\u0012\u0011!E\u0001\u0003\u00131\u0001\u0002G\r\u0002\u0002#\u0005\u00111\u0002\u0005\u0007gU!\t!!\u0004\t\u0013\u0005=Q#%A\u0005\u0002\u0005E!A\u0004'p]\u001eLe\u000e\u001e%bg\"l\u0015\r\u001d\u0006\u00035m\tA!\u001e;jY*\u0011A$H\u0001\u0005G>\u0014XM\u0003\u0002\u001f?\u0005)\u0011\r\u001e7bg*\u0011\u0001%I\u0001\b]\u0016$h\r\\5y\u0015\u0005\u0011\u0013aA2p[\u000e\u00011C\u0001\u0001&!\t1\u0013&D\u0001(\u0015\u0005A\u0013!B:dC2\f\u0017B\u0001\u0016(\u0005\u0019\te.\u001f*fM\u00061an\u001c#bi\u0006\u0004\"AJ\u0017\n\u00059:#\u0001\u0002'p]\u001e\f\u0001bY1qC\u000eLG/\u001f\t\u0003MEJ!AM\u0014\u0003\u0007%sG/\u0001\u0004=S:LGO\u0010\u000b\u0004k]B\u0004C\u0001\u001c\u0001\u001b\u0005I\u0002\"B\u0016\u0004\u0001\u0004a\u0003bB\u0018\u0004!\u0003\u0005\r\u0001M\u0001\u0005W\u0016L8\u000fE\u0002'w1J!\u0001P\u0014\u0003\u000b\u0005\u0013(/Y=\u0002\rY\fG.^3t!\r13\bM\u0001\u0005kN,G-\u0001\u0004dkR|gMZ\u0001\u000eG>l\u0007/\u001e;f\u0007V$xN\u001a4\u0015\u0005A\u001a\u0005\"\u0002#\t\u0001\u0004\u0001\u0014!\u00018\u0002\u00119,w/\u0011:sCf$\"AO$\t\u000b\u0011K\u0001\u0019\u0001\u0019\u0002\rI,7/\u001b>f)\u0005Q\u0005C\u0001\u0014L\u0013\tauE\u0001\u0003V]&$\u0018\u0001\u00025bg\"$2\u0001M(R\u0011\u0015\u00016\u00021\u0001;\u0003\tY7\u000fC\u0003S\u0017\u0001\u0007A&A\u0001l\u0003\r\u0001X\u000f\u001e\u000b\u0006+bK6\f\u0018\t\u0003MYK!aV\u0014\u0003\u000f\t{w\u000e\\3b]\")\u0001\u000b\u0004a\u0001u!)!\f\u0004a\u0001}\u0005\u0011ao\u001d\u0005\u0006%2\u0001\r\u0001\f\u0005\u0006;2\u0001\r\u0001M\u0001\u0002mR\u0019!j\u00181\t\u000bIk\u0001\u0019\u0001\u0017\t\u000buk\u0001\u0019\u0001\u0019\u0002\u0007\u001d,G\u000fF\u00021G\u0012DQA\u0015\bA\u00021BQ!\u001a\bA\u0002A\nA\u0001\u001a4mi\u0006I\u0011N\\2sK6,g\u000e\u001e\u000b\u0003\u0015\"DQAU\bA\u00021\"2A\u00136l\u0011\u0015\u0011\u0006\u00031\u0001-\u0011\u0015a\u0007\u00031\u00011\u0003\u0019\tWn\\;oi\u00069am\u001c:fC\u000eDGC\u0001&p\u0011\u0015\u0001\u0018\u00031\u0001r\u0003\u00051\u0007#\u0002\u0014sYAR\u0015BA:(\u0005%1UO\\2uS>t''\u0001\u0003tSj,W#\u0001\u0019\u0002\u000bQ|W*\u00199\u0016\u0003a\u0004R!_A\u0001YAr!A\u001f@\u0011\u0005m<S\"\u0001?\u000b\u0005u\u001c\u0013A\u0002\u001fs_>$h(\u0003\u0002\u0000O\u00051\u0001K]3eK\u001aLA!a\u0001\u0002\u0006\t\u0019Q*\u00199\u000b\u0005}<\u0013A\u0004'p]\u001eLe\u000e\u001e%bg\"l\u0015\r\u001d\t\u0003mU\u0019\"!F\u0013\u0015\u0005\u0005%\u0011a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\u0014)\u001a\u0001'!\u0006,\u0005\u0005]\u0001\u0003BA\r\u0003Gi!!a\u0007\u000b\t\u0005u\u0011qD\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\t(\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003K\tYBA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class LongIntHashMap {
    private final long noData;
    private long[] keys;
    private int[] values;
    private int used;
    private int cutoff;

    public static int $lessinit$greater$default$2() {
        return LongIntHashMap$.MODULE$.$lessinit$greater$default$2();
    }

    private int computeCutoff(int n) {
        return package$.MODULE$.max(3, n / 2);
    }

    /*
     * WARNING - void declaration
     */
    private long[] newArray(int n) {
        void var2_2;
        long[] tmp = new long[PrimeFinder.nextPrime(n)];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = this.noData;
        }
        return var2_2;
    }

    private void resize() {
        long[] tmpKS = this.newArray(this.keys.length * 2);
        int[] tmpVS = new int[tmpKS.length];
        for (int i = 0; i < this.keys.length; ++i) {
            long k = this.keys[i];
            Object object = k != this.noData ? BoxesRunTime.boxToBoolean((boolean)this.put(tmpKS, tmpVS, k, this.values[i])) : BoxedUnit.UNIT;
        }
        this.keys = tmpKS;
        this.values = tmpVS;
        this.cutoff = this.computeCutoff(tmpKS.length);
    }

    private int hash(long[] ks, long k) {
        return Hash$.MODULE$.absOrZero(Hash$.MODULE$.murmur3(k)) % ks.length;
    }

    private boolean put(long[] ks, int[] vs, long k, int v) {
        int pos = this.hash(ks, k);
        long posV = ks[pos];
        while (posV != this.noData && posV != k) {
            pos = (pos + 1) % ks.length;
            posV = ks[pos];
        }
        ks[pos] = k;
        vs[pos] = v;
        return posV == this.noData;
    }

    public void put(long k, int v) {
        block1: {
            if (this.used >= this.cutoff) {
                this.resize();
            }
            if (!this.put(this.keys, this.values, k, v)) break block1;
            ++this.used;
        }
    }

    public int get(long k, int dflt) {
        int pos = this.hash(this.keys, k);
        long prev;
        while ((prev = this.keys[pos]) != this.noData) {
            if (prev == k) {
                return this.values[pos];
            }
            pos = (pos + 1) % this.keys.length;
        }
        return dflt;
    }

    public void increment(long k) {
        this.increment(k, 1);
    }

    public void increment(long k, int amount) {
        if (this.used >= this.cutoff) {
            this.resize();
        }
        int pos = this.hash(this.keys, k);
        while (true) {
            long prev;
            if ((prev = this.keys[pos]) == this.noData || prev == k) {
                this.keys[pos] = k;
                int[] nArray = this.values;
                int n = pos;
                nArray[n] = nArray[n] + amount;
                if (prev == this.noData) {
                    ++this.used;
                }
                return;
            }
            pos = (pos + 1) % this.keys.length;
        }
    }

    public void foreach(Function2<Object, Object, BoxedUnit> f) {
        for (int i = 0; i < this.keys.length; ++i) {
            long k = this.keys[i];
            if (k == this.noData) continue;
            f.apply$mcVJI$sp(k, this.values[i]);
        }
    }

    public int size() {
        return this.used;
    }

    public Map<Object, Object> toMap() {
        Builder builder = Predef$.MODULE$.Map().newBuilder();
        this.foreach((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVJI.sp & Serializable)(k, v) -> builder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)k)), (Object)BoxesRunTime.boxToInteger((int)v))));
        return (Map)builder.result();
    }

    public LongIntHashMap(long noData, int capacity) {
        this.noData = noData;
        this.keys = this.newArray(capacity);
        this.values = new int[this.keys.length];
        this.used = 0;
        this.cutoff = this.computeCutoff(this.keys.length);
    }
}

