/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.atlas.core.util;

import com.netflix.atlas.core.util.ArrayHelper$;
import com.netflix.atlas.core.util.Hash$;
import com.netflix.atlas.core.util.IntRefHashMap$;
import com.netflix.atlas.core.util.PrimeFinder;
import java.io.Serializable;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Builder;
import scala.math.package$;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Eb\u0001B\f\u0019\u0001\rB\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\t_\u0001\u0011\t\u0011)A\u0005Y!A\u0001\u0007\u0001B\u0002B\u0003-\u0011\u0007C\u0003E\u0001\u0011\u0005Q\t\u0003\u0004M\u0001\u0001\u0006K!\u0014\u0005\u0007!\u0002\u0001\u000b\u0015B)\t\rI\u0003\u0001\u0015)\u0003-\u0011\u0019\u0019\u0006\u0001)Q\u0005Y!)A\u000b\u0001C\u0005+\")\u0001\f\u0001C\u00053\")1\f\u0001C\u00059\")\u0001\r\u0001C\u0005C\")a\r\u0001C\u0005O\")a\r\u0001C\u0001e\")Q\u000f\u0001C\u0001m\")\u0001\u0010\u0001C\u0001s\"1q\u0010\u0001C\u0001\u0003\u0003Aq!a\u0001\u0001\t\u0003\t)aB\u0005\u0002\u000ea\t\t\u0011#\u0001\u0002\u0010\u0019Aq\u0003GA\u0001\u0012\u0003\t\t\u0002\u0003\u0004E)\u0011\u0005\u00111\u0003\u0005\n\u0003+!\u0012\u0013!C\u0001\u0003/\u0011Q\"\u00138u%\u00164\u0007*Y:i\u001b\u0006\u0004(BA\r\u001b\u0003\u0011)H/\u001b7\u000b\u0005ma\u0012\u0001B2pe\u0016T!!\b\u0010\u0002\u000b\u0005$H.Y:\u000b\u0005}\u0001\u0013a\u00028fi\u001ad\u0017\u000e\u001f\u0006\u0002C\u0005\u00191m\\7\u0004\u0001U\u0011AEP\n\u0003\u0001\u0015\u0002\"AJ\u0015\u000e\u0003\u001dR\u0011\u0001K\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001d\u0012a!\u00118z%\u00164\u0017A\u00028p\t\u0006$\u0018\r\u0005\u0002'[%\u0011af\n\u0002\u0004\u0013:$\u0018\u0001C2ba\u0006\u001c\u0017\u000e^=\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007E\u00023sqr!aM\u001c\u0011\u0005Q:S\"A\u001b\u000b\u0005Y\u0012\u0013A\u0002\u001fs_>$h(\u0003\u00029O\u00051\u0001K]3eK\u001aL!AO\u001e\u0003\u00115\u000bg.\u001b4fgRT!\u0001O\u0014\u0011\u0005urD\u0002\u0001\u0003\u0006\u007f\u0001\u0011\r\u0001\u0011\u0002\u0002)F\u0011\u0011)\n\t\u0003M\tK!aQ\u0014\u0003\u000f9{G\u000f[5oO\u00061A(\u001b8jiz\"2A\u0012&L)\t9\u0015\nE\u0002I\u0001qj\u0011\u0001\u0007\u0005\u0006a\u0011\u0001\u001d!\r\u0005\u0006W\u0011\u0001\r\u0001\f\u0005\b_\u0011\u0001\n\u00111\u0001-\u0003\u0011YW-_:\u0011\u0007\u0019rE&\u0003\u0002PO\t)\u0011I\u001d:bs\u00061a/\u00197vKN\u00042A\n(=\u0003\u0011)8/\u001a3\u0002\r\r,Ho\u001c4g\u00035\u0019w.\u001c9vi\u0016\u001cU\u000f^8gMR\u0011AF\u0016\u0005\u0006/&\u0001\r\u0001L\u0001\u0002]\u0006Aa.Z<BeJ\f\u0017\u0010\u0006\u0002N5\")qK\u0003a\u0001Y\u00051!/Z:ju\u0016$\u0012!\u0018\t\u0003MyK!aX\u0014\u0003\tUs\u0017\u000e^\u0001\u0005Q\u0006\u001c\b\u000eF\u0002-E\u0012DQa\u0019\u0007A\u00021\n\u0011a\u001b\u0005\u0006K2\u0001\r\u0001L\u0001\u0007Y\u0016tw\r\u001e5\u0002\u0007A,H\u000fF\u0003iW6|\u0007\u000f\u0005\u0002'S&\u0011!n\n\u0002\b\u0005>|G.Z1o\u0011\u0015aW\u00021\u0001N\u0003\tY7\u000fC\u0003o\u001b\u0001\u0007\u0011+\u0001\u0002wg\")1-\u0004a\u0001Y!)\u0011/\u0004a\u0001y\u0005\ta\u000fF\u0002^gRDQa\u0019\bA\u00021BQ!\u001d\bA\u0002q\n1aZ3u)\tat\u000fC\u0003d\u001f\u0001\u0007A&A\u0004g_J,\u0017m\u00195\u0015\u0005uS\b\"B>\u0011\u0001\u0004a\u0018!\u00014\u0011\u000b\u0019jH\u0006P/\n\u0005y<#!\u0003$v]\u000e$\u0018n\u001c83\u0003\u0011\u0019\u0018N_3\u0016\u00031\nQ\u0001^8NCB,\"!a\u0002\u0011\u000bI\nI\u0001\f\u001f\n\u0007\u0005-1HA\u0002NCB\fQ\"\u00138u%\u00164\u0007*Y:i\u001b\u0006\u0004\bC\u0001%\u0015'\t!R\u0005\u0006\u0002\u0002\u0010\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII*B!!\u0007\u00020U\u0011\u00111\u0004\u0016\u0004Y\u0005u1FAA\u0010!\u0011\t\t#a\u000b\u000e\u0005\u0005\r\"\u0002BA\u0013\u0003O\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005%r%\u0001\u0006b]:|G/\u0019;j_:LA!!\f\u0002$\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u000b}2\"\u0019\u0001!")
public class IntRefHashMap<T> {
    private final int noData;
    private int[] keys;
    private T[] values;
    private int used;
    private int cutoff;

    public static <T> int $lessinit$greater$default$2() {
        return IntRefHashMap$.MODULE$.$lessinit$greater$default$2();
    }

    private int computeCutoff(int n) {
        return package$.MODULE$.max(3, n / 2);
    }

    /*
     * WARNING - void declaration
     */
    private int[] newArray(int n) {
        void var2_2;
        int[] tmp = new int[PrimeFinder.nextPrime(n)];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = this.noData;
        }
        return var2_2;
    }

    private void resize() {
        int[] tmpKS = this.newArray(this.keys.length * 2);
        Object[] tmpVS = (Object[])ArrayHelper$.MODULE$.newInstance(tmpKS.length);
        for (int i = 0; i < this.keys.length; ++i) {
            int k = this.keys[i];
            Object object = k != this.noData ? BoxesRunTime.boxToBoolean((boolean)this.put(tmpKS, tmpVS, k, this.values[i])) : BoxedUnit.UNIT;
        }
        this.keys = tmpKS;
        this.values = tmpVS;
        this.cutoff = this.computeCutoff(tmpKS.length);
    }

    private int hash(int k, int length) {
        return Hash$.MODULE$.absOrZero(k) % length;
    }

    private boolean put(int[] ks, T[] vs, int k, T v) {
        int pos = this.hash(k, ks.length);
        int posV = ks[pos];
        while (posV != this.noData && posV != k) {
            pos = (pos + 1) % ks.length;
            posV = ks[pos];
        }
        ks[pos] = k;
        vs[pos] = v;
        return posV == this.noData;
    }

    public void put(int k, T v) {
        block1: {
            if (this.used >= this.cutoff) {
                this.resize();
            }
            if (!this.put(this.keys, this.values, k, v)) break block1;
            ++this.used;
        }
    }

    public T get(int k) {
        int pos = this.hash(k, this.keys.length);
        int prev;
        while ((prev = this.keys[pos]) != this.noData) {
            if (prev == k) {
                return this.values[pos];
            }
            pos = (pos + 1) % this.keys.length;
        }
        return null;
    }

    public void foreach(Function2<Object, T, BoxedUnit> f) {
        for (int i = 0; i < this.keys.length; ++i) {
            int k = this.keys[i];
            Object object = k != this.noData ? f.apply((Object)BoxesRunTime.boxToInteger((int)k), this.values[i]) : BoxedUnit.UNIT;
        }
    }

    public int size() {
        return this.used;
    }

    public Map<Object, T> toMap() {
        Builder builder = Predef$.MODULE$.Map().newBuilder();
        this.foreach((Function2 & Serializable)(k, v) -> {
            builder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)k))), v));
            return BoxedUnit.UNIT;
        });
        return (Map)builder.result();
    }

    public IntRefHashMap(int noData, int capacity, Manifest<T> evidence$1) {
        this.noData = noData;
        this.keys = this.newArray(capacity);
        this.values = (Object[])ArrayHelper$.MODULE$.newInstance(this.keys.length);
        this.used = 0;
        this.cutoff = this.computeCutoff(this.keys.length);
    }
}

