/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.atlas.core.model;

import com.netflix.atlas.core.model.ArrayTimeSeq;
import com.netflix.atlas.core.model.ConsolidationFunction;
import com.netflix.atlas.core.model.ConsolidationFunction$Avg$;
import com.netflix.atlas.core.model.ConsolidationFunction$Max$;
import com.netflix.atlas.core.model.ConsolidationFunction$Min$;
import com.netflix.atlas.core.model.ConsolidationFunction$Sum$;
import com.netflix.atlas.core.model.DsType;
import com.netflix.atlas.core.model.DsType$Rate$;
import com.netflix.atlas.core.model.TimeSeq;
import com.netflix.atlas.core.util.Math$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u000513A\u0001D\u0007\u00011!A1\u0005\u0001B\u0001B\u0003%q\u0004\u0003\u0005%\u0001\t\u0015\r\u0011\"\u0001&\u0011!I\u0003A!A!\u0002\u00131\u0003\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\t\u000b9\u0002A\u0011A\u0018\t\u000fQ\u0002!\u0019!C\u0005k!1\u0011\b\u0001Q\u0001\nYBqA\u000f\u0001C\u0002\u0013%1\b\u0003\u0004C\u0001\u0001\u0006I\u0001\u0010\u0005\u0006\u0007\u0002!\t\u0001\u0012\u0005\u0006\u0011\u0002!\t!\u0013\u0002\u000f\u001b\u0006\u00048\u000b^3q)&lWmU3r\u0015\tqq\"A\u0003n_\u0012,GN\u0003\u0002\u0011#\u0005!1m\u001c:f\u0015\t\u00112#A\u0003bi2\f7O\u0003\u0002\u0015+\u00059a.\u001a;gY&D(\"\u0001\f\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001Ir\u0004\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2D\u0001\u0004B]f\u0014VM\u001a\t\u0003A\u0005j\u0011!D\u0005\u0003E5\u0011q\u0001V5nKN+\u0017/\u0001\u0002ug\u0006!1\u000f^3q+\u00051\u0003C\u0001\u000e(\u0013\tA3D\u0001\u0003M_:<\u0017!B:uKB\u0004\u0013AA2g!\t\u0001C&\u0003\u0002.\u001b\t)2i\u001c8t_2LG-\u0019;j_:4UO\\2uS>t\u0017A\u0002\u001fj]&$h\b\u0006\u00031cI\u001a\u0004C\u0001\u0011\u0001\u0011\u0015\u0019S\u00011\u0001 \u0011\u0015!S\u00011\u0001'\u0011\u0015QS\u00011\u0001,\u0003=I7oQ8og>d\u0017\u000eZ1uS>tW#\u0001\u001c\u0011\u0005i9\u0014B\u0001\u001d\u001c\u0005\u001d\u0011un\u001c7fC:\f\u0001#[:D_:\u001cx\u000e\\5eCRLwN\u001c\u0011\u0002\u0017\r|gn]8mS\u0012\fG/Z\u000b\u0002yA)!$P @\u007f%\u0011ah\u0007\u0002\n\rVt7\r^5p]J\u0002\"A\u0007!\n\u0005\u0005[\"A\u0002#pk\ndW-\u0001\u0007d_:\u001cx\u000e\\5eCR,\u0007%\u0001\u0004egRK\b/Z\u000b\u0002\u000bB\u0011\u0001ER\u0005\u0003\u000f6\u0011a\u0001R:UsB,\u0017!B1qa2LHCA K\u0011\u0015Y5\u00021\u0001'\u0003%!\u0018.\\3ti\u0006l\u0007\u000f")
public class MapStepTimeSeq
implements TimeSeq {
    private final TimeSeq ts;
    private final long step;
    private final ConsolidationFunction cf;
    private final boolean isConsolidation;
    private final Function2<Object, Object, Object> consolidate;

    @Override
    public TimeSeq mapValues(Function1<Object, Object> f) {
        return TimeSeq.mapValues$(this, f);
    }

    @Override
    public void foreach(long s, long e, Function2<Object, Object, BoxedUnit> f) {
        TimeSeq.foreach$(this, s, e, f);
    }

    @Override
    public ArrayTimeSeq bounded(long s, long e) {
        return TimeSeq.bounded$(this, s, e);
    }

    @Override
    public long step() {
        return this.step;
    }

    private boolean isConsolidation() {
        return this.isConsolidation;
    }

    private Function2<Object, Object, Object> consolidate() {
        return this.consolidate;
    }

    @Override
    public DsType dsType() {
        return this.ts.dsType();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public double apply(long timestamp) {
        int denominator;
        double d;
        if (!this.isConsolidation()) {
            long t = timestamp / this.ts.step() * this.ts.step();
            d = this.ts.apply(t);
            return d;
        }
        long t = timestamp / this.step() * this.step();
        int m = (int)(this.step() / this.ts.step());
        double v = Double.NaN;
        int c = 0;
        for (int i = 0; i < m; ++i) {
            double n = this.ts.apply(t + (long)i * this.ts.step());
            v = this.consolidate().apply$mcDDD$sp(v, n);
            if (Predef$.MODULE$.double2Double(n).isNaN()) continue;
            ++c;
        }
        DsType dsType = this.dsType();
        DsType$Rate$ dsType$Rate$ = DsType$Rate$.MODULE$;
        int n = !(dsType != null ? !dsType.equals(dsType$Rate$) : dsType$Rate$ != null) ? m : (denominator = c);
        if (c > 0) {
            ConsolidationFunction consolidationFunction = this.cf;
            ConsolidationFunction$Avg$ consolidationFunction$Avg$ = ConsolidationFunction$Avg$.MODULE$;
            if (!(consolidationFunction != null ? !consolidationFunction.equals(consolidationFunction$Avg$) : consolidationFunction$Avg$ != null)) {
                d = v / (double)denominator;
                return d;
            }
        }
        d = v;
        return d;
    }

    public MapStepTimeSeq(TimeSeq ts, long step, ConsolidationFunction cf) {
        JFunction2.mcDDD.sp & Serializable intersect;
        this.ts = ts;
        this.step = step;
        this.cf = cf;
        TimeSeq.$init$(this);
        boolean bl = this.isConsolidation = step > ts.step();
        Predef$.MODULE$.require(this.isConsolidation() ? step % ts.step() == 0L : ts.step() % step == 0L, (Function0 & Serializable)() -> "consolidated step must be multiple of primary step");
        ConsolidationFunction consolidationFunction = cf;
        if (ConsolidationFunction$Sum$.MODULE$.equals(consolidationFunction)) {
            intersect = (JFunction2.mcDDD.sp & Serializable)(v1, v2) -> Math$.MODULE$.addNaN(v1, v2);
        } else if (ConsolidationFunction$Avg$.MODULE$.equals(consolidationFunction)) {
            intersect = (JFunction2.mcDDD.sp & Serializable)(v1, v2) -> Math$.MODULE$.addNaN(v1, v2);
        } else if (ConsolidationFunction$Max$.MODULE$.equals(consolidationFunction)) {
            intersect = (JFunction2.mcDDD.sp & Serializable)(v1, v2) -> Math$.MODULE$.maxNaN(v1, v2);
        } else if (ConsolidationFunction$Min$.MODULE$.equals(consolidationFunction)) {
            intersect = (JFunction2.mcDDD.sp & Serializable)(v1, v2) -> Math$.MODULE$.minNaN(v1, v2);
        } else {
            throw new MatchError((Object)consolidationFunction);
        }
        this.consolidate = intersect;
    }
}

