/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.atlas.core.model;

import com.netflix.atlas.core.model.DsType;
import com.netflix.atlas.core.model.TimeSeq;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0005\u00055a\u0001B\n\u0015\u0005}A\u0001B\u000b\u0001\u0003\u0006\u0004%\ta\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005Y!A\u0001\u0007\u0001BC\u0002\u0013\u0005\u0011\u0007\u0003\u00056\u0001\t\u0005\t\u0015!\u00033\u0011!1\u0004A!b\u0001\n\u0003\t\u0004\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\t\u0011a\u0002!Q1A\u0005\u0002eB\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\u0006\u0003\u0002!\tA\u0011\u0005\u0006\u0011\u0002!\t!\r\u0005\u0006\u0013\u0002!\tA\u0013\u0005\u0006\u001b\u0002!\tA\u0014\u0005\u0006\u001b\u0002!\tA\u0018\u0005\u0006\u001b\u0002!\tA\u0019\u0005\u0006O\u0002!\t\u0005\u001b\u0005\u0006c\u0002!\tE\u001d\u0005\u0006m\u0002!\ta\u001e\u0005\u0006s\u0002!\tE\u001f\u0002\r\u0003J\u0014\u0018-\u001f+j[\u0016\u001cV-\u001d\u0006\u0003+Y\tQ!\\8eK2T!a\u0006\r\u0002\t\r|'/\u001a\u0006\u00033i\tQ!\u0019;mCNT!a\u0007\u000f\u0002\u000f9,GO\u001a7jq*\tQ$A\u0002d_6\u001c\u0001aE\u0002\u0001A\u0019\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012a!\u00118z%\u00164\u0007CA\u0014)\u001b\u0005!\u0012BA\u0015\u0015\u0005\u001d!\u0016.\\3TKF\fa\u0001Z:UsB,W#\u0001\u0017\u0011\u0005\u001dj\u0013B\u0001\u0018\u0015\u0005\u0019!5\u000fV=qK\u00069Am\u001d+za\u0016\u0004\u0013!B:uCJ$X#\u0001\u001a\u0011\u0005\u0005\u001a\u0014B\u0001\u001b#\u0005\u0011auN\\4\u0002\rM$\u0018M\u001d;!\u0003\u0011\u0019H/\u001a9\u0002\u000bM$X\r\u001d\u0011\u0002\t\u0011\fG/Y\u000b\u0002uA\u0019\u0011eO\u001f\n\u0005q\u0012#!B!se\u0006L\bCA\u0011?\u0013\ty$E\u0001\u0004E_V\u0014G.Z\u0001\u0006I\u0006$\u0018\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b\r#UIR$\u0011\u0005\u001d\u0002\u0001\"\u0002\u0016\n\u0001\u0004a\u0003\"\u0002\u0019\n\u0001\u0004\u0011\u0004\"\u0002\u001c\n\u0001\u0004\u0011\u0004\"\u0002\u001d\n\u0001\u0004Q\u0014aA3oI\u0006)\u0011\r\u001d9msR\u0011Qh\u0013\u0005\u0006\u0019.\u0001\rAM\u0001\ni&lWm\u001d;b[B\fa!\u001e9eCR,GCA(])\t\u00016\u000b\u0005\u0002\"#&\u0011!K\t\u0002\u0005+:LG\u000fC\u0003U\u0019\u0001\u0007Q+\u0001\u0002paB\u0011a+\u0017\b\u0003O]K!\u0001\u0017\u000b\u0002\u000fA\f7m[1hK&\u0011!l\u0017\u0002\t\u0005&t\u0017M]=Pa*\u0011\u0001\f\u0006\u0005\u0006;2\u0001\raQ\u0001\u0003iN$\"aX1\u0015\u0005A\u0003\u0007\"\u0002+\u000e\u0001\u0004)\u0006\"B/\u000e\u0001\u00041CC\u0001)d\u0011\u0015!f\u00021\u0001e!\u0011\tS-P\u001f\n\u0005\u0019\u0014#!\u0003$v]\u000e$\u0018n\u001c82\u0003\u0019)\u0017/^1mgR\u0011\u0011\u000e\u001c\t\u0003C)L!a\u001b\u0012\u0003\u000f\t{w\u000e\\3b]\")Qn\u0004a\u0001]\u0006)q\u000e\u001e5feB\u0011\u0011e\\\u0005\u0003a\n\u00121!\u00118z\u0003!A\u0017m\u001d5D_\u0012,G#A:\u0011\u0005\u0005\"\u0018BA;#\u0005\rIe\u000e^\u0001\tG\u0006tW)];bYR\u0011\u0011\u000e\u001f\u0005\u0006[F\u0001\rA\\\u0001\ti>\u001cFO]5oOR\t1\u0010E\u0002}\u0003\u000fq1!`A\u0002!\tq(%D\u0001\u0000\u0015\r\t\tAH\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u0015!%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0013\tYA\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u000b\u0011\u0003")
public final class ArrayTimeSeq
implements TimeSeq {
    private final DsType dsType;
    private final long start;
    private final long step;
    private final double[] data;

    @Override
    public TimeSeq mapValues(Function1<Object, Object> f) {
        return TimeSeq.mapValues$(this, f);
    }

    @Override
    public void foreach(long s, long e, Function2<Object, Object, BoxedUnit> f) {
        TimeSeq.foreach$(this, s, e, f);
    }

    @Override
    public ArrayTimeSeq bounded(long s, long e) {
        return TimeSeq.bounded$(this, s, e);
    }

    @Override
    public DsType dsType() {
        return this.dsType;
    }

    public long start() {
        return this.start;
    }

    @Override
    public long step() {
        return this.step;
    }

    public double[] data() {
        return this.data;
    }

    public long end() {
        return this.start() + (long)this.data().length * this.step();
    }

    @Override
    public double apply(long timestamp) {
        long i = (timestamp - this.start()) / this.step();
        return timestamp < this.start() || timestamp >= this.end() ? Double.NaN : this.data()[(int)i];
    }

    public void update(ArrayTimeSeq ts, Function2<Object, Object, Object> op) {
        Predef$.MODULE$.require(this.step() == ts.step(), (Function0 & Serializable)() -> "step sizes must be the same");
        long s = package$.MODULE$.max(this.start(), ts.start());
        long e = package$.MODULE$.min(this.end(), ts.end());
        if (s < e) {
            int i1 = (int)((s - this.start()) / this.step());
            int i2 = (int)((s - ts.start()) / this.step());
            int epos = (int)((e - this.start()) / this.step());
            while (i1 < epos) {
                this.data()[i1] = op.apply$mcDDD$sp(this.data()[i1], ts.data()[i2]);
                ++i1;
                ++i2;
            }
        }
    }

    public void update(TimeSeq ts, Function2<Object, Object, Object> op) {
        Predef$.MODULE$.require(this.step() == ts.step(), (Function0 & Serializable)() -> "step sizes must be the same");
        IntRef i = IntRef.create((int)0);
        ts.foreach(this.start(), this.end(), (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVJD.sp & Serializable)(t, v) -> {
            $this.data()[i$2.elem] = op.apply$mcDDD$sp(this.data()[i$2.elem], v);
            ++i$2.elem;
        });
    }

    public void update(Function1<Object, Object> op) {
        for (int i = 0; i < this.data().length; ++i) {
            this.data()[i] = op.apply$mcDD$sp(this.data()[i]);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        Object object = other;
        if (!(object instanceof ArrayTimeSeq)) return false;
        ArrayTimeSeq arrayTimeSeq = (ArrayTimeSeq)object;
        if (!arrayTimeSeq.canEqual(this)) return false;
        DsType dsType = this.dsType();
        DsType dsType2 = arrayTimeSeq.dsType();
        if (dsType == null) {
            if (dsType2 != null) {
                return false;
            }
        } else if (!dsType.equals(dsType2)) return false;
        if (this.step() != arrayTimeSeq.step()) return false;
        if (this.start() != arrayTimeSeq.start()) return false;
        if (!Arrays.equals(this.data(), arrayTimeSeq.data())) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var2_2;
        int prime;
        int hc = prime = 31;
        hc = hc * prime + this.dsType().hashCode();
        hc = hc * prime + Long.valueOf(this.step()).hashCode();
        hc = hc * prime + Long.valueOf(this.start()).hashCode();
        hc = hc * prime + Arrays.hashCode(this.data());
        return (int)var2_2;
    }

    public boolean canEqual(Object other) {
        return other instanceof ArrayTimeSeq;
    }

    public String toString() {
        Instant s = Instant.ofEpochMilli(this.start());
        String values = Predef$.MODULE$.wrapDoubleArray(this.data()).mkString("[", ",", "]");
        return new StringBuilder(17).append("ArrayTimeSeq(").append(this.dsType()).append(",").append(s).append(",").append(this.step()).append(",").append(values).append(")").toString();
    }

    public ArrayTimeSeq(DsType dsType, long start, long step, double[] data) {
        this.dsType = dsType;
        this.start = start;
        this.step = step;
        this.data = data;
        TimeSeq.$init$(this);
        Predef$.MODULE$.require(start % step == 0L, (Function0 & Serializable)() -> "start time must be on step boundary");
    }
}

