/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.atlas.core.index;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.netflix.atlas.core.index.TagIndex;
import com.netflix.atlas.core.index.TagQuery;
import com.netflix.atlas.core.model.Tag;
import com.netflix.atlas.core.model.TaggedItem;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import scala.Function1;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005b\u0001B\t\u0013\u0001uA\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I!\n\u0005\u0006q\u0001!\t!\u000f\u0005\by\u0001\u0011\r\u0011\"\u0003>\u0011\u0019a\u0006\u0001)A\u0005}!9Q\f\u0001b\u0001\n\u0013q\u0006BB5\u0001A\u0003%q\fC\u0004k\u0001\t\u0007I\u0011\u00020\t\r-\u0004\u0001\u0015!\u0003`\u0011\u001da\u0007A1A\u0005\n5Da\u0001\u001d\u0001!\u0002\u0013q\u0007\"B9\u0001\t\u0013\u0011\b\"\u0002@\u0001\t\u0003y\bbBA\u0003\u0001\u0011\u0005\u0011q\u0001\u0005\b\u0003\u0017\u0001A\u0011AA\u0007\u0011\u001d\t\t\u0002\u0001C\u0001\u0003'Aq!a\u0006\u0001\t\u0003\tIBA\bDC\u000eD\u0017N\\4UC\u001eLe\u000eZ3y\u0015\t\u0019B#A\u0003j]\u0012,\u0007P\u0003\u0002\u0016-\u0005!1m\u001c:f\u0015\t9\u0002$A\u0003bi2\f7O\u0003\u0002\u001a5\u00059a.\u001a;gY&D(\"A\u000e\u0002\u0007\r|Wn\u0001\u0001\u0016\u0005yY3c\u0001\u0001 KA\u0011\u0001eI\u0007\u0002C)\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%C\t1\u0011I\\=SK\u001a\u00042AJ\u0014*\u001b\u0005\u0011\u0012B\u0001\u0015\u0013\u0005!!\u0016mZ%oI\u0016D\bC\u0001\u0016,\u0019\u0001!Q\u0001\f\u0001C\u00025\u0012\u0011\u0001V\t\u0003]E\u0002\"\u0001I\u0018\n\u0005A\n#a\u0002(pi\"Lgn\u001a\t\u0003eUj\u0011a\r\u0006\u0003iQ\tQ!\\8eK2L!AN\u001a\u0003\u0015Q\u000bwmZ3e\u0013R,W.\u0001\u0005eK2,w-\u0019;f\u0003\u0019a\u0014N\\5u}Q\u0011!h\u000f\t\u0004M\u0001I\u0003\"B\u001c\u0003\u0001\u0004)\u0013!\u00044j]\u0012$\u0016mZ:DC\u000eDW-F\u0001?!\u0011y\u0004JS'\u000e\u0003\u0001S!!\u0011\"\u0002\u000b\r\f7\r[3\u000b\u0005\r#\u0015\u0001C2bM\u001a,\u0017N\\3\u000b\u0005\u00153\u0015\u0001\u00032f]6\fg.Z:\u000b\u0005\u001dS\u0012AB4ji\",(-\u0003\u0002J\u0001\naAj\\1eS:<7)Y2iKB\u0011aeS\u0005\u0003\u0019J\u0011\u0001\u0002V1h#V,'/\u001f\t\u0004\u001dZKfBA(U\u001d\t\u00016+D\u0001R\u0015\t\u0011F$\u0001\u0004=e>|GOP\u0005\u0002E%\u0011Q+I\u0001\ba\u0006\u001c7.Y4f\u0013\t9\u0006L\u0001\u0003MSN$(BA+\"!\t\u0011$,\u0003\u0002\\g\t\u0019A+Y4\u0002\u001d\u0019Lg\u000e\u001a+bON\u001c\u0015m\u00195fA\u0005ia-\u001b8e\u0017\u0016L8oQ1dQ\u0016,\u0012a\u0018\t\u0005\u007f!S\u0005\rE\u0002O-\u0006\u0004\"A\u00194\u000f\u0005\r$\u0007C\u0001)\"\u0013\t)\u0017%\u0001\u0004Qe\u0016$WMZ\u0005\u0003O\"\u0014aa\u0015;sS:<'BA3\"\u000391\u0017N\u001c3LKf\u001c8)Y2iK\u0002\nqBZ5oIZ\u000bG.^3t\u0007\u0006\u001c\u0007.Z\u0001\u0011M&tGMV1mk\u0016\u001c8)Y2iK\u0002\naBZ5oI&#X-\\:DC\u000eDW-F\u0001o!\u0011y\u0004JS8\u0011\u000793\u0016&A\bgS:$\u0017\n^3ng\u000e\u000b7\r[3!\u0003!qWm^\"bG\",WCA:w)\t!\u0018\u0010\u0005\u0003@\u0011*+\bC\u0001\u0016w\t\u001598B1\u0001y\u0005\u0005\u0011\u0016C\u0001\u0018 \u0011\u0015Q8\u00021\u0001|\u0003\u00051\u0007\u0003\u0002\u0011}\u0015VL!!`\u0011\u0003\u0013\u0019+hn\u0019;j_:\f\u0014\u0001\u00034j]\u0012$\u0016mZ:\u0015\u00075\u000b\t\u0001\u0003\u0004\u0002\u00041\u0001\rAS\u0001\u0006cV,'/_\u0001\tM&tGmS3zgR\u0019\u0001-!\u0003\t\r\u0005\rQ\u00021\u0001K\u0003)1\u0017N\u001c3WC2,Xm\u001d\u000b\u0004A\u0006=\u0001BBA\u0002\u001d\u0001\u0007!*A\u0005gS:$\u0017\n^3ngR\u0019q.!\u0006\t\r\u0005\rq\u00021\u0001K\u0003\u0011\u0019\u0018N_3\u0016\u0005\u0005m\u0001c\u0001\u0011\u0002\u001e%\u0019\u0011qD\u0011\u0003\u0007%sG\u000f")
public class CachingTagIndex<T extends TaggedItem>
implements TagIndex<T> {
    private final TagIndex<T> delegate;
    private final LoadingCache<TagQuery, List<Tag>> findTagsCache;
    private final LoadingCache<TagQuery, List<String>> findKeysCache;
    private final LoadingCache<TagQuery, List<String>> findValuesCache;
    private final LoadingCache<TagQuery, List<T>> findItemsCache;

    private LoadingCache<TagQuery, List<Tag>> findTagsCache() {
        return this.findTagsCache;
    }

    private LoadingCache<TagQuery, List<String>> findKeysCache() {
        return this.findKeysCache;
    }

    private LoadingCache<TagQuery, List<String>> findValuesCache() {
        return this.findValuesCache;
    }

    private LoadingCache<TagQuery, List<T>> findItemsCache() {
        return this.findItemsCache;
    }

    private <R> LoadingCache<TagQuery, R> newCache(Function1<TagQuery, R> f) {
        CacheLoader loader = new CacheLoader<TagQuery, R>(null, f){
            private final Function1 f$1;

            public Map<TagQuery, R> loadAll(Iterable<? extends TagQuery> x$1) throws Exception {
                return super.loadAll(x$1);
            }

            public CompletableFuture asyncLoad(Object x$1, Executor x$2) {
                return super.asyncLoad(x$1, x$2);
            }

            public CompletableFuture<Map<TagQuery, R>> asyncLoadAll(Iterable<? extends TagQuery> x$1, Executor x$2) {
                return super.asyncLoadAll(x$1, x$2);
            }

            public Object reload(Object x$1, Object x$2) throws Exception {
                return super.reload(x$1, x$2);
            }

            public CompletableFuture asyncReload(Object x$1, Object x$2, Executor x$3) {
                return super.asyncReload(x$1, x$2, x$3);
            }

            public R load(TagQuery query) {
                return (R)this.f$1.apply((Object)query);
            }
            {
                this.f$1 = f$1;
            }
        };
        return Caffeine.newBuilder().maximumSize(1000L).build(loader);
    }

    @Override
    public List<Tag> findTags(TagQuery query) {
        return (List)this.findTagsCache().get((Object)query);
    }

    @Override
    public List<String> findKeys(TagQuery query) {
        return (List)this.findKeysCache().get((Object)query);
    }

    @Override
    public List<String> findValues(TagQuery query) {
        return (List)this.findValuesCache().get((Object)query);
    }

    @Override
    public List<T> findItems(TagQuery query) {
        return (List)this.findItemsCache().get((Object)query);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    public CachingTagIndex(TagIndex<T> delegate) {
        this.delegate = delegate;
        this.findTagsCache = this.newCache((Function1 & Serializable)query -> $this.delegate.findTags((TagQuery)query));
        this.findKeysCache = this.newCache((Function1 & Serializable)query -> $this.delegate.findKeys((TagQuery)query));
        this.findValuesCache = this.newCache((Function1 & Serializable)query -> $this.delegate.findValues((TagQuery)query));
        this.findItemsCache = this.newCache((Function1 & Serializable)query -> $this.delegate.findItems((TagQuery)query));
    }
}

