/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.atlas.core.db;

import com.netflix.atlas.core.db.TimeSeriesBuffer$;
import com.netflix.atlas.core.model.ArrayTimeSeq;
import com.netflix.atlas.core.model.Block;
import com.netflix.atlas.core.model.ConsolidationFunction;
import com.netflix.atlas.core.model.ConsolidationFunction$Avg$;
import com.netflix.atlas.core.model.ConsolidationFunction$Sum$;
import com.netflix.atlas.core.model.Datapoint;
import com.netflix.atlas.core.model.DsType;
import com.netflix.atlas.core.model.DsType$Gauge$;
import com.netflix.atlas.core.model.ItemId;
import com.netflix.atlas.core.model.LazyTaggedItem;
import com.netflix.atlas.core.model.MapStepTimeSeq;
import com.netflix.atlas.core.model.TaggedItem;
import com.netflix.atlas.core.model.TimeSeq;
import com.netflix.atlas.core.model.TimeSeries;
import com.netflix.atlas.core.model.TimeSeries$;
import com.netflix.atlas.core.util.Math$;
import java.io.Serializable;
import java.util.BitSet;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0005\t-v!B\u001c9\u0011\u0003\u0019e!B#9\u0011\u00031\u0005\"B'\u0002\t\u0003q\u0005\"B(\u0002\t\u0003\u0001\u0006BB(\u0002\t\u0003\u0011i\u0005\u0003\u0004P\u0003\u0011\u0005!\u0011\f\u0005\b\u0005w\nA\u0011\u0002B?\u0011\u001d\u0011y)\u0001C\u0001\u0005#Cq!a4\u0002\t\u0003\u0011y\nC\u0004\u0002\\\u0006!\tAa)\t\u000f\u0005-\u0018\u0001\"\u0001\u0003(\u001a!Q\t\u000f\u0002S\u0011!y6B!a\u0001\n\u0003\u0001\u0007\u0002C8\f\u0005\u0003\u0007I\u0011\u00019\t\u0011Y\\!\u0011!Q!\n\u0005D\u0001b^\u0006\u0003\u0006\u0004%\t\u0001\u001f\u0005\ty.\u0011\t\u0011)A\u0005s\")Qj\u0003C\u0001{\"9\u0011\u0011A\u0006\u0005\u0002\u0005\r\u0001bBA\u0003\u0017\u0011\u0005\u0011q\u0001\u0005\b\u0003\u001fYA\u0011AA\t\u0011\u001d\tIb\u0003C\u0001\u0003#Aq!a\u0007\f\t\u0003\ti\u0002\u0003\u0004P\u0017\u0011\u0005\u00111\u0006\u0005\b\u0003cYA\u0011AA\u001a\u0011\u001d\tYd\u0003C\u0001\u0003{Aq!a\u0010\f\t\u0013\t\t\u0005\u0003\u0005\u0002F-!\t\u0001OA$\u0011!\tIh\u0003C\u0001q\u0005m\u0004\u0002CAK\u0017\u0011\u0005\u0001(a&\t\u000f\u0005u5\u0002\"\u0001\u0002 \"9\u0011QT\u0006\u0005\u0002\u0005\u0015\u0006bBAO\u0017\u0011\u0005\u00111\u0016\u0005\b\u0003c[A\u0011AAZ\u0011\u001d\t\tl\u0003C\u0001\u0003oCq!a/\f\t\u0003\ti\fC\u0004\u0002<.!\t!!1\t\u000f\u0005\u00157\u0002\"\u0001\u0002H\"9\u0011QY\u0006\u0005\u0002\u0005-\u0007bBAh\u0017\u0011\u0005\u0011\u0011\u001b\u0005\b\u0003\u001f\\A\u0011AAk\u0011\u001d\tYn\u0003C\u0001\u0003;Dq!a7\f\t\u0003\t\t\u000fC\u0004\u0002h.!\t!!;\t\u000f\u0005-8\u0002\"\u0001\u0002n\"9\u00111^\u0006\u0005\u0002\u0005E\bbBA|\u0017\u0011\u0005\u0011\u0011 \u0005\b\u0003{\\A\u0011AA\u0000\u0011\u001d\u0011)a\u0003C\u0001\u0005\u000fAqAa\u0005\f\t\u0003\u0011)\u0002C\u0004\u0003 -!\tA!\t\t\u000f\t\u001d2\u0002\"\u0011\u0003*!9!QG\u0006\u0005B\t]\u0002b\u0002B\u001d\u0017\u0011\u0005!1\b\u0005\b\u0005\u007fYA\u0011\tB!\u0003A!\u0016.\\3TKJLWm\u001d\"vM\u001a,'O\u0003\u0002:u\u0005\u0011AM\u0019\u0006\u0003wq\nAaY8sK*\u0011QHP\u0001\u0006CRd\u0017m\u001d\u0006\u0003\u007f\u0001\u000bqA\\3uM2L\u0007PC\u0001B\u0003\r\u0019w.\\\u0002\u0001!\t!\u0015!D\u00019\u0005A!\u0016.\\3TKJLWm\u001d\"vM\u001a,'o\u0005\u0002\u0002\u000fB\u0011\u0001jS\u0007\u0002\u0013*\t!*A\u0003tG\u0006d\u0017-\u0003\u0002M\u0013\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\"\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0013E\u0013\u0019E!\u0012\u0003H\t%\u0003C\u0001#\f'\u0015YqiU-]!\t!v+D\u0001V\u0015\t1&(A\u0003n_\u0012,G.\u0003\u0002Y+\nQA+[7f'\u0016\u0014\u0018.Z:\u0011\u0005QS\u0016BA.V\u0005\u001d!\u0016.\\3TKF\u0004\"\u0001V/\n\u0005y+&A\u0004'buf$\u0016mZ4fI&#X-\\\u0001\u0005i\u0006<7/F\u0001b!\u0011\u0011\u0017\u000e\u001c7\u000f\u0005\r<\u0007C\u00013J\u001b\u0005)'B\u00014C\u0003\u0019a$o\\8u}%\u0011\u0001.S\u0001\u0007!J,G-\u001a4\n\u0005)\\'aA'ba*\u0011\u0001.\u0013\t\u0003E6L!A\\6\u0003\rM#(/\u001b8h\u0003!!\u0018mZ:`I\u0015\fHCA9u!\tA%/\u0003\u0002t\u0013\n!QK\\5u\u0011\u001d)X\"!AA\u0002\u0005\f1\u0001\u001f\u00132\u0003\u0015!\u0018mZ:!\u0003\u0011!\u0017\r^1\u0016\u0003e\u0004\"\u0001\u0016>\n\u0005m,&\u0001D!se\u0006LH+[7f'\u0016\f\u0018!\u00023bi\u0006\u0004CcA)\u007f\u007f\")q,\u0005a\u0001C\")q/\u0005a\u0001s\u0006)A.\u00192fYV\tA.\u0001\u0004egRK\b/Z\u000b\u0003\u0003\u0013\u00012\u0001VA\u0006\u0013\r\ti!\u0016\u0002\u0007\tN$\u0016\u0010]3\u0002\tM$X\r]\u000b\u0003\u0003'\u00012\u0001SA\u000b\u0013\r\t9\"\u0013\u0002\u0005\u0019>tw-A\u0003ti\u0006\u0014H/\u0001\u0004wC2,Xm]\u000b\u0003\u0003?\u0001R\u0001SA\u0011\u0003KI1!a\tJ\u0005\u0015\t%O]1z!\rA\u0015qE\u0005\u0004\u0003SI%A\u0002#pk\ndW\r\u0006\u0003\u0002&\u00055\u0002bBA\u0018/\u0001\u0007\u00111C\u0001\u0002i\u0006A\u0011n]!mY:\u000bg*\u0006\u0002\u00026A\u0019\u0001*a\u000e\n\u0007\u0005e\u0012JA\u0004C_>dW-\u00198\u0002\t\r|\u0007/_\u000b\u0002#\u0006A\u0011mZ4s)\u0006<7\u000fF\u0002b\u0003\u0007Ba!a\f\u001b\u0001\u0004\t\u0017!C1hOJ\u0014En\\2l)9\tI%a\u0014\u0002T\u0005u\u0013\u0011MA6\u0003_\u00022\u0001SA&\u0013\r\ti%\u0013\u0002\u0004\u0013:$\bBBA)7\u0001\u0007\u0011-A\u0004cY.$\u0016mZ:\t\u000f\u0005U3\u00041\u0001\u0002X\u0005)!\r\\8dWB\u0019A+!\u0017\n\u0007\u0005mSKA\u0003CY>\u001c7\u000eC\u0004\u0002`m\u0001\r!!\u0013\u0002\t\u0005<wM\u001d\u0005\b\u0003GZ\u0002\u0019AA3\u0003\t\u0019g\rE\u0002U\u0003OJ1!!\u001bV\u0005U\u0019uN\\:pY&$\u0017\r^5p]\u001a+hn\u0019;j_:Dq!!\u001c\u001c\u0001\u0004\tI%\u0001\u0005nk2$\u0018\u000e\u001d7f\u0011\u001d\t\th\u0007a\u0001\u0003g\n!a\u001c9\u0011\u0013!\u000b)(!\n\u0002&\u0005\u0015\u0012bAA<\u0013\nIa)\u001e8di&|gNM\u0001\nm\u0006dW/Z'bg.$r!]A?\u0003#\u000b\u0019\nC\u0004\u0002\u0000q\u0001\r!!!\u0002\t5\f7o\u001b\t\u0005\u0003\u0007\u000bi)\u0004\u0002\u0002\u0006*!\u0011qQAE\u0003\u0011)H/\u001b7\u000b\u0005\u0005-\u0015\u0001\u00026bm\u0006LA!a$\u0002\u0006\n1!)\u001b;TKRDq!!\u0016\u001d\u0001\u0004\t9\u0006C\u0004\u0002nq\u0001\r!!\u0013\u0002\u000f\u00054XM]1hKR)\u0011/!'\u0002\u001c\"9\u0011qP\u000fA\u0002\u0005\u0005\u0005bBA7;\u0001\u0007\u0011\u0011J\u0001\u0004C\u0012$GcA9\u0002\"\"1\u00111\u0015\u0010A\u0002E\u000b!\u0001^:\u0015\r\u0005%\u0013qUAU\u0011\u0015yv\u00041\u0001b\u0011\u001d\t)f\ba\u0001\u0003/\"2!]AW\u0011\u001d\ty\u000b\ta\u0001\u0003K\t\u0011A^\u0001\tgV\u0014GO]1diR\u0019\u0011/!.\t\r\u0005\r\u0016\u00051\u0001R)\r\t\u0018\u0011\u0018\u0005\b\u0003_\u0013\u0003\u0019AA\u0013\u0003!iW\u000f\u001c;ja2LHcA9\u0002@\"1\u00111U\u0012A\u0002E#2!]Ab\u0011\u001d\ty\u000b\na\u0001\u0003K\ta\u0001Z5wS\u0012,GcA9\u0002J\"1\u00111U\u0013A\u0002E#2!]Ag\u0011\u001d\tyK\na\u0001\u0003K\t1!\\1y)\r\t\u00181\u001b\u0005\u0007\u0003G;\u0003\u0019A)\u0015\r\u0005%\u0013q[Am\u0011\u0015y\u0006\u00061\u0001b\u0011\u001d\t)\u0006\u000ba\u0001\u0003/\n1!\\5o)\r\t\u0018q\u001c\u0005\u0007\u0003GK\u0003\u0019A)\u0015\r\u0005%\u00131]As\u0011\u0015y&\u00061\u0001b\u0011\u001d\t)F\u000ba\u0001\u0003/\n\u0011\"\u001b8ji\u000e{WO\u001c;\u0015\u0003E\fQaY8v]R$2!]Ax\u0011\u0019\t\u0019\u000b\fa\u0001#R1\u0011\u0011JAz\u0003kDQaX\u0017A\u0002\u0005Dq!!\u0016.\u0001\u0004\t9&A\u0003nKJ<W\rF\u0002r\u0003wDa!a)/\u0001\u0004\t\u0016aC2p]N|G.\u001b3bi\u0016$R!\u0015B\u0001\u0005\u0007Aq!!\u001c0\u0001\u0004\tI\u0005C\u0004\u0002d=\u0002\r!!\u001a\u0002\u001bUt7i\u001c8t_2LG-\u0019;f)\u001d\t&\u0011\u0002B\u0007\u0005#AqAa\u00031\u0001\u0004\t\u0019\"A\u0001t\u0011\u001d\u0011y\u0001\ra\u0001\u0003'\t\u0011!\u001a\u0005\b\u0003\u001f\u0001\u0004\u0019AA\n\u0003%qwN]7bY&TX\rF\u0004R\u0005/\u0011IBa\u0007\t\u000f\u0005=\u0011\u00071\u0001\u0002\u0014!9\u0011\u0011D\u0019A\u0002\u0005M\u0001b\u0002B\u000fc\u0001\u0007\u0011\u0011J\u0001\u0005g&TX-\u0001\u0005hKR4\u0016\r\\;f)\u0011\t)Ca\t\t\u000f\t\u0015\"\u00071\u0001\u0002\u0014\u0005IA/[7fgR\fW\u000e]\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005U\"1\u0006\u0005\b\u0005[\u0019\u0004\u0019\u0001B\u0018\u0003\u0015yG\u000f[3s!\rA%\u0011G\u0005\u0004\u0005gI%aA!os\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002J\u0005A1-\u00198FcV\fG\u000e\u0006\u0003\u00026\tu\u0002b\u0002B\u0017k\u0001\u0007!qF\u0001\ti>\u001cFO]5oOR\tA\u000eC\u0003`\u0007\u0001\u0007\u0011\rC\u0004\u0002\u0010\r\u0001\r!a\u0005\t\u000f\u0005e1\u00011\u0001\u0002\u0014!9!1J\u0002A\u0002\u0005}\u0011A\u0001<t)%\t&q\nB)\u0005'\u0012)\u0006C\u0003`\t\u0001\u0007\u0011\rC\u0004\u0002\u0010\u0011\u0001\r!a\u0005\t\u000f\u0005eA\u00011\u0001\u0002\u0014!9!q\u000b\u0003A\u0002\u0005M\u0011aA3oIRi\u0011Ka\u0017\u0003^\t}#\u0011\rB2\u0005sBQaX\u0003A\u0002\u0005Dq!a\u0004\u0006\u0001\u0004\t\u0019\u0002C\u0004\u0002\u001a\u0015\u0001\r!a\u0005\t\u000f\t]S\u00011\u0001\u0002\u0014!9!QM\u0003A\u0002\t\u001d\u0014A\u00022m_\u000e\\7\u000f\u0005\u0004\u0003j\tM\u0014q\u000b\b\u0005\u0005W\u0012yGD\u0002e\u0005[J\u0011AS\u0005\u0004\u0005cJ\u0015a\u00029bG.\fw-Z\u0005\u0005\u0005k\u00129H\u0001\u0003MSN$(b\u0001B9\u0013\"9\u0011qL\u0003A\u0002\u0005%\u0013\u0001\u00024jY2$R\"\u001dB@\u0005\u0007\u00139I!#\u0003\f\n5\u0005b\u0002BA\r\u0001\u0007\u0011qK\u0001\u0004E2\\\u0007b\u0002BC\r\u0001\u0007\u0011qD\u0001\u0004EV4\u0007bBA\b\r\u0001\u0007\u00111\u0003\u0005\b\u0005\u00171\u0001\u0019AA\n\u0011\u001d\u0011yA\u0002a\u0001\u0003'Aq!a\u0018\u0007\u0001\u0004\tI%A\u0002tk6$BAa%\u0003\u001aB!\u0001J!&R\u0013\r\u00119*\u0013\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\tmu\u00011\u0001\u0003\u001e\u00069!-\u001e4gKJ\u001c\b#\u0002B5\u0005g\nF\u0003\u0002BJ\u0005CCqAa'\t\u0001\u0004\u0011i\n\u0006\u0003\u0003\u0014\n\u0015\u0006b\u0002BN\u0013\u0001\u0007!Q\u0014\u000b\u0005\u0005'\u0013I\u000bC\u0004\u0003\u001c*\u0001\rA!(")
public final class TimeSeriesBuffer
implements TimeSeries,
TimeSeq,
LazyTaggedItem {
    private Map<String, String> tags;
    private final ArrayTimeSeq data;
    private ItemId id;
    private volatile boolean bitmap$0;

    public static Option<TimeSeriesBuffer> sum(List<TimeSeriesBuffer> list) {
        return TimeSeriesBuffer$.MODULE$.sum(list);
    }

    @Override
    public TimeSeq mapValues(Function1<Object, Object> f) {
        return TimeSeq.mapValues$(this, f);
    }

    @Override
    public void foreach(long s, long e, Function2<Object, Object, BoxedUnit> f) {
        TimeSeq.foreach$(this, s, e, f);
    }

    @Override
    public ArrayTimeSeq bounded(long s, long e) {
        return TimeSeq.bounded$(this, s, e);
    }

    @Override
    public Datapoint datapoint(long timestamp) {
        return TimeSeries.datapoint$(this, timestamp);
    }

    @Override
    public TimeSeries unaryOp(String labelFmt, Function1<Object, Object> f) {
        return TimeSeries.unaryOp$(this, labelFmt, f);
    }

    @Override
    public TimeSeries binaryOp(TimeSeries ts, String labelFmt, Function2<Object, Object, Object> f) {
        return TimeSeries.binaryOp$(this, ts, labelFmt, f);
    }

    @Override
    public TimeSeries withTags(Map<String, String> ts) {
        return TimeSeries.withTags$(this, ts);
    }

    @Override
    public TimeSeries withLabel(String s) {
        return TimeSeries.withLabel$(this, s);
    }

    @Override
    public TimeSeries consolidate(long step, ConsolidationFunction cf) {
        return TimeSeries.consolidate$(this, step, cf);
    }

    @Override
    public TimeSeries blend(TimeSeries ts) {
        return TimeSeries.blend$(this, ts);
    }

    @Override
    public TimeSeries mapTimeSeq(Function1<TimeSeq, TimeSeq> f) {
        return TimeSeries.mapTimeSeq$(this, f);
    }

    @Override
    public TimeSeries offset(long dur) {
        return TimeSeries.offset$(this, dur);
    }

    @Override
    public String idString() {
        return TaggedItem.idString$(this);
    }

    @Override
    public boolean isExpired() {
        return TaggedItem.isExpired$(this);
    }

    @Override
    public void foreach(Function2<String, String, BoxedUnit> f) {
        TaggedItem.foreach$(this, f);
    }

    private ItemId id$lzycompute() {
        TimeSeriesBuffer timeSeriesBuffer = this;
        synchronized (timeSeriesBuffer) {
            if (!this.bitmap$0) {
                this.id = LazyTaggedItem.id$(this);
                this.bitmap$0 = true;
            }
        }
        return this.id;
    }

    @Override
    public ItemId id() {
        return !this.bitmap$0 ? this.id$lzycompute() : this.id;
    }

    @Override
    public Map<String, String> tags() {
        return this.tags;
    }

    public void tags_$eq(Map<String, String> x$1) {
        this.tags = x$1;
    }

    @Override
    public ArrayTimeSeq data() {
        return this.data;
    }

    @Override
    public String label() {
        return TimeSeries$.MODULE$.toLabel(this.tags());
    }

    @Override
    public DsType dsType() {
        return this.data().dsType();
    }

    @Override
    public long step() {
        return this.data().step();
    }

    public long start() {
        return this.data().start();
    }

    public double[] values() {
        return this.data().data();
    }

    @Override
    public double apply(long t) {
        return this.data().apply(t);
    }

    public boolean isAllNaN() {
        boolean hasValue = false;
        for (int i = 0; i < this.values().length && !hasValue; ++i) {
            hasValue = !Double.isNaN(this.values()[i]);
        }
        return !hasValue;
    }

    public TimeSeriesBuffer copy() {
        return new TimeSeriesBuffer(this.tags(), new ArrayTimeSeq(this.data().dsType(), this.start(), this.step(), (double[])this.values().clone()));
    }

    private Map<String, String> aggrTags(Map<String, String> t) {
        return this.tags().toSet().intersect((Set)t.toSet()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public int aggrBlock(Map<String, String> blkTags, Block block, int aggr, ConsolidationFunction cf, int multiple, Function2<Object, Object, Object> op) {
        this.tags_$eq(this.aggrTags(blkTags));
        long s = this.start() / this.step();
        long e = (long)this.values().length + s - 1L;
        long bs = block.start() / this.step();
        long be = bs + (long)(block.size() / multiple) - 1L;
        int valueCount = 0;
        if (e >= bs && s <= be) {
            long spos = s > bs ? s : bs;
            long epos = e < be ? e : be;
            long i = spos;
            int j = (int)(i - bs) * multiple;
            while (i <= epos) {
                int pos = (int)(i - s);
                double v = cf.compute(block, j, aggr, multiple);
                this.values()[pos] = op.apply$mcDDD$sp(this.values()[pos], v);
                if (!Predef$.MODULE$.double2Double(this.values()[pos]).isNaN()) {
                    ++valueCount;
                }
                ++i;
                j += multiple;
            }
        }
        return valueCount;
    }

    public void valueMask(BitSet mask, Block block, int multiple) {
        long blkStep = this.step() / (long)multiple;
        long s = this.start() / blkStep;
        long e = (long)(this.values().length * multiple) + s - 1L;
        long bs = block.start() / blkStep;
        long be = bs + (long)block.size() - 1L;
        if (e >= bs && s <= be) {
            long spos = s > bs ? s : bs;
            long epos = e < be ? e : be;
            for (long i = spos; i <= epos; ++i) {
                double v = block.get((int)(i - bs));
                if (Predef$.MODULE$.double2Double(v).isNaN()) continue;
                mask.set((int)(i - s));
            }
        }
    }

    public void average(BitSet mask, int multiple) {
        int end = this.values().length * multiple;
        int count = 0;
        int i = 0;
        while (i < end) {
            if (mask.get(i)) {
                ++count;
            }
            if (++i % multiple != 0) continue;
            if (count > 0) {
                double[] dArray = this.values();
                int n = i / multiple - 1;
                dArray[n] = dArray[n] / (double)count;
            } else {
                this.values()[i / multiple - 1] = Double.NaN;
            }
            count = 0;
        }
    }

    public void add(TimeSeriesBuffer ts) {
        TimeSeriesBuffer nts = ts.normalize(this.step(), this.start(), this.values().length);
        this.tags_$eq(this.aggrTags(nts.tags()));
        int length = package$.MODULE$.min(this.values().length, nts.values().length);
        for (int pos = 0; pos < length; ++pos) {
            this.values()[pos] = Math$.MODULE$.addNaN(this.values()[pos], nts.values()[pos]);
        }
    }

    public int add(Map<String, String> tags, Block block) {
        return this.aggrBlock(tags, block, 0, ConsolidationFunction$Sum$.MODULE$, 1, (Function2<Object, Object, Object>)(JFunction2.mcDDD.sp & Serializable)(v1, v2) -> Math$.MODULE$.addNaN(v1, v2));
    }

    public void add(double v) {
        for (int pos = 0; pos < this.values().length; ++pos) {
            this.values()[pos] = Math$.MODULE$.addNaN(this.values()[pos], v);
        }
    }

    public void subtract(TimeSeriesBuffer ts) {
        TimeSeriesBuffer nts = ts.normalize(this.step(), this.start(), this.values().length);
        this.tags_$eq(this.aggrTags(nts.tags()));
        int length = package$.MODULE$.min(this.values().length, nts.values().length);
        for (int pos = 0; pos < length; ++pos) {
            this.values()[pos] = this.values()[pos] - nts.values()[pos];
        }
    }

    public void subtract(double v) {
        for (int pos = 0; pos < this.values().length; ++pos) {
            this.values()[pos] = this.values()[pos] - v;
        }
    }

    public void multiply(TimeSeriesBuffer ts) {
        TimeSeriesBuffer nts = ts.normalize(this.step(), this.start(), this.values().length);
        this.tags_$eq(this.aggrTags(nts.tags()));
        int length = package$.MODULE$.min(this.values().length, nts.values().length);
        for (int pos = 0; pos < length; ++pos) {
            this.values()[pos] = this.values()[pos] * nts.values()[pos];
        }
    }

    public void multiply(double v) {
        for (int pos = 0; pos < this.values().length; ++pos) {
            this.values()[pos] = this.values()[pos] * v;
        }
    }

    public void divide(TimeSeriesBuffer ts) {
        TimeSeriesBuffer nts = ts.normalize(this.step(), this.start(), this.values().length);
        this.tags_$eq(this.aggrTags(nts.tags()));
        int length = package$.MODULE$.min(this.values().length, nts.values().length);
        for (int pos = 0; pos < length; ++pos) {
            this.values()[pos] = this.values()[pos] / nts.values()[pos];
        }
    }

    public void divide(double v) {
        for (int pos = 0; pos < this.values().length; ++pos) {
            this.values()[pos] = this.values()[pos] / v;
        }
    }

    public void max(TimeSeriesBuffer ts) {
        TimeSeriesBuffer nts = ts.normalize(this.step(), this.start(), this.values().length);
        this.tags_$eq(this.aggrTags(nts.tags()));
        int length = package$.MODULE$.min(this.values().length, nts.values().length);
        for (int pos = 0; pos < length; ++pos) {
            double v1 = this.values()[pos];
            double v2 = nts.values()[pos];
            this.values()[pos] = Math$.MODULE$.maxNaN(v1, v2);
        }
    }

    public int max(Map<String, String> tags, Block block) {
        return this.aggrBlock(tags, block, 3, ConsolidationFunction$Sum$.MODULE$, 1, (Function2<Object, Object, Object>)(JFunction2.mcDDD.sp & Serializable)(v1, v2) -> Math$.MODULE$.maxNaN(v1, v2));
    }

    public void min(TimeSeriesBuffer ts) {
        TimeSeriesBuffer nts = ts.normalize(this.step(), this.start(), this.values().length);
        this.tags_$eq(this.aggrTags(nts.tags()));
        int length = package$.MODULE$.min(this.values().length, nts.values().length);
        for (int pos = 0; pos < length; ++pos) {
            double v1 = this.values()[pos];
            double v2 = nts.values()[pos];
            this.values()[pos] = Math$.MODULE$.minNaN(v1, v2);
        }
    }

    public int min(Map<String, String> tags, Block block) {
        return this.aggrBlock(tags, block, 2, ConsolidationFunction$Sum$.MODULE$, 1, (Function2<Object, Object, Object>)(JFunction2.mcDDD.sp & Serializable)(v1, v2) -> Math$.MODULE$.minNaN(v1, v2));
    }

    public void initCount() {
        for (int pos = 0; pos < this.values().length; ++pos) {
            this.values()[pos] = Double.isNaN(this.values()[pos]) ? 0.0 : 1.0;
        }
    }

    public void count(TimeSeriesBuffer ts) {
        TimeSeriesBuffer nts = ts.normalize(this.step(), this.start(), this.values().length);
        this.tags_$eq(this.aggrTags(nts.tags()));
        int length = package$.MODULE$.min(this.values().length, nts.values().length);
        for (int pos = 0; pos < length; ++pos) {
            double v1 = this.values()[pos];
            double v2 = Double.isNaN(nts.values()[pos]) ? 0.0 : 1.0;
            this.values()[pos] = v1 + v2;
        }
    }

    public int count(Map<String, String> tags, Block block) {
        return this.aggrBlock(tags, block, 1, ConsolidationFunction$Sum$.MODULE$, 1, (Function2<Object, Object, Object>)(JFunction2.mcDDD.sp & Serializable)(v1, v2) -> Math$.MODULE$.addNaN(v1, v2));
    }

    public void merge(TimeSeriesBuffer ts) {
        Predef$.MODULE$.require(this.step() == ts.step(), (Function0 & Serializable)() -> "step sizes must be the same");
        Predef$.MODULE$.require(this.start() == ts.start(), (Function0 & Serializable)() -> "start times must be the same");
        this.tags_$eq(this.aggrTags(ts.tags()));
        int length = package$.MODULE$.min(this.values().length, ts.values().length);
        for (int i = 0; i < length; ++i) {
            double v1 = this.values()[i];
            double v2 = ts.values()[i];
            if (!Double.isNaN(v1) && !(v1 < v2)) continue;
            this.values()[i] = v2;
        }
    }

    public TimeSeriesBuffer consolidate(int multiple, ConsolidationFunction cf) {
        long e = this.start() + this.step() * (long)this.values().length;
        long newStep = this.step() * (long)multiple;
        ArrayTimeSeq seq = new MapStepTimeSeq(this.data(), newStep, cf).bounded(this.start(), e);
        return new TimeSeriesBuffer(this.tags(), seq);
    }

    public TimeSeriesBuffer unConsolidate(long s, long e, long step) {
        long diff = e - s;
        int size = (int)(diff / step + (long)(diff % step != 0L ? 1 : 0));
        double[] buffer = new double[size];
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = this.getValue(s + (long)i * step);
        }
        return new TimeSeriesBuffer(this.tags(), new ArrayTimeSeq(DsType$Gauge$.MODULE$, s, step, buffer));
    }

    public TimeSeriesBuffer normalize(long step, long start, int size) {
        TimeSeriesBuffer timeSeriesBuffer;
        TimeSeriesBuffer buf;
        TimeSeriesBuffer timeSeriesBuffer2 = buf = step > this.step() ? this.consolidate((int)(step / this.step()), (ConsolidationFunction)ConsolidationFunction$Avg$.MODULE$) : this;
        if (buf.start() == start && buf.step() == step) {
            timeSeriesBuffer = buf;
        } else {
            double[] buffer = new double[size];
            for (int i = 0; i < buffer.length; ++i) {
                buffer[i] = buf.getValue(start + (long)i * step);
            }
            timeSeriesBuffer = new TimeSeriesBuffer(this.tags(), new ArrayTimeSeq(DsType$Gauge$.MODULE$, start / step * step, step, buffer));
        }
        return timeSeriesBuffer;
    }

    public double getValue(long timestamp) {
        long offset = timestamp - this.start();
        int pos = (int)(offset / this.step());
        return offset < 0L || pos >= this.values().length ? Double.NaN : this.values()[pos];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        Object object = other;
        if (!(object instanceof TimeSeriesBuffer)) return false;
        TimeSeriesBuffer timeSeriesBuffer = (TimeSeriesBuffer)object;
        if (!timeSeriesBuffer.canEqual(this)) return false;
        Map<String, String> map = this.tags();
        Map<String, String> map2 = timeSeriesBuffer.tags();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        ArrayTimeSeq arrayTimeSeq = this.data();
        ArrayTimeSeq arrayTimeSeq2 = timeSeriesBuffer.data();
        if (arrayTimeSeq == null) {
            if (arrayTimeSeq2 == null) return true;
            return false;
        } else {
            if (!((Object)arrayTimeSeq).equals(arrayTimeSeq2)) return false;
            return true;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var2_2;
        int prime;
        int hc = prime = 31;
        hc = hc * prime + this.tags().hashCode();
        hc = hc * prime + this.data().hashCode();
        return (int)var2_2;
    }

    public boolean canEqual(Object other) {
        return other instanceof TimeSeriesBuffer;
    }

    public String toString() {
        return new StringBuilder(20).append("TimeSeriesBuffer(").append(this.tags()).append(", ").append(this.data()).append(")").toString();
    }

    public TimeSeriesBuffer(Map<String, String> tags, ArrayTimeSeq data) {
        this.tags = tags;
        this.data = data;
        TaggedItem.$init$(this);
        TimeSeries.$init$(this);
        TimeSeq.$init$(this);
        LazyTaggedItem.$init$(this);
    }
}

