/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.atlas.core.db;

import com.netflix.atlas.core.db.TimeSeriesBuffer;
import com.netflix.atlas.core.model.ArrayTimeSeq;
import com.netflix.atlas.core.model.Block;
import com.netflix.atlas.core.model.DsType$Gauge$;
import com.netflix.atlas.core.util.ArrayHelper$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;

public final class TimeSeriesBuffer$ {
    public static final TimeSeriesBuffer$ MODULE$ = new TimeSeriesBuffer$();

    public TimeSeriesBuffer apply(Map<String, String> tags, long step, long start, double[] vs) {
        return new TimeSeriesBuffer(tags, new ArrayTimeSeq(DsType$Gauge$.MODULE$, start / step * step, step, vs));
    }

    public TimeSeriesBuffer apply(Map<String, String> tags, long step, long start, long end) {
        long s = start / step;
        long e = end / step;
        int size = (int)(e - s) + 1;
        double[] buffer = ArrayHelper$.MODULE$.fill(size, Double.NaN);
        return new TimeSeriesBuffer(tags, new ArrayTimeSeq(DsType$Gauge$.MODULE$, s * step, step, buffer));
    }

    public TimeSeriesBuffer apply(Map<String, String> tags, long step, long start, long end, List<Block> blocks, int aggr) {
        long s = start / step;
        long e = end / step;
        int size = (int)(e - s) + 1;
        double[] buffer = ArrayHelper$.MODULE$.fill(size, Double.NaN);
        blocks.foreach((Function1 & Serializable)block -> {
            TimeSeriesBuffer$.MODULE$.fill(block, buffer, step, s, e, aggr);
            return BoxedUnit.UNIT;
        });
        return new TimeSeriesBuffer(tags, new ArrayTimeSeq(DsType$Gauge$.MODULE$, start, step, buffer));
    }

    private void fill(Block blk, double[] buf, long step, long s, long e, int aggr) {
        long bs = blk.start() / step;
        long be = bs + (long)blk.size() - 1L;
        if (e >= bs && s <= be) {
            long spos = s > bs ? s : bs;
            long epos = e < be ? e : be;
            for (long i = spos; i <= epos; ++i) {
                buf[(int)(i - s)] = blk.get((int)(i - bs), aggr);
            }
        }
    }

    public Option<TimeSeriesBuffer> sum(List<TimeSeriesBuffer> buffers) {
        None$ none$;
        List<TimeSeriesBuffer> list = buffers;
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            TimeSeriesBuffer b = (TimeSeriesBuffer)colon2.head();
            List bs = colon2.next$access$1();
            bs.foreach((Function1 & Serializable)ts -> {
                b.add(ts);
                return BoxedUnit.UNIT;
            });
            none$ = new Some((Object)b);
        } else if (Nil$.MODULE$.equals(list)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError(list);
        }
        return none$;
    }

    public Option<TimeSeriesBuffer> max(List<TimeSeriesBuffer> buffers) {
        None$ none$;
        List<TimeSeriesBuffer> list = buffers;
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            TimeSeriesBuffer b = (TimeSeriesBuffer)colon2.head();
            List bs = colon2.next$access$1();
            bs.foreach((Function1 & Serializable)ts -> {
                b.max(ts);
                return BoxedUnit.UNIT;
            });
            none$ = new Some((Object)b);
        } else if (Nil$.MODULE$.equals(list)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError(list);
        }
        return none$;
    }

    public Option<TimeSeriesBuffer> min(List<TimeSeriesBuffer> buffers) {
        None$ none$;
        List<TimeSeriesBuffer> list = buffers;
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            TimeSeriesBuffer b = (TimeSeriesBuffer)colon2.head();
            List bs = colon2.next$access$1();
            bs.foreach((Function1 & Serializable)ts -> {
                b.min(ts);
                return BoxedUnit.UNIT;
            });
            none$ = new Some((Object)b);
        } else if (Nil$.MODULE$.equals(list)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError(list);
        }
        return none$;
    }

    public Option<TimeSeriesBuffer> count(List<TimeSeriesBuffer> buffers) {
        None$ none$;
        List<TimeSeriesBuffer> list = buffers;
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            TimeSeriesBuffer b = (TimeSeriesBuffer)colon2.head();
            List bs = colon2.next$access$1();
            b.initCount();
            bs.foreach((Function1 & Serializable)ts -> {
                b.count(ts);
                return BoxedUnit.UNIT;
            });
            none$ = new Some((Object)b);
        } else if (Nil$.MODULE$.equals(list)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError(list);
        }
        return none$;
    }

    private TimeSeriesBuffer$() {
    }
}

