/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.atlas.core.db;

import com.netflix.atlas.core.model.DsType$Gauge$;
import com.netflix.atlas.core.model.FunctionTimeSeq;
import com.netflix.atlas.core.model.TimeSeries;
import com.netflix.atlas.core.model.TimeSeries$;
import com.netflix.atlas.core.util.TimeWave;
import com.netflix.atlas.core.util.TimeWave$;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.NoSuchElementException;
import java.util.Random;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class DataSet$ {
    public static final DataSet$ MODULE$ = new DataSet$();
    private static final int step = 60000;

    private Map<String, String> mkTags(String app, String node, Option<String> stack, Option<Object> version) {
        String string;
        String string2;
        Option<String> option = stack;
        if (option instanceof Some) {
            Some some = (Some)option;
            String s = (String)some.value();
            string2 = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s-%s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{app, s}));
        } else if (None$.MODULE$.equals(option)) {
            string2 = app;
        } else {
            throw new MatchError(option);
        }
        String cluster = string2;
        Option<Object> option2 = version;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            int v = BoxesRunTime.unboxToInt((Object)some.value());
            string = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s-v%03d"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{cluster, BoxesRunTime.boxToInteger((int)v)}));
        } else if (None$.MODULE$.equals(option2)) {
            string = cluster;
        } else {
            throw new MatchError(option2);
        }
        String asg = string;
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nf.app"), (Object)app), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nf.cluster"), (Object)cluster), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nf.asg"), (Object)asg), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nf.node"), (Object)node)}));
    }

    public List<TimeSeries> staticSps() {
        Map settings = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"silverlight"), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)30), (Object)BoxesRunTime.boxToDouble((double)50.0), (Object)BoxesRunTime.boxToDouble((double)300.0), (Object)BoxesRunTime.boxToDouble((double)5.0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"xbox"), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)12), (Object)BoxesRunTime.boxToDouble((double)40.0), (Object)BoxesRunTime.boxToDouble((double)220.0), (Object)BoxesRunTime.boxToDouble((double)5.0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"wii"), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)11), (Object)BoxesRunTime.boxToDouble((double)20.0), (Object)BoxesRunTime.boxToDouble((double)240.0), (Object)BoxesRunTime.boxToDouble((double)8.0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ps3"), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)22), (Object)BoxesRunTime.boxToDouble((double)40.0), (Object)BoxesRunTime.boxToDouble((double)260.0), (Object)BoxesRunTime.boxToDouble((double)15.0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"appletv"), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)5), (Object)BoxesRunTime.boxToDouble((double)3.0), (Object)BoxesRunTime.boxToDouble((double)40.0), (Object)BoxesRunTime.boxToDouble((double)5.0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"psvita"), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToDouble((double)0.2), (Object)BoxesRunTime.boxToDouble((double)1.2), (Object)BoxesRunTime.boxToDouble((double)0.6)))}));
        Iterable metrics = (Iterable)settings.flatMap((Function1 & Serializable)t -> {
            Some stack = new Some(t._1());
            Tuple4 conf = (Tuple4)t._2();
            return (IndexedSeq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), BoxesRunTime.unboxToInt((Object)conf._1())).flatMap((Function1 & Serializable)i -> DataSet$.$anonfun$staticSps$2(t, stack, conf, BoxesRunTime.unboxToInt((Object)i)));
        });
        return metrics.toList();
    }

    public List<TimeSeries> staticSpsTimer() {
        Map settings = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"silverlight"), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)300), (Object)BoxesRunTime.boxToDouble((double)50.0), (Object)BoxesRunTime.boxToDouble((double)300.0), (Object)BoxesRunTime.boxToDouble((double)5.0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"xbox"), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)120), (Object)BoxesRunTime.boxToDouble((double)40.0), (Object)BoxesRunTime.boxToDouble((double)220.0), (Object)BoxesRunTime.boxToDouble((double)5.0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"wii"), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)111), (Object)BoxesRunTime.boxToDouble((double)20.0), (Object)BoxesRunTime.boxToDouble((double)240.0), (Object)BoxesRunTime.boxToDouble((double)8.0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ps3"), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)220), (Object)BoxesRunTime.boxToDouble((double)40.0), (Object)BoxesRunTime.boxToDouble((double)260.0), (Object)BoxesRunTime.boxToDouble((double)15.0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"appletv"), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToDouble((double)3.0), (Object)BoxesRunTime.boxToDouble((double)40.0), (Object)BoxesRunTime.boxToDouble((double)5.0))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"psvita"), (Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToDouble((double)0.2), (Object)BoxesRunTime.boxToDouble((double)1.2), (Object)BoxesRunTime.boxToDouble((double)0.6)))}));
        Iterable metrics = (Iterable)settings.flatMap((Function1 & Serializable)t -> {
            Some stack = new Some(t._1());
            Tuple4 conf = (Tuple4)t._2();
            return (IndexedSeq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), BoxesRunTime.unboxToInt((Object)conf._1())).flatMap((Function1 & Serializable)i -> DataSet$.$anonfun$staticSpsTimer$2(t, stack, conf, BoxesRunTime.unboxToInt((Object)i)));
        });
        return metrics.toList();
    }

    public List<TimeSeries> statistics(double maxValue, TimeSeries series) {
        int size = 41;
        Random r = new Random(((String)series.tags().apply((Object)"nf.node")).hashCode());
        double[] offsets = (double[])Array$.MODULE$.fill(size, (Function0)(JFunction0.mcD.sp & Serializable)() -> maxValue * package$.MODULE$.abs(r.nextGaussian()), (ClassTag)ClassTag$.MODULE$.Double());
        return (List)new .colon.colon((Object)series, (List)new .colon.colon((Object)this.stat$1("totalTime", (Function1)(JFunction1.mcDJ.sp & Serializable)t -> DataSet$.total$1(t, series, offsets, size), series), (List)new .colon.colon((Object)this.stat$1("totalOfSquares", (Function1)(JFunction1.mcDJ.sp & Serializable)t -> DataSet$.totalOfSquares$1(t, series, offsets, size), series), (List)new .colon.colon((Object)this.stat$1("max", (Function1)(JFunction1.mcDJ.sp & Serializable)t -> DataSet$.max$1(t, offsets, size), series), (List)Nil$.MODULE$))));
    }

    public TimeSeries noisyWaveSeries() {
        TimeSeries idealF = this.wave(50.0, 300.0, Duration.ofDays(1L));
        return this.noise(31, 25.0, idealF);
    }

    public TimeSeries noisyWaveSeries2h() {
        TimeSeries idealF = this.wave(50.0, 300.0, Duration.ofMinutes(137L));
        return this.noise(31, 25.0, idealF);
    }

    public TimeSeries noisyWave() {
        TimeSeries noiseF = this.noisyWaveSeries();
        String name = "requestPerSecond";
        Map tags = (Map)this.mkTags("alerttest", "alert1", (Option<String>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)42))).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)name));
        return noiseF.withTags((Map<String, String>)tags);
    }

    public TimeSeries waveWithOutages() {
        Instant start1 = ZonedDateTime.of(2012, 1, 1, 5, 0, 0, 0, ZoneOffset.UTC).toInstant();
        Instant end1 = ZonedDateTime.of(2012, 1, 1, 6, 38, 0, 0, ZoneOffset.UTC).toInstant();
        Instant start2 = ZonedDateTime.of(2012, 2, 1, 7, 4, 0, 0, ZoneOffset.UTC).toInstant();
        Instant end2 = ZonedDateTime.of(2012, 2, 1, 7, 5, 0, 0, ZoneOffset.UTC).toInstant();
        Instant start3 = ZonedDateTime.of(2012, 1, 2, 4, 22, 0, 0, ZoneOffset.UTC).toInstant();
        Instant end3 = ZonedDateTime.of(2012, 1, 2, 6, 0, 0, 0, ZoneOffset.UTC).toInstant();
        TimeSeries input = this.noisyWaveSeries();
        TimeSeries bad = this.constant(0.0);
        TimeSeries ds1 = this.interval(input, bad, start1.toEpochMilli(), end1.toEpochMilli());
        TimeSeries ds2 = this.interval(ds1, bad, start2.toEpochMilli(), end2.toEpochMilli());
        TimeSeries ds3 = this.interval(ds2, this.noisyWaveSeries2h(), start3.toEpochMilli(), end3.toEpochMilli());
        Tuple2 name = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"requestsPerSecond");
        Map tags = (Map)this.mkTags("alerttest", "alert1", (Option<String>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)42))).$plus(name);
        return ds3.withTags((Map<String, String>)tags);
    }

    public TimeSeries cpuSpikes() {
        Instant start1 = ZonedDateTime.of(2012, 1, 1, 5, 0, 0, 0, ZoneOffset.UTC).toInstant();
        Instant start2 = ZonedDateTime.of(2012, 2, 1, 7, 4, 0, 0, ZoneOffset.UTC).toInstant();
        Instant end2 = ZonedDateTime.of(2012, 2, 1, 7, 5, 0, 0, ZoneOffset.UTC).toInstant();
        TimeSeries normal = this.noise(31, 4.0, this.constant(20.0));
        TimeSeries bad = this.noise(31, 20.0, this.constant(80.0));
        TimeSeries ds1 = this.interval(normal, bad, start1.toEpochMilli(), end2.toEpochMilli());
        TimeSeries ds2 = this.interval(ds1, bad, start2.toEpochMilli(), end2.toEpochMilli());
        Tuple2 name = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"ssCpuUser");
        Map tags = (Map)this.mkTags("alerttest", "alert1", (Option<String>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)42))).$plus(name);
        return ds2.withTags((Map<String, String>)tags);
    }

    public TimeSeries discoveryStatusUp() {
        Instant start1 = ZonedDateTime.of(2012, 1, 1, 5, 0, 0, 0, ZoneOffset.UTC).toInstant();
        Instant end1 = ZonedDateTime.of(2012, 1, 1, 6, 0, 0, 0, ZoneOffset.UTC).toInstant();
        TimeSeries normal = this.constant(1.0);
        TimeSeries bad = this.constant(0.0);
        TimeSeries ds = this.interval(normal, bad, start1.toEpochMilli(), end1.toEpochMilli());
        Tuple2 name = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"DiscoveryStatus_UP");
        Map tags = (Map)this.mkTags("alerttest", "alert1", (Option<String>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)42))).$plus(name);
        return ds.withTags((Map<String, String>)tags);
    }

    public TimeSeries discoveryStatusDown() {
        Instant start1 = ZonedDateTime.of(2012, 1, 1, 5, 0, 0, 0, ZoneOffset.UTC).toInstant();
        Instant end1 = ZonedDateTime.of(2012, 1, 1, 6, 0, 0, 0, ZoneOffset.UTC).toInstant();
        TimeSeries normal = this.constant(0.0);
        TimeSeries bad = this.constant(1.0);
        TimeSeries ds = this.interval(normal, bad, start1.toEpochMilli(), end1.toEpochMilli());
        Tuple2 name = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"DiscoveryStatus_DOWN");
        Map tags = (Map)this.mkTags("alerttest", "alert1", (Option<String>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)42))).$plus(name);
        return ds.withTags((Map<String, String>)tags);
    }

    public int step() {
        return step;
    }

    public TimeSeries constant(double v) {
        return TimeSeries$.MODULE$.apply((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)((Object)BoxesRunTime.boxToDouble((double)v)).toString())}))), new FunctionTimeSeq(DsType$Gauge$.MODULE$, this.step(), (Function1<Object, Object>)(JFunction1.mcDJ.sp & Serializable)x$1 -> v));
    }

    public TimeSeries noise(int size, double noise, TimeSeries series) {
        Random r = new Random(42L);
        double[] offsets = (double[])Array$.MODULE$.fill(size, (Function0)(JFunction0.mcD.sp & Serializable)() -> {
            double v = noise * r.nextDouble();
            return r.nextBoolean() ? v : -1.0 * v;
        }, (ClassTag)ClassTag$.MODULE$.Double());
        return TimeSeries$.MODULE$.apply((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"noise")}))), new FunctionTimeSeq(DsType$Gauge$.MODULE$, this.step(), (Function1<Object, Object>)(JFunction1.mcDJ.sp & Serializable)t -> DataSet$.f$1(t, size, offsets, series)));
    }

    public TimeSeries wave(double min, double max, Duration wavelength) {
        TimeWave sin = TimeWave$.MODULE$.get(wavelength, this.step());
        return TimeSeries$.MODULE$.apply((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"wave")}))), new FunctionTimeSeq(DsType$Gauge$.MODULE$, this.step(), (Function1<Object, Object>)(JFunction1.mcDJ.sp & Serializable)t -> DataSet$.f$2(t, max, min, sin)));
    }

    public TimeSeries interval(TimeSeries ts1, TimeSeries ts2, long s, long e) {
        return TimeSeries$.MODULE$.apply((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"interval")}))), new FunctionTimeSeq(DsType$Gauge$.MODULE$, this.step(), (Function1<Object, Object>)(JFunction1.mcDJ.sp & Serializable)t -> DataSet$.f$3(t, s, e, ts2, ts1)));
    }

    public List<TimeSeries> staticAlertSet() {
        List<TimeSeries> list = this.smallStaticSet();
        List<TimeSeries> list2 = this.staticSpsTimer();
        return ((List)new .colon.colon((Object)this.waveWithOutages(), (List)new .colon.colon((Object)this.cpuSpikes(), (List)new .colon.colon((Object)this.discoveryStatusUp(), (List)new .colon.colon((Object)this.discoveryStatusDown(), (List)Nil$.MODULE$))))).$colon$colon$colon(list2).$colon$colon$colon(list);
    }

    public List<TimeSeries> smallStaticSet() {
        return this.staticSps();
    }

    public List<TimeSeries> get(String name) {
        List<TimeSeries> list;
        String string = name;
        if ("alert".equals(string)) {
            list = this.staticAlertSet();
        } else if ("small".equals(string)) {
            list = this.smallStaticSet();
        } else {
            throw new NoSuchElementException(name);
        }
        return list;
    }

    public static final /* synthetic */ List $anonfun$staticSps$2(Tuple2 t$1, Some stack$1, Tuple4 conf$1, int i) {
        String node = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s-%04x"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{t$1._1(), BoxesRunTime.boxToInteger((int)i)}));
        Map<String, String> app = MODULE$.mkTags("nccp", node, (Option<String>)stack$1, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)42)));
        Map sps = (Map)app.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"sps"));
        TimeSeries idealF = MODULE$.wave(BoxesRunTime.unboxToDouble((Object)conf$1._2()), BoxesRunTime.unboxToDouble((Object)conf$1._3()), Duration.ofDays(1L));
        TimeSeries ideal = idealF.withTags((Map<String, String>)((Map)sps.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"ideal"))));
        TimeSeries lowNoiseF = MODULE$.noise(31, BoxesRunTime.unboxToDouble((Object)conf$1._4()), idealF);
        TimeSeries lowNoise = lowNoiseF.withTags((Map<String, String>)((Map)sps.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"low-noise"))));
        TimeSeries highNoiseF = MODULE$.noise(31, 4.0 * BoxesRunTime.unboxToDouble((Object)conf$1._4()), idealF);
        TimeSeries highNoise = highNoiseF.withTags((Map<String, String>)((Map)sps.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"high-noise"))));
        return ((List)new .colon.colon((Object)ideal, (List)new .colon.colon((Object)lowNoise, (List)new .colon.colon((Object)highNoise, (List)Nil$.MODULE$)))).map((Function1 & Serializable)m -> m.withTags((Map<String, String>)((Map)m.tags().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type2"), (Object)((String)m.tags().apply((Object)"type")).toUpperCase())))));
    }

    public static final /* synthetic */ List $anonfun$staticSpsTimer$2(Tuple2 t$2, Some stack$2, Tuple4 conf$2, int i) {
        String node = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s-%04x"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{t$2._1(), BoxesRunTime.boxToInteger((int)i)}));
        Map<String, String> app = MODULE$.mkTags("nccp", node, (Option<String>)stack$2, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)42)));
        Map sps = (Map)app.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"playback.startLatency"));
        TimeSeries idealF = MODULE$.wave(BoxesRunTime.unboxToDouble((Object)conf$2._2()), BoxesRunTime.unboxToDouble((Object)conf$2._3()), Duration.ofDays(1L));
        TimeSeries highNoiseF = MODULE$.noise(31, 4.0 * BoxesRunTime.unboxToDouble((Object)conf$2._4()), idealF);
        TimeSeries highNoise = highNoiseF.withTags((Map<String, String>)((Map)sps.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"statistic"), (Object)"count"))));
        TimeSeries exists = MODULE$.constant(1.0).withTags((Map<String, String>)((Map)app.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"poller.asg.instance"))));
        double isUp = i % 2 == 0 ? 1.0 : 0.0;
        TimeSeries up = MODULE$.constant(isUp).withTags((Map<String, String>)((Map)app.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"DiscoveryStatus_nccp_UP"))));
        TimeSeries timeSeries = exists;
        TimeSeries timeSeries2 = up;
        return MODULE$.statistics(0.25, highNoise).$colon$colon((Object)timeSeries2).$colon$colon((Object)timeSeries);
    }

    private static final double total$1(long t, TimeSeries series$1, double[] offsets$1, int size$1) {
        return series$1.data().apply(t) * offsets$1[(int)(t % (long)size$1)];
    }

    private static final double totalOfSquares$1(long t, TimeSeries series$1, double[] offsets$1, int size$1) {
        return series$1.data().apply(t) * offsets$1[(int)(t % (long)size$1)];
    }

    private static final double max$1(long t, double[] offsets$1, int size$1) {
        return offsets$1[(int)(t % (long)size$1)];
    }

    private final TimeSeries stat$1(String name, Function1 f, TimeSeries series$1) {
        return TimeSeries$.MODULE$.apply((Map<String, String>)((Map)series$1.tags().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"statistic"), (Object)name))), new FunctionTimeSeq(DsType$Gauge$.MODULE$, this.step(), (Function1<Object, Object>)f));
    }

    private static final double f$1(long t, int size$2, double[] offsets$2, TimeSeries series$2) {
        int i = (int)(t % (long)size$2);
        double offset = offsets$2[i];
        double v = series$2.data().apply(t) + offset;
        return v < 0.0 ? 0.0 : v;
    }

    private static final double f$2(long t, double max$2, double min$1, TimeWave sin$1) {
        double amp = (max$2 - min$1) / 2.0;
        double yoffset = min$1 + amp;
        return amp * sin$1.apply(t) + yoffset;
    }

    private static final double f$3(long t, long s$1, long e$1, TimeSeries ts2$1, TimeSeries ts1$1) {
        TimeSeries ts = t >= s$1 && t < e$1 ? ts2$1 : ts1$1;
        return ts.data().apply(t);
    }

    private DataSet$() {
    }
}

