/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.fastcsv.writer;

import java.io.IOException;
import java.io.Writer;

final class FastBufferedWriter
extends Writer {
    private static final int BUFFER_SIZE = 8192;
    private Writer out;
    private char[] buf = new char[8192];
    private int pos;

    FastBufferedWriter(Writer writer) {
        this.out = writer;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.pos + len >= this.buf.length) {
            this.flushBuffer();
        }
        if (len >= this.buf.length) {
            this.out.write(cbuf, off, len);
        } else {
            System.arraycopy(cbuf, off, this.buf, this.pos, len);
            this.pos += len;
        }
    }

    @Override
    public void write(int c) throws IOException {
        if (this.pos == this.buf.length) {
            this.flushBuffer();
        }
        this.buf[this.pos++] = (char)c;
    }

    @Override
    public void close() throws IOException {
        this.flushBuffer();
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        this.out.flush();
    }

    private void flushBuffer() throws IOException {
        this.out.write(this.buf, 0, this.pos);
        this.pos = 0;
    }
}

