/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.securitybuilder;

import com.tersesystems.securitybuilder.InstanceGenerator;
import com.tersesystems.securitybuilder.KeyManagerKeyStoreBuilder;
import com.tersesystems.securitybuilder.PrivateKeyStore;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.KeyStoreBuilderParameters;
import javax.net.ssl.X509ExtendedKeyManager;
import org.slieb.throwables.SupplierWithThrowable;

public class KeyManagerBuilder {
    private KeyManagerBuilder() {
    }

    public static KeyManagerFactoryStage builder() {
        return new KeyManagerFactoryStageImpl();
    }

    private static class BuilderFinalImpl
    implements BuilderFinal {
        private final SupplierWithThrowable<KeyManagerFactory, GeneralSecurityException> keyManagerFactory;

        BuilderFinalImpl(SupplierWithThrowable<KeyManagerFactory, GeneralSecurityException> keyManagerFactory) {
            this.keyManagerFactory = keyManagerFactory;
        }

        @Override
        public X509ExtendedKeyManager build() throws GeneralSecurityException {
            return (X509ExtendedKeyManager)((KeyManagerFactory)this.keyManagerFactory.getWithThrowable()).getKeyManagers()[0];
        }
    }

    private static class NewSunParametersStageImpl
    implements NewSunParametersStage {
        private final Supplier<KeyManagerFactory> supplier;

        NewSunParametersStageImpl(Supplier<KeyManagerFactory> supplier) {
            this.supplier = supplier;
        }

        @Override
        public BuilderFinal withPrivateKeyStore(PrivateKeyStore privateKeyStore) {
            return this.withBuilders(() -> Collections.singletonList(privateKeyStore.getBuilder()));
        }

        @Override
        public BuilderFinal withKeyStore(KeyStore keyStore, char[] keyStorePassword) {
            return this.withBuilders(() -> Collections.singletonList(KeyManagerKeyStoreBuilder.newInstance(keyStore, keyStorePassword)));
        }

        @Override
        public BuilderFinal withBuilders(List<KeyStore.Builder> builders) {
            return this.withBuilders(() -> builders);
        }

        @Override
        public BuilderFinal withBuilders(Supplier<List<KeyStore.Builder>> builders) {
            return new BuilderFinalImpl((SupplierWithThrowable<KeyManagerFactory, GeneralSecurityException>)((SupplierWithThrowable)() -> {
                KeyManagerFactory kmf = this.supplier.get();
                kmf.init(new KeyStoreBuilderParameters((List)builders.get()));
                return kmf;
            }));
        }

        @Override
        public BuilderFinal withDefaultKeyStoreAndPassword() {
            return new BuilderFinalImpl((SupplierWithThrowable<KeyManagerFactory, GeneralSecurityException>)((SupplierWithThrowable)() -> {
                KeyManagerFactory kmf = this.supplier.get();
                kmf.init(null, null);
                return kmf;
            }));
        }
    }

    private static class SunParametersStageImpl
    extends InstanceGenerator<KeyManagerFactory, GeneralSecurityException>
    implements SunParametersStage {
        private static final String sunX509 = "SunX509";
        private String provider = null;

        SunParametersStageImpl() {
        }

        SunParametersStageImpl(String provider) {
            this.provider = provider;
        }

        @Override
        public SunPasswordStage withKeyStore(KeyStore keyStore) {
            return this.withKeyStore((SupplierWithThrowable<KeyStore, Exception>)((SupplierWithThrowable)() -> keyStore));
        }

        @Override
        public BuilderFinal withPrivateKeyStore(PrivateKeyStore privateKeyStore) {
            try {
                KeyStore.PasswordProtection passwordProtection = (KeyStore.PasswordProtection)privateKeyStore.getBuilder().getProtectionParameter("default");
                return this.withKeyStore((SupplierWithThrowable<KeyStore, Exception>)((SupplierWithThrowable)privateKeyStore::getKeyStore)).withPassword(passwordProtection.getPassword());
            }
            catch (KeyStoreException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public SunPasswordStage withKeyStore(SupplierWithThrowable<KeyStore, Exception> keyStoreSupplier) {
            return new SunPasswordStageImpl((SupplierWithThrowable<KeyManagerFactory, GeneralSecurityException>)(this.provider == null ? this.getInstance().withAlgorithm(sunX509) : this.getInstance().withAlgorithmAndProvider(sunX509, this.provider)), (Supplier<KeyStore>)keyStoreSupplier);
        }

        @Override
        public SunPasswordStage withDefaultKeyStore() {
            return this.withKeyStore((SupplierWithThrowable<KeyStore, Exception>)((SupplierWithThrowable)() -> null));
        }
    }

    private static class SunPasswordStageImpl
    implements SunPasswordStage {
        private final SupplierWithThrowable<KeyManagerFactory, GeneralSecurityException> keyManagerFactory;
        private final Supplier<KeyStore> keyStore;

        SunPasswordStageImpl(SupplierWithThrowable<KeyManagerFactory, GeneralSecurityException> keyManagerFactory, Supplier<KeyStore> keyStore) {
            this.keyManagerFactory = keyManagerFactory;
            this.keyStore = keyStore;
        }

        @Override
        public BuilderFinal withPassword(KeyStore.PasswordProtection passwordProtection) {
            return this.withPassword(passwordProtection.getPassword());
        }

        @Override
        public BuilderFinal withPassword(char[] password) {
            return new BuilderFinalImpl((SupplierWithThrowable<KeyManagerFactory, GeneralSecurityException>)((SupplierWithThrowable)() -> {
                KeyManagerFactory keyManagerFactory = (KeyManagerFactory)this.keyManagerFactory.get();
                KeyStore keyStore = this.keyStore.get();
                keyManagerFactory.init(keyStore, password);
                return keyManagerFactory;
            }));
        }

        @Override
        public BuilderFinal withDefaultPassword() {
            return new BuilderFinalImpl((SupplierWithThrowable<KeyManagerFactory, GeneralSecurityException>)((SupplierWithThrowable)() -> {
                KeyManagerFactory keyManagerFactory = (KeyManagerFactory)this.keyManagerFactory.get();
                KeyStore keyStore = this.keyStore.get();
                keyManagerFactory.init(keyStore, System.getProperty("javax.net.ssl.keyStorePassword", "").toCharArray());
                return keyManagerFactory;
            }));
        }
    }

    private static class KeyManagerFactoryStageImpl
    extends InstanceGenerator<KeyManagerFactory, GeneralSecurityException>
    implements KeyManagerFactoryStage {
        private KeyManagerFactoryStageImpl() {
        }

        @Override
        public SunParametersStage withSunX509() {
            return new SunParametersStageImpl();
        }

        @Override
        public SunParametersStage withSunX509(String provider) {
            return new SunParametersStageImpl(provider);
        }

        @Override
        public NewSunParametersStage withNewSunX509() {
            return new NewSunParametersStageImpl((Supplier<KeyManagerFactory>)this.getInstance().withAlgorithm("NewSunX509"));
        }

        @Override
        public NewSunParametersStage withNewSunX509(String provider) {
            return new NewSunParametersStageImpl((Supplier<KeyManagerFactory>)this.getInstance().withAlgorithmAndProvider("NewSunX509", provider));
        }
    }

    public static interface BuilderFinal {
        public X509ExtendedKeyManager build() throws GeneralSecurityException;
    }

    public static interface SunPasswordStage {
        public BuilderFinal withPassword(KeyStore.PasswordProtection var1);

        public BuilderFinal withPassword(char[] var1);

        public BuilderFinal withDefaultPassword();
    }

    public static interface NewSunParametersStage {
        public BuilderFinal withKeyStore(KeyStore var1, char[] var2);

        public BuilderFinal withPrivateKeyStore(PrivateKeyStore var1);

        public BuilderFinal withBuilders(List<KeyStore.Builder> var1);

        public BuilderFinal withBuilders(Supplier<List<KeyStore.Builder>> var1);

        public BuilderFinal withDefaultKeyStoreAndPassword();
    }

    public static interface SunParametersStage {
        public SunPasswordStage withKeyStore(KeyStore var1);

        public BuilderFinal withPrivateKeyStore(PrivateKeyStore var1);

        public SunPasswordStage withKeyStore(SupplierWithThrowable<KeyStore, Exception> var1);

        public SunPasswordStage withDefaultKeyStore();
    }

    public static interface KeyManagerFactoryStage {
        public SunParametersStage withSunX509();

        public SunParametersStage withSunX509(String var1);

        public NewSunParametersStage withNewSunX509();

        public NewSunParametersStage withNewSunX509(String var1);
    }
}

