/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.securitybuilder;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyAgreement;
import org.slieb.throwables.SupplierWithThrowable;

public class KeyAgreementBuilder {
    public static InitialStage builder() {
        return new InitialStageImpl();
    }

    private static class BuildFinalImpl
    implements BuildFinal {
        private final SupplierWithThrowable<KeyAgreement, GeneralSecurityException> supplier;

        BuildFinalImpl(SupplierWithThrowable<KeyAgreement, GeneralSecurityException> supplier) {
            this.supplier = supplier;
        }

        @Override
        public KeyAgreement build() throws GeneralSecurityException {
            return (KeyAgreement)this.supplier.getWithThrowable();
        }
    }

    private static class InitStageImpl
    implements InitStage {
        private final SupplierWithThrowable<KeyAgreement, GeneralSecurityException> supplier;

        InitStageImpl(SupplierWithThrowable<KeyAgreement, GeneralSecurityException> supplier) {
            this.supplier = supplier;
        }

        @Override
        public BuildFinal withKey(PrivateKey key) {
            return new BuildFinalImpl((SupplierWithThrowable<KeyAgreement, GeneralSecurityException>)((SupplierWithThrowable)() -> {
                KeyAgreement keyAgreement = (KeyAgreement)this.supplier.getWithThrowable();
                keyAgreement.init(key);
                return keyAgreement;
            }));
        }

        @Override
        public BuildFinal withKeyAndSpec(PrivateKey key, AlgorithmParameterSpec params) {
            return new BuildFinalImpl((SupplierWithThrowable<KeyAgreement, GeneralSecurityException>)((SupplierWithThrowable)() -> {
                KeyAgreement keyAgreement = (KeyAgreement)this.supplier.getWithThrowable();
                keyAgreement.init((Key)key, params);
                return keyAgreement;
            }));
        }
    }

    private static class InitialStageImpl
    implements InitialStage {
        private InitialStageImpl() {
        }

        @Override
        public InitStage withAlgorithm(String algorithm) {
            return new InitStageImpl((SupplierWithThrowable<KeyAgreement, GeneralSecurityException>)((SupplierWithThrowable)() -> KeyAgreement.getInstance(algorithm)));
        }

        @Override
        public InitStage withAlgorithmAndProvider(String algorithm, String provider) {
            return new InitStageImpl((SupplierWithThrowable<KeyAgreement, GeneralSecurityException>)((SupplierWithThrowable)() -> KeyAgreement.getInstance(algorithm, provider)));
        }

        @Override
        public InitStage withECDH() {
            return this.withAlgorithm("ECDH");
        }

        @Override
        public InitStage withDH() {
            return this.withAlgorithm("DH");
        }
    }

    public static interface BuildFinal {
        public KeyAgreement build() throws GeneralSecurityException;
    }

    public static interface InitStage {
        public BuildFinal withKey(PrivateKey var1);

        public BuildFinal withKeyAndSpec(PrivateKey var1, AlgorithmParameterSpec var2);
    }

    public static interface InitialStage {
        public InitStage withAlgorithm(String var1);

        public InitStage withAlgorithmAndProvider(String var1, String var2);

        public InitStage withECDH();

        public InitStage withDH();
    }
}

