/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.ksql.types;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.schema.ksql.types.SqlLambda;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.schema.utils.FormatOptions;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Immutable
public final class SqlLambdaResolved
extends SqlLambda {
    private final ImmutableList<SqlType> inputTypes;
    private final SqlType returnType;

    public static SqlLambdaResolved of(int numInputs) {
        throw new IllegalArgumentException("SqlLambdaResolved can only be constructed with the input types and return type specified.");
    }

    public static SqlLambdaResolved of(List<SqlType> inputType, SqlType returnType) {
        return new SqlLambdaResolved(inputType, returnType);
    }

    @VisibleForTesting
    SqlLambdaResolved(List<SqlType> inputTypes, SqlType returnType) {
        super(inputTypes.size());
        this.inputTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(inputTypes, "inputType"));
        this.returnType = Objects.requireNonNull(returnType, "returnType");
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="inputTypes is ImmutableList")
    public List<SqlType> getInputType() {
        return this.inputTypes;
    }

    public SqlType getReturnType() {
        return this.returnType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlLambdaResolved lambda = (SqlLambdaResolved)o;
        return super.equals(o) && Objects.equals(this.inputTypes, lambda.inputTypes) && Objects.equals(this.returnType, lambda.returnType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.inputTypes, this.returnType);
    }

    @Override
    public String toString() {
        return this.toString(FormatOptions.none());
    }

    public String toString(FormatOptions formatOptions) {
        return "LAMBDA " + this.inputTypes.stream().map(Object::toString).collect(Collectors.joining(", ", "(", ")")) + " => " + this.returnType.toString(formatOptions);
    }
}

