/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.ksql;

import io.confluent.ksql.schema.ksql.types.SqlIntervalUnit;
import io.confluent.ksql.schema.ksql.types.SqlLambda;
import io.confluent.ksql.schema.ksql.types.SqlLambdaResolved;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.schema.utils.FormatOptions;
import java.util.Objects;
import java.util.Optional;

public class SqlArgument {
    private final Optional<SqlType> sqlType;
    private final Optional<SqlLambda> sqlLambda;
    private final Optional<SqlIntervalUnit> sqlIntervalUnit;

    public SqlArgument(SqlType type, SqlLambda lambda, SqlIntervalUnit intervalUnit) {
        if (type != null && lambda != null) {
            throw new RuntimeException("A function argument was assigned to be both a type and a lambda");
        }
        this.sqlType = Optional.ofNullable(type);
        this.sqlLambda = Optional.ofNullable(lambda);
        this.sqlIntervalUnit = Optional.ofNullable(intervalUnit);
    }

    public static SqlArgument of(SqlType type) {
        return new SqlArgument(type, null, null);
    }

    public static SqlArgument of(SqlLambda type) {
        return new SqlArgument(null, type, null);
    }

    public static SqlArgument of(SqlIntervalUnit type) {
        return new SqlArgument(null, null, type);
    }

    public static SqlArgument of(SqlType sqlType, SqlLambda lambdaType) {
        return new SqlArgument(sqlType, lambdaType, null);
    }

    public Optional<SqlType> getSqlType() {
        return this.sqlType;
    }

    public SqlType getSqlTypeOrThrow() {
        if (this.sqlLambda.isPresent()) {
            throw new RuntimeException("Was expecting type as a function argument");
        }
        return this.sqlType.orElse(null);
    }

    public Optional<SqlLambda> getSqlLambda() {
        return this.sqlLambda;
    }

    public Optional<SqlIntervalUnit> getSqlIntervalUnit() {
        return this.sqlIntervalUnit;
    }

    public SqlLambda getSqlLambdaOrThrow() {
        if (this.sqlType.isPresent()) {
            throw new RuntimeException("Was expecting lambda as a function argument");
        }
        if (this.sqlLambda.isPresent()) {
            return this.sqlLambda.get();
        }
        throw new RuntimeException("Was expecting lambda as a function argument");
    }

    public int hashCode() {
        return Objects.hash(this.sqlType, this.sqlLambda, this.sqlIntervalUnit);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlArgument that = (SqlArgument)o;
        return Objects.equals(this.sqlType, that.sqlType) && Objects.equals(this.sqlLambda, that.sqlLambda) && Objects.equals(this.sqlIntervalUnit, that.sqlIntervalUnit);
    }

    public String toString() {
        return this.toString(FormatOptions.none());
    }

    public String toString(FormatOptions formatOptions) {
        if (this.sqlType.isPresent()) {
            return this.sqlType.get().toString(formatOptions);
        }
        if (this.sqlIntervalUnit.isPresent()) {
            return this.sqlIntervalUnit.get().toString();
        }
        return this.sqlLambda.map(lambda -> {
            if (lambda instanceof SqlLambdaResolved) {
                return ((SqlLambdaResolved)lambda).toString();
            }
            return lambda.toString();
        }).orElse("null");
    }
}

