/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.confluent.ksql.rest.entity.CommandStatusEntity;
import io.confluent.ksql.rest.entity.ConnectorDescription;
import io.confluent.ksql.rest.entity.ConnectorList;
import io.confluent.ksql.rest.entity.ConnectorPluginsList;
import io.confluent.ksql.rest.entity.CreateConnectorEntity;
import io.confluent.ksql.rest.entity.DropConnectorEntity;
import io.confluent.ksql.rest.entity.ErrorEntity;
import io.confluent.ksql.rest.entity.ExecutionPlan;
import io.confluent.ksql.rest.entity.FunctionDescriptionList;
import io.confluent.ksql.rest.entity.FunctionNameList;
import io.confluent.ksql.rest.entity.KafkaTopicsList;
import io.confluent.ksql.rest.entity.KafkaTopicsListExtended;
import io.confluent.ksql.rest.entity.KsqlWarning;
import io.confluent.ksql.rest.entity.PropertiesList;
import io.confluent.ksql.rest.entity.Queries;
import io.confluent.ksql.rest.entity.QueryDescriptionEntity;
import io.confluent.ksql.rest.entity.QueryDescriptionList;
import io.confluent.ksql.rest.entity.SourceDescriptionEntity;
import io.confluent.ksql.rest.entity.SourceDescriptionList;
import io.confluent.ksql.rest.entity.StreamsList;
import io.confluent.ksql.rest.entity.TablesList;
import io.confluent.ksql.rest.entity.TerminateQueryEntity;
import io.confluent.ksql.rest.entity.TopicDescription;
import io.confluent.ksql.rest.entity.TypeList;
import io.confluent.ksql.rest.entity.VariablesList;
import io.confluent.ksql.rest.entity.WarningEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonSubTypes(value={@JsonSubTypes.Type(value=CommandStatusEntity.class, name="currentStatus"), @JsonSubTypes.Type(value=PropertiesList.class, name="properties"), @JsonSubTypes.Type(value=Queries.class, name="queries"), @JsonSubTypes.Type(value=SourceDescriptionEntity.class, name="sourceDescription"), @JsonSubTypes.Type(value=QueryDescriptionEntity.class, name="queryDescription"), @JsonSubTypes.Type(value=TopicDescription.class, name="topicDescription"), @JsonSubTypes.Type(value=StreamsList.class, name="streams"), @JsonSubTypes.Type(value=TablesList.class, name="tables"), @JsonSubTypes.Type(value=KafkaTopicsList.class, name="kafka_topics"), @JsonSubTypes.Type(value=KafkaTopicsListExtended.class, name="kafka_topics_extended"), @JsonSubTypes.Type(value=ExecutionPlan.class, name="executionPlan"), @JsonSubTypes.Type(value=SourceDescriptionList.class, name="source_descriptions"), @JsonSubTypes.Type(value=QueryDescriptionList.class, name="query_descriptions"), @JsonSubTypes.Type(value=FunctionDescriptionList.class, name="describe_function"), @JsonSubTypes.Type(value=FunctionNameList.class, name="function_names"), @JsonSubTypes.Type(value=CreateConnectorEntity.class, name="connector_info"), @JsonSubTypes.Type(value=DropConnectorEntity.class, name="drop_connector"), @JsonSubTypes.Type(value=ConnectorList.class, name="connector_list"), @JsonSubTypes.Type(value=ConnectorPluginsList.class, name="connector_plugins_list"), @JsonSubTypes.Type(value=ConnectorDescription.class, name="connector_description"), @JsonSubTypes.Type(value=TypeList.class, name="type_list"), @JsonSubTypes.Type(value=ErrorEntity.class, name="error_entity"), @JsonSubTypes.Type(value=WarningEntity.class, name="warning_entity"), @JsonSubTypes.Type(value=VariablesList.class, name="variables"), @JsonSubTypes.Type(value=TerminateQueryEntity.class, name="terminate_query")})
public abstract class KsqlEntity {
    private final String statementText;
    private final List<KsqlWarning> warnings;

    public KsqlEntity(String statementText) {
        this(statementText, Collections.emptyList());
    }

    public KsqlEntity(String statementText, List<KsqlWarning> warnings) {
        this.statementText = statementText;
        this.warnings = warnings == null ? new ArrayList<KsqlWarning>() : new ArrayList<KsqlWarning>(warnings);
    }

    public String getStatementText() {
        return this.statementText;
    }

    public List<KsqlWarning> getWarnings() {
        return Collections.unmodifiableList(this.warnings);
    }

    public void updateWarnings(List<KsqlWarning> warnings) {
        this.warnings.addAll(warnings);
    }
}

