/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.confluent.ksql.rest.entity.CommandId;
import io.confluent.ksql.rest.entity.CommandStatus;
import io.confluent.ksql.rest.entity.KsqlEntity;
import io.confluent.ksql.rest.entity.KsqlWarning;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CommandStatusEntity
extends KsqlEntity {
    private final CommandId commandId;
    private final CommandStatus commandStatus;
    private final long commandSequenceNumber;

    public CommandStatusEntity(String statementText, CommandId commandId, CommandStatus commandStatus, Long commandSequenceNumber) {
        this(statementText, commandId, commandStatus, commandSequenceNumber, Collections.emptyList());
    }

    @JsonCreator
    public CommandStatusEntity(@JsonProperty(value="statementText") String statementText, @JsonProperty(value="commandId") CommandId commandId, @JsonProperty(value="commandStatus") CommandStatus commandStatus, @JsonProperty(value="commandSequenceNumber") Long commandSequenceNumber, @JsonProperty(value="warnings") List<KsqlWarning> warnings) {
        super(statementText, warnings);
        this.commandId = Objects.requireNonNull(commandId, "commandId");
        this.commandStatus = Objects.requireNonNull(commandStatus, "commandStatus");
        this.commandSequenceNumber = commandSequenceNumber == null ? -1L : commandSequenceNumber;
    }

    public CommandId getCommandId() {
        return this.commandId;
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    public CommandStatus getCommandStatus() {
        return this.commandStatus;
    }

    public long getCommandSequenceNumber() {
        return this.commandSequenceNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CommandStatusEntity)) {
            return false;
        }
        CommandStatusEntity that = (CommandStatusEntity)o;
        return Objects.equals(this.commandId, that.commandId) && Objects.equals(this.commandStatus, that.commandStatus) && this.commandSequenceNumber == that.commandSequenceNumber;
    }

    public int hashCode() {
        return Objects.hash(this.commandId, this.commandStatus, this.commandSequenceNumber);
    }

    public String toString() {
        return "CommandStatusEntity{commandId=" + this.commandId + ", commandStatus=" + this.commandStatus + ", commandSequenceNumber=" + this.commandSequenceNumber + '}';
    }
}

