/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.ListWorkflowsRequest;
import software.amazon.awssdk.services.glue.model.ListWorkflowsResponse;

public class ListWorkflowsIterable
implements SdkIterable<ListWorkflowsResponse> {
    private final GlueClient client;
    private final ListWorkflowsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWorkflowsIterable(GlueClient client, ListWorkflowsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListWorkflowsResponseFetcher();
    }

    public Iterator<ListWorkflowsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListWorkflowsResponseFetcher
    implements SyncPageFetcher<ListWorkflowsResponse> {
        private ListWorkflowsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkflowsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWorkflowsResponse nextPage(ListWorkflowsResponse previousPage) {
            if (previousPage == null) {
                return ListWorkflowsIterable.this.client.listWorkflows(ListWorkflowsIterable.this.firstRequest);
            }
            return ListWorkflowsIterable.this.client.listWorkflows((ListWorkflowsRequest)((Object)ListWorkflowsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

