/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.ContextWordsCopier;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCustomEntityTypeResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetCustomEntityTypeResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetCustomEntityTypeResponse.getter(GetCustomEntityTypeResponse::name)).setter(GetCustomEntityTypeResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> REGEX_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegexString").getter(GetCustomEntityTypeResponse.getter(GetCustomEntityTypeResponse::regexString)).setter(GetCustomEntityTypeResponse.setter(Builder::regexString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegexString").build()}).build();
    private static final SdkField<List<String>> CONTEXT_WORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContextWords").getter(GetCustomEntityTypeResponse.getter(GetCustomEntityTypeResponse::contextWords)).setter(GetCustomEntityTypeResponse.setter(Builder::contextWords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextWords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, REGEX_STRING_FIELD, CONTEXT_WORDS_FIELD));
    private final String name;
    private final String regexString;
    private final List<String> contextWords;

    private GetCustomEntityTypeResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.regexString = builder.regexString;
        this.contextWords = builder.contextWords;
    }

    public final String name() {
        return this.name;
    }

    public final String regexString() {
        return this.regexString;
    }

    public final boolean hasContextWords() {
        return this.contextWords != null && !(this.contextWords instanceof SdkAutoConstructList);
    }

    public final List<String> contextWords() {
        return this.contextWords;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.regexString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContextWords() ? this.contextWords() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCustomEntityTypeResponse)) {
            return false;
        }
        GetCustomEntityTypeResponse other = (GetCustomEntityTypeResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.regexString(), other.regexString()) && this.hasContextWords() == other.hasContextWords() && Objects.equals(this.contextWords(), other.contextWords());
    }

    public final String toString() {
        return ToString.builder((String)"GetCustomEntityTypeResponse").add("Name", (Object)this.name()).add("RegexString", (Object)this.regexString()).add("ContextWords", this.hasContextWords() ? this.contextWords() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RegexString": {
                return Optional.ofNullable(clazz.cast(this.regexString()));
            }
            case "ContextWords": {
                return Optional.ofNullable(clazz.cast(this.contextWords()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCustomEntityTypeResponse, T> g) {
        return obj -> g.apply((GetCustomEntityTypeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private String name;
        private String regexString;
        private List<String> contextWords = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCustomEntityTypeResponse model) {
            super(model);
            this.name(model.name);
            this.regexString(model.regexString);
            this.contextWords(model.contextWords);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRegexString() {
            return this.regexString;
        }

        public final void setRegexString(String regexString) {
            this.regexString = regexString;
        }

        @Override
        public final Builder regexString(String regexString) {
            this.regexString = regexString;
            return this;
        }

        public final Collection<String> getContextWords() {
            if (this.contextWords instanceof SdkAutoConstructList) {
                return null;
            }
            return this.contextWords;
        }

        public final void setContextWords(Collection<String> contextWords) {
            this.contextWords = ContextWordsCopier.copy(contextWords);
        }

        @Override
        public final Builder contextWords(Collection<String> contextWords) {
            this.contextWords = ContextWordsCopier.copy(contextWords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contextWords(String ... contextWords) {
            this.contextWords(Arrays.asList(contextWords));
            return this;
        }

        @Override
        public GetCustomEntityTypeResponse build() {
            return new GetCustomEntityTypeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCustomEntityTypeResponse> {
        public Builder name(String var1);

        public Builder regexString(String var1);

        public Builder contextWords(Collection<String> var1);

        public Builder contextWords(String ... var1);
    }
}

