/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.exception;

import com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.jackson.jq.exception.JsonQueryException;

public class JsonQueryTypeException
extends JsonQueryException {
    private static final long serialVersionUID = -2719442463094461632L;
    private static final int MAX_JSON_STRING_LENGTH = 14;

    private static String truncate(String text, int len) {
        if (text.length() <= len) {
            return text;
        }
        return text.substring(0, len - 3) + "...";
    }

    public JsonQueryTypeException(JsonNode obj, String msg) {
        this("%s %s", obj, msg);
    }

    public JsonQueryTypeException(JsonNode obj1, JsonNode obj2, String msg) {
        this("%s and %s %s", obj1, obj2, msg);
    }

    private static String formatJsonNodes(String format, Object ... args) {
        Object[] formattedArguments = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof JsonNode) {
                JsonNode node = (JsonNode)args[i];
                formattedArguments[i] = String.format("%s (%s)", node.getNodeType().toString().toLowerCase(), JsonQueryTypeException.truncate(node.toString(), 14));
                continue;
            }
            formattedArguments[i] = args[i];
        }
        return String.format(format, formattedArguments);
    }

    public JsonQueryTypeException(String format, Object ... args) {
        super(JsonQueryTypeException.formatJsonNodes(format, args));
    }
}

