/*
 * Decompiled with CFR 0.152.
 */
package io.conduktor.security;

import arrow.core.Either;
import io.conduktor.security.CertificateConfig;
import io.conduktor.security.CertificateManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.KeyStore;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/conduktor/security/CertificateManagerLoader;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "load", "Larrow/core/Either;", "", "Lio/conduktor/security/CertificateManager;", "customTruststore", "Ljava/nio/file/Path;", "certificateConfig", "Lio/conduktor/security/CertificateConfig;", "common"})
public final class CertificateManagerLoader {
    @NotNull
    public static final CertificateManagerLoader INSTANCE = new CertificateManagerLoader();
    private static final Logger logger = LoggerFactory.getLogger(INSTANCE.getClass());

    private CertificateManagerLoader() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final Either<Throwable, CertificateManager> load(@NotNull Path customTruststore, @NotNull CertificateConfig certificateConfig) {
        Either either;
        if (Files.exists(customTruststore, new LinkOption[0])) {
            logger.info("Loading Conduktor's truststore: " + customTruststore);
            Either $this$flatMap$iv = CertificateManager.Companion.loadKeyStore$common(customTruststore, "changeit");
            boolean $i$f$flatMap = false;
            Either either2 = $this$flatMap$iv;
            if (either2 instanceof Either.Right) {
                KeyStore it = (KeyStore)((Either.Right)$this$flatMap$iv).getValue();
                boolean bl = false;
                CertificateManager cm = new CertificateManager(customTruststore, certificateConfig.getAllowNonTrusted());
                cm.setSSLContextWithConduktorTrustStore$common();
                either = (Either)new Either.Right((Object)cm);
                return either;
            } else {
                if (!(either2 instanceof Either.Left)) throw new NoWhenBranchMatchedException();
                either = $this$flatMap$iv;
            }
            return either;
        } else {
            logger.info("No Conduktor's truststore to load");
            either = (Either)new Either.Right((Object)new CertificateManager(customTruststore, certificateConfig.getAllowNonTrusted()));
        }
        return either;
    }
}

