/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.rdd;

import java.io.Serializable;
import org.apache.spark.Partition;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.random.RandomDataGenerator;
import org.apache.spark.mllib.rdd.RandomRDDPartition;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.collection.Iterator;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.java8.JFunction0;
import scala.util.Random;

public final class RandomRDD$
implements Serializable {
    public static final RandomRDD$ MODULE$ = new RandomRDD$();

    public <T> long $lessinit$greater$default$5() {
        return Utils$.MODULE$.random().nextLong();
    }

    public <T> Partition[] getPartitions(long size, int numPartitions, RandomDataGenerator<T> rng, long seed) {
        RandomRDDPartition[] partitions = new RandomRDDPartition[numPartitions];
        long start = 0L;
        long end = 0L;
        Random random = new Random(seed);
        for (int i = 0; i < numPartitions; ++i) {
            end = (long)(i + 1) * size / (long)numPartitions;
            partitions[i] = new RandomRDDPartition<T>(i, (int)(end - start), rng, random.nextLong());
            start = end;
        }
        return partitions;
    }

    public <T> Iterator<T> getPointIterator(RandomRDDPartition<T> partition, ClassTag<T> evidence$2) {
        RandomDataGenerator generator = partition.generator().copy();
        generator.setSeed(partition.seed());
        return package$.MODULE$.Iterator().fill(partition.size(), (Function0 & Serializable)() -> generator.nextValue());
    }

    public Iterator<Vector> getVectorIterator(RandomRDDPartition<Object> partition, int vectorSize) {
        RandomDataGenerator<Object> generator = partition.generator().copy();
        generator.setSeed(partition.seed());
        return package$.MODULE$.Iterator().fill(partition.size(), (Function0 & Serializable)() -> new DenseVector((double[])Array$.MODULE$.fill(vectorSize, (Function0)(JFunction0.mcD.sp & Serializable)() -> BoxesRunTime.unboxToDouble(generator.nextValue()), (ClassTag)ClassTag$.MODULE$.Double())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RandomRDD$.class);
    }

    private RandomRDD$() {
    }
}

