/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import org.apache.spark.SparkException;
import org.apache.spark.SparkException$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.streaming.state.ConvertableToCannotLoadStoreError;
import org.apache.spark.sql.execution.streaming.state.StateStoreCannotCreateColumnFamilyWithReservedChars;
import org.apache.spark.sql.execution.streaming.state.StateStoreCannotUseColumnFamilyWithInvalidName;
import org.apache.spark.sql.execution.streaming.state.StateStoreCheckpointIdsNotSupported;
import org.apache.spark.sql.execution.streaming.state.StateStoreCheckpointLocationNotEmpty;
import org.apache.spark.sql.execution.streaming.state.StateStoreColumnFamilyMismatch;
import org.apache.spark.sql.execution.streaming.state.StateStoreCommitValidationFailed;
import org.apache.spark.sql.execution.streaming.state.StateStoreDuplicateStateVariableDefined;
import org.apache.spark.sql.execution.streaming.state.StateStoreFailedToGetChangelogWriter;
import org.apache.spark.sql.execution.streaming.state.StateStoreId;
import org.apache.spark.sql.execution.streaming.state.StateStoreIncorrectNumOrderingColsForPrefixScan;
import org.apache.spark.sql.execution.streaming.state.StateStoreIncorrectNumOrderingColsForRangeScan;
import org.apache.spark.sql.execution.streaming.state.StateStoreInvalidConfigAfterRestart;
import org.apache.spark.sql.execution.streaming.state.StateStoreInvalidStamp;
import org.apache.spark.sql.execution.streaming.state.StateStoreInvalidStateMachineTransition;
import org.apache.spark.sql.execution.streaming.state.StateStoreInvalidValueSchemaEvolution;
import org.apache.spark.sql.execution.streaming.state.StateStoreInvalidVariableTypeChange;
import org.apache.spark.sql.execution.streaming.state.StateStoreKeyRowFormatValidationFailure;
import org.apache.spark.sql.execution.streaming.state.StateStoreKeySchemaNotCompatible;
import org.apache.spark.sql.execution.streaming.state.StateStoreMultipleColumnFamiliesNotSupportedException;
import org.apache.spark.sql.execution.streaming.state.StateStoreNullTypeOrderingColsNotSupported;
import org.apache.spark.sql.execution.streaming.state.StateStoreOperationOutOfOrder;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderDoesNotSupportFineGrainedReplay;
import org.apache.spark.sql.execution.streaming.state.StateStoreRemovingColumnFamiliesNotSupportedException;
import org.apache.spark.sql.execution.streaming.state.StateStoreSnapshotFileNotFound;
import org.apache.spark.sql.execution.streaming.state.StateStoreSnapshotPartitionNotFound;
import org.apache.spark.sql.execution.streaming.state.StateStoreStateSchemaFilesThresholdExceeded;
import org.apache.spark.sql.execution.streaming.state.StateStoreUnexpectedEmptyFileInRocksDBZip;
import org.apache.spark.sql.execution.streaming.state.StateStoreUnsupportedOperationException;
import org.apache.spark.sql.execution.streaming.state.StateStoreUnsupportedOperationOnMissingColumnFamily;
import org.apache.spark.sql.execution.streaming.state.StateStoreValueRowFormatValidationFailure;
import org.apache.spark.sql.execution.streaming.state.StateStoreValueSchemaEvolutionThresholdExceeded;
import org.apache.spark.sql.execution.streaming.state.StateStoreValueSchemaNotCompatible;
import org.apache.spark.sql.execution.streaming.state.StateStoreVariableSizeOrderingColsNotSupported;
import org.apache.spark.sql.execution.streaming.state.StatefulProcessorCannotAssignTTLInTimeMode;
import org.apache.spark.sql.execution.streaming.state.StatefulProcessorCannotPerformOperationWithInvalidHandleState;
import org.apache.spark.sql.execution.streaming.state.StatefulProcessorCannotPerformOperationWithInvalidTimeMode;
import org.apache.spark.sql.execution.streaming.state.StatefulProcessorTTLMustBePositive;
import org.apache.spark.sql.execution.streaming.state.TWSSchemaMustBeNullable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class StateStoreErrors$ {
    public static final StateStoreErrors$ MODULE$ = new StateStoreErrors$();

    public SparkException implicitKeyNotFound(String stateName) {
        return SparkException$.MODULE$.internalError("Implicit key not found in state store for stateName=" + stateName, "TWS");
    }

    public SparkException missingTimeValues(String timeMode) {
        return SparkException$.MODULE$.internalError("Failed to find time values for timeMode=" + timeMode, "TWS");
    }

    public StateStoreKeyRowFormatValidationFailure keyRowFormatValidationFailure(String errorMsg, String stateStoreID) {
        return new StateStoreKeyRowFormatValidationFailure(errorMsg, stateStoreID);
    }

    public StateStoreValueRowFormatValidationFailure valueRowFormatValidationFailure(String errorMsg, String stateStoreID) {
        return new StateStoreValueRowFormatValidationFailure(errorMsg, stateStoreID);
    }

    public StateStoreUnsupportedOperationOnMissingColumnFamily unsupportedOperationOnMissingColumnFamily(String operationName, String colFamilyName) {
        return new StateStoreUnsupportedOperationOnMissingColumnFamily(operationName, colFamilyName);
    }

    public StateStoreMultipleColumnFamiliesNotSupportedException multipleColumnFamiliesNotSupported(String stateStoreProvider) {
        return new StateStoreMultipleColumnFamiliesNotSupportedException(stateStoreProvider);
    }

    public StateStoreRemovingColumnFamiliesNotSupportedException removingColumnFamiliesNotSupported(String stateStoreProvider) {
        return new StateStoreRemovingColumnFamiliesNotSupportedException(stateStoreProvider);
    }

    public StateStoreCannotUseColumnFamilyWithInvalidName cannotUseColumnFamilyWithInvalidName(String operationName, String colFamilyName) {
        return new StateStoreCannotUseColumnFamilyWithInvalidName(operationName, colFamilyName);
    }

    public StateStoreUnsupportedOperationException unsupportedOperationException(String operationName, String entity) {
        return new StateStoreUnsupportedOperationException(operationName, entity);
    }

    public void requireNonNullStateValue(Object value, String stateName) {
        SparkException$.MODULE$.require(value != null, "ILLEGAL_STATE_STORE_VALUE.NULL_VALUE", (Function0 & Serializable)() -> (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stateName"), (Object)stateName)})));
    }

    public <S> void requireNonEmptyListStateValue(Object value, String stateName) {
        SparkException$.MODULE$.require(ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.genericArrayOps(value)), "ILLEGAL_STATE_STORE_VALUE.EMPTY_LIST_VALUE", (Function0 & Serializable)() -> (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stateName"), (Object)stateName)})));
    }

    public StateStoreIncorrectNumOrderingColsForPrefixScan incorrectNumOrderingColsForPrefixScan(String numPrefixCols) {
        return new StateStoreIncorrectNumOrderingColsForPrefixScan(numPrefixCols);
    }

    public StateStoreInvalidStateMachineTransition invalidStateMachineTransition(String oldState, String newState, String transition, StateStoreId storeId) {
        return new StateStoreInvalidStateMachineTransition(oldState, newState, transition, storeId);
    }

    public StateStoreInvalidStamp invalidStamp(long providedStamp, long currentStamp) {
        return new StateStoreInvalidStamp(providedStamp, currentStamp);
    }

    public StateStoreIncorrectNumOrderingColsForRangeScan incorrectNumOrderingColsForRangeScan(String numOrderingCols) {
        return new StateStoreIncorrectNumOrderingColsForRangeScan(numOrderingCols);
    }

    public StateStoreNullTypeOrderingColsNotSupported nullTypeOrderingColsNotSupported(String fieldName, String index) {
        return new StateStoreNullTypeOrderingColsNotSupported(fieldName, index);
    }

    public StateStoreVariableSizeOrderingColsNotSupported variableSizeOrderingColsNotSupported(String fieldName, String index) {
        return new StateStoreVariableSizeOrderingColsNotSupported(fieldName, index);
    }

    public StateStoreCannotCreateColumnFamilyWithReservedChars cannotCreateColumnFamilyWithReservedChars(String colFamilyName) {
        return new StateStoreCannotCreateColumnFamilyWithReservedChars(colFamilyName);
    }

    public StatefulProcessorCannotPerformOperationWithInvalidTimeMode cannotPerformOperationWithInvalidTimeMode(String operationType, String timeMode) {
        return new StatefulProcessorCannotPerformOperationWithInvalidTimeMode(operationType, timeMode);
    }

    public StatefulProcessorCannotPerformOperationWithInvalidHandleState cannotPerformOperationWithInvalidHandleState(String operationType, String handleState) {
        return new StatefulProcessorCannotPerformOperationWithInvalidHandleState(operationType, handleState);
    }

    public StatefulProcessorCannotAssignTTLInTimeMode cannotProvideTTLConfigForTimeMode(String stateName, String timeMode) {
        return new StatefulProcessorCannotAssignTTLInTimeMode(stateName, timeMode);
    }

    public StatefulProcessorTTLMustBePositive ttlMustBePositive(String operationType, String stateName) {
        return new StatefulProcessorTTLMustBePositive(operationType, stateName);
    }

    public StateStoreKeySchemaNotCompatible stateStoreKeySchemaNotCompatible(String storedKeySchema, String newKeySchema) {
        return new StateStoreKeySchemaNotCompatible(storedKeySchema, newKeySchema);
    }

    public StateStoreValueSchemaNotCompatible stateStoreValueSchemaNotCompatible(String storedValueSchema, String newValueSchema) {
        return new StateStoreValueSchemaNotCompatible(storedValueSchema, newValueSchema);
    }

    public TWSSchemaMustBeNullable twsSchemaMustBeNullable(String columnFamilyName, String schema) {
        return new TWSSchemaMustBeNullable(columnFamilyName, schema);
    }

    public StateStoreInvalidValueSchemaEvolution stateStoreInvalidValueSchemaEvolution(String oldValueSchema, String newValueSchema) {
        return new StateStoreInvalidValueSchemaEvolution(oldValueSchema, newValueSchema);
    }

    public StateStoreValueSchemaEvolutionThresholdExceeded stateStoreValueSchemaEvolutionThresholdExceeded(int numSchemaEvolutions, int maxSchemaEvolutions, String colFamilyName) {
        return new StateStoreValueSchemaEvolutionThresholdExceeded(numSchemaEvolutions, maxSchemaEvolutions, colFamilyName);
    }

    public StateStoreStateSchemaFilesThresholdExceeded streamingStateSchemaFilesThresholdExceeded(int numSchemaFiles, int schemaFilesThreshold, List<String> addedColFamilies, List<String> removedColFamilies) {
        return new StateStoreStateSchemaFilesThresholdExceeded(numSchemaFiles, schemaFilesThreshold, addedColFamilies, removedColFamilies);
    }

    public StateStoreCheckpointLocationNotEmpty streamingStateCheckpointLocationNotEmpty(String checkpointLocation) {
        return new StateStoreCheckpointLocationNotEmpty(checkpointLocation);
    }

    public StateStoreColumnFamilyMismatch stateStoreColumnFamilyMismatch(String columnFamilyName, String oldColumnFamilySchema, String newColumnFamilySchema) {
        return new StateStoreColumnFamilyMismatch(columnFamilyName, oldColumnFamilySchema, newColumnFamilySchema);
    }

    public StateStoreSnapshotFileNotFound stateStoreSnapshotFileNotFound(String fileToRead, String clazz) {
        return new StateStoreSnapshotFileNotFound(fileToRead, clazz);
    }

    public StateStoreSnapshotPartitionNotFound stateStoreSnapshotPartitionNotFound(long snapshotPartitionId, int operatorId, String checkpointLocation) {
        return new StateStoreSnapshotPartitionNotFound(snapshotPartitionId, operatorId, checkpointLocation);
    }

    public StateStoreProviderDoesNotSupportFineGrainedReplay stateStoreProviderDoesNotSupportFineGrainedReplay(String inputClass) {
        return new StateStoreProviderDoesNotSupportFineGrainedReplay(inputClass);
    }

    public StateStoreInvalidConfigAfterRestart invalidConfigChangedAfterRestart(String configName, String oldConfig, String newConfig) {
        return new StateStoreInvalidConfigAfterRestart(configName, oldConfig, newConfig);
    }

    public StateStoreCommitValidationFailed stateStoreCommitValidationFailed(long batchId, int expectedCommits, int actualCommits, String missingCommits) {
        return new StateStoreCommitValidationFailed(batchId, expectedCommits, actualCommits, missingCommits);
    }

    public StateStoreDuplicateStateVariableDefined duplicateStateVariableDefined(String stateName) {
        return new StateStoreDuplicateStateVariableDefined(stateName);
    }

    public StateStoreInvalidVariableTypeChange invalidVariableTypeChange(String stateName, String oldType, String newType) {
        return new StateStoreInvalidVariableTypeChange(stateName, oldType, newType);
    }

    public StateStoreFailedToGetChangelogWriter failedToGetChangelogWriter(long version, Throwable e) {
        return new StateStoreFailedToGetChangelogWriter(version, e);
    }

    public StateStoreOperationOutOfOrder stateStoreOperationOutOfOrder(String errorMsg) {
        return new StateStoreOperationOutOfOrder(errorMsg);
    }

    public StateStoreUnexpectedEmptyFileInRocksDBZip unexpectedEmptyFileInRocksDBZip(String fileName, String zipFileName) {
        return new StateStoreUnexpectedEmptyFileInRocksDBZip(fileName, zipFileName);
    }

    public Throwable cannotLoadStore(Throwable e) {
        SparkException sparkException;
        Throwable throwable = e;
        if (throwable instanceof SparkException && Option$.MODULE$.apply((Object)(sparkException = (SparkException)throwable).getCondition()).exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.contains("CANNOT_LOAD_STATE_STORE")))) {
            return sparkException;
        }
        if (throwable instanceof ConvertableToCannotLoadStoreError) {
            Throwable throwable2 = throwable;
            return ((ConvertableToCannotLoadStoreError)((Object)throwable2)).convertToCannotLoadStoreError();
        }
        if (throwable != null) {
            Throwable throwable3 = throwable;
            return QueryExecutionErrors$.MODULE$.cannotLoadStore(throwable3);
        }
        throw new MatchError((Object)throwable);
    }

    public StateStoreCheckpointIdsNotSupported stateStoreCheckpointIdsNotSupported(String msg) {
        return new StateStoreCheckpointIdsNotSupported(msg);
    }

    private StateStoreErrors$() {
    }
}

