/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.util;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.util.GpxCreator;

public class ShapeSplitter {
    private static final Logger log = Logger.getLogger(ShapeSplitter.class);
    private static final int LEFT = 0;
    private static final int TOP = 1;
    private static final int RIGHT = 2;
    private static final int BOTTOM = 3;
    private boolean detectedProblems;
    private List<MergeCloseHelper> newLess;
    private List<MergeCloseHelper> newMore;
    private String gpxDirectory;
    private long fullArea;
    private List<LoopEndPoint> endPoints;
    private List<List<Coord>> origList;
    private boolean multSamePoint;
    private LoopEndPoint forwardLine;
    private LoopEndPoint backwardLine;
    private int directionBalance;
    private List<LoopEndPoint> dLoops;
    private List<LoopEndPoint> shapes;
    private List<LoopEndPoint> holes;
    private boolean droppedEmpty;

    public static Path2D.Double clipShape(Shape shape, Rectangle2D clippingRect) {
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        PathIterator pit = shape.getPathIterator(null);
        double[] points = new double[512];
        int num = 0;
        Path2D.Double result = null;
        double[] res = new double[6];
        while (!pit.isDone()) {
            int type = pit.currentSegment(res);
            double x = res[0];
            double y = res[1];
            if (x < minX) {
                minX = x;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (y > maxY) {
                maxY = y;
            }
            switch (type) {
                case 0: 
                case 1: {
                    if (num + 2 >= points.length) {
                        points = Arrays.copyOf(points, points.length * 2);
                    }
                    points[num++] = x;
                    points[num++] = y;
                    break;
                }
                case 4: {
                    Path2D.Double segment = null;
                    if (!clippingRect.contains(minX, minY) || !clippingRect.contains(maxX, maxY)) {
                        Rectangle2D.Double bbox = new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
                        segment = ShapeSplitter.clipSinglePathWithSutherlandHodgman(points, num, clippingRect, bbox);
                    } else {
                        segment = ShapeSplitter.pointsToPath2D(points, num);
                    }
                    if (segment != null) {
                        if (result == null) {
                            result = segment;
                        } else {
                            result.append(segment, false);
                        }
                    }
                    num = 0;
                    minY = Double.POSITIVE_INFINITY;
                    minX = Double.POSITIVE_INFINITY;
                    maxY = Double.NEGATIVE_INFINITY;
                    maxX = Double.NEGATIVE_INFINITY;
                    break;
                }
                default: {
                    log.error((Object)("Unsupported path iterator type " + type + ". This is an mkgmap error."));
                }
            }
            pit.next();
        }
        return result;
    }

    public static Path2D.Double pointsToPath2D(double[] points, int num) {
        if (num < 2) {
            return null;
        }
        if (points[0] == points[num - 2] && points[1] == points[num - 1]) {
            num -= 2;
        }
        if (num < 6) {
            return null;
        }
        Path2D.Double path = new Path2D.Double(1, num / 2 + 2);
        double lastX = points[0];
        double lastY = points[1];
        path.moveTo(lastX, lastY);
        int numOut = 1;
        int i = 2;
        while (i < num) {
            double x = points[i++];
            double y = points[i++];
            if (x == lastX && y == lastY) continue;
            path.lineTo(x, y);
            lastX = x;
            lastY = y;
            ++numOut;
        }
        if (numOut < 3) {
            return null;
        }
        path.closePath();
        return path;
    }

    public static Path2D.Double clipSinglePathWithSutherlandHodgman(double[] points, int num, Rectangle2D clippingRect, Rectangle2D.Double bbox) {
        if (num <= 2 || !bbox.intersects(clippingRect)) {
            return null;
        }
        int countVals = num;
        if (points[0] == points[num - 2] && points[1] == points[num - 1]) {
            countVals -= 2;
        }
        double[] outputList = points;
        double leftX = clippingRect.getMinX();
        double rightX = clippingRect.getMaxX();
        double lowerY = clippingRect.getMinY();
        double upperY = clippingRect.getMaxY();
        boolean eIsIn = false;
        boolean sIsIn = false;
        for (int side = 0; side <= 3; ++side) {
            boolean skipTestForThisSide;
            if (countVals < 6) {
                return null;
            }
            switch (side) {
                case 0: {
                    skipTestForThisSide = bbox.getMinX() >= leftX;
                    break;
                }
                case 1: {
                    skipTestForThisSide = bbox.getMaxY() < upperY;
                    break;
                }
                case 2: {
                    skipTestForThisSide = bbox.getMaxX() < rightX;
                    break;
                }
                default: {
                    boolean bl = skipTestForThisSide = bbox.getMinY() >= lowerY;
                }
            }
            if (skipTestForThisSide) continue;
            double[] input = outputList;
            outputList = new double[countVals + 16];
            double sLon = 0.0;
            double sLat = 0.0;
            double pLon = 0.0;
            double pLat = 0.0;
            int posIn = countVals - 2;
            int posOut = 0;
            for (int i = 0; i < countVals + 2; i += 2) {
                if (posIn >= countVals) {
                    posIn = 0;
                }
                double eLon = input[posIn++];
                double eLat = input[posIn++];
                switch (side) {
                    case 0: {
                        eIsIn = eLon >= leftX;
                        break;
                    }
                    case 1: {
                        eIsIn = eLat < upperY;
                        break;
                    }
                    case 2: {
                        eIsIn = eLon < rightX;
                        break;
                    }
                    default: {
                        boolean bl = eIsIn = eLat >= lowerY;
                    }
                }
                if (i > 0) {
                    if (eIsIn != sIsIn) {
                        double slope = eLon != sLon ? (eLat - sLat) / (eLon - sLon) : 1.0;
                        switch (side) {
                            case 0: {
                                pLon = leftX;
                                pLat = slope * (leftX - sLon) + sLat;
                                break;
                            }
                            case 2: {
                                pLon = rightX;
                                pLat = slope * (rightX - sLon) + sLat;
                                break;
                            }
                            case 1: {
                                pLon = eLon != sLon ? sLon + (upperY - sLat) / slope : sLon;
                                pLat = upperY;
                                break;
                            }
                            default: {
                                pLon = eLon != sLon ? sLon + (lowerY - sLat) / slope : sLon;
                                pLat = lowerY;
                            }
                        }
                    }
                    int toAdd = 0;
                    if (eIsIn) {
                        if (!sIsIn) {
                            toAdd += 2;
                        }
                        toAdd += 2;
                    } else if (sIsIn) {
                        toAdd += 2;
                    }
                    if (posOut + toAdd >= outputList.length) {
                        outputList = Arrays.copyOf(outputList, outputList.length * 2);
                    }
                    if (eIsIn) {
                        if (!sIsIn) {
                            outputList[posOut++] = pLon;
                            outputList[posOut++] = pLat;
                        }
                        outputList[posOut++] = eLon;
                        outputList[posOut++] = eLat;
                    } else if (sIsIn) {
                        outputList[posOut++] = pLon;
                        outputList[posOut++] = pLat;
                    }
                }
                sLon = eLon;
                sLat = eLat;
                sIsIn = eIsIn;
            }
            countVals = posOut;
        }
        return ShapeSplitter.pointsToPath2D(outputList, countVals);
    }

    private void logMsg(Object ... olist) {
        this.detectedProblems = true;
        log.warn(olist);
    }

    private void doLines(int startInx, int endInx, MergeCloseHelper addHolesToThis) {
        boolean calledFromHole;
        int inx = startInx;
        boolean bl = calledFromHole = addHolesToThis == null;
        while (inx < endInx) {
            LoopEndPoint lowElem = this.endPoints.get(inx);
            int otherEndInx = lowElem.otherEnd.ownIndex;
            MergeCloseHelper thisLine = lowElem.theLoop;
            if (lowElem.lowEnd != 1) {
                this.logMsg("Wrong end of shape/hole encountered", inx, startInx, endInx, calledFromHole);
                return;
            }
            this.doLines(inx + 1, otherEndInx, calledFromHole ? thisLine : null);
            inx = otherEndInx + 1;
            if (calledFromHole) {
                thisLine.closeAppend(true);
                continue;
            }
            addHolesToThis.addHole(thisLine);
        }
    }

    private void processLineList(List<MergeCloseHelper> lineInfo, List<List<Coord>> origList) {
        this.origList = origList;
        if (origList == null) {
            return;
        }
        MergeCloseHelper firstLine = lineInfo.get(0);
        if (lineInfo.size() == 1) {
            if (!firstLine.points.isEmpty()) {
                firstLine.closeAppend(false);
            }
            return;
        }
        MergeCloseHelper lastLine = lineInfo.get(lineInfo.size() - 1);
        if (lastLine.points.isEmpty()) {
            lineInfo.remove(lineInfo.size() - 1);
        } else {
            lastLine.combineFirstIntoLast(firstLine);
            lineInfo.remove(0);
            firstLine = lineInfo.get(0);
        }
        if (lineInfo.size() == 1) {
            firstLine.setMoreInfo(0);
            firstLine.closeAppend(true);
            return;
        }
        int fullAreaSign = Long.signum(this.fullArea);
        boolean someDirectionsNotSet = false;
        int areaDirection = 0;
        this.endPoints = new ArrayList<LoopEndPoint>(lineInfo.size() * 2);
        for (MergeCloseHelper thisLine : lineInfo) {
            LoopEndPoint lep2;
            thisLine.setMoreInfo(fullAreaSign);
            if (thisLine.direction == 0) {
                someDirectionsNotSet = true;
            } else if (thisLine.areaToLine != 0L) {
                int tmpAreaDirection = thisLine.direction * Long.signum(thisLine.areaToLine);
                if (areaDirection == 0) {
                    areaDirection = tmpAreaDirection;
                } else if (areaDirection != tmpAreaDirection) {
                    this.logMsg("Direction/Area conflict", fullAreaSign, areaDirection, tmpAreaDirection);
                }
            }
            LoopEndPoint lep1 = new LoopEndPoint(thisLine.lowPoint, 1, thisLine);
            lep1.otherEnd = lep2 = new LoopEndPoint(thisLine.highPoint, -1, thisLine);
            lep2.otherEnd = lep1;
            this.endPoints.add(lep1);
            this.endPoints.add(lep2);
        }
        if (someDirectionsNotSet) {
            if (areaDirection == 0) {
                this.logMsg("Can't deduce direction/Area mapping", fullAreaSign);
            } else {
                for (MergeCloseHelper thisLine : lineInfo) {
                    if (thisLine.direction != 0) continue;
                    thisLine.direction = areaDirection * Long.signum(thisLine.areaToLine);
                }
            }
        }
        EndPointComparator comparator = new EndPointComparator();
        this.multSamePoint = false;
        this.endPoints.sort(comparator);
        if (this.multSamePoint) {
            this.processAwkward(comparator);
        }
        int ownIndex = 0;
        for (LoopEndPoint endPoint : this.endPoints) {
            endPoint.ownIndex = ownIndex++;
        }
        this.doLines(0, this.endPoints.size(), null);
        if (this.detectedProblems && log.isDebugEnabled()) {
            for (LoopEndPoint endPoint : this.endPoints) {
                log.warn("ep", endPoint.ownIndex, endPoint.thePoint, endPoint.lowEnd, System.identityHashCode(endPoint), System.identityHashCode(endPoint.otherEnd), endPoint.theLoop);
            }
        }
    }

    private void processAwkward(Comparator<LoopEndPoint> comparator) {
        boolean haveBalloons = false;
        ArrayList<LoopEndPoint> newList = new ArrayList<LoopEndPoint>(this.endPoints.size());
        LoopEndPoint prevElem = null;
        boolean grouping = false;
        for (LoopEndPoint thisElem : this.endPoints) {
            if (prevElem != null) {
                boolean sameAsPrev = comparator.compare(thisElem, prevElem) == 0;
                this.fixDups(newList, prevElem, sameAsPrev, grouping);
                grouping = sameAsPrev;
            }
            prevElem = thisElem;
            if (thisElem.theLoop.lowPoint != thisElem.theLoop.highPoint) continue;
            haveBalloons = true;
        }
        this.fixDups(newList, prevElem, false, grouping);
        if (newList.size() < this.endPoints.size()) {
            log.debug("Reduced dLoops from", this.endPoints.size(), "to", newList.size());
            this.endPoints.clear();
            this.endPoints.addAll(newList);
        }
        if (!haveBalloons) {
            return;
        }
        newList = new ArrayList(this.endPoints.size());
        this.dLoops = new ArrayList<LoopEndPoint>();
        this.shapes = new ArrayList<LoopEndPoint>();
        this.holes = new ArrayList<LoopEndPoint>();
        this.droppedEmpty = false;
        boolean reordered = false;
        prevElem = null;
        grouping = false;
        for (LoopEndPoint thisElem : this.endPoints) {
            if (prevElem != null) {
                boolean sameAsPrev = thisElem.thePoint == prevElem.thePoint;
                reordered |= this.fixOrder(newList, prevElem, sameAsPrev, grouping, comparator);
                grouping = sameAsPrev;
            }
            prevElem = thisElem;
        }
        if ((reordered |= this.fixOrder(newList, prevElem, false, grouping, comparator)) || this.droppedEmpty) {
            log.debug("Reordered endPoints or droppedEmpty", this.droppedEmpty);
            this.endPoints.clear();
            this.endPoints.addAll(newList);
        }
    }

    private void fixDups(List<LoopEndPoint> newList, LoopEndPoint prevElem, boolean sameAsPrev, boolean grouping) {
        if (grouping || sameAsPrev) {
            if (prevElem.lowEnd == 1) {
                if (!grouping) {
                    this.forwardLine = null;
                    this.backwardLine = null;
                    this.directionBalance = 0;
                }
                if (prevElem.theLoop.direction > 0) {
                    this.forwardLine = prevElem;
                    ++this.directionBalance;
                } else {
                    this.backwardLine = prevElem;
                    --this.directionBalance;
                }
                prevElem.theLoop.removedDloop = true;
            } else if (!prevElem.theLoop.removedDloop) {
                newList.add(prevElem);
            }
        }
        if (sameAsPrev) {
            return;
        }
        if (!grouping) {
            newList.add(prevElem);
            return;
        }
        if (prevElem.lowEnd == 1) {
            if (this.directionBalance > 0) {
                newList.add(this.forwardLine);
                this.forwardLine.theLoop.removedDloop = false;
            } else if (this.directionBalance < 0) {
                newList.add(this.backwardLine);
                this.backwardLine.theLoop.removedDloop = false;
            }
        }
    }

    private boolean fixOrder(List<LoopEndPoint> newList, LoopEndPoint prevElem, boolean sameAsPrev, boolean grouping, Comparator<LoopEndPoint> comparator) {
        if (grouping || sameAsPrev) {
            if (prevElem.theLoop.lowPoint != prevElem.theLoop.highPoint) {
                this.dLoops.add(prevElem);
            } else if (prevElem.theLoop.areaOrHole == 1) {
                this.shapes.add(prevElem);
            } else if (prevElem.theLoop.areaOrHole == -1) {
                this.holes.add(prevElem);
            } else {
                this.droppedEmpty = true;
            }
        }
        if (sameAsPrev) {
            return false;
        }
        if (!grouping) {
            newList.add(prevElem);
            return false;
        }
        if (this.holes.size() > 2) {
            log.warn("Cutting", this.holes.size() / 2, "holes at same point might cause self-intersection", this.holes.get((int)0).theLoop.points.get(0).toOSMURL());
        }
        if (this.dLoops.isEmpty()) {
            if (this.shapes.isEmpty()) {
                newList.addAll(this.holes);
                this.holes.clear();
                return false;
            }
            if (this.holes.isEmpty()) {
                newList.addAll(this.shapes);
                this.shapes.clear();
                return false;
            }
            if (this.shapes.size() > 2) {
                log.warn("Cutting hole and ", this.shapes.size() / 2, "shapes at same point is problematic", this.shapes.get((int)0).theLoop.points.get(0).toOSMURL());
            }
            this.shapes.addAll(this.holes);
            this.holes.clear();
            this.shapes.sort(comparator);
            newList.addAll(this.shapes);
            this.shapes.clear();
            return true;
        }
        if (this.shapes.isEmpty() && this.holes.isEmpty()) {
            newList.addAll(this.dLoops);
            this.dLoops.clear();
            return false;
        }
        if (this.dLoops.get((int)0).theLoop.areaOrHole == this.dLoops.get((int)0).lowEnd) {
            newList.addAll(this.shapes);
            newList.add(this.dLoops.get(0));
            newList.addAll(this.holes);
        } else {
            newList.addAll(this.holes);
            newList.add(this.dLoops.get(0));
            newList.addAll(this.shapes);
        }
        this.dLoops.remove(0);
        if (!this.dLoops.isEmpty()) {
            log.warn("Possible ambiguous balloon allocation at", this.dLoops.get((int)0).theLoop.points.get(0).toOSMURL(), "Dloops:", this.dLoops.size(), "shapes:", this.shapes.size() / 2, "holes:", this.holes.size() / 2);
            newList.addAll(this.dLoops);
            this.dLoops.clear();
        }
        this.shapes.clear();
        this.holes.clear();
        return true;
    }

    private List<Coord> startLine(List<MergeCloseHelper> lineInfo) {
        MergeCloseHelper thisLine = new MergeCloseHelper();
        lineInfo.add(thisLine);
        return thisLine.points;
    }

    private void openLine(List<MergeCloseHelper> lineInfo, Coord lineCoord, int lineAlong, long currentArea) {
        MergeCloseHelper thisLine = lineInfo.get(lineInfo.size() - 1);
        thisLine.points.add(lineCoord);
        thisLine.firstPoint = lineAlong;
        thisLine.startingArea = currentArea;
    }

    private List<Coord> closeLine(List<MergeCloseHelper> lineInfo, Coord lineCoord, int lineAlong, long currentArea) {
        MergeCloseHelper thisLine = lineInfo.get(lineInfo.size() - 1);
        thisLine.points.add(lineCoord);
        thisLine.lastPoint = lineAlong;
        thisLine.endingArea = currentArea;
        return this.startLine(lineInfo);
    }

    public static void splitShape(List<Coord> coords, int dividingLine, boolean isLongitude, List<List<Coord>> lessList, List<List<Coord>> moreList, Long2ObjectOpenHashMap<Coord> coordPool) {
        ShapeSplitter ss = new ShapeSplitter();
        ss.split(coords, dividingLine, isLongitude, lessList, moreList, coordPool);
    }

    private void split(List<Coord> coords, int dividingLine, boolean isLongitude, List<List<Coord>> lessList, List<List<Coord>> moreList, Long2ObjectOpenHashMap<Coord> coordPool) {
        if (log.isDebugEnabled()) {
            this.gpxDirectory = (isLongitude ? "V" : "H") + dividingLine + "_" + (isLongitude ? coords.get(0).getLatitude() : coords.get(0).getLongitude()) + "/";
        }
        this.formLoops(coords, dividingLine, isLongitude, lessList != null, moreList != null, coordPool);
        this.processLineList(this.newLess, lessList);
        this.processLineList(this.newMore, moreList);
        if (this.detectedProblems) {
            this.logDiagInfo(coords, lessList, moreList);
            log.warn(isLongitude ? "Vertical" : "Horizontal", "split", dividingLine, "failed on shape at", coords.get(0).toOSMURL(), "Possibly a self-intersecting polygon");
        }
    }

    private void formLoops(List<Coord> coords, int dividingLine, boolean isLongitude, boolean wantLess, boolean wantMore, Long2ObjectOpenHashMap<Coord> coordPool) {
        List<Coord> lessPoly = null;
        List<Coord> morePoly = null;
        if (wantLess) {
            this.newLess = new ArrayList<MergeCloseHelper>();
            lessPoly = this.startLine(this.newLess);
        }
        if (wantMore) {
            this.newMore = new ArrayList<MergeCloseHelper>();
            morePoly = this.startLine(this.newMore);
        }
        Coord trailCoord = null;
        int trailAway = 0;
        int trailAlong = 0;
        int trailRel = 0;
        long runningArea = 0L;
        for (Coord leadCoord : coords) {
            int leadAway = isLongitude ? leadCoord.getHighPrecLon() : leadCoord.getHighPrecLat();
            int leadAlong = isLongitude ? leadCoord.getHighPrecLat() : leadCoord.getHighPrecLon();
            int leadRel = Integer.signum(leadAway - dividingLine);
            if (trailCoord != null) {
                long extraArea;
                Coord lineCoord = null;
                int lineAlong = trailAlong;
                if (trailRel == 0) {
                    lineCoord = trailCoord;
                } else if (leadRel == 0) {
                    lineCoord = leadCoord;
                    lineAlong = leadAlong;
                } else if (trailRel != leadRel) {
                    if (lineAlong != leadAlong) {
                        lineAlong = (int)((long)lineAlong + Math.round((double)(dividingLine - trailAway) * (double)(leadAlong - trailAlong) / (double)(leadAway - trailAway)));
                    }
                    lineCoord = Coord.makeHighPrecCoord(isLongitude ? lineAlong : dividingLine, isLongitude ? dividingLine : lineAlong);
                }
                if (lineCoord != null && coordPool != null) {
                    long hashVal = Utils.coord2Long(lineCoord);
                    Coord replCoord = coordPool.get(hashVal);
                    if (replCoord == null) {
                        coordPool.put(hashVal, lineCoord);
                    } else {
                        lineCoord = replCoord;
                    }
                }
                if (leadRel * trailRel >= 0) {
                    extraArea = (long)(trailAlong + leadAlong) * (long)(trailAway - leadAway);
                } else {
                    runningArea += (long)(trailAlong + lineAlong) * (long)(trailAway - dividingLine);
                    extraArea = (long)(lineAlong + leadAlong) * (long)(dividingLine - leadAway);
                }
                if (wantLess) {
                    if (leadRel < 0) {
                        if (trailRel >= 0) {
                            this.openLine(this.newLess, lineCoord, lineAlong, runningArea);
                        }
                        lessPoly.add(leadCoord);
                    } else if (trailRel < 0) {
                        lessPoly = this.closeLine(this.newLess, lineCoord, lineAlong, runningArea + (leadRel == 0 ? extraArea : 0L));
                    }
                }
                if (wantMore) {
                    if (leadRel > 0) {
                        if (trailRel <= 0) {
                            this.openLine(this.newMore, lineCoord, lineAlong, runningArea);
                        }
                        morePoly.add(leadCoord);
                    } else if (trailRel > 0) {
                        morePoly = this.closeLine(this.newMore, lineCoord, lineAlong, runningArea + (leadRel == 0 ? extraArea : 0L));
                    }
                }
                runningArea += extraArea;
            }
            trailCoord = leadCoord;
            trailAway = leadAway;
            trailAlong = leadAlong;
            trailRel = leadRel;
        }
        this.fullArea = runningArea;
    }

    void logDiagInfo(List<Coord> coords, List<List<Coord>> lessList, List<List<Coord>> moreList) {
        int lowestPoint = this.newLess != null ? this.newLess.get((int)0).lowPoint : (this.newMore != null ? this.newMore.get((int)0).lowPoint : 0);
        log.info("#points:", coords.size(), "fullArea:", this.fullArea, "lowest:", lowestPoint, "gpxDir:", this.gpxDirectory);
        if (this.newLess != null) {
            for (MergeCloseHelper thisLine : this.newLess) {
                log.info("LessLoop", thisLine.lowPoint - lowestPoint, thisLine.highPoint - lowestPoint, thisLine.direction, thisLine.areaOrHole, thisLine.areaToLine, thisLine.points.size());
            }
        }
        if (this.newMore != null) {
            for (MergeCloseHelper thisLine : this.newMore) {
                log.info("MoreLoop", thisLine.lowPoint - lowestPoint, thisLine.highPoint - lowestPoint, thisLine.direction, thisLine.areaOrHole, thisLine.areaToLine, thisLine.points.size());
            }
        }
        if (log.isDebugEnabled()) {
            String filePrefix;
            GpxCreator.createGpx(this.gpxDirectory + "S", coords);
            int fInx = 0;
            String string = filePrefix = lessList == moreList ? "B" : "L";
            if (lessList != null) {
                for (List<Coord> fragment : lessList) {
                    GpxCreator.createGpx(this.gpxDirectory + filePrefix + ++fInx, fragment);
                }
            }
            fInx = 0;
            if (moreList != null && lessList != moreList) {
                for (List<Coord> fragment : moreList) {
                    GpxCreator.createGpx(this.gpxDirectory + "M" + ++fInx, fragment);
                }
            }
        }
    }

    public static List<List<Coord>> clipToBounds(List<Coord> coords, Area bounds, Long2ObjectOpenHashMap<Coord> coordPool) {
        ArrayList<List<Coord>> newListA = new ArrayList<List<Coord>>();
        int dividingLine = bounds.getMinLat() << 6;
        ShapeSplitter.splitShape(coords, dividingLine, false, null, newListA, coordPool);
        if (newListA.isEmpty()) {
            return newListA;
        }
        ArrayList<List<Coord>> newListB = new ArrayList<List<Coord>>();
        dividingLine = bounds.getMinLong() << 6;
        for (List list : newListA) {
            ShapeSplitter.splitShape(list, dividingLine, true, null, newListB, coordPool);
        }
        if (newListB.isEmpty()) {
            return newListB;
        }
        newListA.clear();
        dividingLine = bounds.getMaxLat() << 6;
        for (List list : newListB) {
            ShapeSplitter.splitShape(list, dividingLine, false, newListA, null, coordPool);
        }
        if (newListA.isEmpty()) {
            return newListA;
        }
        newListB.clear();
        dividingLine = bounds.getMaxLong() << 6;
        for (List list : newListA) {
            ShapeSplitter.splitShape(list, dividingLine, true, newListB, null, coordPool);
        }
        return newListB;
    }

    private class EndPointComparator
    implements Comparator<LoopEndPoint> {
        private EndPointComparator() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int compare(LoopEndPoint lep1, LoopEndPoint lep2) {
            int cmp = lep1.thePoint - lep2.thePoint;
            if (cmp != 0) {
                return cmp;
            }
            ShapeSplitter.this.multSamePoint = true;
            MergeCloseHelper mch1 = lep1.theLoop;
            MergeCloseHelper mch2 = lep2.theLoop;
            if (mch1 == mch2) {
                return lep2.lowEnd;
            }
            if (lep1.lowEnd == 1) {
                if (lep2.lowEnd != 1) return 1;
                cmp = mch2.highPoint - mch1.highPoint;
            } else {
                if (lep2.lowEnd == 1) {
                    return -1;
                }
                cmp = mch2.lowPoint - mch1.lowPoint;
            }
            if (cmp != 0) {
                return cmp;
            }
            cmp = Long.compare(Math.abs(mch2.areaToLine), Math.abs(mch1.areaToLine));
            if (cmp == 0) return 0;
            return cmp * lep1.lowEnd;
        }
    }

    private class LoopEndPoint {
        int thePoint;
        int lowEnd;
        MergeCloseHelper theLoop;
        LoopEndPoint otherEnd;
        int ownIndex;

        LoopEndPoint(int thePoint, int lowEnd, MergeCloseHelper theLoop) {
            this.thePoint = thePoint;
            this.lowEnd = lowEnd;
            this.theLoop = theLoop;
        }
    }

    private class MergeCloseHelper {
        List<Coord> points = new ArrayList<Coord>();
        int firstPoint;
        int lastPoint;
        long startingArea;
        long endingArea;
        int direction;
        int lowPoint;
        int highPoint;
        long areaToLine;
        int areaOrHole;
        boolean removedDloop;

        MergeCloseHelper() {
        }

        public String toString() {
            return "fp=" + this.firstPoint + " lp=" + this.lastPoint + " area=" + this.areaToLine + " #=" + this.points.size() + " " + this.points.get(1).toOSMURL() + " " + this.points.get(this.points.size() / 2).toOSMURL();
        }

        void setMoreInfo(int fullAreaSign) {
            this.direction = Integer.signum(this.lastPoint - this.firstPoint);
            if (this.direction > 0) {
                this.lowPoint = this.firstPoint;
                this.highPoint = this.lastPoint;
            } else {
                this.lowPoint = this.lastPoint;
                this.highPoint = this.firstPoint;
            }
            this.areaToLine = this.endingArea - this.startingArea;
            this.areaOrHole = fullAreaSign * Long.signum(this.areaToLine);
        }

        void combineFirstIntoLast(MergeCloseHelper other) {
            this.points.addAll(other.points);
            this.lastPoint = other.lastPoint;
            this.endingArea = ShapeSplitter.this.fullArea + other.endingArea;
        }

        void addHole(MergeCloseHelper other) {
            if (other.areaToLine == 0L) {
                return;
            }
            if (this.direction == 0 && other.direction == 0) {
                ShapeSplitter.this.logMsg(new Object[]{"Direction of shape and hole indeterminate.", "shape:", this, "hole:", other});
            } else if (this.direction != 0 && other.direction != 0 && this.direction == other.direction) {
                ShapeSplitter.this.logMsg(new Object[]{"Direction of shape and hole conflict.", "shape:", this, "hole:", other});
            } else if (this.direction < 0 || other.direction > 0) {
                this.points.addAll(other.points);
                if (this.direction == 0) {
                    this.direction = -1;
                }
            } else {
                other.points.addAll(this.points);
                this.points = other.points;
                if (this.direction == 0) {
                    this.direction = 1;
                }
            }
            this.areaToLine += other.areaToLine;
        }

        void closeAppend(boolean onDividingLine) {
            Coord firstCoord = this.points.get(0);
            int lastPointInx = this.points.size() - 1;
            if (lastPointInx >= 3 && firstCoord.highPrecEquals(this.points.get(lastPointInx))) {
                if (firstCoord != this.points.get(lastPointInx)) {
                    this.points.set(lastPointInx, firstCoord);
                }
            } else {
                this.points.add(firstCoord);
            }
            if (onDividingLine && this.areaToLine == 0L) {
                return;
            }
            ShapeSplitter.this.origList.add(this.points);
        }
    }
}

