/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle;

import java.io.Writer;
import java.util.Formatter;
import java.util.Map;
import uk.me.parabola.mkgmap.osmstyle.RuleSet;
import uk.me.parabola.mkgmap.reader.osm.Rule;
import uk.me.parabola.mkgmap.reader.osm.Style;
import uk.me.parabola.mkgmap.reader.osm.StyleInfo;

public class StylePrinter {
    private final Style style;
    private Map<String, String> generalOptions;
    private RuleSet nodes;
    private RuleSet lines;
    private RuleSet polygons;
    private RuleSet relations;

    public StylePrinter(Style style) {
        this.style = style;
    }

    public void dumpToFile(Writer out) {
        Formatter fmt = new Formatter(out);
        fmt.format("<<<version>>>\n0\n", new Object[0]);
        this.dumpInfo(fmt);
        this.dumpOptions(fmt);
        if (this.relations != null) {
            StylePrinter.dumpRuleSet(fmt, "relations", this.relations);
        }
        if (this.nodes != null) {
            StylePrinter.dumpRuleSet(fmt, "points", this.nodes);
        }
        if (this.lines != null) {
            StylePrinter.dumpRuleSet(fmt, "lines", this.lines);
        }
        if (this.polygons != null) {
            StylePrinter.dumpRuleSet(fmt, "polygons", this.polygons);
        }
        fmt.flush();
    }

    private void dumpOptions(Formatter fmt) {
        fmt.format("<<<options>>>\n", new Object[0]);
        if (this.generalOptions != null) {
            for (Map.Entry<String, String> entry : this.generalOptions.entrySet()) {
                fmt.format("%s: %s\n", entry.getKey(), entry.getValue());
            }
        }
    }

    private void dumpInfo(Formatter fmt) {
        fmt.format("<<<info>>>\n", new Object[0]);
        StyleInfo styleInfo = this.style.getInfo();
        fmt.format("version %s\n", this.dumpInfoVal(styleInfo.getVersion()));
        fmt.format("summary %s\n", this.dumpInfoVal(styleInfo.getSummary()));
        for (String name : styleInfo.baseStyles()) {
            fmt.format("# base-style %s\n", this.dumpInfoVal(name));
        }
        fmt.format("description %s\n", this.dumpInfoVal(styleInfo.getLongDescription()));
    }

    private String dumpInfoVal(String str) {
        if (str.indexOf(10) >= 0) {
            return "{\n" + str + "\n}";
        }
        return ": " + str;
    }

    static void dumpRuleSet(Formatter fmt, String name, RuleSet set) {
        fmt.format("<<<%s>>>\n", name);
        for (Rule rule : set) {
            fmt.format("%s\n", rule.toString());
        }
    }

    void setGeneralOptions(Map<String, String> generalOptions) {
        this.generalOptions = generalOptions;
    }

    void setNodes(RuleSet nodes) {
        this.nodes = nodes;
    }

    void setLines(RuleSet lines) {
        this.lines = lines;
    }

    void setPolygons(RuleSet polygons) {
        this.polygons = polygons;
    }

    public void setRelations(RuleSet relations) {
        this.relations = relations;
    }
}

