/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.typ;

import java.nio.charset.CharsetEncoder;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.typ.ColourInfo;
import uk.me.parabola.imgfmt.app.typ.TypElement;
import uk.me.parabola.imgfmt.app.typ.Xpm;

public class TypPoint
extends TypElement {
    private Xpm nightXpm;
    private static final byte F_BITMAP = 1;
    private static final byte F_NIGHT_XPM = 2;
    private static final byte F_LABEL = 4;
    private static final byte F_EXTENDED_FONT = 8;

    @Override
    public void write(ImgFileWriter writer, CharsetEncoder encoder) {
        this.offset = writer.position();
        int flags = 1;
        if (this.nightXpm != null) {
            flags = (byte)(flags | 2);
        }
        if (!this.labels.isEmpty()) {
            flags = (byte)(flags | 4);
        }
        if (this.fontStyle != 0 || this.dayFontColour != null || this.nightFontColour != null) {
            flags = (byte)(flags | 8);
        }
        writer.put1u(flags);
        ColourInfo colourInfo = this.xpm.getColourInfo();
        writer.put1u(colourInfo.getWidth());
        writer.put1u(colourInfo.getHeight());
        this.writeImage(writer, this.xpm);
        if ((flags & 2) != 0) {
            this.writeImage(writer, this.nightXpm);
        }
        if ((flags & 4) != 0) {
            this.writeLabelBlock(writer, encoder);
        }
        if ((flags & 8) != 0) {
            this.writeExtendedFontInfo(writer);
        }
    }

    public void setNightXpm(Xpm nightXpm) {
        this.nightXpm = nightXpm;
    }

    @Override
    public boolean simpleBitmap() {
        return false;
    }
}

