/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.lbl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Exit;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.Label;
import uk.me.parabola.imgfmt.app.lbl.City;
import uk.me.parabola.imgfmt.app.lbl.Country;
import uk.me.parabola.imgfmt.app.lbl.ExitFacility;
import uk.me.parabola.imgfmt.app.lbl.Highway;
import uk.me.parabola.imgfmt.app.lbl.LBLFile;
import uk.me.parabola.imgfmt.app.lbl.POIIndex;
import uk.me.parabola.imgfmt.app.lbl.POIRecord;
import uk.me.parabola.imgfmt.app.lbl.PlacesHeader;
import uk.me.parabola.imgfmt.app.lbl.Region;
import uk.me.parabola.imgfmt.app.lbl.Zip;
import uk.me.parabola.imgfmt.app.srt.CombinedSortKey;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.imgfmt.app.srt.SortKey;
import uk.me.parabola.imgfmt.app.trergn.Subdivision;

public class PlacesFile {
    public static final int MIN_INDEXED_POI_TYPE = 41;
    public static final int MAX_INDEXED_POI_TYPE = 48;
    private final Map<String, Country> countries = new LinkedHashMap<String, Country>();
    private final List<Country> countryList = new ArrayList<Country>();
    private final Map<String, Region> regions = new LinkedHashMap<String, Region>();
    private final List<Region> regionList = new ArrayList<Region>();
    private final Map<String, City> cities = new LinkedHashMap<String, City>();
    private final List<City> cityList = new ArrayList<City>();
    private final Map<String, Zip> postalCodes = new LinkedHashMap<String, Zip>();
    private final List<Zip> zipList = new ArrayList<Zip>();
    private final List<Highway> highways = new ArrayList<Highway>();
    private final List<ExitFacility> exitFacilities = new ArrayList<ExitFacility>();
    private final List<POIRecord> pois = new ArrayList<POIRecord>();
    private final TreeMap<Integer, List<POIIndex>> poiIndex = new TreeMap();
    private LBLFile lblFile;
    private PlacesHeader placeHeader;
    private boolean poisClosed;
    private Sort sort;
    private final Random random = new Random();

    void init(LBLFile file, PlacesHeader pheader) {
        this.lblFile = file;
        this.placeHeader = pheader;
    }

    /*
     * WARNING - void declaration
     */
    void write(ImgFileWriter writer) {
        this.countryList.forEach(c -> c.write(writer));
        this.placeHeader.endCountries(writer.position());
        this.regionList.forEach(r -> r.write(writer));
        this.placeHeader.endRegions(writer.position());
        this.cityList.forEach(sc -> sc.write(writer));
        this.placeHeader.endCity(writer.position());
        for (List<POIIndex> pil : this.poiIndex.values()) {
            ArrayList<SortKey<POIIndex>> sorted = new ArrayList<SortKey<POIIndex>>();
            for (POIIndex pOIIndex : pil) {
                SortKey<POIIndex> sortKey = this.sort.createSortKey(pOIIndex, pOIIndex.getName());
                sorted.add(sortKey);
            }
            sorted.sort(null);
            for (SortKey sortKey : sorted) {
                ((POIIndex)sortKey.getObject()).write(writer);
            }
        }
        this.placeHeader.endPOIIndex(writer.position());
        int poistart = writer.position();
        int poiglobalflags = this.placeHeader.getPOIGlobalFlags();
        int cityPtrSize = Utils.numberToPointerSize(this.cityList.size());
        int zipPtrSize = Utils.numberToPointerSize(this.postalCodes.size());
        int n = Utils.numberToPointerSize(this.highways.size());
        int exitFacilityPtrSize = Utils.numberToPointerSize(this.exitFacilities.size());
        for (POIRecord pOIRecord : this.pois) {
            pOIRecord.write(writer, poiglobalflags, writer.position() - poistart, cityPtrSize, zipPtrSize, n, exitFacilityPtrSize);
        }
        this.placeHeader.endPOI(writer.position());
        int numPoiIndexEntries = 0;
        for (Map.Entry<Integer, List<POIIndex>> entry : this.poiIndex.entrySet()) {
            int i = entry.getKey();
            writer.put1u(i);
            writer.put3u(numPoiIndexEntries + 1);
            numPoiIndexEntries += entry.getValue().size();
        }
        this.placeHeader.endPOITypeIndex(writer.position());
        this.zipList.forEach(z -> z.write(writer));
        this.placeHeader.endZip(writer.position());
        boolean bl = false;
        for (Highway h2 : this.highways) {
            void var9_21;
            h2.setExtraDataOffset((int)var9_21);
            var9_21 += h2.getExtraDataSize();
            h2.write(writer, false);
        }
        this.placeHeader.endHighway(writer.position());
        this.exitFacilities.forEach(ef -> ef.write(writer));
        this.placeHeader.endExitFacility(writer.position());
        this.highways.forEach(h -> h.write(writer, true));
        this.placeHeader.endHighwayData(writer.position());
    }

    Country createCountry(String name, String abbr) {
        String s = abbr != null ? name + '\u001d' + abbr : name;
        return this.countries.computeIfAbsent(s, k -> new Country(this.countries.size() + 1, this.lblFile.newLabel(s)));
    }

    Region createRegion(Country country, String name, String abbr) {
        String s = abbr != null ? name + '\u001d' + abbr : name;
        String uniqueRegionName = s.toUpperCase() + "_C" + country.getLabel().getOffset();
        return this.regions.computeIfAbsent(uniqueRegionName, k -> new Region(country, this.lblFile.newLabel(s)));
    }

    City createCity(Country country, String name, boolean unique) {
        String uniqueCityName = name.toUpperCase() + "_C" + country.getLabel().getOffset();
        if (unique) {
            uniqueCityName = this.createUniqueCityName(uniqueCityName);
        }
        City c = null;
        if (!unique) {
            c = this.cities.get(uniqueCityName);
        }
        if (c == null) {
            c = new City(country);
            c.setLabel(this.lblFile.newLabel(name));
            this.cityList.add(c);
            this.cities.put(uniqueCityName, c);
            assert (this.cityList.size() == this.cities.size()) : " cityList and cities are different lengths after inserting " + name + " and " + uniqueCityName;
        }
        return c;
    }

    City createCity(Region region, String name, boolean unique) {
        String uniqueCityName = name.toUpperCase() + "_R" + region.getLabel().getOffset();
        if (unique) {
            uniqueCityName = this.createUniqueCityName(uniqueCityName);
        }
        City c = null;
        if (!unique) {
            c = this.cities.get(uniqueCityName);
        }
        if (c == null) {
            c = new City(region);
            c.setLabel(this.lblFile.newLabel(name));
            this.cityList.add(c);
            this.cities.put(uniqueCityName, c);
            assert (this.cityList.size() == this.cities.size()) : " cityList and cities are different lengths after inserting " + name + " and " + uniqueCityName;
        }
        return c;
    }

    private String createUniqueCityName(String name) {
        String uniqueCityName = name;
        while (this.cities.get(uniqueCityName) != null) {
            uniqueCityName = uniqueCityName + "_" + this.random.nextInt(65536);
        }
        return uniqueCityName;
    }

    Zip createZip(String code) {
        return this.postalCodes.computeIfAbsent(code, k -> new Zip(this.lblFile.newLabel(code)));
    }

    Highway createHighway(Region region, String name) {
        Highway h = new Highway(region, this.highways.size() + 1);
        h.setLabel(this.lblFile.newLabel(name));
        this.highways.add(h);
        return h;
    }

    public ExitFacility createExitFacility(int type, char direction, int facilities, String description, boolean last) {
        Label d = this.lblFile.newLabel(description);
        ExitFacility ef = new ExitFacility(type, direction, facilities, d, last, this.exitFacilities.size() + 1);
        this.exitFacilities.add(ef);
        return ef;
    }

    POIRecord createPOI(String name) {
        assert (!this.poisClosed);
        POIRecord p = new POIRecord();
        p.setLabel(this.lblFile.newLabel(name));
        this.pois.add(p);
        return p;
    }

    POIRecord createExitPOI(String name, Exit exit) {
        assert (!this.poisClosed);
        POIRecord p = new POIRecord();
        p.setLabel(this.lblFile.newLabel(name));
        p.setExit(exit);
        this.pois.add(p);
        return p;
    }

    void createPOIIndex(String name, int index, Subdivision group, int type) {
        assert (index < 256) : "Too many POIS in division";
        int t = type >> 8;
        if (t < 41 || t > 48) {
            return;
        }
        POIIndex pi = new POIIndex(name, index, group, type & 0xFF);
        this.poiIndex.computeIfAbsent(t, k -> new ArrayList()).add(pi);
    }

    void allPOIsDone() {
        this.sortCountries();
        this.sortRegions();
        this.sortCities();
        this.sortZips();
        this.poisClosed = true;
        int poiFlags = 0;
        for (POIRecord p : this.pois) {
            poiFlags |= p.getPOIFlags();
        }
        this.placeHeader.setPOIGlobalFlags(poiFlags);
        int ofs = 0;
        int cityPtrSize = Utils.numberToPointerSize(this.cityList.size());
        int zipPtrSize = Utils.numberToPointerSize(this.postalCodes.size());
        int highwayPtrSize = Utils.numberToPointerSize(this.highways.size());
        int exitFacilityPtrSize = Utils.numberToPointerSize(this.exitFacilities.size());
        for (POIRecord p : this.pois) {
            ofs += p.calcOffset(ofs, poiFlags, cityPtrSize, zipPtrSize, highwayPtrSize, exitFacilityPtrSize);
        }
    }

    private void sortCountries() {
        ArrayList<SortKey<Country>> keys = new ArrayList<SortKey<Country>>();
        for (Country c : this.countries.values()) {
            SortKey<Country> sortKey = this.sort.createSortKey(c, c.getLabel());
            keys.add(sortKey);
        }
        keys.sort(null);
        this.countryList.clear();
        int index = 1;
        for (SortKey sortKey : keys) {
            Country c = (Country)sortKey.getObject();
            c.setIndex(index++);
            this.countryList.add(c);
        }
    }

    private void sortRegions() {
        ArrayList<SortKey<Region>> keys = new ArrayList<SortKey<Region>>();
        for (Region r : this.regions.values()) {
            SortKey<Region> sortKey = this.sort.createSortKey(r, r.getLabel(), r.getCountry().getIndex());
            keys.add(sortKey);
        }
        keys.sort(null);
        this.regionList.clear();
        int index = 1;
        for (SortKey sortKey : keys) {
            Region r = (Region)sortKey.getObject();
            r.setIndex(index++);
            this.regionList.add(r);
        }
    }

    private void sortCities() {
        ArrayList<CombinedSortKey<City>> keys = new ArrayList<CombinedSortKey<City>>();
        for (City c : this.cityList) {
            SortKey<City> sortKey = this.sort.createSortKey(c, c.getLabel());
            CombinedSortKey<City> combinedSortKey = new CombinedSortKey<City>(sortKey, c.getRegionNumber(), c.getCountryNumber());
            keys.add(combinedSortKey);
        }
        keys.sort(null);
        this.cityList.clear();
        int index = 1;
        for (SortKey sortKey : keys) {
            City city = (City)sortKey.getObject();
            city.setIndex(index++);
            this.cityList.add(city);
        }
    }

    private void sortZips() {
        ArrayList<SortKey<Zip>> keys = new ArrayList<SortKey<Zip>>();
        for (Zip c : this.postalCodes.values()) {
            SortKey<Zip> sortKey = this.sort.createSortKey(c, c.getLabel());
            keys.add(sortKey);
        }
        keys.sort(null);
        this.zipList.clear();
        int index = 1;
        for (SortKey sortKey : keys) {
            Zip zip = (Zip)sortKey.getObject();
            zip.setIndex(index++);
            this.zipList.add(zip);
        }
    }

    public int numCities() {
        return this.cityList.size();
    }

    public int numZips() {
        return this.postalCodes.size();
    }

    public int numHighways() {
        return this.highways.size();
    }

    public int numExitFacilities() {
        return this.exitFacilities.size();
    }

    public void setSort(Sort sort) {
        this.sort = sort;
    }
}

