/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.stream.Collectors;
import uk.me.parabola.imgfmt.ExitException;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.ElementSaver;
import uk.me.parabola.mkgmap.reader.osm.FakeIdGenerator;
import uk.me.parabola.mkgmap.reader.osm.MultiPolygonCutter;
import uk.me.parabola.mkgmap.reader.osm.Node;
import uk.me.parabola.mkgmap.reader.osm.Relation;
import uk.me.parabola.mkgmap.reader.osm.TagDict;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.util.IsInUtil;
import uk.me.parabola.util.Java2DConverter;
import uk.me.parabola.util.MultiIdentityHashMap;
import uk.me.parabola.util.ShapeSplitter;

public class MultiPolygonRelation
extends Relation {
    private static final Logger log = Logger.getLogger(MultiPolygonRelation.class);
    public static final String STYLE_FILTER_TAG = "mkgmap:stylefilter";
    public static final String STYLE_FILTER_LINE = "polyline";
    public static final String STYLE_FILTER_POLYGON = "polygon";
    public static final short TKM_MP_CREATED = TagDict.getInstance().xlate("mkgmap:mp_created");
    private static final short TKM_MP_ROLE = TagDict.getInstance().xlate("mkgmap:mp_role");
    private static final short TKM_CACHE_AREA_SIZEKEY = TagDict.getInstance().xlate("mkgmap:cache_area_size");
    public static final String ROLE_OUTER = "outer";
    public static final String ROLE_INNER = "inner";
    private static final byte INT_ROLE_NULL = 1;
    private static final byte INT_ROLE_INNER = 2;
    private static final byte INT_ROLE_OUTER = 4;
    private static final byte INT_ROLE_BLANK = 8;
    private static final byte INT_ROLE_OTHER = 16;
    private final Map<Long, Way> tileWayMap;
    protected List<JoinedWay> polygons;
    private Map<Long, Way> mpPolygons = new LinkedHashMap<Long, Way>();
    protected JoinedWay largestOuterPolygon;
    private Long2ObjectOpenHashMap<Coord> commonCoordMap = new Long2ObjectOpenHashMap();
    protected Set<Way> outerWaysForLineTagging;
    private final Area tileBounds;
    private java.awt.geom.Area tileArea;
    private Coord cOfG = null;
    private double mpAreaSize;
    private boolean noRecalc;

    public MultiPolygonRelation(Relation other, Map<Long, Way> wayMap, Area bbox) {
        this.tileWayMap = wayMap;
        this.tileBounds = bbox;
        this.tileArea = Java2DConverter.createBoundsArea(this.tileBounds);
        this.setId(other.getId());
        this.copyTags(other);
        other.getElements().forEach(e -> this.addElement((String)e.getKey(), (Element)e.getValue()));
        if (log.isDebugEnabled()) {
            log.debug("Constructed multipolygon", this.toBrowseURL(), this.toTagString());
        }
    }

    public Coord getCofG() {
        return this.cOfG;
    }

    private static String getRole(JoinedWay jw) {
        if (jw.intRole == 2) {
            return ROLE_INNER;
        }
        if (jw.intRole == 4) {
            return ROLE_OUTER;
        }
        return null;
    }

    private List<JoinedWay> joinWays() {
        ArrayList<JoinedWay> joinedWays = new ArrayList<JoinedWay>();
        LinkedList<JoinedWay> unclosedWays = new LinkedList<JoinedWay>();
        this.parseElements(joinedWays, unclosedWays);
        if (unclosedWays.isEmpty()) {
            return joinedWays;
        }
        if (unclosedWays.size() > 1) {
            this.joinInGivenOrder(joinedWays, unclosedWays);
        }
        if (unclosedWays.size() == 1) {
            joinedWays.add((JoinedWay)unclosedWays.remove(0));
        }
        if (!unclosedWays.isEmpty()) {
            this.joinWithIndex(joinedWays, unclosedWays);
        }
        joinedWays.addAll(unclosedWays);
        if (log.isInfoEnabled()) {
            for (JoinedWay jw : joinedWays) {
                if (Integer.bitCount(jw.intRole) <= 1) continue;
                log.info("Joined polygon ways have different roles", this.toBrowseURL(), jw.toString());
            }
        }
        return joinedWays;
    }

    private void parseElements(List<JoinedWay> closedWays, List<JoinedWay> unclosedWays) {
        HashMap<Long, Way> dupCheck = new HashMap<Long, Way>();
        for (Map.Entry<String, Element> entry : this.getElements()) {
            String role = entry.getKey();
            Element el = entry.getValue();
            if (el instanceof Way) {
                Way wayEl = (Way)el;
                if (dupCheck.put(wayEl.getId(), wayEl) != null) {
                    log.warn("repeated way member with id", el.getId(), "is ignored in multipolygon relation", this.toBrowseURL());
                    continue;
                }
                if (wayEl.getPoints().size() <= 1) {
                    log.warn("Way", wayEl, "has", wayEl.getPoints().size(), "points and cannot be used for the multipolygon", this.toBrowseURL());
                    continue;
                }
                JoinedWay jw = new JoinedWay(wayEl, role);
                if (jw.intRole == 16) {
                    log.warn("Way role invalid", role, el.toBrowseURL(), "in multipolygon", this.toBrowseURL(), this.toTagString());
                }
                if (wayEl.isClosedInOSM() && !wayEl.hasIdenticalEndPoints() && !wayEl.isComplete()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Close incomplete but closed polygon:", wayEl);
                    }
                    jw.closeWayArtificially();
                }
                if (jw.hasIdenticalEndPoints()) {
                    closedWays.add(jw);
                    continue;
                }
                unclosedWays.add(jw);
                continue;
            }
            if (el instanceof Node) {
                if ("label".equals(role)) {
                    this.cOfG = ((Node)el).getLocation();
                    continue;
                }
                if ("admin_centre".equals(role)) continue;
                log.warn("Node with unknown role is ignored", role, el.toBrowseURL(), "in multipolygon", this.toBrowseURL(), this.toTagString());
                continue;
            }
            log.warn("Non Way/Node member with role is ignored", role, el.toBrowseURL(), "in multipolygon", this.toBrowseURL(), this.toTagString());
        }
    }

    private void joinInGivenOrder(List<JoinedWay> closedWays, List<JoinedWay> unclosedWays) {
        JoinedWay work = null;
        while (unclosedWays.size() > 1) {
            if (work == null) {
                work = unclosedWays.get(0);
            }
            if (!work.canJoin(unclosedWays.get(1))) break;
            work.joinWith(unclosedWays.get(1));
            unclosedWays.remove(1);
            if (!work.hasIdenticalEndPoints()) continue;
            closedWays.add(work);
            unclosedWays.remove(0);
            work = null;
        }
    }

    private void joinWithIndex(List<JoinedWay> closedWays, List<JoinedWay> unclosedWays) {
        MultiIdentityHashMap<Coord, JoinedWay> index = new MultiIdentityHashMap<Coord, JoinedWay>();
        unclosedWays.forEach(jw -> {
            index.add(jw.getFirstPoint(), (JoinedWay)jw);
            index.add(jw.getLastPoint(), (JoinedWay)jw);
        });
        ArrayList<JoinedWay> finishedUnclosed = new ArrayList<JoinedWay>();
        while (!unclosedWays.isEmpty()) {
            JoinedWay joinWay = unclosedWays.remove(0);
            Object candidates = index.get(joinWay.getLastPoint());
            if (candidates.size() != 2) {
                candidates = index.get(joinWay.getFirstPoint());
            }
            if (candidates.size() <= 1) {
                finishedUnclosed.add(joinWay);
                continue;
            }
            candidates.remove(joinWay);
            JoinedWay other = (JoinedWay)candidates.get(0);
            if (candidates.size() > 1) {
                other = candidates.stream().filter(joinWay::buildsRingWith).findFirst().orElse(other);
            }
            index.removeMapping(other.getFirstPoint(), other);
            index.removeMapping(other.getLastPoint(), other);
            index.removeMapping(joinWay.getFirstPoint(), joinWay);
            index.removeMapping(joinWay.getLastPoint(), joinWay);
            unclosedWays.remove(other);
            joinWay.joinWith(other);
            if (joinWay.hasIdenticalEndPoints()) {
                closedWays.add(joinWay);
                continue;
            }
            index.add(joinWay.getFirstPoint(), joinWay);
            index.add(joinWay.getLastPoint(), joinWay);
            unclosedWays.add(0, joinWay);
        }
        unclosedWays.addAll(finishedUnclosed);
    }

    private void tryCloseSingleWays(JoinedWay way) {
        if (way.hasIdenticalEndPoints() || way.getPoints().size() < 3) {
            return;
        }
        Coord p1 = way.getFirstPoint();
        Coord p2 = way.getLastPoint();
        if (p1.getLatitude() <= this.tileBounds.getMinLat() && p2.getLatitude() <= this.tileBounds.getMinLat() || p1.getLatitude() >= this.tileBounds.getMaxLat() && p2.getLatitude() >= this.tileBounds.getMaxLat() || p1.getLongitude() <= this.tileBounds.getMinLong() && p2.getLongitude() <= this.tileBounds.getMinLong() || p1.getLongitude() >= this.tileBounds.getMaxLong() && p2.getLongitude() >= this.tileBounds.getMaxLong()) {
            way.closeWayArtificially();
            log.info("Endpoints of way", way, "are both outside the bbox. Closing it directly.");
            return;
        }
        double closeDist = way.getFirstPoint().distance(way.getLastPoint());
        if (closeDist > this.getMaxCloseDist()) {
            return;
        }
        Line2D.Double closingLine = new Line2D.Double(p1.getHighPrecLon(), p1.getHighPrecLat(), p2.getHighPrecLon(), p2.getHighPrecLat());
        boolean intersects = false;
        Coord lastPoint = null;
        for (Coord thisPoint : way.getPoints().subList(1, way.getPoints().size() - 1)) {
            if (lastPoint != null && closingLine.intersectsLine(lastPoint.getHighPrecLon(), lastPoint.getHighPrecLat(), thisPoint.getHighPrecLon(), thisPoint.getHighPrecLat())) {
                intersects = true;
                break;
            }
            lastPoint = thisPoint;
        }
        if (!intersects) {
            if (log.isInfoEnabled()) {
                log.info("Closing way", way);
                log.info("from", way.getFirstPoint().toOSMURL());
                log.info("to", way.getLastPoint().toOSMURL());
            }
            way.closeWayArtificially();
        }
    }

    private boolean connectUnclosedWays(List<JoinedWay> allWays, boolean onlyOutside) {
        List unclosed = allWays.stream().filter(w -> !w.hasEqualEndPoints()).collect(Collectors.toList());
        if (!unclosed.isEmpty()) {
            log.debug("Checking", unclosed.size(), "unclosed ways for connections outside the bbox");
            IdentityHashMap<Coord, JoinedWay> openEnds = new IdentityHashMap<Coord, JoinedWay>();
            for (JoinedWay w2 : unclosed) {
                for (Coord e : Arrays.asList(w2.getFirstPoint(), w2.getLastPoint())) {
                    if (!onlyOutside) {
                        openEnds.put(e, w2);
                        continue;
                    }
                    if (this.tileBounds.insideBoundary(e)) continue;
                    log.debug("Point", e, "of way", w2.getId(), "outside bbox");
                    openEnds.put(e, w2);
                }
            }
            if (openEnds.size() < 2) {
                log.debug(openEnds.size(), "point outside the bbox. No connection possible.");
                return false;
            }
            ArrayList<ConnectionData> coordPairs = new ArrayList<ConnectionData>();
            ArrayList coords = new ArrayList(openEnds.keySet());
            for (int i = 0; i < coords.size(); ++i) {
                for (int j = i + 1; j < coords.size(); ++j) {
                    ConnectionData cd = new ConnectionData();
                    cd.c1 = (Coord)coords.get(i);
                    cd.c2 = (Coord)coords.get(j);
                    cd.w1 = (JoinedWay)openEnds.get(cd.c1);
                    cd.w2 = (JoinedWay)openEnds.get(cd.c2);
                    if (!onlyOutside && cd.w1 == cd.w2) continue;
                    if (onlyOutside && this.lineCutsBbox(cd.c1, cd.c2)) {
                        Coord edgePoint1 = new Coord(cd.c1.getLatitude(), cd.c2.getLongitude());
                        Coord edgePoint2 = new Coord(cd.c2.getLatitude(), cd.c1.getLongitude());
                        ArrayList<Coord> possibleEdges = new ArrayList<Coord>();
                        if (!this.lineCutsBbox(cd.c1, edgePoint1) && !this.lineCutsBbox(edgePoint1, cd.c2)) {
                            possibleEdges.add(edgePoint1);
                        }
                        if (!this.lineCutsBbox(cd.c1, edgePoint2) && !this.lineCutsBbox(edgePoint2, cd.c2)) {
                            possibleEdges.add(edgePoint2);
                        }
                        if (possibleEdges.size() != 1) continue;
                        cd.imC = (Coord)possibleEdges.get(0);
                        cd.distance = cd.c1.distance(cd.imC) + cd.imC.distance(cd.c2);
                    } else {
                        cd.distance = cd.c1.distance(cd.c2);
                    }
                    coordPairs.add(cd);
                }
            }
            if (coordPairs.isEmpty()) {
                log.debug((Object)"All potential connections cross the bbox. No connection possible.");
                return false;
            }
            ConnectionData minCon = (ConnectionData)Collections.min(coordPairs, (o1, o2) -> Double.compare(o1.distance, o2.distance));
            if (onlyOutside || minCon.distance < this.getMaxCloseDist()) {
                if (minCon.w1 == minCon.w2) {
                    log.debug("Close a gap in way", minCon.w1);
                    if (minCon.imC != null) {
                        minCon.w1.getPoints().add(minCon.imC);
                    }
                    minCon.w1.closeWayArtificially();
                } else {
                    log.debug("Connect", minCon.w1, "with", minCon.w2);
                    if (minCon.w1.getFirstPoint() == minCon.c1) {
                        Collections.reverse(minCon.w1.getPoints());
                    }
                    if (minCon.w2.getFirstPoint() != minCon.c2) {
                        Collections.reverse(minCon.w2.getPoints());
                    }
                    minCon.w1.getPoints().addAll(minCon.w2.getPoints());
                    minCon.w1.addWay(minCon.w2);
                    allWays.remove(minCon.w2);
                }
                return true;
            }
        }
        return false;
    }

    private void removeUnclosedWays(List<JoinedWay> wayList) {
        Iterator<JoinedWay> it = wayList.iterator();
        boolean firstWarn = true;
        while (it.hasNext()) {
            JoinedWay jw = it.next();
            if (jw.hasIdenticalEndPoints()) continue;
            if (jw.getArea().intersects(this.tileBounds)) {
                if (firstWarn) {
                    log.warn("Cannot join the following ways to closed polygons. Multipolygon", this.toBrowseURL(), this.toTagString());
                    firstWarn = false;
                }
                MultiPolygonRelation.logWayURLs(Level.WARNING, "- way:", jw);
                this.logFakeWayDetails(Level.WARNING, jw);
                String role = MultiPolygonRelation.getRole(jw);
                if (role == null || ROLE_OUTER.equals(role)) {
                    this.outerWaysForLineTagging.addAll(jw.getOriginalWays());
                }
            }
            it.remove();
        }
    }

    private void removeWaysOutsideBbox(List<JoinedWay> wayList) {
        ListIterator<JoinedWay> wayIter = wayList.listIterator();
        while (wayIter.hasNext()) {
            JoinedWay w = wayIter.next();
            if (!this.isFullyOutsideBBox(w)) continue;
            if (log.isDebugEnabled()) {
                if (w.originalWays.size() == 1) {
                    log.debug(this.getId(), ": Ignoring way", ((Way)w.originalWays.get(0)).getId(), "because it is completely outside the bounding box.");
                } else {
                    log.debug(this.getId(), ": Ignoring joined ways", w.originalWays.stream().map(way -> Long.toString(way.getId())).collect(Collectors.joining(",")), "because they are completely outside the bounding box.");
                }
            }
            wayIter.remove();
        }
    }

    private boolean isFullyOutsideBBox(JoinedWay w) {
        if (!w.getBounds().intersects(this.tileArea.getBounds())) {
            return true;
        }
        if (w.getBounds().contains(this.tileArea.getBounds())) {
            return false;
        }
        if (w.getPoints().stream().anyMatch(this.tileBounds::contains)) {
            return false;
        }
        for (int i = 0; i < w.getPoints().size() - 1; ++i) {
            if (!this.lineCutsBbox(w.getPoints().get(i), w.getPoints().get(i + 1))) continue;
            return false;
        }
        return true;
    }

    @Override
    public final void processElements() {
        log.info("Processing multipolygon", this.toBrowseURL());
        if (!this.isUsable()) {
            log.info("Do not process multipolygon", this.getId(), "because it has no style relevant tags.");
            return;
        }
        this.polygons = this.buildRings();
        if (this.polygons.isEmpty()) {
            return;
        }
        this.polygons.forEach(jw -> jw.setFullArea(jw.getFullArea()));
        if (this.polygons.stream().allMatch(jw -> ((JoinedWay)jw).intRole == 2 || ((JoinedWay)jw).intRole == 16)) {
            log.warn("Multipolygon", this.toBrowseURL(), "does not contain any way tagged with role=outer or empty role.");
            this.cleanup();
            return;
        }
        this.largestOuterPolygon = MultiPolygonRelation.getLargest(this.polygons);
        ArrayList<List<JoinedWay>> partitions = new ArrayList<List<JoinedWay>>();
        if ("boundary".equals(this.getTag("type")) || this.noPartitioning()) {
            partitions.add(this.polygons);
        } else {
            this.divideLargest(this.polygons, partitions, 0);
        }
        for (List list : partitions) {
            this.processPartition(new Partition(list));
        }
        this.tagOuterWays();
        this.postProcessing();
        this.cleanup();
    }

    protected boolean noPartitioning() {
        return false;
    }

    private List<JoinedWay> buildRings() {
        List<JoinedWay> polygons = this.joinWays();
        this.outerWaysForLineTagging = new HashSet<Way>();
        polygons = this.filterUnclosed(polygons);
        do {
            polygons.forEach(this::tryCloseSingleWays);
        } while (this.connectUnclosedWays(polygons, this.assumeDataInBoundsIsComplete()));
        this.removeUnclosedWays(polygons);
        boolean hasPolygons = !polygons.isEmpty();
        this.removeWaysOutsideBbox(polygons);
        if (polygons.isEmpty()) {
            if (log.isInfoEnabled()) {
                log.info("Multipolygon", this.toBrowseURL(), hasPolygons ? "is completely outside the bounding box. It is not processed." : "does not contain a closed polygon.");
            }
            this.tagOuterWays();
            this.cleanup();
        }
        return polygons;
    }

    private static JoinedWay getLargest(List<JoinedWay> polygons) {
        double maxSize = -1.0;
        int maxPos = -1;
        for (int i = 0; i < polygons.size(); ++i) {
            JoinedWay closed = polygons.get(i);
            double size = MultiPolygonRelation.calcAreaSize(closed.getPoints());
            if (!(size > maxSize)) continue;
            maxSize = size;
            maxPos = i;
        }
        return polygons.get(maxPos);
    }

    private static Area calcBounds(Collection<JoinedWay> polygons) {
        int minLat = Integer.MAX_VALUE;
        int minLon = Integer.MAX_VALUE;
        int maxLat = Integer.MIN_VALUE;
        int maxLon = Integer.MIN_VALUE;
        for (JoinedWay jw : polygons) {
            if (jw.minLat < minLat) {
                minLat = jw.minLat;
            }
            if (jw.minLon < minLon) {
                minLon = jw.minLon;
            }
            if (jw.maxLat > maxLat) {
                maxLat = jw.maxLat;
            }
            if (jw.maxLon <= maxLon) continue;
            maxLon = jw.maxLon;
        }
        return new Area(minLat, minLon, maxLat, maxLon);
    }

    void processPartition(Partition partition) {
        if (partition.innerEqualsOuter) {
            return;
        }
        if (partition.outerPolygons.isEmpty()) {
            Area fullArea = MultiPolygonRelation.calcBounds(partition.polygons);
            log.warn("Part of divided multipolygon has no outer area and is ignored", this, "in bbox", fullArea);
            return;
        }
        LinkedBlockingQueue<PolygonStatus> polygonWorkingQueue = new LinkedBlockingQueue<PolygonStatus>();
        polygonWorkingQueue.addAll(partition.getPolygonStatus(null));
        this.processQueue(partition, polygonWorkingQueue);
        if (this.doReporting() && log.isLoggable(Level.WARNING)) {
            partition.reportProblems();
        }
    }

    protected boolean doReporting() {
        return true;
    }

    protected boolean isUsable() {
        for (Map.Entry<String, String> tagEntry : this.getTagEntryIterator()) {
            String tagName = tagEntry.getKey();
            if ("type".equals(tagName) || tagName.startsWith("mkgmap:")) continue;
            return true;
        }
        return false;
    }

    protected boolean needsWaysForOutlines() {
        return true;
    }

    protected boolean assumeDataInBoundsIsComplete() {
        return true;
    }

    private void tagOuterWays() {
        Way patternWayForLineCopies;
        if (this.outerWaysForLineTagging.isEmpty()) {
            return;
        }
        if (this.needsWaysForOutlines()) {
            patternWayForLineCopies = new Way(0L);
            patternWayForLineCopies.copyTags(this);
            patternWayForLineCopies.deleteTag("type");
            patternWayForLineCopies.addTag(STYLE_FILTER_TAG, STYLE_FILTER_LINE);
            patternWayForLineCopies.addTag(TKM_MP_CREATED, "true");
            if (this.needsAreaSizeTag()) {
                patternWayForLineCopies.addTag(TKM_CACHE_AREA_SIZEKEY, this.getAreaSizeString());
            }
        } else {
            patternWayForLineCopies = null;
        }
        for (Way orgOuterWay : this.outerWaysForLineTagging) {
            if (patternWayForLineCopies != null) {
                Way lineTagWay = new Way(this.getOriginalId(), orgOuterWay.getPoints());
                lineTagWay.markAsGeneratedFrom(this);
                lineTagWay.copyTags(patternWayForLineCopies);
                if (log.isDebugEnabled()) {
                    log.debug("Add line way", lineTagWay.getId(), lineTagWay.toTagString());
                }
                this.tileWayMap.put(lineTagWay.getId(), lineTagWay);
            }
            for (Map.Entry<String, String> tag : this.getTagEntryIterator()) {
                if (!tag.getValue().equals(orgOuterWay.getTag(tag.getKey()))) continue;
                MultiPolygonRelation.markTagsForRemovalInOrgWays(orgOuterWay, tag.getKey());
            }
        }
    }

    private List<JoinedWay> filterUnclosed(List<JoinedWay> polygons) {
        if (this.assumeDataInBoundsIsComplete()) {
            return polygons;
        }
        return polygons.stream().filter(w -> {
            Coord last;
            Coord first = w.getFirstPoint();
            return first == (last = w.getLastPoint()) || this.tileBounds.contains(first) && this.tileBounds.contains(last);
        }).collect(Collectors.toList());
    }

    protected void processQueue(Partition partition, Queue<PolygonStatus> polygonWorkingQueue) {
        while (!polygonWorkingQueue.isEmpty()) {
            List<Way> singularOuterPolygons;
            boolean processPolygon;
            PolygonStatus currentPolygon = polygonWorkingQueue.poll();
            partition.markFinished(currentPolygon);
            List<PolygonStatus> holes = partition.getPolygonStatus(currentPolygon);
            polygonWorkingQueue.addAll(holes);
            if (currentPolygon.outer) {
                this.outerWaysForLineTagging.addAll(currentPolygon.polygon.getOriginalWays());
            }
            if (!(processPolygon = currentPolygon.outer || !holes.isEmpty())) continue;
            if (holes.isEmpty()) {
                Way w = new Way(currentPolygon.polygon.getId(), currentPolygon.polygon.getPoints());
                singularOuterPolygons = Collections.singletonList(w);
            } else {
                Iterator<Way> innerWays = new ArrayList<JoinedWay>(holes.size());
                for (PolygonStatus polygonHoleStatus : holes) {
                    innerWays.add(polygonHoleStatus.polygon);
                }
                MultiPolygonCutter cutter = new MultiPolygonCutter(this, this.tileArea, this.commonCoordMap);
                singularOuterPolygons = cutter.cutOutInnerPolygons(currentPolygon.polygon, (List<Way>)((Object)innerWays));
                if (currentPolygon.outer) {
                    singularOuterPolygons.forEach(s -> s.setMpRel(this));
                }
            }
            if (singularOuterPolygons.isEmpty()) continue;
            if (currentPolygon.outer) {
                for (Way p : singularOuterPolygons) {
                    p.copyTags(this);
                    p.deleteTag("type");
                }
            } else {
                currentPolygon.polygon.mergeTagsFromOrgWays();
                for (Way p : singularOuterPolygons) {
                    p.copyTags(currentPolygon.polygon);
                }
                MultiPolygonRelation.markTagsForRemovalInOrgWays(currentPolygon.polygon);
            }
            long fullArea = currentPolygon.polygon.getFullArea();
            for (Way mpWay : singularOuterPolygons) {
                if (log.isDebugEnabled()) {
                    log.debug(mpWay.getId(), mpWay.toTagString());
                }
                mpWay.setFullArea(fullArea);
                mpWay.addTag(STYLE_FILTER_TAG, STYLE_FILTER_POLYGON);
                mpWay.addTag(TKM_MP_CREATED, "true");
                if (currentPolygon.outer) {
                    mpWay.addTag(TKM_MP_ROLE, ROLE_OUTER);
                    if (this.needsAreaSizeTag()) {
                        this.mpAreaSize += MultiPolygonRelation.calcAreaSize(mpWay.getPoints());
                    }
                } else {
                    mpWay.addTag(TKM_MP_ROLE, ROLE_INNER);
                }
                this.mpPolygons.put(mpWay.getId(), mpWay);
            }
        }
    }

    protected double getMaxCloseDist() {
        return Double.MAX_VALUE;
    }

    private String getAreaSizeString() {
        return String.format(Locale.US, "%.3f", this.mpAreaSize);
    }

    protected void postProcessing() {
        String mpAreaSizeStr = null;
        if (this.needsAreaSizeTag()) {
            mpAreaSizeStr = this.getAreaSizeString();
            this.addTag(TKM_CACHE_AREA_SIZEKEY, mpAreaSizeStr);
        }
        for (Way w : this.mpPolygons.values()) {
            String role = w.deleteTag(TKM_MP_ROLE);
            if (mpAreaSizeStr == null || !ROLE_OUTER.equals(role)) continue;
            w.addTag(TKM_CACHE_AREA_SIZEKEY, mpAreaSizeStr);
        }
        this.tileWayMap.putAll(this.mpPolygons);
        if (this.cOfG == null && this.largestOuterPolygon != null) {
            this.cOfG = this.largestOuterPolygon.getCofG();
        }
        if (this.largestOuterPolygon == null) {
            this.cOfG = null;
        }
    }

    protected void cleanup() {
        this.mpPolygons = null;
        this.tileArea = null;
        this.outerWaysForLineTagging = null;
        this.commonCoordMap = null;
    }

    private static boolean calcContains(JoinedWay expectedOuter, JoinedWay expectedInner) {
        if (!expectedOuter.hasIdenticalEndPoints()) {
            return false;
        }
        if (!expectedOuter.getBounds().contains(expectedInner.getBounds())) {
            return false;
        }
        int x = IsInUtil.isLineInShape(expectedInner.getPoints(), expectedOuter.getPoints(), expectedInner.getArea());
        return (x & 4) == 0;
    }

    private boolean lineCutsBbox(Coord p1, Coord p2) {
        Coord nw = new Coord(this.tileBounds.getMaxLat(), this.tileBounds.getMinLong());
        Coord sw = new Coord(this.tileBounds.getMinLat(), this.tileBounds.getMinLong());
        Coord se = new Coord(this.tileBounds.getMinLat(), this.tileBounds.getMaxLong());
        Coord ne = new Coord(this.tileBounds.getMaxLat(), this.tileBounds.getMaxLong());
        return MultiPolygonRelation.linesCutEachOther(nw, sw, p1, p2) || MultiPolygonRelation.linesCutEachOther(sw, se, p1, p2) || MultiPolygonRelation.linesCutEachOther(se, ne, p1, p2) || MultiPolygonRelation.linesCutEachOther(ne, nw, p1, p2);
    }

    private static boolean linesCutEachOther(Coord p11, Coord p12, Coord p21, Coord p22) {
        long width1 = (long)p12.getHighPrecLon() - (long)p11.getHighPrecLon();
        long width2 = (long)p22.getHighPrecLon() - (long)p21.getHighPrecLon();
        long height1 = (long)p12.getHighPrecLat() - (long)p11.getHighPrecLat();
        long height2 = (long)p22.getHighPrecLat() - (long)p21.getHighPrecLat();
        long denominator = height2 * width1 - width2 * height1;
        if (denominator == 0L) {
            return false;
        }
        long x1Mx3 = (long)p11.getHighPrecLon() - (long)p21.getHighPrecLon();
        long y1My3 = (long)p11.getHighPrecLat() - (long)p21.getHighPrecLat();
        double isx = (double)(width2 * y1My3 - height2 * x1Mx3) / (double)denominator;
        if (isx <= 0.0 || isx >= 1.0) {
            return false;
        }
        double isy = (double)(width1 * y1My3 - height1 * x1Mx3) / (double)denominator;
        return isy > 0.0 && isy < 1.0;
    }

    private static void logWayURLs(Level level, String preMsg, Way way) {
        if (log.isLoggable(level)) {
            if (way instanceof JoinedWay) {
                if (((JoinedWay)way).getOriginalWays().isEmpty()) {
                    log.warn("Way", way, "does not contain any original ways");
                }
                for (Way segment : ((JoinedWay)way).getOriginalWays()) {
                    if (preMsg == null || preMsg.length() == 0) {
                        log.log(level, (Object)segment.toBrowseURL());
                        continue;
                    }
                    log.log(level, preMsg, segment.toBrowseURL());
                }
            } else if (preMsg == null || preMsg.length() == 0) {
                log.log(level, (Object)way.toBrowseURL());
            } else {
                log.log(level, preMsg, way.toBrowseURL());
            }
        }
    }

    private void logFakeWayDetails(Level logLevel, JoinedWay fakeWay) {
        if (!log.isLoggable(logLevel)) {
            return;
        }
        if (!FakeIdGenerator.isFakeId(this.getId())) {
            return;
        }
        if (fakeWay.getOriginalWays().stream().noneMatch(w -> FakeIdGenerator.isFakeId(w.getId()))) {
            return;
        }
        for (Way orgWay : fakeWay.getOriginalWays()) {
            log.log(logLevel, "Way", orgWay.getId(), "is composed of other artificial ways. Details:");
            log.log(logLevel, " Start:", orgWay.getFirstPoint().toOSMURL());
            if (orgWay.hasEqualEndPoints()) {
                int mid = orgWay.getPoints().size() / 2;
                log.log(logLevel, " Mid:  ", orgWay.getPoints().get(mid).toOSMURL());
                continue;
            }
            log.log(logLevel, " End:  ", orgWay.getLastPoint().toOSMURL());
        }
    }

    private static void markTagsForRemovalInOrgWays(JoinedWay way) {
        for (Map.Entry<String, String> tag : way.getTagEntryIterator()) {
            MultiPolygonRelation.markTagForRemovalInOrgWays(way, tag.getKey(), tag.getValue());
        }
    }

    private static void markTagForRemovalInOrgWays(JoinedWay way, String tagKey, String tagvalue) {
        for (Way w : way.getOriginalWays()) {
            if (w instanceof JoinedWay) {
                MultiPolygonRelation.markTagForRemovalInOrgWays((JoinedWay)w, tagKey, tagvalue);
                continue;
            }
            if (!tagvalue.equals(w.getTag(tagKey))) continue;
            MultiPolygonRelation.markTagsForRemovalInOrgWays(w, tagKey);
        }
    }

    private static void markTagsForRemovalInOrgWays(Way way, String tagKey) {
        if (tagKey == null || tagKey.isEmpty()) {
            return;
        }
        String tagsToRemove = way.getTag(ElementSaver.TKM_REMOVETAGS);
        if (tagsToRemove == null) {
            tagsToRemove = tagKey;
        } else {
            if (tagKey.equals(tagsToRemove)) {
                return;
            }
            String[] keys = tagsToRemove.split(";");
            if (Arrays.asList(keys).contains(tagKey)) {
                return;
            }
            tagsToRemove = tagsToRemove + ";" + tagKey;
        }
        if (log.isDebugEnabled()) {
            log.debug("Will remove", tagKey + "=" + way.getTag(tagKey), "from way", way.getId(), way.toTagString());
        }
        way.addTag(ElementSaver.TKM_REMOVETAGS, tagsToRemove);
    }

    protected boolean needsAreaSizeTag() {
        return true;
    }

    protected Map<Long, Way> getTileWayMap() {
        return this.tileWayMap;
    }

    protected Map<Long, Way> getMpPolygons() {
        return this.mpPolygons;
    }

    protected Area getTileBounds() {
        return this.tileBounds;
    }

    public static double calcAreaSize(List<Coord> polygon) {
        if (polygon.size() < 4 || polygon.get(0) != polygon.get(polygon.size() - 1)) {
            return 0.0;
        }
        long area = 0L;
        Iterator<Coord> polyIter = polygon.iterator();
        Coord c2 = polyIter.next();
        while (polyIter.hasNext()) {
            Coord c1 = c2;
            c2 = polyIter.next();
            area += (long)(c2.getHighPrecLon() + c1.getHighPrecLon()) * (long)(c1.getHighPrecLat() - c2.getHighPrecLat());
        }
        double areaSize = (double)area / 8192.0;
        return Math.abs(areaSize);
    }

    private void divideLargest(List<JoinedWay> partition, List<List<JoinedWay>> partitions, int depth) {
        if (partition.isEmpty()) {
            return;
        }
        if (depth >= 10 || partition.size() < 2 || this.tagIsLikeYes("expect-self-intersection")) {
            partitions.add(partition);
            return;
        }
        JoinedWay mostComplex = partition.get(0);
        for (JoinedWay jw : partition) {
            if (mostComplex.getPoints().size() >= jw.getPoints().size()) continue;
            mostComplex = jw;
        }
        if (mostComplex.getPoints().size() > 2000) {
            Area fullArea = MultiPolygonRelation.calcBounds(partition);
            boolean niceSplitShift = false;
            Area[] areas = fullArea.getHeight() > fullArea.getWidth() ? fullArea.split(1, 2, 0) : fullArea.split(2, 1, 0);
            if (areas != null && areas.length == 2) {
                int dividingLine = 0;
                boolean isLongitude = false;
                boolean commonLine = true;
                if (areas[0].getMaxLat() == areas[1].getMinLat()) {
                    dividingLine = areas[0].getMaxLat();
                } else if (areas[0].getMaxLong() == areas[1].getMinLong()) {
                    dividingLine = areas[0].getMaxLong();
                    isLongitude = true;
                } else {
                    commonLine = false;
                    log.error((Object)"Split into 2 expects shared edge between the areas");
                }
                if (commonLine) {
                    ArrayList<JoinedWay> dividedLess = new ArrayList<JoinedWay>();
                    ArrayList<JoinedWay> dividedMore = new ArrayList<JoinedWay>();
                    for (int i = 0; i < partition.size(); ++i) {
                        JoinedWay jw = partition.get(i);
                        ArrayList<List<Coord>> lessList = new ArrayList<List<Coord>>();
                        ArrayList<List<Coord>> moreList = new ArrayList<List<Coord>>();
                        ShapeSplitter.splitShape(jw.getPoints(), dividingLine << 6, isLongitude, lessList, moreList, this.commonCoordMap);
                        lessList.forEach(part -> dividedLess.add(new JoinedWay(jw, (List<Coord>)part)));
                        moreList.forEach(part -> dividedMore.add(new JoinedWay(jw, (List<Coord>)part)));
                    }
                    this.divideLargest(dividedLess, partitions, depth + 1);
                    this.divideLargest(dividedMore, partitions, depth + 1);
                    return;
                }
            }
        }
        partitions.add(partition);
    }

    public Way getLargestOuterRing() {
        return this.largestOuterPolygon;
    }

    public List<JoinedWay> getRings() {
        if (this.polygons == null) {
            this.polygons = this.buildRings();
            this.cleanup();
        }
        return this.polygons;
    }

    public void setNoRecalc(boolean b) {
        this.noRecalc = b;
    }

    public boolean isNoRecalc() {
        return this.noRecalc;
    }

    protected class Partition {
        public boolean innerEqualsOuter;
        final List<JoinedWay> polygons;
        final List<BitSet> containsMatrix;
        public final BitSet unfinishedPolygons;
        final BitSet innerPolygons;
        final BitSet taggedInnerPolygons;
        final BitSet outerPolygons;
        final BitSet taggedOuterPolygons;
        final BitSet nestedOuterPolygons;
        final BitSet nestedInnerPolygons;
        final BitSet outmostInnerPolygons;

        public Partition(List<JoinedWay> list) {
            this.polygons = Collections.unmodifiableList(list);
            this.innerPolygons = new BitSet(list.size());
            this.taggedInnerPolygons = new BitSet(list.size());
            this.outerPolygons = new BitSet(list.size());
            this.taggedOuterPolygons = new BitSet(list.size());
            this.analyseRelationRoles();
            this.unfinishedPolygons = new BitSet(list.size());
            this.unfinishedPolygons.set(0, list.size());
            this.containsMatrix = this.createContainsMatrix(list);
            this.nestedOuterPolygons = new BitSet(list.size());
            this.nestedInnerPolygons = new BitSet(list.size());
            this.outmostInnerPolygons = new BitSet(list.size());
            if (this.polygons.size() == 2 && this.polygons.get(0).getPoints().size() == 5 && this.polygons.get(1).getPoints().size() == 5) {
                JoinedWay p0 = this.polygons.get(0);
                JoinedWay p1 = this.polygons.get(1);
                int x = IsInUtil.isLineInShape(p0.getPoints(), p1.getPoints(), p0.getArea());
                if (x == 2) {
                    this.innerEqualsOuter = true;
                }
            }
        }

        public void markFinished(PolygonStatus currentPolygon) {
            this.unfinishedPolygons.clear(currentPolygon.index);
        }

        private List<BitSet> createContainsMatrix(List<JoinedWay> polygons) {
            ArrayList<BitSet> matrix = new ArrayList<BitSet>();
            for (int i = 0; i < polygons.size(); ++i) {
                matrix.add(new BitSet());
            }
            long t1 = System.currentTimeMillis();
            if (log.isDebugEnabled()) {
                log.debug("createContainsMatrix listSize:", polygons.size());
            }
            ArrayList<BitSet> finishedMatrix = new ArrayList<BitSet>(polygons.size());
            for (int i = 0; i < polygons.size(); ++i) {
                BitSet matrixRow = new BitSet();
                matrixRow.set(i);
                finishedMatrix.add(matrixRow);
            }
            for (int rowIndex = 0; rowIndex < polygons.size(); ++rowIndex) {
                JoinedWay potentialOuterPolygon = polygons.get(rowIndex);
                BitSet containsColumns = (BitSet)matrix.get(rowIndex);
                BitSet finishedCol = (BitSet)finishedMatrix.get(rowIndex);
                int colIndex = finishedCol.nextClearBit(0);
                while (colIndex >= 0 && colIndex < polygons.size()) {
                    JoinedWay innerPolygon = polygons.get(colIndex);
                    if (potentialOuterPolygon.getBounds().intersects(innerPolygon.getBounds())) {
                        boolean contains = MultiPolygonRelation.calcContains(potentialOuterPolygon, innerPolygon);
                        if (contains) {
                            containsColumns.set(colIndex);
                            ((BitSet)finishedMatrix.get(colIndex)).set(rowIndex);
                            containsColumns.or((BitSet)matrix.get(colIndex));
                            finishedCol.or(containsColumns);
                        }
                    } else {
                        ((BitSet)finishedMatrix.get(colIndex)).set(rowIndex);
                        ((BitSet)finishedMatrix.get(rowIndex)).set(colIndex);
                    }
                    finishedCol.set(colIndex);
                    colIndex = finishedCol.nextClearBit(colIndex + 1);
                }
            }
            if (log.isDebugEnabled()) {
                long t2 = System.currentTimeMillis();
                log.debug("createMatrix for", polygons.size(), "polygons took", t2 - t1, "ms");
                log.debug((Object)"Containsmatrix:");
                int i = 0;
                boolean noContained = true;
                for (BitSet b : matrix) {
                    if (!b.isEmpty()) {
                        log.debug(i, "contains", b);
                        noContained = false;
                    }
                    ++i;
                }
                if (noContained) {
                    log.debug((Object)"Matrix is empty");
                }
            }
            return matrix;
        }

        private BitSet getOutmostRingsAndMatchWithRoles() {
            BitSet outmostPolygons;
            boolean outmostInnerFound;
            do {
                outmostInnerFound = false;
                outmostPolygons = this.findOutmostPolygons(this.unfinishedPolygons);
                if (!outmostPolygons.intersects(this.taggedInnerPolygons)) continue;
                this.outmostInnerPolygons.or(outmostPolygons);
                this.outmostInnerPolygons.and(this.taggedInnerPolygons);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("wrong inner polygons: " + this.outmostInnerPolygons));
                }
                this.unfinishedPolygons.andNot(this.outmostInnerPolygons);
                outmostPolygons.andNot(this.outmostInnerPolygons);
                outmostInnerFound = true;
            } while (outmostInnerFound);
            return outmostPolygons;
        }

        private void analyseRelationRoles() {
            for (int i = 0; i < this.polygons.size(); ++i) {
                JoinedWay jw = this.polygons.get(i);
                if (jw.intRole == 2) {
                    this.innerPolygons.set(i);
                    this.taggedInnerPolygons.set(i);
                    continue;
                }
                if (jw.intRole == 4) {
                    this.outerPolygons.set(i);
                    this.taggedOuterPolygons.set(i);
                    continue;
                }
                this.innerPolygons.set(i);
                this.outerPolygons.set(i);
            }
        }

        public void reportProblems() {
            if (this.outmostInnerPolygons.cardinality() + this.unfinishedPolygons.cardinality() + this.nestedOuterPolygons.cardinality() + this.nestedInnerPolygons.cardinality() >= 1) {
                log.warn("Multipolygon", MultiPolygonRelation.this.toBrowseURL(), MultiPolygonRelation.this.toTagString(), "contains errors.");
                BitSet outerUnusedPolys = new BitSet();
                outerUnusedPolys.or(this.unfinishedPolygons);
                outerUnusedPolys.or(this.outmostInnerPolygons);
                outerUnusedPolys.or(this.nestedOuterPolygons);
                outerUnusedPolys.or(this.nestedInnerPolygons);
                outerUnusedPolys.or(this.unfinishedPolygons);
                outerUnusedPolys.and(this.outerPolygons);
                for (JoinedWay w : this.bitsetToList(outerUnusedPolys)) {
                    MultiPolygonRelation.this.outerWaysForLineTagging.addAll(w.getOriginalWays());
                }
                this.runOutmostInnerPolygonCheck(this.polygons, this.outmostInnerPolygons);
                this.runNestedOuterPolygonCheck(this.polygons, this.nestedOuterPolygons);
                this.runNestedInnerPolygonCheck(this.polygons, this.nestedInnerPolygons);
                this.runWrongInnerPolygonCheck(this.polygons, this.unfinishedPolygons, this.innerPolygons);
                List<JoinedWay> lostWays = this.bitsetToList(this.unfinishedPolygons);
                for (JoinedWay w : lostWays) {
                    log.warn("Polygon", w, "is not processed due to an unknown reason.");
                    MultiPolygonRelation.logWayURLs(Level.WARNING, "-", w);
                }
            }
        }

        private List<JoinedWay> bitsetToList(BitSet selection) {
            return selection.stream().mapToObj(this.polygons::get).collect(Collectors.toList());
        }

        private void runNestedOuterPolygonCheck(List<JoinedWay> polygons, BitSet nestedOuterPolygons) {
            nestedOuterPolygons.stream().forEach(idx -> {
                JoinedWay outerWay = (JoinedWay)polygons.get(idx);
                log.warn("Polygon", outerWay, "carries role outer but lies inside an outer polygon. Potentially its role should be inner.");
                MultiPolygonRelation.this.logFakeWayDetails(Level.WARNING, outerWay);
            });
        }

        private void runNestedInnerPolygonCheck(List<JoinedWay> polygons, BitSet nestedInnerPolygons) {
            nestedInnerPolygons.stream().forEach(idx -> {
                JoinedWay innerWay = (JoinedWay)polygons.get(idx);
                log.warn("Polygon", innerWay, "carries role", MultiPolygonRelation.getRole(innerWay), "but lies inside an inner polygon. Potentially its role should be outer.");
                MultiPolygonRelation.this.logFakeWayDetails(Level.WARNING, innerWay);
            });
        }

        private void runOutmostInnerPolygonCheck(List<JoinedWay> polygons, BitSet outmostInnerPolygons) {
            outmostInnerPolygons.stream().forEach(idx -> {
                JoinedWay innerWay = (JoinedWay)polygons.get(idx);
                log.warn("Polygon", innerWay, "carries role", MultiPolygonRelation.getRole(innerWay), "but is not inside any other polygon. Potentially it does not belong to this multipolygon.");
                MultiPolygonRelation.this.logFakeWayDetails(Level.WARNING, innerWay);
            });
        }

        private void runWrongInnerPolygonCheck(List<JoinedWay> polygons, BitSet unfinishedPolygons, BitSet innerPolygons) {
            BitSet wrongInnerPolygons = this.findOutmostPolygons(unfinishedPolygons, innerPolygons);
            if (log.isDebugEnabled()) {
                log.debug("unfinished", unfinishedPolygons);
                log.debug(MultiPolygonRelation.ROLE_INNER, innerPolygons);
                log.debug("wrong", wrongInnerPolygons);
            }
            if (!wrongInnerPolygons.isEmpty()) {
                wrongInnerPolygons.stream().forEach(wiIndex -> {
                    BitSet containedPolygons = new BitSet();
                    containedPolygons.or(unfinishedPolygons);
                    containedPolygons.and(this.containsMatrix.get(wiIndex));
                    JoinedWay innerWay = (JoinedWay)polygons.get(wiIndex);
                    if (containedPolygons.isEmpty()) {
                        log.warn("Polygon", innerWay, "carries role", MultiPolygonRelation.getRole(innerWay), "but is not inside any outer polygon. Potentially it does not belong to this multipolygon.");
                        MultiPolygonRelation.this.logFakeWayDetails(Level.WARNING, innerWay);
                    } else {
                        log.warn("Polygon", innerWay, "carries role", MultiPolygonRelation.getRole(innerWay), "but is not inside any outer polygon. Potentially the roles are interchanged with the following", containedPolygons.cardinality() > 1 ? "ways" : "way", ".");
                        containedPolygons.stream().forEach(wrIndex -> {
                            MultiPolygonRelation.logWayURLs(Level.WARNING, "-", (Way)polygons.get(wrIndex));
                            unfinishedPolygons.set(wrIndex);
                            wrongInnerPolygons.set(wrIndex);
                        });
                        MultiPolygonRelation.this.logFakeWayDetails(Level.WARNING, innerWay);
                    }
                    unfinishedPolygons.clear(wiIndex);
                    wrongInnerPolygons.clear(wiIndex);
                });
            }
        }

        private boolean contains(int polygonIndex1, int polygonIndex2) {
            return this.containsMatrix.get(polygonIndex1).get(polygonIndex2);
        }

        private BitSet findOutmostPolygons(BitSet candidates, BitSet roleFilter) {
            BitSet realCandidates = (BitSet)candidates.clone();
            realCandidates.and(roleFilter);
            return this.findOutmostPolygons(realCandidates);
        }

        private BitSet findOutmostPolygons(BitSet candidates) {
            BitSet outmostPolygons = new BitSet();
            candidates.stream().forEach(candidateIndex -> {
                boolean isOutmost = candidates.stream().noneMatch(otherCandidateIndex -> this.contains(otherCandidateIndex, candidateIndex));
                if (isOutmost) {
                    outmostPolygons.set(candidateIndex);
                }
            });
            return outmostPolygons;
        }

        public List<PolygonStatus> getPolygonStatus(PolygonStatus currentPolygon) {
            String defaultRole;
            BitSet outmostPolygons;
            ArrayList<PolygonStatus> polygonStatusList = new ArrayList<PolygonStatus>();
            if (currentPolygon == null) {
                outmostPolygons = this.getOutmostRingsAndMatchWithRoles();
                defaultRole = MultiPolygonRelation.ROLE_OUTER;
            } else {
                outmostPolygons = this.checkRoleAgainstGeometry(currentPolygon);
                defaultRole = currentPolygon.outer ? MultiPolygonRelation.ROLE_INNER : MultiPolygonRelation.ROLE_OUTER;
            }
            outmostPolygons.stream().forEach(polyIndex -> {
                JoinedWay polygon = this.polygons.get(polyIndex);
                String role = MultiPolygonRelation.getRole(polygon);
                if (role == null || "".equals(role)) {
                    role = defaultRole;
                }
                polygonStatusList.add(new PolygonStatus(MultiPolygonRelation.ROLE_OUTER.equals(role), polyIndex, polygon));
            });
            if (polygonStatusList.size() > 2) {
                polygonStatusList.sort((o1, o2) -> {
                    if (o1.outer != o2.outer) {
                        return o1.outer ? -1 : 1;
                    }
                    return o1.polygon.getPoints().size() - o2.polygon.getPoints().size();
                });
            }
            return polygonStatusList;
        }

        public BitSet checkRoleAgainstGeometry(PolygonStatus currentPolygon) {
            BitSet holeIndexes;
            boolean holesOk;
            BitSet polygonContains = new BitSet();
            polygonContains.or(this.containsMatrix.get(currentPolygon.index));
            polygonContains.and(this.unfinishedPolygons);
            do {
                holeIndexes = this.findOutmostPolygons(polygonContains);
                holesOk = true;
                if (currentPolygon.outer) {
                    if (!holeIndexes.intersects(this.taggedOuterPolygons)) continue;
                    BitSet addOuterNestedPolygons = new BitSet();
                    addOuterNestedPolygons.or(holeIndexes);
                    addOuterNestedPolygons.and(this.taggedOuterPolygons);
                    this.nestedOuterPolygons.or(addOuterNestedPolygons);
                    holeIndexes.andNot(addOuterNestedPolygons);
                    this.unfinishedPolygons.andNot(addOuterNestedPolygons);
                    polygonContains.andNot(addOuterNestedPolygons);
                    holesOk = false;
                    continue;
                }
                if (!holeIndexes.intersects(this.taggedInnerPolygons)) continue;
                BitSet addInnerNestedPolygons = new BitSet();
                addInnerNestedPolygons.or(holeIndexes);
                addInnerNestedPolygons.and(this.taggedInnerPolygons);
                this.nestedInnerPolygons.or(addInnerNestedPolygons);
            } while (!holesOk);
            return holeIndexes;
        }
    }

    protected static class PolygonStatus {
        public final boolean outer;
        public final int index;
        public final JoinedWay polygon;

        public PolygonStatus(boolean outer, int index, JoinedWay polygon) {
            this.outer = outer;
            this.index = index;
            this.polygon = polygon;
        }

        public String toString() {
            return this.polygon + "_" + this.outer;
        }
    }

    public static final class JoinedWay
    extends Way {
        private final List<Way> originalWays;
        private byte intRole;
        private boolean closedArtificially;
        private Coord pointInside;
        private boolean doPointInsideCalcs = true;
        private int minLat;
        private int maxLat;
        private int minLon;
        private int maxLon;
        private Rectangle bounds;
        private Area area;

        public JoinedWay(Way originalWay, String givenRole) {
            super(originalWay.getOriginalId(), originalWay.getPoints());
            this.markAsGeneratedFrom(originalWay);
            this.originalWays = new ArrayList<Way>();
            this.addWay(originalWay, this.roleToInt(givenRole));
            Coord c0 = originalWay.getFirstPoint();
            this.minLat = this.maxLat = c0.getLatitude();
            this.minLon = this.maxLon = c0.getLongitude();
            this.updateBounds(originalWay.getPoints());
        }

        public JoinedWay(JoinedWay other, List<Coord> points) {
            super(other.getOriginalId(), points);
            this.markAsGeneratedFrom(other);
            this.originalWays = new ArrayList<Way>(other.getOriginalWays());
            this.intRole = other.intRole;
            this.closedArtificially = other.closedArtificially;
            Coord c0 = points.get(0);
            this.minLat = this.maxLat = c0.getLatitude();
            this.minLon = this.maxLon = c0.getLongitude();
            this.updateBounds(points);
        }

        private byte roleToInt(String role) {
            if (role == null) {
                return 1;
            }
            switch (role) {
                case "inner": {
                    return 2;
                }
                case "outer": {
                    return 4;
                }
                case "": {
                    return 8;
                }
            }
            return 16;
        }

        public void addPoint(int index, Coord point) {
            this.getPoints().add(index, point);
            this.updateBounds(point);
        }

        @Override
        public void addPoint(Coord point) {
            super.addPoint(point);
            this.updateBounds(point);
        }

        private void updateBounds(List<Coord> pointList) {
            for (Coord c : pointList) {
                this.updateBounds(c.getLatitude(), c.getLongitude());
            }
        }

        private void updateBounds(JoinedWay other) {
            this.updateBounds(other.minLat, other.minLon);
            this.updateBounds(other.maxLat, other.maxLon);
        }

        private void updateBounds(int lat, int lon) {
            if (lat < this.minLat) {
                this.minLat = lat;
                this.bounds = null;
            } else if (lat > this.maxLat) {
                this.maxLat = lat;
                this.bounds = null;
            }
            if (lon < this.minLon) {
                this.minLon = lon;
                this.bounds = null;
            } else if (lon > this.maxLon) {
                this.maxLon = lon;
                this.bounds = null;
            }
        }

        private void updateBounds(Coord point) {
            this.updateBounds(point.getLatitude(), point.getLongitude());
        }

        public Rectangle getBounds() {
            if (this.bounds == null) {
                this.bounds = new Rectangle(this.minLon - 1, this.minLat - 1, this.maxLon - this.minLon + 2, this.maxLat - this.minLat + 2);
            }
            return this.bounds;
        }

        public Area getArea() {
            if (this.area == null) {
                this.area = new Area(this.minLat, this.minLon, this.maxLat, this.maxLon);
            }
            return this.area;
        }

        public void addWay(Way way, int internalRole) {
            if (way instanceof JoinedWay) {
                this.originalWays.addAll(((JoinedWay)way).getOriginalWays());
                this.intRole = (byte)(this.intRole | ((JoinedWay)way).intRole);
                this.updateBounds((JoinedWay)way);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Joined", this.getId(), "with", way.getId());
                }
                this.originalWays.add(way);
                this.intRole = (byte)(this.intRole | internalRole);
            }
        }

        public void addWay(JoinedWay way) {
            this.originalWays.addAll(way.originalWays);
            this.intRole = (byte)(this.intRole | way.intRole);
            this.updateBounds(way);
        }

        public void closeWayArtificially() {
            this.addPoint(this.getPoints().get(0));
            this.closedArtificially = true;
        }

        public boolean isClosedArtificially() {
            return this.closedArtificially;
        }

        public static Map<String, String> getMergedTags(Collection<Way> ways) {
            HashMap<String, String> mergedTags = new HashMap<String, String>();
            boolean first = true;
            for (Way way : ways) {
                if (first) {
                    for (Map.Entry<String, String> tag2 : way.getTagEntryIterator()) {
                        mergedTags.put(tag2.getKey(), tag2.getValue());
                    }
                    first = false;
                    continue;
                }
                if (mergedTags.isEmpty()) break;
                mergedTags.entrySet().removeIf(tag -> {
                    String wayTagValue = way.getTag((String)tag.getKey());
                    return wayTagValue != null && !((String)tag.getValue()).equals(wayTagValue);
                });
            }
            return mergedTags;
        }

        public void mergeTagsFromOrgWays() {
            if (log.isDebugEnabled()) {
                log.debug("Way", this.getId(), "merge tags from", this.getOriginalWays().size(), "ways");
            }
            this.removeAllTags();
            Map<String, String> mergedTags = JoinedWay.getMergedTags(this.getOriginalWays());
            mergedTags.forEach(this::addTag);
        }

        public List<Way> getOriginalWays() {
            return this.originalWays;
        }

        @Override
        public String toString() {
            String prefix = this.getId() + "(" + this.getPoints().size() + "P)(";
            return this.getOriginalWays().stream().map(w -> w.getId() + "[" + w.getPoints().size() + "P]").collect(Collectors.joining(",", prefix, ")"));
        }

        public boolean canJoin(JoinedWay other) {
            return this.getFirstPoint() == other.getFirstPoint() || this.getFirstPoint() == other.getLastPoint() || this.getLastPoint() == other.getFirstPoint() || this.getLastPoint() == other.getLastPoint();
        }

        public boolean buildsRingWith(JoinedWay other) {
            return this.getFirstPoint() == other.getFirstPoint() && this.getLastPoint() == other.getLastPoint() || this.getFirstPoint() == other.getLastPoint() && this.getLastPoint() == other.getFirstPoint();
        }

        private void joinWith(JoinedWay other) {
            boolean reverseOther = false;
            int insIdx = -1;
            int firstOtherIdx = 1;
            if (this.getFirstPoint() == other.getFirstPoint()) {
                insIdx = 0;
                reverseOther = true;
                firstOtherIdx = 1;
            } else if (this.getLastPoint() == other.getFirstPoint()) {
                insIdx = this.getPoints().size();
                firstOtherIdx = 1;
            } else if (this.getFirstPoint() == other.getLastPoint()) {
                insIdx = 0;
                firstOtherIdx = 0;
            } else if (this.getLastPoint() == other.getLastPoint()) {
                insIdx = this.getPoints().size();
                reverseOther = true;
                firstOtherIdx = 0;
            } else {
                String msg = "Cannot join " + this.getBasicLogInformation() + " with " + other.getBasicLogInformation();
                log.error((Object)msg);
                throw new ExitException(msg);
            }
            int lastIdx = other.getPoints().size();
            if (firstOtherIdx == 0) {
                --lastIdx;
            }
            List<Coord> tempCoords = other.getPoints().subList(firstOtherIdx, lastIdx);
            if (reverseOther) {
                tempCoords = new ArrayList<Coord>(tempCoords);
                Collections.reverse(tempCoords);
            }
            this.getPoints().addAll(insIdx, tempCoords);
            this.addWay(other);
        }

        public Coord getPointInside() {
            if (this.doPointInsideCalcs) {
                this.doPointInsideCalcs = false;
                Coord test = super.getCofG();
                if (IsInUtil.isPointInShape(test, this.getPoints()) == 1) {
                    this.pointInside = test;
                }
            }
            return this.pointInside;
        }
    }

    private static class ConnectionData {
        Coord c1;
        Coord c2;
        JoinedWay w1;
        JoinedWay w2;
        Coord imC;
        double distance;

        private ConnectionData() {
        }
    }
}

