/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.general.LineClipper;
import uk.me.parabola.mkgmap.reader.osm.MultiPolygonRelation;
import uk.me.parabola.mkgmap.reader.osm.Node;
import uk.me.parabola.mkgmap.reader.osm.OSMId2ObjectMap;
import uk.me.parabola.mkgmap.reader.osm.OsmConverter;
import uk.me.parabola.mkgmap.reader.osm.Relation;
import uk.me.parabola.mkgmap.reader.osm.RestrictionRelation;
import uk.me.parabola.mkgmap.reader.osm.SeaPolygonRelation;
import uk.me.parabola.mkgmap.reader.osm.TagDict;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.util.EnhancedProperties;
import uk.me.parabola.util.MultiHashMap;

public class ElementSaver {
    private static final Logger log = Logger.getLogger(ElementSaver.class);
    protected OSMId2ObjectMap<Coord> coordMap = new OSMId2ObjectMap();
    protected Map<Long, Node> nodeMap;
    protected Map<Long, Way> wayMap;
    protected Map<Long, Relation> relationMap;
    protected final MultiHashMap<Long, Map.Entry<String, Relation>> deferredRelationMap = new MultiHashMap();
    private Area boundingBox;
    private int minLat = Integer.MAX_VALUE;
    private int minLon = Integer.MAX_VALUE;
    private int maxLat = Integer.MIN_VALUE;
    private int maxLon = Integer.MIN_VALUE;
    private final boolean ignoreTurnRestrictions;
    private final String[] deadEndArgs;
    public static final short TKM_REMOVETAGS = TagDict.getInstance().xlate("mkgmap:removetags");

    public ElementSaver(EnhancedProperties args) {
        if (args.getProperty("preserve-element-order", false)) {
            this.nodeMap = new LinkedHashMap<Long, Node>(5000);
            this.wayMap = new LinkedHashMap<Long, Way>(5000);
            this.relationMap = new LinkedHashMap<Long, Relation>();
        } else {
            this.nodeMap = new HashMap<Long, Node>();
            this.wayMap = new HashMap<Long, Way>();
            this.relationMap = new HashMap<Long, Relation>();
        }
        this.ignoreTurnRestrictions = args.getProperty("ignore-turn-restrictions", false) || !args.containsKey("route");
        this.deadEndArgs = args.getProperty("dead-ends", "fixme,FIXME").split(",");
    }

    public void addPoint(long id, Coord co) {
        this.coordMap.put(id, co);
        if (co.getLatitude() < this.minLat) {
            this.minLat = co.getLatitude();
        }
        if (co.getLatitude() > this.maxLat) {
            this.maxLat = co.getLatitude();
        }
        if (co.getLongitude() < this.minLon) {
            this.minLon = co.getLongitude();
        }
        if (co.getLongitude() > this.maxLon) {
            this.maxLon = co.getLongitude();
        }
    }

    public void addNode(Node node) {
        this.nodeMap.put(node.getId(), node);
    }

    public void addWay(Way way) {
        this.wayMap.put(way.getId(), way);
    }

    public void addRelation(Relation rel) {
        String type = rel.getTag("type");
        if (type != null) {
            if ("multipolygon".equals(type) || "boundary".equals(type)) {
                rel = this.createMultiPolyRelation(rel);
            } else if ("restriction".equals(type) || type.startsWith("restriction:")) {
                if (this.ignoreTurnRestrictions) {
                    rel = null;
                } else if (rel.getTag("restriction") == null && rel.getTagsWithPrefix("restriction:", false).isEmpty()) {
                    log.warn((Object)("ignoring unspecified/unsupported restriction " + rel.toBrowseURL()));
                } else {
                    rel = new RestrictionRelation(rel);
                }
            }
        }
        if (rel != null) {
            long id = rel.getId();
            this.relationMap.put(rel.getId(), rel);
            rel.processElements();
            List entries = (List)this.deferredRelationMap.remove(id);
            if (entries != null) {
                for (Map.Entry entry : entries) {
                    ((Relation)entry.getValue()).addElement((String)entry.getKey(), rel);
                }
            }
        }
    }

    public Relation createMultiPolyRelation(Relation rel) {
        return new MultiPolygonRelation(rel, this.wayMap, this.getBoundingBox());
    }

    public SeaPolygonRelation createSeaPolyRelation(Relation rel) {
        return new SeaPolygonRelation(rel, this.wayMap, this.getBoundingBox());
    }

    public void setBoundingBox(Area bbox) {
        this.boundingBox = bbox;
    }

    public Coord getCoord(long id) {
        return this.coordMap.get(id);
    }

    public Node getNode(long id) {
        return this.nodeMap.get(id);
    }

    public Way getWay(long id) {
        return this.wayMap.get(id);
    }

    public Relation getRelation(long id) {
        return this.relationMap.get(id);
    }

    public void finishLoading() {
        this.coordMap = null;
    }

    public void convert(OsmConverter converter) {
        if (this.boundingBox != null) {
            this.makeBoundaryNodes();
        }
        converter.setBoundingBox(this.getBoundingBox());
        converter.augmentWith(this);
        for (Relation r : this.relationMap.values()) {
            converter.convertRelation(r);
        }
        block1: for (Node n : this.nodeMap.values()) {
            converter.convertNode(n);
            for (String deadEndArg : this.deadEndArgs) {
                String[] arg = deadEndArg.split("=", 2);
                String key = arg[0];
                String value = arg.length < 2 || "*".equals(arg[1]) ? "" : arg[1];
                String tagValue = n.getTag(key);
                if (tagValue == null || !tagValue.equals(value) && !value.isEmpty()) continue;
                Coord location = n.getLocation();
                if (location == null) continue block1;
                location.setSkipDeadEndCheck(true);
                continue block1;
            }
        }
        this.nodeMap = null;
        Iterator<Way> wayIter = this.wayMap.values().iterator();
        while (wayIter.hasNext()) {
            Way way = wayIter.next();
            converter.convertWay(way);
            wayIter.remove();
        }
        this.wayMap = null;
        converter.end();
        this.relationMap = null;
        this.deferredRelationMap.clear();
    }

    private void makeBoundaryNodes() {
        log.info((Object)"Making boundary nodes");
        int numBoundaryNodesDetected = 0;
        int numBoundaryNodesAdded = 0;
        for (Way way : this.wayMap.values()) {
            List<Coord> points = way.getPoints();
            for (int i = points.size() - 1; i >= 1; --i) {
                Coord[] pair = new Coord[]{points.get(i - 1), points.get(i)};
                Coord[] clippedPair = LineClipper.clip(this.getBoundingBox(), pair, true);
                if (clippedPair == null) continue;
                if (clippedPair[1] != points.get(i)) {
                    assert (clippedPair[1].getOnBoundary());
                    points.add(i, clippedPair[1]);
                    ++numBoundaryNodesAdded;
                } else if (clippedPair[1].getOnBoundary()) {
                    ++numBoundaryNodesDetected;
                }
                if (clippedPair[0] != points.get(i - 1)) {
                    assert (clippedPair[0].getOnBoundary());
                    points.add(i, clippedPair[0]);
                    ++numBoundaryNodesAdded;
                    continue;
                }
                if (!clippedPair[0].getOnBoundary()) continue;
                ++numBoundaryNodesDetected;
            }
        }
        log.info((Object)("Making boundary nodes - finished (" + numBoundaryNodesAdded + " added, " + numBoundaryNodesDetected + " detected)"));
    }

    public Map<Long, Node> getNodes() {
        return this.nodeMap;
    }

    public Map<Long, Way> getWays() {
        return this.wayMap;
    }

    public Map<Long, Relation> getRelations() {
        return this.relationMap;
    }

    public Area getBoundingBox() {
        if (this.boundingBox != null) {
            return this.boundingBox;
        }
        if (this.minLat > this.maxLat) {
            return new Area(0, 0, 0, 0);
        }
        return this.getDataBoundingBox();
    }

    public Area getDataBoundingBox() {
        if (this.minLat > this.maxLat) {
            return null;
        }
        return new Area(Math.max(Utils.toMapUnit(-90.0), this.minLat - 1), Math.max(Utils.toMapUnit(-180.0), this.minLon - 1), Math.min(Utils.toMapUnit(90.0), this.maxLat + 1), Math.min(Utils.toMapUnit(180.0), this.maxLon + 1));
    }

    public void deferRelation(long id, Relation parentRel, String role) {
        this.deferredRelationMap.add(id, new AbstractMap.SimpleEntry<String, Relation>(role, parentRel));
    }

    public Node getOrCreateNode(long id) {
        Coord co;
        Node node = this.nodeMap.get(id);
        if (node == null && (co = this.getCoord(id)) != null) {
            node = new Node(id, co);
            this.addNode(node);
        }
        return node;
    }
}

