/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import uk.me.parabola.imgfmt.ExitException;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.net.RoadNetwork;
import uk.me.parabola.imgfmt.app.trergn.Overview;
import uk.me.parabola.mkgmap.Version;
import uk.me.parabola.mkgmap.general.MapDataSource;
import uk.me.parabola.mkgmap.general.MapDetails;
import uk.me.parabola.mkgmap.general.MapLine;
import uk.me.parabola.mkgmap.general.MapPoint;
import uk.me.parabola.mkgmap.general.MapShape;
import uk.me.parabola.util.Configurable;
import uk.me.parabola.util.EnhancedProperties;

public abstract class MapperBasedMapDataSource
implements MapDataSource,
Configurable {
    protected final MapDetails mapper = new MapDetails();
    private EnhancedProperties configProps;
    private boolean driveOnLeft;
    private static final LocalDateTime now = LocalDateTime.now();

    @Override
    public Area getBounds() {
        return this.mapper.getBounds();
    }

    @Override
    public List<MapLine> getLines() {
        return this.mapper.getLines();
    }

    @Override
    public List<MapShape> getShapes() {
        return this.mapper.getShapes();
    }

    @Override
    public RoadNetwork getRoadNetwork() {
        return this.mapper.getRoadNetwork();
    }

    @Override
    public List<Overview> getOverviews() {
        return this.mapper.getOverviews();
    }

    @Override
    public List<MapPoint> getPoints() {
        return this.mapper.getPoints();
    }

    @Override
    public void config(EnhancedProperties props) {
        this.configProps = props;
        this.mapper.config(props);
    }

    protected EnhancedProperties getConfig() {
        return this.configProps;
    }

    public MapDetails getMapper() {
        return this.mapper;
    }

    public void addBackground() {
        MapShape background = new MapShape();
        background.setPoints(this.mapper.getBounds().toCoords());
        background.setType(75);
        background.setMinResolution(0);
        background.setFullArea(0x7FFFFFFFFFFFFFFEL);
        this.mapper.addShape(background);
    }

    public void addBoundaryLine(Area area, int type, String name) {
        MapLine boundary = new MapLine();
        boundary.setType(type);
        if (name != null) {
            boundary.setName(name);
        }
        boundary.setMinResolution(0);
        boundary.setPoints(area.toCoords());
        this.mapper.addLine(boundary);
    }

    public Boolean getDriveOnLeft() {
        return this.driveOnLeft;
    }

    protected void setDriveOnLeft(boolean b) {
        this.driveOnLeft = b;
    }

    public static String[] readCopyrightFile(String copyrightFileName) {
        List<Object> copyrightArray = new ArrayList();
        try {
            File file = new File(copyrightFileName);
            copyrightArray = Files.readAllLines(file.toPath(), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new ExitException("Error reading copyright file " + copyrightFileName, e);
        }
        if (!copyrightArray.isEmpty() && ((String)copyrightArray.get(0)).startsWith("\ufeff")) {
            copyrightArray.set(0, ((String)copyrightArray.get(0)).substring(1));
        }
        UnaryOperator replaceVariables = s -> s.replace("$MKGMAP_VERSION$", Version.VERSION).replace("$JAVA_VERSION$", System.getProperty("java.version")).replace("$YEAR$", Integer.toString(now.getYear())).replace("$LONGDATE$", now.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.LONG))).replace("$SHORTDATE$", now.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT))).replace("$TIME$", now.toLocalTime().toString().substring(0, 5));
        copyrightArray.replaceAll(replaceVariables);
        String[] copyright = new String[copyrightArray.size()];
        copyrightArray.toArray(copyright);
        return copyright;
    }
}

