/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle.function;

import uk.me.parabola.mkgmap.osmstyle.function.AreaSizeFunction;
import uk.me.parabola.mkgmap.osmstyle.function.IsClosedFunction;
import uk.me.parabola.mkgmap.osmstyle.function.IsCompleteFunction;
import uk.me.parabola.mkgmap.osmstyle.function.IsDriveOnLeftFunction;
import uk.me.parabola.mkgmap.osmstyle.function.IsInFunction;
import uk.me.parabola.mkgmap.osmstyle.function.LengthFunction;
import uk.me.parabola.mkgmap.osmstyle.function.MaxSpeedFunction;
import uk.me.parabola.mkgmap.osmstyle.function.OsmIdFunction;
import uk.me.parabola.mkgmap.osmstyle.function.StyleFunction;
import uk.me.parabola.mkgmap.osmstyle.function.TypeFunction;

public class FunctionFactory {
    private FunctionFactory() {
    }

    public static StyleFunction createFunction(String name) {
        switch (name) {
            case "length": {
                return new LengthFunction();
            }
            case "is_closed": {
                return new IsClosedFunction();
            }
            case "is_complete": {
                return new IsCompleteFunction();
            }
            case "area_size": {
                return new AreaSizeFunction();
            }
            case "maxspeedkmh": {
                return new MaxSpeedFunction(MaxSpeedFunction.SpeedUnit.KMH);
            }
            case "maxspeedmph": {
                return new MaxSpeedFunction(MaxSpeedFunction.SpeedUnit.MPH);
            }
            case "type": {
                return new TypeFunction();
            }
            case "osmid": {
                return new OsmIdFunction();
            }
            case "is_in": {
                return new IsInFunction();
            }
            case "is_drive_on_left": {
                return new IsDriveOnLeftFunction();
            }
        }
        return null;
    }
}

