/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle.actions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import uk.me.parabola.mkgmap.osmstyle.actions.Action;
import uk.me.parabola.mkgmap.osmstyle.actions.AddAccessAction;
import uk.me.parabola.mkgmap.osmstyle.actions.AddTagAction;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.Relation;

public class SubAction
implements Action {
    private final List<Action> actionList = new ArrayList<Action>();
    private final String role;
    private final String selector;

    public SubAction(String role, String selector) {
        this.role = role;
        this.selector = selector;
    }

    @Override
    public boolean perform(Element el) {
        if (el instanceof Relation) {
            this.performOnSubElements((Relation)el);
        }
        return true;
    }

    private void performOnSubElements(Relation rel) {
        List<Map.Entry<String, Element>> elements = rel.getElements();
        for (Action a2 : this.actionList) {
            if (a2 instanceof AddTagAction) {
                ((AddTagAction)a2).setValueTags(rel);
                continue;
            }
            if (!(a2 instanceof AddAccessAction)) continue;
            ((AddAccessAction)a2).setValueTags(rel);
        }
        boolean once = "once".equals(this.selector);
        boolean onlyFirst = "first".equals(this.selector);
        HashSet<Element> elems = once ? new HashSet<Element>() : null;
        for (Map.Entry<String, Element> r_el : elements) {
            if (!(this.role != null && !this.role.equals(r_el.getKey()) || once && !elems.add(r_el.getValue()))) {
                this.actionList.forEach(a -> a.perform((Element)r_el.getValue()));
            }
            if (!onlyFirst) continue;
            break;
        }
    }

    public void add(Action act) {
        this.actionList.add(act);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("apply");
        if (this.selector != null) {
            sb.append(String.format("_%s", this.selector));
        }
        if (this.role != null) {
            sb.append(String.format(" role=%s ", this.role));
        }
        sb.append(this.actionList.stream().map(Object::toString).collect(Collectors.joining(" ", "{", "}")));
        return sb.toString();
    }
}

