/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle.actions;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.me.parabola.mkgmap.osmstyle.actions.ValueFilter;
import uk.me.parabola.mkgmap.osmstyle.eval.UnitConversions;
import uk.me.parabola.mkgmap.reader.osm.Element;

public class ConvertFilter
extends ValueFilter {
    private static final Pattern UNIT_RE = Pattern.compile("\\s*([\\d.]+)\\s*([\\w/]*)\\s*");
    private final UnitConversions units;

    public ConvertFilter(String arg) {
        this.units = UnitConversions.createConversion(arg);
    }

    @Override
    protected String doFilter(String value, Element el) {
        if (value == null || !this.units.isValid()) {
            return value;
        }
        String number = value;
        Double factor = this.units.getDefaultFactor();
        if (!Character.isDigit(value.charAt(value.length() - 1))) {
            Matcher matcher = UNIT_RE.matcher(value);
            if (matcher.matches()) {
                number = matcher.group(1);
                String source = matcher.group(2);
                factor = this.units.convertFactor(source);
                if (factor == null) {
                    return value;
                }
            } else {
                return value;
            }
        }
        try {
            double d = Double.parseDouble(number);
            return String.valueOf(Math.round(d * factor));
        }
        catch (NumberFormatException e) {
            return value;
        }
    }
}

