/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import uk.me.parabola.imgfmt.ExitException;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.CoordNode;
import uk.me.parabola.imgfmt.app.Label;
import uk.me.parabola.imgfmt.app.net.AccessTagsAndBits;
import uk.me.parabola.imgfmt.app.net.GeneralRouteRestriction;
import uk.me.parabola.imgfmt.app.trergn.ExtTypeAttributes;
import uk.me.parabola.imgfmt.app.trergn.MapObject;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.CommandArgs;
import uk.me.parabola.mkgmap.build.LocatorConfig;
import uk.me.parabola.mkgmap.filters.LineSizeSplitterFilter;
import uk.me.parabola.mkgmap.general.AreaClipper;
import uk.me.parabola.mkgmap.general.Clipper;
import uk.me.parabola.mkgmap.general.LineAdder;
import uk.me.parabola.mkgmap.general.LineClipper;
import uk.me.parabola.mkgmap.general.MapCollector;
import uk.me.parabola.mkgmap.general.MapElement;
import uk.me.parabola.mkgmap.general.MapExitPoint;
import uk.me.parabola.mkgmap.general.MapLine;
import uk.me.parabola.mkgmap.general.MapPoint;
import uk.me.parabola.mkgmap.general.MapRoad;
import uk.me.parabola.mkgmap.general.MapShape;
import uk.me.parabola.mkgmap.osmstyle.ConvertedWay;
import uk.me.parabola.mkgmap.osmstyle.NameFinder;
import uk.me.parabola.mkgmap.osmstyle.NearbyPoiHandler;
import uk.me.parabola.mkgmap.osmstyle.PrefixSuffixFilter;
import uk.me.parabola.mkgmap.osmstyle.RoadMerger;
import uk.me.parabola.mkgmap.osmstyle.WrongAngleFixer;
import uk.me.parabola.mkgmap.osmstyle.housenumber.HousenumberGenerator;
import uk.me.parabola.mkgmap.reader.osm.CoordPOI;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.ElementSaver;
import uk.me.parabola.mkgmap.reader.osm.FakeIdGenerator;
import uk.me.parabola.mkgmap.reader.osm.FeatureKind;
import uk.me.parabola.mkgmap.reader.osm.GType;
import uk.me.parabola.mkgmap.reader.osm.MultiPolygonRelation;
import uk.me.parabola.mkgmap.reader.osm.Node;
import uk.me.parabola.mkgmap.reader.osm.OsmConverter;
import uk.me.parabola.mkgmap.reader.osm.Relation;
import uk.me.parabola.mkgmap.reader.osm.RestrictionRelation;
import uk.me.parabola.mkgmap.reader.osm.Rule;
import uk.me.parabola.mkgmap.reader.osm.Style;
import uk.me.parabola.mkgmap.reader.osm.TagDict;
import uk.me.parabola.mkgmap.reader.osm.Tags;
import uk.me.parabola.mkgmap.reader.osm.TypeResult;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.util.ElementQuadTree;
import uk.me.parabola.util.EnhancedProperties;
import uk.me.parabola.util.MultiHashMap;

public class StyledConverter
implements OsmConverter {
    private static final Logger log = Logger.getLogger(StyledConverter.class);
    private static final Logger roadLog = Logger.getLogger(StyledConverter.class.getName() + ".roads");
    private final NameFinder nameFinder;
    private final MapCollector collector;
    private Clipper clipper = Clipper.NULL_CLIPPER;
    private Area bbox = Area.PLANET;
    private final List<RestrictionRelation> restrictions = new ArrayList<RestrictionRelation>();
    private final MultiHashMap<Long, RestrictionRelation> wayRelMap = new MultiHashMap();
    private Map<Node, List<Way>> poiRestrictions = new LinkedHashMap<Node, List<Way>>();
    private Map<Node, CoordNode> replacedCoordPoi = new HashMap<Node, CoordNode>();
    private static final int MAX_LINE_LENGTH = 40000;
    private static final int MAX_ARC_LENGTH = 20450000;
    private static final int MAX_ROAD_POINTS = 31250;
    private static final int MAX_NODES_IN_WAY = 64;
    private IdentityHashMap<Coord, CoordNode> nodeIdMap = new IdentityHashMap();
    public static final String WAY_POI_NODE_IDS = "mkgmap:way-poi-node-ids";
    private static final short TKM_HAS_DIRECTION = TagDict.getInstance().xlate("mkgmap:has-direction");
    private final Set<Way> borders = new LinkedHashSet<Way>();
    private boolean addBoundaryNodesAtAdminBoundaries;
    private int admLevelNod3;
    private List<ConvertedWay> roads = new ArrayList<ConvertedWay>();
    private List<ConvertedWay> lines = new ArrayList<ConvertedWay>();
    private int nextRoadId = 1;
    private HousenumberGenerator housenumberGenerator;
    private final Rule wayRules;
    private final Rule nodeRules;
    private final Rule lineRules;
    private final Rule polygonRules;
    private Style style;
    private String driveOn;
    private Boolean driveOnLeft;
    private int numDriveOnLeftRoads;
    private int numDriveOnRightRoads;
    private int numDriveOnSideUnknown;
    private int numRoads;
    private String countryAbbr;
    private final boolean checkRoundaboutDirections;
    private final boolean fixRoundaboutDirections;
    private final int reportDeadEnds;
    private final boolean linkPOIsToWays;
    private final boolean mergeRoads;
    private final boolean allowReverseMerge;
    private final Set<Integer> lineTypesWithDirection = new HashSet<Integer>();
    private final boolean routable;
    private boolean forceEndNodesRoutingNodes;
    private final Tags styleOptionTags;
    private static final String STYLE_OPTION_PREF = "mkgmap:option:";
    private final PrefixSuffixFilter prefixSuffixFilter;
    private final boolean keepBlanks;
    private LineAdder lineAdder;
    private NearbyPoiHandler nearbyPoiHandler;
    static List<String> unusedStyleOptions = new ArrayList<String>();
    static List<String> duplicateKeys = new ArrayList<String>();
    static List<String> unspecifiedStyleOptions = new ArrayList<String>();
    private final WayTypeResult wayTypeResult = new WayTypeResult();
    private static final short TKM_STYLEFILTER = TagDict.getInstance().xlate("mkgmap:stylefilter");
    private static final short TKM_MAKE_CYCLE_WAY = TagDict.getInstance().xlate("mkgmap:make-cycle-way");
    private long lastRoadId = 0L;
    private int lineCacheId = 0;
    private BitSet routingWarningWasPrinted = new BitSet();
    private static final short TK_ONEWAY = TagDict.getInstance().xlate("oneway");
    private NodeTypeResult nodeTypeResult = new NodeTypeResult();
    private static final short[] labelTagKeys = new short[]{TagDict.getInstance().xlate("mkgmap:label:1"), TagDict.getInstance().xlate("mkgmap:label:2"), TagDict.getInstance().xlate("mkgmap:label:3"), TagDict.getInstance().xlate("mkgmap:label:4")};
    private static final short TKM_HIGHEST_RES_ONLY = TagDict.getInstance().xlate("mkgmap:highest-resolution-only");
    private static final short TKM_SKIP_SIZE_FILTER = TagDict.getInstance().xlate("mkgmap:skipSizeFilter");
    private static final short TKM_DRAW_LEVEL = TagDict.getInstance().xlate("mkgmap:drawLevel");
    private static final short TKM_COUNTRY = TagDict.getInstance().xlate("mkgmap:country");
    private static final short TKM_REGION = TagDict.getInstance().xlate("mkgmap:region");
    private static final short TKM_CITY = TagDict.getInstance().xlate("mkgmap:city");
    private static final short TKM_POSTAL_CODE = TagDict.getInstance().xlate("mkgmap:postal_code");
    private static final short TKM_STREET = TagDict.getInstance().xlate("mkgmap:street");
    private static final short TKM_HOUSENUMBER = TagDict.getInstance().xlate("mkgmap:housenumber");
    private static final short TKM_PHONE = TagDict.getInstance().xlate("mkgmap:phone");
    private static final short TKM_IS_IN = TagDict.getInstance().xlate("mkgmap:is_in");
    private static final String[] CONNECTION_TAGS = new String[]{"mkgmap:set_unconnected_type", "mkgmap:set_semi_connected_type"};

    public StyledConverter(Style style, MapCollector collector, EnhancedProperties props) {
        this.collector = collector;
        this.nameFinder = new NameFinder(props);
        this.style = style;
        this.wayRules = style.getWayRules();
        this.nodeRules = style.getNodeRules();
        this.lineRules = style.getLineRules();
        this.polygonRules = style.getPolygonRules();
        if (this.lineRules.containsExpression("$mkgmap:dest_hint='true'")) {
            log.error((Object)"At least one 'lines' rule in the style contains the expression mkgmap:dest_hint=true, it should be changed to mkgmap:dest_hint=*");
        }
        this.housenumberGenerator = new HousenumberGenerator(props);
        this.driveOn = props.getProperty("drive-on", null);
        if (this.driveOn == null) {
            this.driveOn = "detect,right";
        }
        switch (this.driveOn) {
            case "left": {
                this.driveOnLeft = true;
                break;
            }
            case "right": {
                this.driveOnLeft = false;
                break;
            }
            case "detect": 
            case "detect,left": 
            case "detect,right": {
                break;
            }
            default: {
                throw new ExitException("invalid parameters for option drive-on:" + this.driveOn);
            }
        }
        this.countryAbbr = props.getProperty("country-abbr", null);
        if (this.countryAbbr != null) {
            this.countryAbbr = this.countryAbbr.toUpperCase();
        }
        if (props.getProperty("check-roundabouts", false)) {
            this.checkRoundaboutDirections = log.isLoggable(Level.WARNING);
            this.fixRoundaboutDirections = true;
        } else {
            String checkRoundaboutsOption = props.getProperty("report-roundabout-issues");
            boolean check = false;
            if (checkRoundaboutsOption != null) {
                if ("".equals(checkRoundaboutsOption)) {
                    check = true;
                }
                for (String option : checkRoundaboutsOption.split(",")) {
                    if (!"all".equals(option) && !"direction".equals(option)) continue;
                    check = true;
                }
            }
            this.checkRoundaboutDirections = check;
            this.fixRoundaboutDirections = props.getProperty("fix-roundabout-direction", false);
        }
        this.reportDeadEnds = props.getProperty("report-dead-ends") != null ? props.getProperty("report-dead-ends", 1) : 0;
        this.prefixSuffixFilter = new PrefixSuffixFilter(props);
        this.lineAdder = line -> {
            if (line instanceof MapRoad) {
                this.prefixSuffixFilter.filter((MapRoad)line);
                collector.addRoad((MapRoad)line);
            } else {
                collector.addLine(line);
            }
        };
        LineAdder overlayAdder = style.getOverlays(this.lineAdder);
        if (overlayAdder != null) {
            this.lineAdder = overlayAdder;
        }
        this.linkPOIsToWays = props.getProperty("link-pois-to-ways", false);
        this.nearbyPoiHandler = new NearbyPoiHandler(props);
        this.mergeRoads = !props.getProperty("no-mergeroads", false);
        this.allowReverseMerge = props.getProperty("allow-reverse-merge", false);
        String typesOption = "line-types-with-direction";
        String typeList = props.getProperty("line-types-with-direction", "");
        if (typeList.isEmpty()) {
            typeList = style.getOption("line-types-with-direction");
        }
        List<String> types = CommandArgs.stringToList(typeList, "line-types-with-direction");
        for (String type : types) {
            if (type.isEmpty()) continue;
            this.lineTypesWithDirection.add(Integer.decode(type));
        }
        this.routable = props.containsKey("route");
        String styleOption = props.getProperty("style-option", null);
        this.styleOptionTags = this.parseStyleOption(styleOption);
        this.admLevelNod3 = props.getProperty("add-boundary-nodes-at-admin-boundaries", 2);
        this.addBoundaryNodesAtAdminBoundaries = this.routable && this.admLevelNod3 > 0;
        this.keepBlanks = props.containsKey("keep-blanks");
        this.forceEndNodesRoutingNodes = !props.getProperty("no-force-end-nodes-routing-nodes", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tags parseStyleOption(String styleOption) {
        Tags styleTags = new Tags();
        if (styleOption != null) {
            String[] tags;
            for (String t : tags = styleOption.split(";")) {
                String val;
                String old;
                String[] pair = t.split("=");
                String optionKey = pair[0];
                String tagKey = STYLE_OPTION_PREF + optionKey;
                if (!this.style.getUsedTags().contains(tagKey)) {
                    List<String> list = unusedStyleOptions;
                    synchronized (list) {
                        if (!unusedStyleOptions.contains(optionKey)) {
                            unusedStyleOptions.add(optionKey);
                            Logger.defaultLogger.warn((Object)("Option style-options sets tag not used in style: '" + optionKey + "' (gives " + tagKey + ")"));
                        }
                    }
                }
                if ((old = styleTags.put(tagKey, val = pair.length == 1 ? "true" : pair[1])) == null) continue;
                List<String> list = duplicateKeys;
                synchronized (list) {
                    if (!duplicateKeys.contains(optionKey)) {
                        duplicateKeys.add(optionKey);
                        Logger.defaultLogger.error("duplicate tag key", optionKey, "in style option", styleOption);
                    }
                }
            }
        }
        if (this.style.getUsedTags() != null) {
            for (String s : this.style.getUsedTags()) {
                if (s == null || !s.startsWith(STYLE_OPTION_PREF) || styleTags.get(s) != null) continue;
                List<String> list = unspecifiedStyleOptions;
                synchronized (list) {
                    if (!unspecifiedStyleOptions.contains(s)) {
                        unspecifiedStyleOptions.add(s);
                        Logger.defaultLogger.warn((Object)("Option style-options doesn't specify '" + s.replaceFirst(STYLE_OPTION_PREF, "") + "' (for " + s + ")"));
                    }
                }
            }
        }
        return styleTags;
    }

    @Override
    public void convertWay(Way way) {
        Rule rules;
        if (way.getPoints().size() < 2 || way.getTagCount() == 0) {
            this.removeRestrictionsWithWay(Level.WARNING, way, "is ignored");
            return;
        }
        if (this.addBoundaryNodesAtAdminBoundaries && !FakeIdGenerator.isFakeId(way.getId()) && this.isNod3Border(way)) {
            this.borders.add(way);
        }
        this.preConvertRules(way);
        String styleFilterTag = way.getTag(TKM_STYLEFILTER);
        if ("polyline".equals(styleFilterTag)) {
            rules = this.lineRules;
        } else if ("polygon".equals(styleFilterTag)) {
            rules = this.polygonRules;
        } else {
            if (way.isClosedInOSM() && !way.isComplete() && !way.hasIdenticalEndPoints()) {
                way.getPoints().add(way.getFirstPoint());
            }
            rules = !way.hasIdenticalEndPoints() || way.getPoints().size() < 4 ? this.lineRules : this.wayRules;
        }
        Way cycleWay = null;
        String cycleWayTag = way.getTag(TKM_MAKE_CYCLE_WAY);
        if ("yes".equals(cycleWayTag)) {
            way.deleteTag(TKM_MAKE_CYCLE_WAY);
            cycleWay = StyledConverter.makeCycleWay(way);
            way.addTag("bicycle", "no");
        }
        this.wayTypeResult.setWay(way);
        this.lineCacheId = rules.resolveType(this.lineCacheId, way, this.wayTypeResult);
        if (!this.wayTypeResult.isMatched()) {
            this.housenumberGenerator.addWay(way);
            if (way.getMpRel() != null) {
                way.getMpRel().setNoRecalc(true);
            }
        }
        if (cycleWay != null) {
            this.wayTypeResult.setWay(cycleWay);
            this.lineCacheId = rules.resolveType(this.lineCacheId, cycleWay, this.wayTypeResult);
            if (!this.wayTypeResult.isMatched()) {
                this.housenumberGenerator.addWay(cycleWay);
            }
        }
        if (this.lastRoadId != way.getId()) {
            this.removeRestrictionsWithWay(Level.WARNING, way, "is not routable");
        } else {
            ConvertedWay cw;
            for (int i = this.lines.size() - 1; i >= 0 && (cw = this.lines.get(i)).getWay().getId() == way.getId(); --i) {
                cw.setOverlay(true);
                int lineType = cw.getGType().getType();
                if (!GType.isSpecialRoutableLineType(lineType) || cw.getGType().getMinLevel() != 0 || this.routingWarningWasPrinted.get(lineType)) continue;
                log.error("routable type", GType.formatType(cw.getGType().getType()), "is used with a non-routable way which was also added as a routable way. This leads to routing errors.", "Try --check-styles to check the style.");
                this.routingWarningWasPrinted.set(lineType);
            }
        }
    }

    private boolean isNod3Border(Element el) {
        String admLevelString;
        if ("administrative".equals(el.getTag("boundary")) && (admLevelString = el.getTag("admin_level")) != null) {
            try {
                int al = Integer.parseInt(admLevelString);
                return al <= this.admLevelNod3;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public void convertNode(Node node) {
        if (node.getTagCount() == 0) {
            return;
        }
        this.preConvertRules(node);
        this.nodeTypeResult.setNode(node);
        this.nodeRules.resolveType(node, this.nodeTypeResult);
        if (!this.nodeTypeResult.isMatched()) {
            this.housenumberGenerator.addNode(node);
        }
    }

    private void preConvertRules(Element el) {
        if (this.styleOptionTags != null && this.styleOptionTags.size() > 0) {
            Iterator<Map.Entry<Short, String>> iter = this.styleOptionTags.entryShortIterator();
            while (iter.hasNext()) {
                Map.Entry<Short, String> tag = iter.next();
                el.addTag(tag.getKey(), tag.getValue());
            }
        }
        this.nameFinder.setNameWithNameTagList(el);
    }

    private static Way makeCycleWay(Way way) {
        Way cycleWay = new Way(way.getId(), way.getPoints());
        cycleWay.copyTags(way);
        cycleWay.addTag("access", "no");
        cycleWay.addTag("bicycle", "yes");
        cycleWay.addTag("mkgmap:synthesised", "yes");
        cycleWay.addTag(TK_ONEWAY, "no");
        cycleWay.deleteTag("foot");
        cycleWay.deleteTag("motorcar");
        cycleWay.deleteTag("goods");
        cycleWay.deleteTag("hgv");
        cycleWay.deleteTag("bus");
        cycleWay.deleteTag("taxi");
        cycleWay.deleteTag("emergency");
        cycleWay.deleteTag("vehicle");
        cycleWay.deleteTag("motor_vehicle");
        cycleWay.deleteTag("carpool");
        cycleWay.deleteTag("motorcycle");
        cycleWay.deleteTag("psv");
        cycleWay.deleteTag("truck");
        return cycleWay;
    }

    @Override
    public void augmentWith(ElementSaver elementSaver) {
        this.nodeRules.augmentWith(elementSaver);
        this.lineRules.augmentWith(elementSaver);
        this.polygonRules.augmentWith(elementSaver);
    }

    private static void postConvertRules(Element el, GType type) {
        if (type.getDefaultName() != null && el.getName() == null) {
            el.addTag("mkgmap:label:1", type.getDefaultName());
        }
    }

    @Override
    public void setBoundingBox(Area bbox) {
        this.clipper = new AreaClipper(bbox);
        this.bbox = bbox;
        this.collector.addToBounds(new Coord(bbox.getMinLat(), bbox.getMinLong()));
        this.collector.addToBounds(new Coord(bbox.getMaxLat(), bbox.getMaxLong()));
    }

    private void removeRestrictionsWithWay(Level logLevel, Way way, String reason) {
        Object rrList = this.wayRelMap.get(way.getId());
        Iterator iterator = rrList.iterator();
        while (iterator.hasNext()) {
            RestrictionRelation rr = (RestrictionRelation)iterator.next();
            if (rr.isValidWithoutWay(way.getId())) continue;
            if (log.isLoggable(logLevel)) {
                log.log(logLevel, "restriction", rr.toBrowseURL(), "is ignored because referenced way", way.toBrowseURL(), reason);
            }
            rr.setInvalid();
            this.restrictions.remove(rr);
        }
    }

    private void checkRoutingNodesAtAdminBoundaries() {
        if (!this.addBoundaryNodesAtAdminBoundaries || this.borders.isEmpty()) {
            return;
        }
        long t1 = System.currentTimeMillis();
        ArrayList<Element> clippedBorders = new ArrayList<Element>();
        for (Way b : this.borders) {
            List<List<Coord>> clipped = LineClipper.clip(this.bbox, b.getPoints());
            if (clipped == null) {
                StyledConverter.splitBoundary(clippedBorders, b, b.getPoints());
                continue;
            }
            for (List<Coord> list : clipped) {
                StyledConverter.splitBoundary(clippedBorders, b, list);
            }
        }
        ElementQuadTree qt = new ElementQuadTree(this.bbox, clippedBorders);
        long countChg = 0L;
        Long2ObjectOpenHashMap<Coord> commonCoordMap = new Long2ObjectOpenHashMap<Coord>();
        for (ConvertedWay r : this.roads) {
            Way way;
            Area searchRect;
            Set<Element> boundaries;
            if (!r.isValid() || (boundaries = qt.get(searchRect = Area.getBBox((way = r.getWay()).getPoints()))).isEmpty()) continue;
            Coord pw1 = way.getFirstPoint();
            int pos = 1;
            while (pos < way.getPoints().size()) {
                boolean changed = false;
                Coord pw2 = way.getPoints().get(pos);
                for (Element el : boundaries) {
                    List<Coord> b = ((Way)el).getPoints();
                    for (int i = 0; i < b.size() - 1; ++i) {
                        double dist2;
                        Coord pb2;
                        Coord pb1 = b.get(i);
                        Coord is = Utils.getSegmentSegmentIntersection(pw1, pw2, pb1, pb2 = b.get(i + 1));
                        if (is == null) continue;
                        double dist1 = is.distance(pw1);
                        if (dist1 < (dist2 = is.distance(pw2)) && dist1 < 1.0) {
                            if (!pw1.getOnCountryBorder()) {
                                ++countChg;
                                if (!pw1.getOnBoundary()) {
                                    log.info("road intersects admin boundary, changing existing node to external routing node at", pw1);
                                }
                            }
                            pw1.setOnCountryBorder(true);
                            continue;
                        }
                        if (dist2 < dist1 && dist2 < 1.0) {
                            if (!pw2.getOnCountryBorder()) {
                                ++countChg;
                                if (!pw2.getOnBoundary()) {
                                    log.info("road intersects admin boundary, changing existing node to external routing node at", pw2);
                                }
                            }
                            pw2.setOnCountryBorder(true);
                            continue;
                        }
                        long key = Utils.coord2Long(is);
                        Coord replacement = (Coord)commonCoordMap.get(key);
                        if (replacement == null) {
                            commonCoordMap.put(key, is);
                        } else {
                            assert (is.highPrecEquals(replacement));
                            is = replacement;
                        }
                        is.setOnCountryBorder(true);
                        log.info("road intersects admin boundary, adding external routing node at", is);
                        way.getPoints().add(pos, is);
                        changed = true;
                        pw2 = is;
                    }
                }
                if (changed) continue;
                ++pos;
                pw1 = pw2;
            }
        }
        long l = System.currentTimeMillis() - t1;
        log.info("added", commonCoordMap.size(), "new nodes at country borders");
        log.info("marked", countChg, "existing nodes at country borders");
        log.info((Object)("adding country border routing nodes took " + l + " ms"));
    }

    private static void splitBoundary(List<Element> clippedBorders, Way orig, List<Coord> points) {
        int pos = 0;
        int max = 20;
        while (pos < points.size()) {
            int right = Math.min(points.size(), pos + 20);
            Way w = new Way(orig.getId(), points.subList(pos, right));
            w.markAsGeneratedFrom(orig);
            clippedBorders.add(w);
            if ((pos += 19) + 1 != points.size()) continue;
            --pos;
        }
    }

    private void mergeRoads() {
        if (this.mergeRoads) {
            this.roads = new RoadMerger(this.allowReverseMerge).merge(this.roads, this.restrictions);
        } else {
            log.info((Object)"Merging roads is disabled");
        }
    }

    @Override
    public void end() {
        this.style.reportStats();
        this.driveOnLeft = this.calcDrivingSide();
        this.checkRoutingNodesAtAdminBoundaries();
        this.borders.clear();
        this.setHighwayCounts();
        HashMap<Long, ConvertedWay> modifiedRoads = new HashMap<Long, ConvertedWay>();
        this.findUnconnectedRoads();
        this.rotateClosedWaysToFirstNode(modifiedRoads);
        this.filterCoordPOI();
        HashSet<Long> deletedRoads = new HashSet<Long>();
        WrongAngleFixer wrongAngleFixer = new WrongAngleFixer(this.bbox);
        Set<MapPoint> allPOI = this.nearbyPoiHandler.getAllPOI();
        wrongAngleFixer.optimizeWays(this.roads, this.lines, modifiedRoads, deletedRoads, this.restrictions, allPOI);
        this.nearbyPoiHandler.deDuplicate().forEach(this.collector::addPoint);
        this.nearbyPoiHandler = null;
        for (ConvertedWay line : this.lines) {
            ConvertedWay modWay;
            if (!line.isValid()) continue;
            Way way = line.getWay();
            if (deletedRoads.contains(way.getId())) {
                line.getPoints().clear();
                continue;
            }
            if (!line.isOverlay() || (modWay = modifiedRoads.get(way.getId())) == null) continue;
            List<Coord> points = line.getPoints();
            points.clear();
            points.addAll(modWay.getPoints());
            if (modWay.isReversed() == line.isReversed()) continue;
            Collections.reverse(points);
        }
        for (Long wayId : deletedRoads) {
            if (!this.wayRelMap.containsKey(wayId)) continue;
            log.warn("Way that is used in valid restriction relation was removed, id:", wayId);
        }
        deletedRoads.clear();
        modifiedRoads.clear();
        this.mergeRoads();
        this.resetHighwayCounts();
        this.setHighwayCounts();
        for (ConvertedWay cw : this.lines) {
            if (!cw.isValid()) continue;
            this.addLine(cw);
        }
        this.lines = null;
        if (roadLog.isInfoEnabled()) {
            roadLog.info((Object)"Flags: oneway,no-emergency, no-delivery, no-throughroute, no-truck, no-bike, no-foot, carpool, no-taxi, no-bus, no-car");
            roadLog.info((Object)String.format("%19s %4s %11s %6s %6s %6s %s", "Road-OSM-Id", "Type", "Flags", "Class", "Speed", "Points", "Labels"));
        }
        for (ConvertedWay cw : this.roads) {
            if (!cw.isValid()) continue;
            this.addRoad(cw);
        }
        this.housenumberGenerator.generate(this.lineAdder);
        this.housenumberGenerator = null;
        if (this.routable) {
            this.poiRestrictions.entrySet().forEach(e -> this.createRouteRestrictionsFromPOI((Node)e.getKey(), (List)e.getValue()));
        }
        this.poiRestrictions = null;
        this.replacedCoordPoi = null;
        if (this.routable) {
            for (RestrictionRelation rr : this.restrictions) {
                rr.addRestriction(this.collector, this.nodeIdMap);
            }
        }
        this.roads = null;
        this.nodeIdMap = null;
        this.restrictions.clear();
    }

    private Boolean calcDrivingSide() {
        Boolean dol = null;
        log.info("Found", this.numRoads, "roads", this.numDriveOnLeftRoads, "in drive-on-left country,", this.numDriveOnRightRoads, "in drive-on-right country, and", this.numDriveOnSideUnknown, "with unknown country");
        if (this.numDriveOnLeftRoads > 0 && this.numDriveOnRightRoads > 0) {
            log.error((Object)("Attention: Tile contains both drive-on-left (" + this.numDriveOnLeftRoads + ") and drive-on-right roads (" + this.numDriveOnRightRoads + ")"));
        }
        if (this.driveOn.startsWith("detect")) {
            if ((double)this.numDriveOnSideUnknown > (double)this.numRoads * 0.05) {
                log.warn("Found", this.numDriveOnSideUnknown, "roads with unknown country and driving side");
            }
            dol = this.numDriveOnLeftRoads > this.numDriveOnRightRoads + this.numDriveOnSideUnknown ? Boolean.valueOf(true) : (this.numDriveOnRightRoads > this.numDriveOnLeftRoads + this.numDriveOnSideUnknown ? Boolean.valueOf(false) : (this.driveOn.endsWith("left") ? Boolean.valueOf(true) : Boolean.valueOf(false)));
            log.info("detected value for driving on left flag is:", dol);
        } else {
            dol = "left".equals(this.driveOn);
            if ("left".equals(this.driveOn) && this.numDriveOnLeftRoads == 0 && this.numDriveOnRightRoads > 0) {
                log.warn((Object)"The drive-on-left flag is set but tile contains only drive-on-right roads");
            }
            if ("right".equals(this.driveOn) && this.numDriveOnRightRoads == 0 && this.numDriveOnLeftRoads > 0) {
                log.warn((Object)"The drive-on-left flag is NOT set but tile contains only drive-on-left roads");
            }
        }
        assert (dol != null);
        return dol;
    }

    private void rotateClosedWaysToFirstNode(HashMap<Long, ConvertedWay> modifiedRoads) {
        block0: for (ConvertedWay cw : this.roads) {
            Coord p0;
            Way way;
            List<Coord> points;
            if (!cw.isValid() || (points = (way = cw.getWay()).getPoints()).size() < 3 || points.get(0) != points.get(points.size() - 1) || (p0 = points.get(0)).getHighwayCount() > 2) continue;
            for (int i = 1; i < points.size() - 1; ++i) {
                Coord p = points.get(i);
                if (p.getHighwayCount() <= 1) continue;
                p.incHighwayCount();
                points.remove(points.size() - 1);
                p0.decHighwayCount();
                Collections.rotate(points, -i);
                points.add(points.get(0));
                modifiedRoads.put(way.getId(), cw);
                continue block0;
            }
        }
    }

    private void checkRoundabout(ConvertedWay cw) {
        if (!cw.isRoundabout()) {
            return;
        }
        Way way = cw.getWay();
        List<Coord> points = way.getPoints();
        if ((this.checkRoundaboutDirections || this.fixRoundaboutDirections) && points.size() > 2 && !way.tagIsLikeYes("mkgmap:no-dir-check") && !way.tagIsLikeNo("mkgmap:dir-check")) {
            Coord centre = way.getCofG();
            int dir = 0;
            int i = 0;
            while (i + 1 < points.size()) {
                Coord pi = points.get(i);
                Coord pi1 = points.get(i + 1);
                if (pi.distance(centre) > 2.5 && pi.distance(pi1) > 2.5) {
                    double b;
                    double a = pi.bearingTo(pi1);
                    for (b = pi.bearingTo(centre) - a; b > 180.0; b -= 360.0) {
                    }
                    while (b < -180.0) {
                        b += 360.0;
                    }
                    if (b >= 15.0 && b < 165.0) {
                        ++dir;
                    } else if (b <= -15.0 && b > -165.0) {
                        --dir;
                    }
                }
                i += 3;
            }
            if (dir == 0) {
                log.info((Object)("Roundabout segment " + way.getId() + " direction unknown (see " + points.get(0).toOSMURL() + ")"));
            } else {
                boolean dirIsWrong;
                boolean clockwise = dir > 0;
                boolean bl = dirIsWrong = Boolean.TRUE.equals(this.driveOnLeft) && !clockwise || Boolean.FALSE.equals(this.driveOnLeft) && clockwise;
                if (points.get(0) == points.get(points.size() - 1)) {
                    if (dirIsWrong) {
                        if (this.checkRoundaboutDirections) {
                            log.diagnostic("Roundabout " + way.getId() + " direction is wrong " + (this.fixRoundaboutDirections ? "- reversing it " : "") + "(see " + centre.toOSMURL() + ")");
                        }
                        if (this.fixRoundaboutDirections) {
                            way.reverse();
                        }
                    }
                } else if (dirIsWrong && this.checkRoundaboutDirections) {
                    log.diagnostic("Roundabout segment " + way.getId() + " direction looks wrong (see " + points.get(0).toOSMURL() + ")");
                }
            }
        }
    }

    private void createRouteRestrictionsFromPOI(Node node, List<Way> wayList) {
        Coord p = node.getLocation();
        byte exceptMask = AccessTagsAndBits.evalAccessTags(node);
        LinkedHashMap<Integer, CoordNode> otherNodeIds = new LinkedHashMap<Integer, CoordNode>();
        CoordNode viaNode = null;
        CoordNode neededNode = this.nodeIdMap.get(p);
        if (neededNode == null) {
            neededNode = this.replacedCoordPoi.get(node);
        }
        if (neededNode == null) {
            log.error("link-pois-to-ways: Internal error: Did not find CoordPOI node at", p.toOSMURL(), "in ways", wayList);
            return;
        }
        for (Way way : wayList) {
            CoordNode lastNode = null;
            for (Coord co : way.getPoints()) {
                if (!(co instanceof CoordNode)) continue;
                CoordNode cn = (CoordNode)co;
                if (co == neededNode) {
                    viaNode = cn;
                    if (lastNode != null) {
                        otherNodeIds.put(lastNode.getId(), lastNode);
                    }
                } else if (lastNode == neededNode) {
                    otherNodeIds.put(cn.getId(), cn);
                }
                lastNode = cn;
            }
        }
        if (otherNodeIds.size() < 2) {
            log.info("link-pois-to-ways: Access restriction in POI node", node.toBrowseURL(), "was ignored, has no effect on any connected way");
            return;
        }
        GeneralRouteRestriction rr = new GeneralRouteRestriction("no_through", exceptMask, "link-pois-to-ways: CoordPOI at " + p.toOSMURL());
        rr.setViaNodes(Arrays.asList(viaNode));
        int added = this.collector.addRestriction(rr);
        log.info("link-pois-to-ways: Access restriction in POI node", node.toBrowseURL(), added == 0 ? " was ignored, has no effect on any connected way" : "was translated to " + added + " route restriction(s)");
        if (wayList.size() > 1 && added > 2) {
            log.warn("link-pois-to-ways: Access restriction in POI node", node.toBrowseURL(), "affects routing on multiple ways");
        }
    }

    @Override
    public void convertRelation(Relation relation) {
        block5: {
            block4: {
                if (relation.getTagCount() == 0) {
                    return;
                }
                this.housenumberGenerator.addRelation(relation);
                if (!(relation instanceof RestrictionRelation)) break block4;
                RestrictionRelation rr = (RestrictionRelation)relation;
                if (!rr.isValid()) break block5;
                this.restrictions.add(rr);
                for (long id : rr.getWayIds()) {
                    this.wayRelMap.add(id, rr);
                }
                break block5;
            }
            if (this.addBoundaryNodesAtAdminBoundaries && (relation instanceof MultiPolygonRelation || "boundary".equals(relation.getTag("type"))) && this.isNod3Border(relation)) {
                for (Map.Entry<String, Element> e : relation.getElements()) {
                    if (FakeIdGenerator.isFakeId(e.getValue().getId()) || !(e.getValue() instanceof Way)) continue;
                    this.borders.add((Way)e.getValue());
                }
            }
        }
    }

    private void addLine(ConvertedWay cw) {
        this.addLine(cw, -1);
    }

    private void addLine(ConvertedWay cw, int replType) {
        List<Coord> wayPoints = cw.getPoints();
        ArrayList<Coord> points = new ArrayList<Coord>(wayPoints.size());
        double lineLength = 0.0;
        Coord lastP = null;
        for (Coord p : wayPoints) {
            if (p.highPrecEquals(lastP)) continue;
            points.add(p);
            if (lastP != null && (lineLength += p.distance(lastP)) >= 40000.0) {
                if (log.isInfoEnabled()) {
                    log.info("Splitting line", cw.getWay().toBrowseURL(), "at", p.toOSMURL(), "to limit its length to", (long)lineLength + "m");
                }
                this.addLine(cw, replType, points);
                points = new ArrayList(wayPoints.size() - points.size() + 1);
                points.add(p);
                lineLength = 0.0;
            }
            lastP = p;
        }
        if (points.size() > 1) {
            this.addLine(cw, replType, points);
        }
    }

    private void addLine(ConvertedWay cw, int replType, List<Coord> points) {
        MapLine line = new MapLine();
        this.elementSetup(line, cw.getGType(), cw.getWay());
        if (replType >= 0) {
            line.setType(replType);
        }
        line.setPoints(points);
        line.setDirection(cw.hasDirection());
        this.clipper.clipLine(line, this.lineAdder);
    }

    private void elementSetup(MapElement ms, GType gt, Element element) {
        String[] labels = new String[4];
        int numLabels = 0;
        for (int labelNo = 0; labelNo < 4; ++labelNo) {
            String label;
            String label1 = element.getTag(labelTagKeys[labelNo]);
            String string = label = this.keepBlanks ? label1 : Label.squashSpaces(label1);
            if (label == null) continue;
            labels[numLabels] = label;
            ++numLabels;
        }
        if (labels[0] != null) {
            ms.setLabels(labels);
        }
        ms.setType(gt.getType());
        ms.setMinResolution(gt.getMinResolution());
        ms.setMaxResolution(gt.getMaxResolution());
        if (element.tagIsLikeYes(TKM_HIGHEST_RES_ONLY)) {
            ms.setMinResolution(ms.getMaxResolution());
        }
        if (ms instanceof MapLine && element.tagIsLikeYes(TKM_SKIP_SIZE_FILTER)) {
            ((MapLine)ms).setSkipSizeFilter(true);
        }
        String country = element.getTag(TKM_COUNTRY);
        String region = element.getTag(TKM_REGION);
        String city = element.getTag(TKM_CITY);
        String zip = element.getTag(TKM_POSTAL_CODE);
        String street = element.getTag(TKM_STREET);
        String houseNumber = element.getTag(TKM_HOUSENUMBER);
        String phone = element.getTag(TKM_PHONE);
        String isIn = element.getTag(TKM_IS_IN);
        if (country != null) {
            ms.setCountry(country);
        }
        if (region != null) {
            ms.setRegion(region);
        }
        if (city != null) {
            ms.setCity(city);
        }
        if (zip != null) {
            ms.setZip(zip);
        }
        if (street == null) {
            street = element.getTag("addr:place");
        }
        if (street != null) {
            ms.setStreet(street);
        }
        if (houseNumber != null) {
            ms.setHouseNumber(houseNumber);
        }
        if (isIn != null) {
            ms.setIsIn(isIn);
        }
        if (phone != null) {
            ms.setPhone(phone);
        }
        if (MapObject.hasExtendedType(gt.getType())) {
            Map<String, String> xta = element.getTagsWithPrefix("mkgmap:xt-", true);
            xta.putAll(element.getTagsWithPrefix("seamark:", false));
            ms.setExtTypeAttributes(new ExtTypeAttributes(xta, "OSM id " + element.getId()));
        }
    }

    private void addRoad(ConvertedWay cw) {
        List<List<Coord>> lineSegs;
        Way way = cw.getWay();
        if (way.getPoints().size() < 2) {
            log.warn("road has < 2 points", way.getId(), "(discarding)");
            return;
        }
        this.checkRoundabout(cw);
        double stubSegmentLength = 25.0;
        String wayPOI = way.getTag(WAY_POI_NODE_IDS);
        if (wayPOI != null) {
            List<Coord> points = way.getPoints();
            for (int i = 0; i < points.size(); ++i) {
                int splitPos;
                Node node;
                Coord p = points.get(i);
                if (p instanceof CoordPOI && ((CoordPOI)p).isUsed()) {
                    CoordPOI coordPOI = (CoordPOI)p;
                    node = coordPOI.getNode();
                    if (wayPOI.contains("[" + node.getId() + "]")) {
                        log.debug("POI", node.getId(), "changes way", way.getId());
                        if (p.getHighwayCount() < 2 && coordPOI.getConvertToViaInRouteRestriction() && i != 0 && i != points.size() - 1) {
                            p.incHighwayCount();
                        }
                        String roadClass = node.getTag("mkgmap:road-class");
                        String roadSpeed = node.getTag("mkgmap:road-speed");
                        if (roadClass != null || roadSpeed != null) {
                            boolean speedChanged;
                            boolean classChanged;
                            if (!way.isViaWay()) {
                                Coord splitPoint;
                                double segmentLength = 0.0;
                                int splitPos2 = i + 1;
                                while (splitPos2 + 1 < points.size()) {
                                    splitPoint = points.get(splitPos2);
                                    if (splitPoint.getHighwayCount() > 1 || (segmentLength += splitPoint.distance(points.get(splitPos2 - 1))) > 20.0) break;
                                    ++splitPos2;
                                }
                                if (segmentLength > 35.0) {
                                    splitPoint = points.get(splitPos2);
                                    Coord prev = points.get(splitPos2 - 1);
                                    double dist = splitPoint.distance(prev);
                                    double neededLength = 25.0 - (segmentLength - dist);
                                    splitPoint = prev.makeBetweenPoint(splitPoint, neededLength / dist);
                                    double newDist = splitPoint.distance(prev);
                                    segmentLength += newDist - dist;
                                    points.add(splitPos2, splitPoint);
                                    splitPoint.incHighwayCount();
                                }
                                if (splitPos2 + 1 < points.size() && StyledConverter.safeToSplitWay(points, splitPos2, i, points.size() - 1)) {
                                    Way tail = this.splitWayAt(way, splitPos2);
                                    this.addRoad(new ConvertedWay(cw, tail));
                                }
                            }
                            if ((classChanged = cw.recalcRoadClass(node)) && log.isInfoEnabled()) {
                                log.info("link-pois-to-ways: POI is changing road class of", way.toBrowseURL(), "to", cw.getRoadClass(), "at", points.get(0).toOSMURL());
                            }
                            if ((speedChanged = cw.recalcRoadSpeed(node)) && log.isInfoEnabled()) {
                                log.info("link-pois-to-ways: POI is changing road speed of", way.toBrowseURL(), "to", cw.getRoadSpeed(), "at", points.get(0).toOSMURL());
                            }
                        }
                    }
                }
                if (way.isViaWay() || i + 1 >= points.size() || !(points.get(i + 1) instanceof CoordPOI)) continue;
                CoordPOI coordPOI = (CoordPOI)points.get(i + 1);
                node = coordPOI.getNode();
                if (!coordPOI.isUsed() || !wayPOI.contains("[" + node.getId() + "]") || node.getTag("mkgmap:road-class") == null && node.getTag("mkgmap:road-speed") == null) continue;
                double segmentLength = 0.0;
                for (splitPos = i; splitPos >= 0; --splitPos) {
                    Coord splitPoint = points.get(splitPos);
                    if (splitPoint.getHighwayCount() >= 2 || (segmentLength += splitPoint.distance(points.get(splitPos + 1))) > 20.0) break;
                }
                if (segmentLength > 35.0) {
                    Coord splitPoint = points.get(splitPos);
                    Coord prev = points.get(splitPos + 1);
                    double dist = splitPoint.distance(prev);
                    double neededLength = 25.0 - (segmentLength - dist);
                    splitPoint = prev.makeBetweenPoint(splitPoint, neededLength / dist);
                    segmentLength += splitPoint.distance(prev) - dist;
                    points.add(++splitPos, splitPoint);
                    splitPoint.incHighwayCount();
                }
                if (splitPos <= 0 || !StyledConverter.safeToSplitWay(points, splitPos, 0, points.size() - 1)) continue;
                Way tail = this.splitWayAt(way, splitPos);
                this.addRoad(new ConvertedWay(cw, tail));
            }
        }
        ArrayList<Way> clippedWays = null;
        if (this.bbox != null && (lineSegs = LineClipper.clip(this.bbox, way.getPoints())) != null) {
            if (lineSegs.isEmpty()) {
                this.removeRestrictionsWithWay(Level.WARNING, way, "ends on tile boundary, restriction is ignored");
            }
            clippedWays = new ArrayList<Way>();
            for (List list : lineSegs) {
                Way nWay = new Way(way.getId());
                nWay.copyTags(way);
                for (Coord co : list) {
                    nWay.addPoint(co);
                    if (!co.getOnBoundary() && !co.getOnCountryBorder()) continue;
                    co.incHighwayCount();
                }
                clippedWays.add(nWay);
            }
        }
        if (clippedWays != null) {
            for (Way clippedWay : clippedWays) {
                this.addRoadAfterSplittingLoops(new ConvertedWay(cw, clippedWay));
            }
        } else {
            this.addRoadAfterSplittingLoops(cw);
        }
    }

    private void addRoadAfterSplittingLoops(ConvertedWay cw) {
        Way way = cw.getWay();
        if (this.routable && (this.forceEndNodesRoutingNodes || this.wayRelMap.containsKey(way.getId()))) {
            way.getPoints().get(0).incHighwayCount();
            way.getPoints().get(way.getPoints().size() - 1).incHighwayCount();
        }
        boolean wayWasSplit = true;
        while (wayWasSplit) {
            List<Coord> wayPoints = way.getPoints();
            int numPointsInWay = wayPoints.size();
            wayWasSplit = false;
            for (int p1I = 0; !wayWasSplit && p1I < numPointsInWay - 1; ++p1I) {
                Coord p1 = wayPoints.get(p1I);
                if (p1.getHighwayCount() < 2) continue;
                int niceSplitPos = -1;
                for (int p2I = p1I + 1; !wayWasSplit && p2I < numPointsInWay; ++p2I) {
                    int splitI;
                    Coord p2 = wayPoints.get(p2I);
                    if (p1 != p2) {
                        if (p2.getHighwayCount() <= 1) continue;
                        niceSplitPos = p2I;
                        continue;
                    }
                    if (niceSplitPos >= 0 && StyledConverter.safeToSplitWay(wayPoints, niceSplitPos, p1I, p2I)) {
                        splitI = niceSplitPos;
                    } else {
                        for (splitI = p2I - 1; splitI > p1I && !StyledConverter.safeToSplitWay(wayPoints, splitI, p1I, p2I); --splitI) {
                            if (!log.isInfoEnabled()) continue;
                            log.info("Looped way", way.getDebugName(), "can't safely split at point[" + splitI + "], trying the preceeding point");
                        }
                    }
                    if (splitI == p1I) {
                        log.info("Splitting looped way", way.getDebugName(), "would make a zero length arc, so it will have to be pruned at", wayPoints.get(p2I).toOSMURL());
                        do {
                            log.info((Object)("  Pruning point[" + p2I + "]"));
                            wayPoints.remove(p2I);
                            if (--p2I + 1 != --numPointsInWay) continue;
                            wayPoints.get(p2I).incHighwayCount();
                        } while (p2I > p1I && p2I + 1 == numPointsInWay && p1.equals(wayPoints.get(p2I)));
                        continue;
                    }
                    if (log.isInfoEnabled()) {
                        log.info("Splitting looped way", way.getDebugName(), "at", wayPoints.get(splitI).toOSMURL(), "- it has", numPointsInWay - splitI - 1, "following segment(s).");
                    }
                    Way loopTail = this.splitWayAt(way, splitI);
                    ConvertedWay next = new ConvertedWay(cw, loopTail);
                    this.addRoadAfterSplittingLoops(cw);
                    cw = next;
                    way = loopTail;
                    wayWasSplit = true;
                }
            }
            if (wayWasSplit) continue;
            this.addRoadWithoutLoops(cw);
        }
    }

    private static boolean safeToSplitWay(List<Coord> points, int pos, int floor, int ceiling) {
        Coord p;
        int i;
        Coord candidate = points.get(pos);
        if (floor < 0) {
            floor = 0;
        }
        if (ceiling >= points.size()) {
            ceiling = points.size() - 1;
        }
        for (i = pos + 1; i <= ceiling; ++i) {
            p = points.get(i);
            if (i != ceiling && p.getHighwayCount() <= 1) continue;
            if (!candidate.equals(p)) break;
            return false;
        }
        for (i = pos - 1; i >= floor; --i) {
            p = points.get(i);
            if (i != floor && p.getHighwayCount() <= 1) continue;
            if (!candidate.equals(p)) break;
            return false;
        }
        return true;
    }

    private void addRoadWithoutLoops(ConvertedWay cw) {
        Way way = cw.getWay();
        ArrayList<Integer> nodeIndices = new ArrayList<Integer>();
        List<Coord> points = way.getPoints();
        if (points.size() < 2) {
            log.warn("road has < 2 points", way.getId(), "(discarding)");
            return;
        }
        Way trailingWay = null;
        String debugWayName = way.getDebugName();
        double arcLength = 0.0;
        class WayBBox {
            int minLat = Integer.MAX_VALUE;
            int maxLat = Integer.MIN_VALUE;
            int minLon = Integer.MAX_VALUE;
            int maxLon = Integer.MIN_VALUE;

            WayBBox() {
            }

            void addPoint(Coord co) {
                int lon;
                int lat = co.getLatitude();
                if (lat < this.minLat) {
                    this.minLat = lat;
                }
                if (lat > this.maxLat) {
                    this.maxLat = lat;
                }
                if ((lon = co.getLongitude()) < this.minLon) {
                    this.minLon = lon;
                }
                if (lon > this.maxLon) {
                    this.maxLon = lon;
                }
            }

            boolean tooBig() {
                return LineSizeSplitterFilter.testDims(this.maxLat - this.minLat, this.maxLon - this.minLon) >= 1.0;
            }
        }
        WayBBox wayBBox = new WayBBox();
        for (int i = 0; i < points.size(); ++i) {
            byte nodeAccess;
            String wayPOI;
            CoordPOI cp;
            Coord p = points.get(i);
            wayBBox.addPoint(p);
            if (i + 1 < points.size()) {
                Coord nextP = points.get(i + 1);
                double d = p.distance(nextP);
                while (true) {
                    int dlat = Math.abs(nextP.getLatitude() - p.getLatitude());
                    int dlon = Math.abs(nextP.getLongitude() - p.getLongitude());
                    if (!(d > 2.045E7) && Math.max(dlat, dlon) < Short.MAX_VALUE) break;
                    double frac = Math.min(0.5, 0.95 * (2.045E7 / d));
                    nextP = p.makeBetweenPoint(nextP, frac);
                    nextP.incHighwayCount();
                    points.add(i + 1, nextP);
                    double newD = p.distance(nextP);
                    if (log.isInfoEnabled()) {
                        log.info("Way", debugWayName, "contains a segment that is", (int)d + "m long but I am adding a new point to reduce its length to", (int)newD + "m");
                    }
                    d = newD;
                }
                wayBBox.addPoint(nextP);
                if (i >= 31250) {
                    trailingWay = this.splitWayAt(way, i);
                    if (log.isInfoEnabled()) {
                        log.info("Splitting way", debugWayName, "at", points.get(i).toOSMURL(), "to limit the total number of points");
                    }
                } else if (arcLength + d > 2.045E7) {
                    if (i <= 0) {
                        log.error("internal error: long arc segment was not split", debugWayName);
                    }
                    assert (i > 0) : "long arc segment was not split";
                    assert (trailingWay == null) : "trailingWay not null #1";
                    trailingWay = this.splitWayAt(way, i);
                    if (log.isInfoEnabled()) {
                        log.info("Splitting way", debugWayName, "at", points.get(i).toOSMURL(), "to limit arc length to", (long)arcLength + "m");
                    }
                } else if (wayBBox.tooBig()) {
                    if (i <= 0) {
                        log.error("internal error: arc segment with big bbox not split", debugWayName);
                    }
                    assert (i > 0) : "arc segment with big bbox not split";
                    assert (trailingWay == null) : "trailingWay not null #2";
                    trailingWay = this.splitWayAt(way, i);
                    if (log.isInfoEnabled()) {
                        log.info("Splitting way", debugWayName, "at", points.get(i).toOSMURL(), "to limit the size of its bounding box");
                    }
                } else {
                    if (p.getHighwayCount() > 1) {
                        arcLength = 0.0;
                    }
                    arcLength += d;
                }
            }
            if (p.getHighwayCount() <= 1 && (!this.routable || !p.getOnCountryBorder())) continue;
            if (p instanceof CoordPOI && (cp = (CoordPOI)p).getConvertToViaInRouteRestriction() && (wayPOI = way.getTag(WAY_POI_NODE_IDS)) != null && wayPOI.contains("[" + cp.getNode().getId() + "]") && (nodeAccess = AccessTagsAndBits.evalAccessTags(cp.getNode())) != cw.getAccess()) {
                this.poiRestrictions.computeIfAbsent(cp.getNode(), k -> new ArrayList()).add(way);
            }
            assert (!nodeIndices.contains(i)) : debugWayName + " has multiple nodes for point " + i + " new node is " + p.toOSMURL();
            nodeIndices.add(i);
            if (i + 1 >= points.size() || nodeIndices.size() != 64) continue;
            assert (trailingWay == null) : "trailingWay not null #7";
            trailingWay = this.splitWayAt(way, i);
            if (!log.isInfoEnabled()) continue;
            log.info("Splitting way", debugWayName, "at", points.get(i).toOSMURL(), "as it has at least", 64, "nodes");
        }
        MapLine line = new MapLine();
        this.elementSetup(line, cw.getGType(), way);
        line.setPoints(points);
        MapRoad road = new MapRoad(this.nextRoadId++, way.getId(), line);
        if (!this.routable) {
            road.skipAddToNOD(true);
        }
        boolean doFlareCheck = true;
        if (cw.isRoundabout()) {
            road.setRoundabout(true);
            doFlareCheck = false;
        }
        if (way.tagIsLikeYes("mkgmap:synthesised")) {
            road.setSynthesised(true);
            doFlareCheck = false;
        }
        if (way.tagIsLikeNo("mkgmap:flare-check")) {
            doFlareCheck = false;
        } else if (way.tagIsLikeYes("mkgmap:flare-check")) {
            doFlareCheck = true;
        }
        road.doFlareCheck(doFlareCheck);
        road.setRoadClass(cw.getRoadClass());
        road.setSpeed(cw.getRoadSpeed());
        if (cw.isOneway()) {
            road.setOneway();
        }
        road.setDirection(cw.hasDirection());
        road.setAccess(cw.getAccess());
        if (cw.isCarpool()) {
            road.setCarpoolLane();
        }
        if (!cw.isThroughroute()) {
            road.setNoThroughRouting();
        }
        if (cw.isToll()) {
            road.setToll();
        }
        if (cw.isUnpaved()) {
            road.paved(false);
        }
        if (cw.isFerry()) {
            road.ferry(true);
        }
        if (this.routable && nodeIndices.isEmpty()) {
            nodeIndices.add(0);
        }
        int numNodes = nodeIndices.size();
        if (way.isViaWay() && numNodes > 2) {
            Object rrList = this.wayRelMap.get(way.getId());
            Iterator dlat = rrList.iterator();
            while (dlat.hasNext()) {
                RestrictionRelation rr = (RestrictionRelation)dlat.next();
                rr.updateViaWay(way, nodeIndices);
            }
        }
        if (numNodes > 0) {
            for (int i = 0; i < numNodes; ++i) {
                int n = (Integer)nodeIndices.get(i);
                Coord p = points.get(n);
                CoordNode coordNode = this.nodeIdMap.get(p);
                if (coordNode == null) {
                    int uniqueId = this.nodeIdMap.size() + 1;
                    coordNode = new CoordNode(p, uniqueId, p.getOnBoundary(), p.getOnCountryBorder());
                    this.nodeIdMap.put(p, coordNode);
                }
                if ((p.getOnBoundary() || p.getOnCountryBorder()) && log.isInfoEnabled()) {
                    log.info("Way", debugWayName + "'s point #" + n, "at", p.toOSMURL(), "is a boundary node");
                }
                if (p instanceof CoordPOI && ((CoordPOI)p).getNode().getLocation() != p) {
                    this.replacedCoordPoi.put(((CoordPOI)p).getNode(), coordNode);
                }
                points.set(n, coordNode);
            }
        }
        if (roadLog.isInfoEnabled()) {
            int cmpAccess = (road.getRoadDef().getTabAAccess() & 0xFF) + ((road.getRoadDef().getTabAAccess() & 0xC000) >> 6);
            if (road.isDirection()) {
                cmpAccess |= 0x400;
            }
            String access = String.format("%11s", Integer.toBinaryString(cmpAccess)).replace(' ', '0');
            roadLog.info((Object)String.format("%19d 0x%-2x %11s %6d %6d %6d %s", way.getId(), road.getType(), access, road.getRoadDef().getRoadClass(), road.getRoadDef().getRoadSpeed(), road.getPoints().size(), Arrays.toString(road.getLabels())));
        }
        this.housenumberGenerator.addRoad(way, road);
        if (trailingWay != null) {
            this.addRoadWithoutLoops(new ConvertedWay(cw, trailingWay));
        }
    }

    private Way splitWayAt(Way way, int index) {
        int i;
        if (way.isViaWay()) {
            this.removeRestrictionsWithWay(Level.WARNING, way, "is split, restriction will be ignored");
        }
        Way trailingWay = new Way(way.getId());
        List<Coord> wayPoints = way.getPoints();
        int numPointsInWay = wayPoints.size();
        for (i = index; i < numPointsInWay; ++i) {
            trailingWay.addPoint(wayPoints.get(i));
        }
        wayPoints.get(index).incHighwayCount();
        trailingWay.copyTags(way);
        for (i = numPointsInWay - 1; i > index; --i) {
            wayPoints.remove(i);
        }
        return trailingWay;
    }

    private void setHighwayCounts() {
        log.debug((Object)"Maintaining highway counters");
        long lastId = 0L;
        ArrayList<Way> dupIdHighways = new ArrayList<Way>();
        for (ConvertedWay cw : this.roads) {
            if (!cw.isValid()) continue;
            Way way = cw.getWay();
            if (way.getId() == lastId) {
                log.debug("Road with identical id:", way.getId());
                dupIdHighways.add(way);
                continue;
            }
            lastId = way.getId();
            way.getPoints().forEach(Coord::incHighwayCount);
        }
        for (Way way : dupIdHighways) {
            List<Coord> points = way.getPoints();
            points.get(0).incHighwayCount();
            points.get(points.size() - 1).incHighwayCount();
            for (int i = 1; i < points.size() - 1; ++i) {
                Coord p = points.get(i);
                if (p.getHighwayCount() <= 1) continue;
                p.incHighwayCount();
            }
        }
    }

    private void resetHighwayCounts() {
        log.debug((Object)"Resetting highway counters");
        long lastId = 0L;
        for (ConvertedWay cw : this.roads) {
            Way way = cw.getWay();
            if (!cw.isValid() || way.getId() == lastId) continue;
            lastId = way.getId();
            way.getPoints().forEach(Coord::resetHighwayCount);
        }
    }

    private void findUnconnectedRoads() {
        boolean remove;
        IdentityHashMap<Coord, HashSet<Way>> connectors = new IdentityHashMap<Coord, HashSet<Way>>(this.roads.size() * 2);
        HashSet<Way> selfConnectors = new HashSet<Way>();
        long lastId = 0L;
        for (ConvertedWay cw : this.roads) {
            Way way = cw.getWay();
            if (way.getId() == lastId) continue;
            lastId = way.getId();
            for (Coord p : way.getPoints()) {
                boolean wasNew;
                if (p.getHighwayCount() <= 1) continue;
                HashSet<Way> ways = (HashSet<Way>)connectors.get(p);
                if (ways == null) {
                    ways = new HashSet<Way>();
                    connectors.put(p, ways);
                }
                if ((wasNew = ways.add(way)) || this.reportDeadEnds <= 0) continue;
                selfConnectors.add(way);
            }
        }
        HashMap<Long, Integer> poorlyConnectedRoads = new HashMap<Long, Integer>();
        Iterator<ConvertedWay> iter = this.roads.iterator();
        while (iter.hasNext()) {
            ConvertedWay cw = iter.next();
            if (!cw.isValid()) continue;
            Way way = cw.getWay();
            if (this.reportDeadEnds > 0) {
                this.reportDeadEnds(cw, connectors, selfConnectors);
            }
            boolean onBoundary = false;
            int countCon = 0;
            for (Coord p : way.getPoints()) {
                HashSet ways;
                if (p.getOnBoundary()) {
                    onBoundary = true;
                    break;
                }
                if (p.getHighwayCount() <= 1 || (ways = (HashSet)connectors.get(p)) == null || ways.size() <= 1) continue;
                ++countCon;
            }
            remove = false;
            if (countCon > true) continue;
            remove = this.handlePoorConnection(countCon, cw, onBoundary);
            if (remove) {
                iter.remove();
            }
            if (onBoundary) continue;
            poorlyConnectedRoads.put(way.getId(), countCon);
        }
        Iterator<ConvertedWay> linesIter = this.lines.iterator();
        while (linesIter.hasNext()) {
            Way way;
            Integer countCon;
            ConvertedWay cw = linesIter.next();
            if (!cw.isOverlay() || (countCon = (Integer)poorlyConnectedRoads.get((way = cw.getWay()).getId())) == null || !(remove = this.handlePoorConnection(countCon, cw, false))) continue;
            linesIter.remove();
        }
    }

    private boolean handlePoorConnection(int count, ConvertedWay cw, boolean onBoundary) {
        String tagKey;
        Way way = cw.getWay();
        String replTypeString = way.getTag(tagKey = CONNECTION_TAGS[count]);
        if (replTypeString == null) {
            return false;
        }
        StringBuilder sb = new StringBuilder(100);
        sb.append(way.toBrowseURL()).append(' ').append(GType.formatType(cw.getGType().getType()));
        if (cw.isOverlay()) {
            sb.append("(Overlay)");
        }
        sb.append(": ").append(count == 0 ? "road not connected" : "road doesn't go").append(" to other roads");
        if (onBoundary) {
            log.info(sb.toString(), "but is on boundary");
            return false;
        }
        sb.append(',');
        if ("none".equals(replTypeString)) {
            log.info(sb.toString(), "is ignored because of", tagKey + "=none");
            return true;
        }
        int replType = -1;
        try {
            replType = Integer.decode(replTypeString);
            if (GType.isSpecialRoutableLineType(replType)) {
                replType = -1;
                log.error("type value in", tagKey, "should not be a routable type:" + replTypeString);
            }
            if (!GType.checkType(FeatureKind.POLYLINE, replType)) {
                replType = -1;
                log.error("type value in", tagKey, "is not a valid line type:" + replTypeString);
            }
        }
        catch (NumberFormatException e) {
            throw new ExitException("invalid type value in style" + tagKey + "=" + replTypeString);
        }
        if (replType != -1) {
            log.info(sb.toString(), "added as line with type", replTypeString);
            this.addLine(cw, replType);
        } else {
            log.info(sb.toString(), "but replacement type is invalid. Was dropped");
        }
        return true;
    }

    private void reportDeadEnds(ConvertedWay cw, Map<Coord, HashSet<Way>> connectors, HashSet<Way> selfConnectors) {
        Way way = cw.getWay();
        if (cw.isOneway() && !way.tagIsLikeNo("mkgmap:dead-end-check")) {
            int[] pointsToCheck;
            List<Coord> points = way.getPoints();
            if (points.get((pointsToCheck = new int[]{0, points.size() - 1})[0]) == points.get(pointsToCheck[1])) {
                return;
            }
            for (int pos : pointsToCheck) {
                boolean isDeadEnd = true;
                boolean isDeadEndOfMultipleWays = true;
                Coord p = points.get(pos);
                if (!this.bbox.contains(p) || p.getOnBoundary()) {
                    isDeadEnd = false;
                } else if (p.getHighwayCount() < 2) {
                    isDeadEndOfMultipleWays = false;
                } else {
                    HashSet<Way> ways = connectors.get(p);
                    if (ways.size() <= 1) {
                        isDeadEndOfMultipleWays = false;
                    }
                    block1: for (Way connectedWay : ways) {
                        Coord otherLast;
                        if (!isDeadEnd) break;
                        if (way == connectedWay) {
                            Coord pTest;
                            if (!selfConnectors.contains(way)) continue;
                            if (pos == 0) {
                                for (int k = pos + 1; k < points.size() - 1 && (pTest = points.get(k)) != p; ++k) {
                                    if (pTest.getHighwayCount() <= 1) continue;
                                    isDeadEnd = false;
                                    continue block1;
                                }
                                continue;
                            }
                            for (int k = pos - 1; k >= 0 && (pTest = points.get(k)) != p; --k) {
                                if (pTest.getHighwayCount() <= 1) continue;
                                isDeadEnd = false;
                                continue block1;
                            }
                            continue;
                        }
                        List<Coord> otherPoints = connectedWay.getPoints();
                        Coord otherFirst = otherPoints.get(0);
                        if (otherFirst == (otherLast = otherPoints.get(otherPoints.size() - 1)) || !connectedWay.tagIsLikeYes(TK_ONEWAY)) {
                            isDeadEnd = false;
                            continue;
                        }
                        Coord pOther = pos != 0 ? otherLast : otherFirst;
                        if (p == pOther) continue;
                        isDeadEnd = false;
                    }
                }
                if (!isDeadEnd || !isDeadEndOfMultipleWays && this.reportDeadEnds <= 1) continue;
                log.diagnostic("Oneway road " + way.getId() + " with tags " + way.toTagString() + (pos == 0 ? " comes from" : " goes to") + " nowhere at " + p.toOSMURL());
            }
        }
    }

    private void filterCoordPOI() {
        if (!this.linkPOIsToWays) {
            return;
        }
        log.debug((Object)"translating CoordPOI");
        for (ConvertedWay cw : this.roads) {
            Way way;
            if (!cw.isValid() || !"true".equals((way = cw.getWay()).getTag("mkgmap:way-has-pois"))) continue;
            StringBuilder wayPOI = new StringBuilder();
            List<Coord> points = way.getPoints();
            int numPoints = points.size();
            for (int i = 0; i < numPoints; ++i) {
                byte nodeAccess;
                Coord p = points.get(i);
                if (!(p instanceof CoordPOI)) continue;
                CoordPOI cp = (CoordPOI)p;
                Node node = cp.getNode();
                boolean usedInThisWay = false;
                byte wayAccess = cw.getAccess();
                if (wayAccess != 1 && (node.getTag("mkgmap:road-class") != null || node.getTag("mkgmap:road-speed") != null)) {
                    usedInThisWay = true;
                }
                if ((nodeAccess = AccessTagsAndBits.evalAccessTags(node)) != -1) {
                    if ((wayAccess & nodeAccess) != wayAccess) {
                        if (p.getHighwayCount() >= 2 || i != 0 && i != numPoints - 1) {
                            usedInThisWay = true;
                            cp.setConvertToViaInRouteRestriction(true);
                        } else {
                            log.info("link-pois-to-ways: POI node at", node.toBrowseURL(), "with access restriction is ignored, it is not connected to other routable ways");
                        }
                    } else {
                        log.info("link-pois-to-ways: Access restriction in POI node", node.toBrowseURL(), "was ignored for way", way.toBrowseURL());
                    }
                }
                if (!usedInThisWay) continue;
                cp.setUsed(true);
                wayPOI.append('[').append(node.getId()).append(']');
            }
            if (wayPOI.length() == 0) {
                way.deleteTag("mkgmap:way-has-pois");
                log.info("link-pois-to-ways: ignoring CoordPOI(s) for way", way.toBrowseURL(), "because routing is not affected.");
                continue;
            }
            way.addTag(WAY_POI_NODE_IDS, wayPOI.toString());
        }
    }

    @Override
    public Boolean getDriveOnLeft() {
        assert (this.roads == null) : "getDriveOnLeft() should be called after end()";
        return this.driveOnLeft;
    }

    private class NodeTypeResult
    implements TypeResult {
        private Node node;
        private boolean matched;

        private NodeTypeResult() {
        }

        public void setNode(Node node) {
            this.node = node;
            this.matched = false;
        }

        @Override
        public void add(Element el, GType type) {
            this.matched = true;
            if (type.isContinueSearch() && el == this.node) {
                el = this.node.copy();
            }
            StyledConverter.postConvertRules(el, type);
            StyledConverter.this.housenumberGenerator.addNode((Node)el);
            this.addPoint((Node)el, type);
        }

        private void addPoint(Node node, GType gt) {
            MapPoint mp;
            if (!StyledConverter.this.clipper.contains(node.getLocation())) {
                return;
            }
            int type = gt.getType();
            if (type >= 8192 && type < 10240) {
                String ref = node.getTag("exit:road_ref");
                String id = node.getTag("mkgmap:osmid");
                if (ref != null) {
                    String to = node.getTag("exit:to");
                    MapExitPoint mep = new MapExitPoint(ref, to);
                    String fd = node.getTag("exit:facility");
                    if (fd != null) {
                        mep.setFacilityDescription(fd);
                    }
                    if (id != null) {
                        mep.setOSMId(id);
                    }
                    mp = mep;
                } else {
                    mp = new MapPoint();
                    if ("motorway_junction".equals(node.getTag("highway"))) {
                        log.warn("Motorway exit", node.getName(), "(" + node.toBrowseURL() + ") has no (motorway) ref! (either make the exit share a node with the motorway or specify the motorway ref with a", "exit:road_ref", "tag)");
                    }
                }
            } else {
                mp = new MapPoint();
            }
            StyledConverter.this.elementSetup(mp, gt, node);
            mp.setLocation(node.getLocation());
            StyledConverter.this.nearbyPoiHandler.add(mp, node);
        }

        public boolean isMatched() {
            return this.matched;
        }
    }

    private class WayTypeResult
    implements TypeResult {
        private Way way;
        private boolean matched;

        private WayTypeResult() {
        }

        public void setWay(Way way) {
            this.way = way;
            this.matched = false;
        }

        @Override
        public void add(Element el, GType type) {
            this.matched = true;
            if (type.isContinueSearch() && el == this.way) {
                el = this.way.copy();
            }
            StyledConverter.postConvertRules(el, type);
            if (!type.isRoad()) {
                StyledConverter.this.housenumberGenerator.addWay((Way)el);
            }
            this.addConvertedWay((Way)el, type);
        }

        private void addConvertedWay(Way way, GType foundType) {
            if (foundType.getFeatureKind() == FeatureKind.POLYGON) {
                this.addShape(way, foundType);
                return;
            }
            boolean wasReversed = false;
            String oneWay = way.getTag(TK_ONEWAY);
            if (oneWay != null) {
                if ("-1".equals(oneWay)) {
                    way.reverse();
                    wasReversed = true;
                    way.addTag(TK_ONEWAY, "yes");
                }
                if (way.tagIsLikeYes(TK_ONEWAY)) {
                    way.addTag(TK_ONEWAY, "yes");
                    if (foundType.isRoad() && this.hasSkipDeadEndCheckNode(way)) {
                        way.addTag("mkgmap:dead-end-check", "false");
                    }
                } else {
                    way.deleteTag(TK_ONEWAY);
                }
            }
            ConvertedWay cw = new ConvertedWay(way, foundType);
            cw.setReversed(wasReversed);
            boolean hasDirection = cw.isOneway();
            if (way.tagIsLikeYes(TKM_HAS_DIRECTION)) {
                hasDirection = true;
            } else if (way.tagIsLikeNo(TKM_HAS_DIRECTION)) {
                hasDirection = false;
            } else if (StyledConverter.this.lineTypesWithDirection.contains(foundType.getType())) {
                hasDirection = true;
            } else if (!cw.isRoad()) {
                hasDirection = false;
            }
            cw.setHasDirection(hasDirection);
            if (cw.isRoad()) {
                if (way.getId() == StyledConverter.this.lastRoadId) {
                    ConvertedWay prevRoad;
                    for (int i = StyledConverter.this.roads.size() - 1; i >= 0 && (prevRoad = (ConvertedWay)StyledConverter.this.roads.get(i)).getWay().getId() == StyledConverter.this.lastRoadId; --i) {
                        if (!RoadMerger.isMergeable(way.getFirstPoint(), prevRoad, cw, true)) continue;
                        log.warn("Ignoring duplicate road", foundType, "for", way.getBasicLogInformation());
                        return;
                    }
                }
                StyledConverter.this.roads.add(cw);
                StyledConverter.this.numRoads++;
                if (!cw.isOneway() && !cw.isFerry() && (cw.getAccess() & 0xFFFFFFFC) != 0) {
                    String countryIso = LocatorConfig.get().getCountryISOCode(way.getTag(TKM_COUNTRY));
                    if (countryIso != null) {
                        boolean drivingSideIsLeft = LocatorConfig.get().getDriveOnLeftFlag(countryIso);
                        if (drivingSideIsLeft) {
                            StyledConverter.this.numDriveOnLeftRoads++;
                        } else {
                            StyledConverter.this.numDriveOnRightRoads++;
                        }
                        if (StyledConverter.this.driveOnLeft != null && drivingSideIsLeft != StyledConverter.this.driveOnLeft) {
                            log.warn("wrong driving side", way.toBrowseURL());
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("assumed driving side is", drivingSideIsLeft ? "left" : "right", way.toBrowseURL());
                        }
                    } else {
                        StyledConverter.this.numDriveOnSideUnknown++;
                    }
                }
                if (cw.isRoundabout() && wasReversed && StyledConverter.this.checkRoundaboutDirections) {
                    log.diagnostic("Roundabout " + way.getId() + " has reverse oneway tag (" + way.getFirstPoint().toOSMURL() + ")");
                }
                StyledConverter.this.lastRoadId = way.getId();
            } else {
                StyledConverter.this.lines.add(cw);
            }
        }

        private void addShape(Way way, GType gt) {
            if (!way.hasIdenticalEndPoints() && way.hasEqualEndPoints()) {
                log.error((Object)("shape is not closed with identical points " + way.getId()));
            }
            if (!way.hasIdenticalEndPoints()) {
                return;
            }
            MapShape shape = new MapShape(way.getId());
            StyledConverter.this.elementSetup(shape, gt, way);
            shape.setPoints(way.getPoints());
            long areaVal = 0L;
            String tagStringVal = way.getTag(TKM_DRAW_LEVEL);
            if (tagStringVal != null) {
                try {
                    areaVal = Integer.parseInt(tagStringVal);
                    if (areaVal < 1L || areaVal > 100L) {
                        log.error("mkgmap:drawLevel must be in range 1..100, not", areaVal);
                        areaVal = 0L;
                    } else {
                        areaVal = areaVal <= 50L ? Long.MAX_VALUE - areaVal : 101L - areaVal;
                    }
                }
                catch (NumberFormatException e) {
                    log.error("mkgmap:drawLevel invalid integer:", tagStringVal);
                }
            }
            if (areaVal == 0L) {
                areaVal = way.getFullArea();
            }
            shape.setFullArea(areaVal);
            shape.setMpRel(way.getMpRel());
            StyledConverter.this.clipper.clipShape(shape, StyledConverter.this.collector);
        }

        private boolean hasSkipDeadEndCheckNode(Way way) {
            return way.getFirstPoint().isSkipDeadEndCheck() || way.getLastPoint().isSkipDeadEndCheck();
        }

        public boolean isMatched() {
            return this.matched;
        }
    }
}

