/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Formatter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.general.LevelInfo;
import uk.me.parabola.mkgmap.osmstyle.ActionRule;
import uk.me.parabola.mkgmap.osmstyle.DirectoryFileLoader;
import uk.me.parabola.mkgmap.osmstyle.ExpressionArranger;
import uk.me.parabola.mkgmap.osmstyle.ExpressionRule;
import uk.me.parabola.mkgmap.osmstyle.RuleSet;
import uk.me.parabola.mkgmap.osmstyle.StyleFileLoader;
import uk.me.parabola.mkgmap.osmstyle.StylePrinter;
import uk.me.parabola.mkgmap.osmstyle.TypeReader;
import uk.me.parabola.mkgmap.osmstyle.actions.Action;
import uk.me.parabola.mkgmap.osmstyle.actions.ActionList;
import uk.me.parabola.mkgmap.osmstyle.actions.ActionReader;
import uk.me.parabola.mkgmap.osmstyle.actions.AddTagAction;
import uk.me.parabola.mkgmap.osmstyle.actions.DeleteAction;
import uk.me.parabola.mkgmap.osmstyle.eval.EqualsOp;
import uk.me.parabola.mkgmap.osmstyle.eval.ExpressionReader;
import uk.me.parabola.mkgmap.osmstyle.eval.NotOp;
import uk.me.parabola.mkgmap.osmstyle.eval.Op;
import uk.me.parabola.mkgmap.osmstyle.eval.ValueOp;
import uk.me.parabola.mkgmap.osmstyle.function.GetTagFunction;
import uk.me.parabola.mkgmap.reader.osm.FeatureKind;
import uk.me.parabola.mkgmap.reader.osm.GType;
import uk.me.parabola.mkgmap.reader.osm.Rule;
import uk.me.parabola.mkgmap.scan.SyntaxException;
import uk.me.parabola.mkgmap.scan.TokType;
import uk.me.parabola.mkgmap.scan.Token;
import uk.me.parabola.mkgmap.scan.TokenScanner;

public class RuleFileReader {
    private static final Logger log = Logger.getLogger(RuleFileReader.class);
    private final FeatureKind kind;
    private final TypeReader typeReader;
    private final RuleSet rules;
    private RuleSet finalizeRules;
    private final boolean performChecks;
    private final boolean forRoutableMap;
    private final Map<Integer, List<Integer>> overlays;
    private final Deque<Op[]> ifStack = new LinkedList<Op[]>();
    public static final String IF_PREFIX = "mkgmap:if:";
    private boolean inFinalizeSection;
    private final ExpressionArranger arranger = new ExpressionArranger();
    private int ifCounter;

    public RuleFileReader(FeatureKind kind, LevelInfo[] levels, RuleSet rules, boolean performChecks, Map<Integer, List<Integer>> overlays) {
        this(kind, levels, rules, performChecks, false, overlays);
    }

    public RuleFileReader(FeatureKind kind, LevelInfo[] levels, RuleSet rules, boolean performChecks, boolean forRoutableMap, Map<Integer, List<Integer>> overlays) {
        this.kind = kind;
        this.rules = rules;
        this.performChecks = performChecks;
        this.forRoutableMap = forRoutableMap;
        this.overlays = overlays;
        this.typeReader = new TypeReader(kind, levels);
    }

    public void load(StyleFileLoader loader, String name) throws FileNotFoundException {
        this.loadFile(loader, name);
        this.rules.prepare();
        if (this.finalizeRules != null) {
            this.finalizeRules.prepare();
            this.rules.setFinalizeRule(this.finalizeRules);
        }
    }

    private void loadFile(StyleFileLoader loader, String name) throws FileNotFoundException {
        Reader r = loader.open(name);
        TokenScanner scanner = new TokenScanner(name, r);
        scanner.setExtraWordChars("-:.");
        ExpressionReader expressionReader = new ExpressionReader(scanner, this.kind);
        ActionReader actionReader = new ActionReader(scanner);
        scanner.skipSpace();
        while (!scanner.isEndOfFile()) {
            String actionsString;
            if (this.checkCommand(loader, scanner, expressionReader)) continue;
            if (scanner.isEndOfFile()) break;
            Op expr = expressionReader.readConditions(this.ifStack);
            expr = this.arranger.arrange(expr);
            ActionList actionList = actionReader.readActions();
            this.checkIfStack(actionList);
            if (this.performChecks && this.kind == FeatureKind.RELATION && ((actionsString = actionList.getList().toString()).contains("set mkgmap:stylefilter") || actionsString.contains("add mkgmap:stylefilter"))) {
                log.error("Style file", name, "should not set or add the special tag mkgmap:stylefilter:", actionsString);
            }
            ArrayList<GType> types = new ArrayList<GType>();
            while (scanner.checkToken("[")) {
                GType type = this.typeReader.readType(scanner, this.performChecks, this.forRoutableMap, this.overlays);
                types.add(type);
                scanner.skipSpace();
            }
            if (types.isEmpty() && actionList.isEmpty()) {
                throw new SyntaxException(scanner, "No type definition given");
            }
            if (types.isEmpty()) {
                this.saveRule(scanner, expr, actionList, null);
            }
            if (types.size() >= 2 && actionList.isModifyingTags()) {
                throw new SyntaxException(scanner, "Combination of multiple type definitions with tag modifying action is not yet supported.");
            }
            for (int i = 0; i < types.size(); ++i) {
                GType type = (GType)types.get(i);
                if (i + 1 < types.size()) {
                    type.setContinueSearch(true);
                }
                this.saveRule(scanner, expr, actionList, type);
                actionList = new ActionList(Collections.emptyList(), Collections.emptySet());
            }
        }
        this.rules.addUsedTags(expressionReader.getUsedTags());
        this.rules.addUsedTags(actionReader.getUsedTags());
    }

    private boolean checkCommand(StyleFileLoader currentLoader, TokenScanner scanner, ExpressionReader expressionReader) {
        scanner.skipSpace();
        if (scanner.isEndOfFile()) {
            return false;
        }
        if (scanner.checkToken("include") ? this.readInclude(currentLoader, scanner) : (scanner.checkToken("if") ? this.readIf(scanner, expressionReader) : (scanner.checkToken("else") ? this.readElse(scanner) : (scanner.checkToken("end") ? this.readEnd(scanner) : scanner.checkToken("<") && this.readFinalize(scanner))))) {
            return true;
        }
        scanner.skipSpace();
        return false;
    }

    private boolean readIf(TokenScanner scanner, ExpressionReader expressionReader) {
        Token tok = scanner.nextToken();
        scanner.skipSpace();
        Token next = scanner.peekToken();
        if (next.getType() == TokType.SYMBOL && next.isValue("(")) {
            Op origExpr = expressionReader.readConditions();
            scanner.validateNext("then");
            String ifVar = this.getNextIfVar();
            ArrayList<Action> actions = new ArrayList<Action>(1);
            actions.add(new AddTagAction(ifVar, "true", true));
            ActionList actionList = new ActionList(actions, Collections.singleton(ifVar + "=true"));
            this.saveRule(scanner, origExpr, actionList, null);
            EqualsOp safeExpr = new EqualsOp();
            safeExpr.setFirst(new GetTagFunction(ifVar));
            safeExpr.setSecond(new ValueOp("true"));
            Op[] ifExpressions = new Op[]{origExpr, safeExpr};
            this.ifStack.addLast(ifExpressions);
            return true;
        }
        scanner.pushToken(tok);
        return false;
    }

    private boolean readElse(TokenScanner scanner) {
        Token tok = scanner.nextToken();
        scanner.skipSpace();
        Token next = scanner.peekToken();
        if (next.getType() == TokType.SYMBOL && !next.isValue("(") && !next.isValue("!")) {
            scanner.pushToken(tok);
            return false;
        }
        Op[] ifExpressions = this.ifStack.removeLast();
        for (int i = 0; i < ifExpressions.length; ++i) {
            Op op = ifExpressions[i];
            NotOp not = new NotOp();
            not.setFirst(op);
            ifExpressions[i] = not;
        }
        this.ifStack.addLast(ifExpressions);
        return true;
    }

    private boolean readEnd(TokenScanner scanner) {
        Token tok = scanner.nextToken();
        scanner.skipSpace();
        if (this.ifStack.isEmpty()) {
            scanner.pushToken(tok);
            return false;
        }
        this.ifStack.removeLast();
        return true;
    }

    private void checkIfStack(ActionList actionList) {
        if (actionList.isEmpty()) {
            return;
        }
        for (Op[] ops : this.ifStack) {
            if (ops[0] == ops[1] || !this.possiblyChanged(ops[0], actionList)) continue;
            ops[0] = ops[1];
        }
    }

    private boolean possiblyChanged(Op expr, ActionList actionList) {
        Set<String> evaluated = expr.getEvaluatedTagKeys();
        if (evaluated.isEmpty()) {
            return false;
        }
        for (String tagKey : evaluated) {
            for (String s : actionList.getChangeableTags()) {
                int pos = s.indexOf(61);
                String key = pos > 0 ? s.substring(0, pos) : s;
                if (!tagKey.equals(key)) continue;
                return true;
            }
            for (Action a : actionList.getList()) {
                if (!(a instanceof DeleteAction) || !a.toString().contains(tagKey)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean readInclude(StyleFileLoader currentLoader, TokenScanner scanner) {
        Token token = scanner.nextToken();
        scanner.skipSpace();
        Token next = scanner.peekToken();
        if (next.getType() == TokType.TEXT || next.getType() == TokType.SYMBOL && (next.isValue("'") || next.isValue("\""))) {
            String filename = scanner.nextWord();
            StyleFileLoader loader = currentLoader;
            scanner.skipSpace();
            if (scanner.checkToken("from")) {
                scanner.nextToken();
                String styleName = scanner.nextWord();
                if (Objects.equals(styleName, ";")) {
                    throw new SyntaxException(scanner, "No style name after 'from'");
                }
                try {
                    loader = StyleFileLoader.createStyleLoader(null, styleName);
                }
                catch (FileNotFoundException e) {
                    throw new SyntaxException(scanner, "Cannot find style: " + styleName);
                }
            }
            if (scanner.checkToken(";")) {
                scanner.nextToken();
            }
            try {
                this.loadFile(loader, filename);
                boolean styleName = true;
                return styleName;
            }
            catch (FileNotFoundException e) {
                throw new SyntaxException(scanner, "Cannot open included file: " + filename);
            }
            finally {
                if (loader != currentLoader) {
                    Utils.closeFile(loader);
                }
            }
        }
        scanner.pushToken(token);
        return false;
    }

    private boolean readFinalize(TokenScanner scanner) {
        Token token = scanner.nextToken();
        if (scanner.checkToken("finalize")) {
            Token finalizeToken = scanner.nextToken();
            if (scanner.checkToken(">")) {
                if (this.inFinalizeSection) {
                    throw new SyntaxException(scanner, "There is only one finalize section allowed");
                }
                scanner.nextToken();
                this.inFinalizeSection = true;
                this.finalizeRules = new RuleSet();
                return true;
            }
            scanner.pushToken(finalizeToken);
            scanner.pushToken(token);
        } else {
            scanner.pushToken(token);
        }
        return false;
    }

    private void saveRule(TokenScanner scanner, Op op, ActionList actions, GType gt) {
        log.debug("EXP", op, ", type=", gt);
        if (this.inFinalizeSection && gt != null) {
            throw new SyntaxException(scanner, "Element type definition is not allowed in <finalize> section");
        }
        Iterator<Op> it = this.arranger.prepareForSave(op);
        while (it.hasNext()) {
            Op prepared = it.next();
            String keystring = this.arranger.getKeystring(scanner, prepared);
            this.createAndSaveRule(keystring, prepared, actions, gt);
        }
    }

    private void createAndSaveRule(String keystring, Op expr, ActionList actions, GType gt) {
        Rule rule = actions.isEmpty() ? new ExpressionRule(expr, gt) : new ActionRule(expr, actions.getList(), gt);
        if (this.inFinalizeSection) {
            this.finalizeRules.add(keystring, rule, actions.getChangeableTags());
        } else {
            this.rules.add(keystring, rule, actions.getChangeableTags());
        }
    }

    public String getNextIfVar() {
        return IF_PREFIX + ++this.ifCounter;
    }

    public static void main(String[] args) throws FileNotFoundException {
        if (args.length > 0) {
            RuleSet rs = new RuleSet();
            RuleFileReader rr = new RuleFileReader(FeatureKind.POLYLINE, LevelInfo.createFromString("0:24 1:20 2:18 3:16 4:14"), rs, false, Collections.emptyMap());
            DirectoryFileLoader loader = new DirectoryFileLoader(new File(args[0]).getAbsoluteFile().getParentFile());
            String fname = new File(args[0]).getName();
            rr.load(loader, fname);
            StylePrinter.dumpRuleSet(new Formatter(System.out), "rules", rs);
        } else {
            System.err.println("Usage: RuleFileReader <file>");
        }
    }
}

