/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.general.MapRoad;
import uk.me.parabola.mkgmap.scan.TokType;
import uk.me.parabola.mkgmap.scan.Token;
import uk.me.parabola.mkgmap.scan.TokenScanner;
import uk.me.parabola.util.EnhancedProperties;

public class PrefixSuffixFilter {
    private static final Logger log = Logger.getLogger(PrefixSuffixFilter.class);
    private static final int MODE_PREFIX = 0;
    private static final int MODE_SUFFIX = 1;
    private boolean enabled;
    private final Set<String> languages = new LinkedHashSet<String>();
    private final Map<String, List<String>> langPrefixMap = new HashMap<String, List<String>>();
    private final Map<String, List<String>> langSuffixMap = new HashMap<String, List<String>>();
    private final Map<String, List<String>> countryLanguageMap = new HashMap<String, List<String>>();
    private final Map<String, List<String>> countryPrefixMap = new HashMap<String, List<String>>();
    private final Map<String, List<String>> countrySuffixMap = new HashMap<String, List<String>>();
    private EnhancedProperties options = new EnhancedProperties();

    public PrefixSuffixFilter(EnhancedProperties props) {
        String cfgFile = props.getProperty("road-name-config", null);
        this.enabled = this.readConfig(cfgFile);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean readConfig(String cfgFile) {
        if (cfgFile == null) {
            return false;
        }
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(cfgFile), StandardCharsets.UTF_8);){
            this.readOptionFile(reader, cfgFile);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            log.error((Object)(this.getClass().getSimpleName() + " disabled, failed to read config file " + cfgFile));
            return false;
        }
    }

    private void readOptionFile(Reader r, String filename) {
        BufferedReader br = new BufferedReader(r);
        TokenScanner ts = new TokenScanner(filename, br);
        ts.setExtraWordChars(":");
        while (!ts.isEndOfFile()) {
            Token tok = ts.nextToken();
            if (tok.isValue("#")) {
                ts.skipLine();
                continue;
            }
            String key = tok.getValue();
            ts.skipSpace();
            tok = ts.peekToken();
            if (tok.getType() == TokType.SYMBOL) {
                switch (ts.nextValue()) {
                    case ":": 
                    case "=": {
                        this.processOption(key, ts.readLine());
                        break;
                    }
                    default: {
                        ts.skipLine();
                        break;
                    }
                }
                continue;
            }
            if (key != null) {
                throw new IllegalArgumentException("don't understand line with " + key);
            }
            ts.skipLine();
        }
        for (String lang : this.languages) {
            String prefix1 = this.options.getProperty("prefix1:" + lang, null);
            if (prefix1 == null) continue;
            String prefix2 = this.options.getProperty("prefix2:" + lang, null);
            List<String> p1 = Arrays.asList(prefix1.split(","));
            List<String> p2 = prefix2 != null ? Arrays.asList(prefix2.split(",")) : Collections.emptyList();
            this.langPrefixMap.put(lang, PrefixSuffixFilter.genPrefix(p1, p2));
        }
    }

    private void processOption(String key, String val) {
        String[] keysParts = key.split(":");
        String[] valParts = val.split(",");
        if (keysParts.length < 2 || val.isEmpty() || valParts.length < 1) {
            throw new IllegalArgumentException("don't understand " + key + " = " + val);
        }
        switch (keysParts[0].trim()) {
            case "prefix1": 
            case "prefix2": {
                this.options.put(key, val);
                break;
            }
            case "suffix": {
                ArrayList<String> suffixes = new ArrayList<String>();
                for (String s : valParts) {
                    suffixes.add(PrefixSuffixFilter.stripBlanksAndQuotes(s));
                }
                PrefixSuffixFilter.sortByLength(suffixes);
                this.langSuffixMap.put(keysParts[1].trim(), suffixes);
                break;
            }
            case "lang": {
                String iso = keysParts[1].trim();
                ArrayList<String> langs = new ArrayList<String>();
                for (String lang : valParts) {
                    langs.add(lang.trim());
                }
                this.countryLanguageMap.put(iso, langs);
                this.languages.addAll(langs);
            }
        }
    }

    private static List<String> genPrefix(List<String> prefix1, List<String> prefix2) {
        ArrayList<String> prefixes = new ArrayList<String>();
        for (String p1 : prefix1) {
            p1 = PrefixSuffixFilter.stripBlanksAndQuotes(p1);
            for (String p2 : prefix2) {
                p2 = PrefixSuffixFilter.stripBlanksAndQuotes(p2);
                prefixes.add(p1 + " " + p2);
            }
            prefixes.add(p1 + " ");
        }
        PrefixSuffixFilter.sortByLength(prefixes);
        return prefixes;
    }

    private static String stripBlanksAndQuotes(String s) {
        if ((s = s.trim()).startsWith("'") && s.endsWith("'") || s.startsWith("\"") && s.endsWith("\"")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public void filter(MapRoad road) {
        if (!this.enabled) {
            return;
        }
        String country = road.getCountry();
        if (country == null) {
            return;
        }
        List<String> prefixesCountry = this.getSearchStrings(country, 0);
        List<String> suffixesCountry = this.getSearchStrings(country, 1);
        String[] labels = road.getLabels();
        for (int i = 0; i < labels.length; ++i) {
            String label = labels[i];
            if (label == null || label.isEmpty()) continue;
            label = PrefixSuffixFilter.applyPrefixes(label, prefixesCountry);
            if ((label = PrefixSuffixFilter.applySuffixes(label, suffixesCountry)).equals(labels[i])) continue;
            labels[i] = label;
            log.debug("modified", label, country, road.getRoadDef());
        }
    }

    static String applyPrefixes(String label, List<String> prefixesCountry) {
        if (label.charAt(0) < '\u0007') {
            return label;
        }
        for (String prefix : prefixesCountry) {
            if (label.length() < prefix.length() || !prefix.equalsIgnoreCase(label.substring(0, prefix.length()))) continue;
            if (prefix.endsWith(" ")) {
                return prefix.substring(0, prefix.length() - 1) + '\u001e' + label.substring(prefix.length());
            }
            return prefix + '\u001b' + label.substring(prefix.length());
        }
        return label;
    }

    private static String applySuffixes(String label, List<String> suffixesCountry) {
        for (String suffix : suffixesCountry) {
            int len = label.length();
            int pos = len - suffix.length();
            if (pos < 0 || !suffix.equalsIgnoreCase(label.substring(pos, len))) continue;
            if (suffix.startsWith(" ")) {
                return label.substring(0, pos) + '\u001f' + suffix.substring(1);
            }
            return label.substring(0, pos) + '\u001c' + suffix;
        }
        return label;
    }

    private List<String> getSearchStrings(String country, int mode) {
        Map<String, List<String>> cache = mode == 0 ? this.countryPrefixMap : this.countrySuffixMap;
        return cache.computeIfAbsent(country, k -> {
            List<String> languageList = this.countryLanguageMap.get(country);
            if (languageList == null) {
                return Collections.emptyList();
            }
            Map<String, List<String>> map = mode == 0 ? this.langPrefixMap : this.langSuffixMap;
            List<String> res = languageList.stream().map(lang -> map.getOrDefault(lang, Collections.emptyList())).flatMap(Collection::stream).distinct().collect(Collectors.toList());
            if (res.isEmpty()) {
                return Collections.emptyList();
            }
            PrefixSuffixFilter.sortByLength(res);
            return res;
        });
    }

    private static void sortByLength(List<String> strings) {
        strings.sort((o1, o2) -> Integer.compare(o2.length(), o1.length()));
    }
}

