/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.combiners;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import uk.me.parabola.imgfmt.FileExistsException;
import uk.me.parabola.imgfmt.FileNotWritableException;
import uk.me.parabola.imgfmt.FileSystemParam;
import uk.me.parabola.imgfmt.MapFailedException;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.mdr.MdrConfig;
import uk.me.parabola.imgfmt.app.srt.SRTFile;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.imgfmt.fs.FileSystem;
import uk.me.parabola.imgfmt.fs.ImgChannel;
import uk.me.parabola.imgfmt.mps.MapBlock;
import uk.me.parabola.imgfmt.mps.MpsFile;
import uk.me.parabola.imgfmt.mps.MpsFileReader;
import uk.me.parabola.imgfmt.mps.ProductBlock;
import uk.me.parabola.imgfmt.sys.FileLink;
import uk.me.parabola.imgfmt.sys.ImgFS;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.CommandArgs;
import uk.me.parabola.mkgmap.combiners.Combiner;
import uk.me.parabola.mkgmap.combiners.FileCopier;
import uk.me.parabola.mkgmap.combiners.FileInfo;
import uk.me.parabola.mkgmap.combiners.FileKind;
import uk.me.parabola.mkgmap.combiners.MdrBuilder;
import uk.me.parabola.mkgmap.combiners.SubFileInfo;

public class GmapsuppBuilder
implements Combiner {
    private static final String GMAPSUPP = "gmapsupp.img";
    private final Map<String, FileInfo> files = new LinkedHashMap<String, FileInfo>();
    private String areaName;
    private String mapsetName;
    private String overallDescription = "Combined map";
    private String outputDir;
    private MpsFile mpsFile;
    private boolean createIndex;
    private final Map<Integer, MdrBuilder> mdrBuilderMap = new LinkedHashMap<Integer, MdrBuilder>();
    private final Map<Integer, Sort> sortMap = new LinkedHashMap<Integer, Sort>();
    private MdrConfig mdrConfig;
    private boolean hideGmapsuppOnPC;
    private int productVersion;
    private FileSystem imgFs;

    @Override
    public void init(CommandArgs args) {
        this.areaName = args.get("area-name", null);
        this.mapsetName = args.get("mapset-name", "OSM map set");
        this.overallDescription = args.getDescription();
        this.outputDir = args.getOutputDir();
        this.hideGmapsuppOnPC = args.get("hide-gmapsupp-on-pc", false);
        this.productVersion = args.get("product-version", 100);
        this.mdrConfig = new MdrConfig();
        this.mdrConfig.setIndexOptions(args);
        try {
            this.imgFs = this.createGmapsupp();
        }
        catch (FileNotWritableException e) {
            throw new MapFailedException("Could not create gmapsupp.img file");
        }
    }

    private MdrBuilder addMdrFile(int familyId, Sort sort) {
        MdrBuilder mdrBuilder = this.mdrBuilderMap.get(familyId);
        if (mdrBuilder != null) {
            return mdrBuilder;
        }
        mdrBuilder = new MdrBuilder();
        try {
            String imgname = String.format("%08d.MDR", familyId);
            ImgChannel chan = this.imgFs.create(imgname);
            mdrBuilder.initForDevice(chan, sort, this.mdrConfig);
        }
        catch (FileExistsException e) {
            Logger.defaultLogger.error((Object)"Could not create duplicate MDR file");
        }
        this.mdrBuilderMap.put(familyId, mdrBuilder);
        return mdrBuilder;
    }

    private void addSrtFile(int familyId, FileInfo info) {
        Sort prevSort = this.sortMap.get(familyId);
        Sort sort = info.getSort();
        if (prevSort == null) {
            if (info.getKind() == FileKind.IMG_KIND) {
                this.sortMap.put(familyId, sort);
            }
        } else {
            if (prevSort.getCodepage() != sort.getCodepage()) {
                Logger.defaultLogger.warn((Object)("Input file '" + info.getFilename() + "' has a different code page (" + sort.getCodepage() + " rather than " + prevSort.getCodepage() + ")"));
            }
            if (info.hasSortOrder() && prevSort.getSortOrderId() != sort.getSortOrderId()) {
                Logger.defaultLogger.warn((Object)("Input file '" + info.getFilename() + "' has a different sort order (" + sort.getSortOrderId() + " rather than " + prevSort.getSortOrderId() + ")"));
            }
        }
    }

    @Override
    public void onMapEnd(FileInfo info) {
        this.files.put(info.getFilename(), info);
        if (info.isImg()) {
            int familyId = info.getFamilyId();
            if (this.createIndex) {
                MdrBuilder mdrBuilder = this.addMdrFile(familyId, info.getSort());
                mdrBuilder.onMapEnd(info);
            }
            this.addSrtFile(familyId, info);
        }
    }

    @Override
    public void onFinish() {
        for (MdrBuilder mdrBuilder : this.mdrBuilderMap.values()) {
            mdrBuilder.onFinishForDevice();
        }
        try {
            this.addAllFiles(this.imgFs);
            this.writeSrtFile(this.imgFs);
            this.writeMpsFile();
        }
        catch (FileNotWritableException e) {
            Logger.defaultLogger.error((Object)"Could not create gmapsupp file");
        }
        finally {
            Utils.closeFile(this.imgFs);
        }
    }

    private void writeSrtFile(FileSystem imgFs) throws FileNotWritableException {
        for (Map.Entry<Integer, Sort> ent : this.sortMap.entrySet()) {
            Sort sort = ent.getValue();
            int familyId = ent.getKey();
            if (sort.getId1() == 0 && sort.getId2() == 0) {
                return;
            }
            try {
                ImgChannel channel = imgFs.create(String.format("%08d.SRT", familyId));
                SRTFile srtFile = new SRTFile(channel);
                srtFile.setSort(sort);
                srtFile.write();
            }
            catch (FileExistsException e) {
                Logger.defaultLogger.error((Object)"could not create SRT file as it exists already");
                throw new FileNotWritableException("already existed", e);
            }
        }
    }

    private void writeMpsFile() throws FileNotWritableException {
        try {
            this.mpsFile.sync();
        }
        catch (IOException e) {
            throw new FileNotWritableException("Could not finish write to MPS file", e);
        }
    }

    private MapBlock makeMapBlock(FileInfo info) {
        MapBlock mb = new MapBlock(info.getCodePage());
        mb.setMapNumber(info.getMapnameAsInt());
        mb.setHexNumber(info.getHexname());
        mb.setMapDescription(info.getDescription());
        mb.setAreaName(this.areaName != null ? this.areaName : "Area " + info.getMapname());
        mb.setSeriesName(info.getSeriesName());
        mb.setIds(info.getFamilyId(), info.getProductId());
        return mb;
    }

    private static ProductBlock makeProductBlock(FileInfo info) {
        ProductBlock pb = new ProductBlock(info.getCodePage());
        pb.setFamilyId(info.getFamilyId());
        pb.setProductId(info.getProductId());
        pb.setDescription(info.getFamilyName());
        return pb;
    }

    private void addAllFiles(FileSystem outfs) {
        for (FileInfo info : this.files.values()) {
            switch (info.getKind()) {
                case IMG_KIND: {
                    GmapsuppBuilder.addImg(outfs, info);
                    this.addMpsEntry(info);
                    break;
                }
                case GMAPSUPP_KIND: {
                    GmapsuppBuilder.addImg(outfs, info);
                    this.addMpsFile(info);
                    break;
                }
                case APP_KIND: 
                case TYP_KIND: {
                    GmapsuppBuilder.addFile(outfs, info);
                    break;
                }
            }
        }
    }

    private static void addImg(FileSystem outfs, FileInfo info) {
        FileCopier fc = new FileCopier(info.getFilename());
        List<SubFileInfo> subFiles = info.subFiles();
        for (SubFileInfo sf : subFiles) {
            try {
                ImgChannel chan = outfs.create(sf.getName());
                Closeable sync = fc.add(sf.getName(), chan);
                ((FileLink)((Object)chan)).link(sf, sync);
            }
            catch (FileExistsException e) {
                Logger.defaultLogger.warn("Could not copy " + sf.getName(), e);
            }
        }
    }

    private static void addFile(FileSystem outfs, FileInfo info) {
        String filename = info.getFilename();
        FileCopier fc = new FileCopier(filename);
        try {
            ImgChannel chan = outfs.create(GmapsuppBuilder.createImgFilename(filename));
            ((FileLink)((Object)chan)).link(info.subFiles().get(0), fc.file(chan));
        }
        catch (FileExistsException e) {
            Logger.defaultLogger.warn("Could not copy " + filename, e);
        }
    }

    private void addMpsFile(FileInfo info) {
        String name = info.getFilename();
        try (FileSystem fs = ImgFS.openFs(name);){
            MpsFileReader mr = new MpsFileReader(fs.open(info.getMpsName(), "r"), info.getCodePage());
            for (MapBlock block : mr.getMaps()) {
                this.mpsFile.addMap(block);
            }
            for (ProductBlock b : mr.getProducts()) {
                this.mpsFile.addProduct(b);
            }
            mr.close();
        }
        catch (IOException e) {
            Logger.defaultLogger.error((Object)"Could not read MPS file from gmapsupp", e);
        }
    }

    private void addMpsEntry(FileInfo info) {
        this.mpsFile.addMap(this.makeMapBlock(info));
        this.mpsFile.addProduct(GmapsuppBuilder.makeProductBlock(info));
    }

    private static MpsFile createMpsFile(FileSystem outfs) throws FileNotWritableException {
        try {
            ImgChannel channel = outfs.create("MAKEGMAP.MPS");
            return new MpsFile(channel);
        }
        catch (FileExistsException e) {
            Logger.defaultLogger.error((Object)"could not create MPS file as it already exists");
            throw new FileNotWritableException("already existed", e);
        }
    }

    private static String createImgFilename(String pathname) {
        String ext;
        int dot;
        File f = new File(pathname);
        String name = f.getName().toUpperCase(Locale.ENGLISH);
        String base = name.substring(0, dot = name.lastIndexOf(46));
        if (base.length() > 8) {
            base = base.substring(0, 8);
        }
        if ((ext = name.substring(dot + 1)).length() > 3) {
            ext = ext.substring(0, 3);
        }
        return base + '.' + ext;
    }

    private FileSystem createGmapsupp() throws FileNotWritableException {
        FileSystemParam params = new FileSystemParam();
        params.setMapDescription(this.overallDescription);
        params.setGmapsupp(true);
        params.setHideGmapsuppOnPC(this.hideGmapsuppOnPC);
        params.setProductVersion(this.productVersion);
        FileSystem outfs = ImgFS.createFs(Utils.joinPath(this.outputDir, GMAPSUPP), params);
        this.mpsFile = GmapsuppBuilder.createMpsFile(outfs);
        this.mpsFile.setMapsetName(this.mapsetName);
        return outfs;
    }

    public void setCreateIndex(boolean create) {
        this.createIndex = create;
    }
}

