/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.combiners;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import uk.me.parabola.imgfmt.FileSystemParam;
import uk.me.parabola.imgfmt.MapFailedException;
import uk.me.parabola.imgfmt.ReadFailedException;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.BufferedImgFileReader;
import uk.me.parabola.imgfmt.app.lbl.LBLFileReader;
import uk.me.parabola.imgfmt.app.map.MapReader;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.imgfmt.app.trergn.TREFileReader;
import uk.me.parabola.imgfmt.app.trergn.TREHeader;
import uk.me.parabola.imgfmt.fs.DirectoryEntry;
import uk.me.parabola.imgfmt.fs.FileSystem;
import uk.me.parabola.imgfmt.fs.ImgChannel;
import uk.me.parabola.imgfmt.sys.FileImgChannel;
import uk.me.parabola.imgfmt.sys.ImgFS;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.CommandArgs;
import uk.me.parabola.mkgmap.combiners.FileKind;
import uk.me.parabola.mkgmap.combiners.OverviewBuilder;
import uk.me.parabola.mkgmap.combiners.SubFileInfo;
import uk.me.parabola.mkgmap.srt.SrtTextReader;

public class FileInfo {
    private static final Logger log = Logger.getLogger(FileInfo.class);
    private static final List<String> KNOWN_FILE_TYPE_EXT = Arrays.asList("TRE", "RGN", "LBL", "NET", "NOD", "TYP");
    private final String filename;
    private FileKind kind;
    private String mapname;
    private int hexname;
    private String innername;
    private String description;
    private int rgnsize;
    private int tresize;
    private int lblsize;
    private int netsize;
    private int nodsize;
    private final List<SubFileInfo> subFiles = new ArrayList<SubFileInfo>();
    private String[] licenceInfo;
    private CommandArgs args;
    private String mpsName;
    private int codePage;
    private int sortOrderId;
    private int demsize;
    private MapReader mapReader;
    private Area bounds;

    private FileInfo(String filename, FileKind kind) {
        this.filename = filename;
        this.kind = kind;
    }

    public String getMapname() {
        return this.mapname;
    }

    protected void setMapname(String mapname) {
        this.mapname = mapname;
    }

    public String getDescription() {
        return this.description;
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    public int getRgnsize() {
        return this.rgnsize;
    }

    protected void setRgnsize(int rgnsize) {
        this.rgnsize = rgnsize;
    }

    public int getTresize() {
        return this.tresize;
    }

    protected void setTresize(int tresize) {
        this.tresize = tresize;
    }

    public int getLblsize() {
        return this.lblsize;
    }

    protected void setLblsize(int lblsize) {
        this.lblsize = lblsize;
    }

    public Area getBounds() {
        return this.bounds;
    }

    public static FileInfo getFileInfo(String inputName) throws FileNotFoundException {
        FileInfo info;
        int end = inputName.length();
        File f = new File(inputName);
        if (f.isDirectory() || end < 3) {
            return new FileInfo(inputName, FileKind.UNKNOWN_KIND);
        }
        String ext = end < 3 ? "" : inputName.substring(end - 3).toUpperCase(Locale.ENGLISH);
        try {
            info = Objects.equals(ext, "IMG") ? FileInfo.imgInfo(inputName) : ("TYP".equals(ext) ? FileInfo.fileInfo(inputName, FileKind.TYP_KIND) : (KNOWN_FILE_TYPE_EXT.contains(ext) ? FileInfo.fileInfo(inputName, FileKind.APP_KIND) : new FileInfo(inputName, FileKind.UNKNOWN_KIND)));
        }
        catch (AssertionError | ReadFailedException e) {
            throw new MapFailedException("Could not read file " + inputName, (Throwable)e);
        }
        return info;
    }

    private static FileInfo fileInfo(String inputName, FileKind kind) {
        FileInfo info = new FileInfo(inputName, kind);
        File f = new File(inputName);
        info.subFiles.add(new SubFileInfo(inputName, f.length()));
        if (inputName.toLowerCase().endsWith(".lbl")) {
            FileInfo.lblInfo(inputName, info);
        } else if (inputName.toLowerCase().endsWith(".typ")) {
            FileInfo.typInfo(inputName, info);
        }
        return info;
    }

    private static void typInfo(String filename, FileInfo info) {
        try (FileImgChannel chan = new FileImgChannel(filename, "r");
             BufferedImgFileReader fr = new BufferedImgFileReader(chan);){
            fr.position(21L);
            info.setCodePage(fr.get2u());
        }
        catch (IOException e) {
            Logger.defaultLogger.error((Object)("Unexpected error reading " + filename), e);
        }
    }

    private static FileInfo imgInfo(String inputName) throws FileNotFoundException {
        try (FileSystem imgFs = ImgFS.openFs(inputName);){
            int dot;
            FileSystemParam params = imgFs.fsparam();
            log.info("Desc", params.getMapDescription());
            log.info("Blocksize", params.getBlockSize());
            FileInfo info = new FileInfo(inputName, FileKind.UNKNOWN_KIND);
            info.setDescription(params.getMapDescription());
            File f = new File(inputName);
            String name = f.getName();
            if (OverviewBuilder.isOverviewImg(name)) {
                name = OverviewBuilder.getMapName(name);
            }
            if ((dot = name.lastIndexOf(46)) < 0) {
                name = "0";
            } else {
                if (dot > name.length()) {
                    dot = name.length();
                }
                if (dot > 8) {
                    dot = 8;
                }
                name = name.substring(0, dot);
            }
            info.setMapname(name);
            boolean hasTre = false;
            DirectoryEntry treEnt = null;
            List<DirectoryEntry> entries = imgFs.list();
            for (DirectoryEntry ent : entries) {
                if (ent.isSpecial()) continue;
                log.info("file", ent.getFullName());
                String ext = ent.getExt();
                if ("TRE".equals(ext)) {
                    info.setTresize(ent.getSize());
                    info.setInnername(ent.getName());
                    hasTre = true;
                    treEnt = ent;
                } else if ("RGN".equals(ext)) {
                    int size = ent.getSize();
                    info.setRgnsize(size);
                } else if ("LBL".equals(ext)) {
                    info.setLblsize(ent.getSize());
                    FileInfo.lblInfo(imgFs, ent, info);
                } else if ("NET".equals(ext)) {
                    info.setNetsize(ent.getSize());
                } else if ("NOD".equals(ext)) {
                    info.setNodsize(ent.getSize());
                } else if ("DEM".equals(ext)) {
                    info.setDemsize(ent.getSize());
                } else if ("MDR".equals(ext)) {
                    info.setKind(FileKind.MDR_KIND);
                } else if ("MPS".equals(ext)) {
                    info.setKind(FileKind.GMAPSUPP_KIND);
                    info.mpsName = ent.getFullName();
                }
                info.subFiles.add(new SubFileInfo(ent.getFullName(), ent.getSize()));
            }
            if (hasTre) {
                FileInfo.treInfo(imgFs, treEnt, info);
            }
            if (info.getKind() == FileKind.UNKNOWN_KIND && hasTre) {
                info.setKind(FileKind.IMG_KIND);
            }
            FileInfo fileInfo = info;
            return fileInfo;
        }
    }

    private static void treInfo(FileSystem imgFs, DirectoryEntry ent, FileInfo info) throws FileNotFoundException {
        try (ImgChannel treChan = imgFs.open(ent.getFullName(), "r");
             TREFileReader treFile = new TREFileReader(treChan);){
            info.setBounds(treFile.getBounds());
            info.setLicenceInfo(treFile.getMapInfo(info.getCodePage()));
            info.setHexname(((TREHeader)treFile.getHeader()).getMapId());
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw new FileNotFoundException();
        }
    }

    private static void lblInfo(FileSystem imgFs, DirectoryEntry ent, FileInfo info) throws FileNotFoundException {
        ImgChannel chan = imgFs.open(ent.getFullName(), "r");
        FileInfo.lblInfo(chan, info);
    }

    private static void lblInfo(String filename, FileInfo info) {
        FileImgChannel r = new FileImgChannel(filename, "r");
        try {
            FileInfo.lblInfo(r, info);
        }
        finally {
            Utils.closeFile(r);
        }
    }

    private static void lblInfo(ImgChannel chan, FileInfo info) {
        try (LBLFileReader lblFile = new LBLFileReader(chan, false, 0);){
            info.setCodePage(lblFile.getCodePage());
            info.setSortOrderId(lblFile.getSortOrderId());
        }
    }

    private void setBounds(Area area) {
        this.bounds = area;
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean isImg() {
        return this.kind == FileKind.IMG_KIND;
    }

    protected void setKind(FileKind kind) {
        this.kind = kind;
    }

    public FileKind getKind() {
        return this.kind;
    }

    public int getMapnameAsInt() {
        try {
            return Integer.valueOf(this.mapname);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public List<SubFileInfo> subFiles() {
        return this.subFiles;
    }

    private void setLicenceInfo(String[] info) {
        this.licenceInfo = info;
    }

    public String[] getLicenseInfo() {
        return this.licenceInfo;
    }

    public int getNetsize() {
        return this.netsize;
    }

    protected void setNetsize(int netsize) {
        this.netsize = netsize;
    }

    public int getNodsize() {
        return this.nodsize;
    }

    protected void setNodsize(int nodsize) {
        this.nodsize = nodsize;
    }

    public void setArgs(CommandArgs args) {
        this.args = args;
    }

    public String getFamilyName() {
        return this.args.get("family-name", "OSM map");
    }

    public String getSeriesName() {
        return this.args.get("series-name", "series name");
    }

    public int getFamilyId() {
        return this.args.get("family-id", 6324);
    }

    public int getProductId() {
        return this.args.get("product-id", 1);
    }

    public Sort getSort() {
        Sort sort = SrtTextReader.sortForCodepage(this.codePage);
        if (sort == null) {
            sort = this.args.getSort();
        }
        sort.setSortOrderId(this.sortOrderId);
        return sort;
    }

    public String getOutputDir() {
        return this.args.getOutputDir();
    }

    public String getMpsName() {
        return this.mpsName;
    }

    public String getInnername() {
        return this.innername;
    }

    public void setInnername(String name) {
        this.innername = name;
    }

    public void setHexname(int hexname) {
        this.hexname = hexname;
    }

    public int getHexname() {
        return this.hexname;
    }

    public int getCodePage() {
        return this.codePage;
    }

    public void setCodePage(int codePage) {
        this.codePage = codePage;
    }

    public void setSortOrderId(int sortOrderId) {
        this.sortOrderId = sortOrderId;
    }

    public boolean hasSortOrder() {
        return this.sortOrderId != 0;
    }

    public String getOverviewName() {
        return this.args.get("overview-mapname", "osmmap");
    }

    public int getDemsize() {
        return this.demsize;
    }

    public void setDemsize(int demsize) {
        this.demsize = demsize;
    }

    public MapReader getMapReader() throws FileNotFoundException {
        if (this.mapReader == null) {
            this.mapReader = new MapReader(this.filename);
        }
        return this.mapReader;
    }

    public void closeMapReader() {
        if (this.mapReader != null) {
            Utils.closeFile(this.mapReader);
            this.mapReader = null;
        }
    }
}

