/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.build;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import uk.me.parabola.imgfmt.ExitException;
import uk.me.parabola.imgfmt.MapFailedException;
import uk.me.parabola.imgfmt.MapTooBigException;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.Exit;
import uk.me.parabola.imgfmt.app.Label;
import uk.me.parabola.imgfmt.app.dem.DEMFile;
import uk.me.parabola.imgfmt.app.lbl.City;
import uk.me.parabola.imgfmt.app.lbl.Country;
import uk.me.parabola.imgfmt.app.lbl.ExitFacility;
import uk.me.parabola.imgfmt.app.lbl.Highway;
import uk.me.parabola.imgfmt.app.lbl.LBLFile;
import uk.me.parabola.imgfmt.app.lbl.POIRecord;
import uk.me.parabola.imgfmt.app.lbl.Region;
import uk.me.parabola.imgfmt.app.lbl.Zip;
import uk.me.parabola.imgfmt.app.net.NETFile;
import uk.me.parabola.imgfmt.app.net.NODFile;
import uk.me.parabola.imgfmt.app.net.Numbers;
import uk.me.parabola.imgfmt.app.net.RoadDef;
import uk.me.parabola.imgfmt.app.net.RoadNetwork;
import uk.me.parabola.imgfmt.app.net.RouteCenter;
import uk.me.parabola.imgfmt.app.trergn.ExtTypeAttributes;
import uk.me.parabola.imgfmt.app.trergn.Overview;
import uk.me.parabola.imgfmt.app.trergn.Point;
import uk.me.parabola.imgfmt.app.trergn.PointOverview;
import uk.me.parabola.imgfmt.app.trergn.Polygon;
import uk.me.parabola.imgfmt.app.trergn.PolygonOverview;
import uk.me.parabola.imgfmt.app.trergn.Polyline;
import uk.me.parabola.imgfmt.app.trergn.PolylineOverview;
import uk.me.parabola.imgfmt.app.trergn.RGNFile;
import uk.me.parabola.imgfmt.app.trergn.Subdivision;
import uk.me.parabola.imgfmt.app.trergn.TREFile;
import uk.me.parabola.imgfmt.app.trergn.Zoom;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.CommandArgs;
import uk.me.parabola.mkgmap.Version;
import uk.me.parabola.mkgmap.build.LayerFilterChain;
import uk.me.parabola.mkgmap.build.Locator;
import uk.me.parabola.mkgmap.build.LocatorUtil;
import uk.me.parabola.mkgmap.build.MapArea;
import uk.me.parabola.mkgmap.build.MapSplitter;
import uk.me.parabola.mkgmap.filters.BaseFilter;
import uk.me.parabola.mkgmap.filters.DouglasPeuckerFilter;
import uk.me.parabola.mkgmap.filters.FilterConfig;
import uk.me.parabola.mkgmap.filters.LineMergeFilter;
import uk.me.parabola.mkgmap.filters.LinePreparerFilter;
import uk.me.parabola.mkgmap.filters.LineSplitterFilter;
import uk.me.parabola.mkgmap.filters.MapFilter;
import uk.me.parabola.mkgmap.filters.MapFilterChain;
import uk.me.parabola.mkgmap.filters.PolygonSplitterFilter;
import uk.me.parabola.mkgmap.filters.RemoveEmpty;
import uk.me.parabola.mkgmap.filters.RemoveObsoletePointsFilter;
import uk.me.parabola.mkgmap.filters.RoundCoordsFilter;
import uk.me.parabola.mkgmap.filters.ShapeMergeFilter;
import uk.me.parabola.mkgmap.filters.SizeFilter;
import uk.me.parabola.mkgmap.general.CityInfo;
import uk.me.parabola.mkgmap.general.LevelInfo;
import uk.me.parabola.mkgmap.general.LoadableMapDataSource;
import uk.me.parabola.mkgmap.general.MapDataSource;
import uk.me.parabola.mkgmap.general.MapElement;
import uk.me.parabola.mkgmap.general.MapExitPoint;
import uk.me.parabola.mkgmap.general.MapLine;
import uk.me.parabola.mkgmap.general.MapPoint;
import uk.me.parabola.mkgmap.general.MapRoad;
import uk.me.parabola.mkgmap.general.MapShape;
import uk.me.parabola.mkgmap.general.ZipCodeInfo;
import uk.me.parabola.mkgmap.reader.MapperBasedMapDataSource;
import uk.me.parabola.mkgmap.reader.hgt.HGTConverter;
import uk.me.parabola.mkgmap.reader.osm.FakeIdGenerator;
import uk.me.parabola.mkgmap.reader.osm.GType;
import uk.me.parabola.mkgmap.reader.osm.GeneralRelation;
import uk.me.parabola.mkgmap.reader.osm.MultiPolygonRelation;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.mkgmap.reader.overview.OverviewMapDataSource;
import uk.me.parabola.util.Configurable;
import uk.me.parabola.util.EnhancedProperties;
import uk.me.parabola.util.Java2DConverter;
import uk.me.parabola.util.ShapeSplitter;

public class MapBuilder
implements Configurable {
    private static final Logger log = Logger.getLogger(MapBuilder.class);
    private static final int CLEAR_TOP_BITS = 17;
    private static final LocalDateTime now = LocalDateTime.now();
    private static final int MIN_SIZE_LINE = 1;
    private final boolean isOverviewComponent;
    private final boolean isOverviewCombined;
    private final Map<MapPoint, POIRecord> poimap = new HashMap<MapPoint, POIRecord>();
    private final Map<MapPoint, City> cityMap = new HashMap<MapPoint, City>();
    private List<String> mapInfo = new ArrayList<String>();
    private List<String> copyrights = new ArrayList<String>();
    private boolean hasNet;
    private Boolean driveOnLeft;
    private Locator locator;
    private final Map<String, Highway> highways = new HashMap<String, Highway>();
    private static final String UNKNOWN_CITY_NAME = "";
    private Country defaultCountry;
    private String countryName = "COUNTRY";
    private String countryAbbr = "ABC";
    private String regionName = null;
    private String regionAbbr;
    private Set<String> locationAutofill = Collections.emptySet();
    private int minSizePolygon;
    private String polygonSizeLimitsOpt;
    private TreeMap<Integer, Integer> polygonSizeLimits;
    private TreeMap<Integer, Double> dpFilterLineResMap;
    private TreeMap<Integer, Double> dpFilterShapeResMap;
    private boolean mergeLines;
    private boolean mergeShapes;
    private boolean poiAddresses;
    private int poiDisplayFlags;
    private boolean enableLineCleanFilters = true;
    private boolean makePOIIndex;
    private int routeCenterBoundaryType;
    private LBLFile lblFile;
    private String licenseFileName;
    private boolean orderByDecreasingArea;
    private String pathsToHGT;
    private List<Integer> demDists;
    private short demOutsidePolygonHeight;
    private Area demPolygon;
    private HGTConverter.InterpolationMethod demInterpolationMethod;
    private boolean allowReverseMerge;
    private boolean improveOverview;

    public MapBuilder(boolean overviewComponent, boolean overviewCombined) {
        this.locator = new Locator();
        this.isOverviewComponent = overviewComponent;
        this.isOverviewCombined = overviewCombined;
    }

    @Override
    public void config(EnhancedProperties props) {
        String ipm;
        this.countryName = props.getProperty("country-name", this.countryName);
        this.countryAbbr = props.getProperty("country-abbr", this.countryAbbr);
        this.regionName = props.getProperty("region-name", null);
        this.regionAbbr = props.getProperty("region-abbr", null);
        this.minSizePolygon = props.getProperty("min-size-polygon", 8);
        this.polygonSizeLimitsOpt = props.getProperty("polygon-size-limits", null);
        double reducePointError = props.getProperty("reduce-point-density", 2.6);
        double reducePointErrorPolygon = props.getProperty("reduce-point-density-polygon", -1);
        if (reducePointErrorPolygon == -1.0) {
            reducePointErrorPolygon = reducePointError;
        }
        this.dpFilterLineResMap = this.parseLevelOption(props, "simplify-lines", reducePointError);
        this.dpFilterShapeResMap = this.parseLevelOption(props, "simplify-polygons", reducePointErrorPolygon);
        this.mergeLines = props.containsKey("merge-lines");
        this.allowReverseMerge = props.getProperty("allow-reverse-merge", false);
        this.mergeShapes = !props.getProperty("no-mergeshapes", false);
        this.improveOverview = props.getProperty("improve-overview", false);
        this.makePOIIndex = props.getProperty("make-poi-index", false);
        if (props.getProperty("poi-address") != null) {
            this.poiAddresses = true;
        }
        this.routeCenterBoundaryType = props.getProperty("route-center-boundary", 0);
        this.licenseFileName = props.getProperty("license-file", null);
        this.locationAutofill = LocatorUtil.parseAutofillOption(props);
        this.locator = new Locator(props);
        this.locator.setDefaultCountry(this.countryName, this.countryAbbr);
        String driveOn = props.getProperty("drive-on", null);
        if ("left".equals(driveOn)) {
            this.driveOnLeft = true;
        }
        if ("right".equals(driveOn)) {
            this.driveOnLeft = false;
        }
        this.orderByDecreasingArea = props.getProperty("order-by-decreasing-area", false);
        this.pathsToHGT = props.getProperty("dem", null);
        String demDistStr = props.getProperty("dem-dists", "-1");
        this.demOutsidePolygonHeight = (short)props.getProperty("dem-outside-polygon", Short.MIN_VALUE);
        String demPolygonFile = props.getProperty("dem-poly", null);
        if (demPolygonFile != null) {
            this.demPolygon = Java2DConverter.readPolyFile(demPolygonFile);
        }
        switch (ipm = props.getProperty("dem-interpolation", "auto")) {
            case "auto": {
                this.demInterpolationMethod = HGTConverter.InterpolationMethod.AUTOMATIC;
                break;
            }
            case "bicubic": {
                this.demInterpolationMethod = HGTConverter.InterpolationMethod.BICUBIC;
                break;
            }
            case "bilinear": {
                this.demInterpolationMethod = HGTConverter.InterpolationMethod.BILINEAR;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid argument for option dem-interpolation: '" + ipm + "' supported are 'bilinear', 'bicubic', or 'auto'");
            }
        }
        if (this.isOverviewCombined) {
            demDistStr = props.getProperty("overview-dem-dist", "-1");
            this.mergeLines = true;
            if (this.orderByDecreasingArea) {
                this.orderByDecreasingArea = false;
                this.mergeShapes = false;
            } else {
                this.mergeShapes = true;
            }
        }
        this.demDists = MapBuilder.parseDemDists(demDistStr);
    }

    private static List<Integer> parseDemDists(String demDists) {
        List<Integer> dists = CommandArgs.stringToList(demDists, "dem-dists").stream().map(Integer::parseInt).collect(Collectors.toList());
        if (dists.isEmpty()) {
            return Arrays.asList(-1);
        }
        return dists;
    }

    public void makeMap(uk.me.parabola.imgfmt.app.map.Map map, LoadableMapDataSource src) {
        RGNFile rgnFile = map.getRgnFile();
        TREFile treFile = map.getTreFile();
        this.lblFile = map.getLblFile();
        NETFile netFile = map.getNetFile();
        boolean bl = this.hasNet = netFile != null;
        if (this.routeCenterBoundaryType != 0 && netFile != null && src instanceof MapperBasedMapDataSource) {
            for (RouteCenter rc : src.getRoadNetwork().getCenters()) {
                ((MapperBasedMapDataSource)((Object)src)).addBoundaryLine(rc.getArea(), this.routeCenterBoundaryType, rc.reportSizes());
            }
        }
        if (this.mapInfo.isEmpty()) {
            this.getMapInfo();
        }
        if (map.getNodFile() != null) {
            src.getRoadNetwork().getCenters();
        }
        this.normalizeCountries(src);
        this.processCities(map, src);
        this.processRoads(map, src);
        this.processPOIs(map, src);
        this.processOverviews(map, src);
        this.processInfo(map, src);
        this.makeMapAreas(map, src);
        if (this.driveOnLeft == null && src instanceof MapperBasedMapDataSource) {
            this.driveOnLeft = ((MapperBasedMapDataSource)((Object)src)).getDriveOnLeft();
        }
        if (this.driveOnLeft == null) {
            this.driveOnLeft = false;
        }
        treFile.setDriveOnLeft(this.driveOnLeft);
        treFile.setLastRgnPos(rgnFile.position() - 125);
        rgnFile.write();
        treFile.write(rgnFile.haveExtendedTypes());
        this.lblFile.write();
        this.lblFile.writePost();
        if (netFile != null) {
            RoadNetwork network = src.getRoadNetwork();
            netFile.setNetwork(network.getRoadDefs());
            NODFile nodFile = map.getNodFile();
            if (nodFile != null) {
                nodFile.setNetwork(network.getCenters(), network.getRoadDefs(), network.getBoundary());
                nodFile.setDriveOnLeft(this.driveOnLeft);
                nodFile.write();
            }
            netFile.write(this.lblFile.numCities(), this.lblFile.numZips());
            if (nodFile != null) {
                nodFile.writePost();
            }
            netFile.writePost(rgnFile.getWriter());
        }
        this.warnAbout3ByteImgRefs();
        this.buildDem(map, src);
        treFile.writePost();
    }

    private void buildDem(uk.me.parabola.imgfmt.app.map.Map map, LoadableMapDataSource src) {
        DEMFile demFile = map.getDemFile();
        if (demFile == null) {
            return;
        }
        if (this.demDists.size() > src.mapLevels().length) {
            throw new MapFailedException("More dem-dist values than levels: \n\t" + this.demDists + "\n\t" + Arrays.toString(src.mapLevels()) + "\n");
        }
        try {
            Path2D demPoly;
            uk.me.parabola.imgfmt.app.Area bbox;
            Rectangle r;
            long t1 = System.currentTimeMillis();
            Area demArea = null;
            if (this.demPolygon != null && this.demPolygon.intersects(r = new Rectangle((bbox = src.getBounds()).getMinLong() - 2, bbox.getMinLat() - 2, bbox.getWidth() + 4, bbox.getHeight() + 4)) && !this.demPolygon.contains(r)) {
                demArea = this.demPolygon;
            }
            if (demArea == null && this.isOverviewCombined && (demPoly = ((OverviewMapDataSource)src).getTileAreaPath()) != null) {
                demArea = new Area(demPoly);
            }
            uk.me.parabola.imgfmt.app.Area treArea = demFile.calc(src.getBounds(), demArea, this.pathsToHGT, this.demDists, this.demOutsidePolygonHeight, this.demInterpolationMethod);
            map.setBounds(treArea);
            long t2 = System.currentTimeMillis();
            log.info("DEM file calculation for", map.getFilename(), "took", t2 - t1, "ms");
            demFile.write();
        }
        catch (MapTooBigException e) {
            throw new MapTooBigException(e.getMaxAllowedSize(), "The DEM section of the map or tile is too big.", "Try increasing the DEM distance.");
        }
        catch (MapFailedException e) {
            throw new MapFailedException("Error creating DEM File. " + e.getMessage());
        }
    }

    private void warnAbout3ByteImgRefs() {
        String mapContains = "Map contains";
        String infoMsg = "- more than 65535 might cause indexing problems and excess size. Suggest splitter with lower --max-nodes";
        int itemCount = this.lblFile.numCities();
        if (itemCount > 65535) {
            log.error(mapContains, itemCount, "Cities", infoMsg);
        }
        if ((itemCount = this.lblFile.numZips()) > 65535) {
            log.error(mapContains, itemCount, "Zips", infoMsg);
        }
        if ((itemCount = this.lblFile.numHighways()) > 65535) {
            log.error(mapContains, itemCount, "Highways", infoMsg);
        }
        if ((itemCount = this.lblFile.numExitFacilities()) > 65535) {
            log.error(mapContains, itemCount, "Exit facilities", infoMsg);
        }
    }

    private Country getDefaultCountry() {
        if (this.defaultCountry == null && this.lblFile != null) {
            this.defaultCountry = this.lblFile.createCountry(this.countryName, this.countryAbbr);
        }
        return this.defaultCountry;
    }

    private Region getDefaultRegion(Country country) {
        if (this.lblFile == null || this.regionName == null) {
            return null;
        }
        if (country == null) {
            if (this.getDefaultCountry() == null) {
                return null;
            }
            return this.lblFile.createRegion(this.getDefaultCountry(), this.regionName, this.regionAbbr);
        }
        return this.lblFile.createRegion(country, this.regionName, this.regionAbbr);
    }

    private void normalizeCountries(MapDataSource src) {
        String countryStr;
        for (MapPoint p : src.getPoints()) {
            countryStr = p.getCountry();
            if (countryStr == null) continue;
            countryStr = this.locator.normalizeCountry(countryStr);
            p.setCountry(countryStr);
        }
        for (MapLine l : src.getLines()) {
            countryStr = l.getCountry();
            if (countryStr == null) continue;
            countryStr = this.locator.normalizeCountry(countryStr);
            l.setCountry(countryStr);
        }
    }

    private void processCities(uk.me.parabola.imgfmt.app.map.Map map, MapDataSource src) {
        LBLFile lbl = map.getLblFile();
        if (!this.locationAutofill.isEmpty()) {
            for (MapPoint p : src.getPoints()) {
                if (!p.isCity() || p.getName() == null) continue;
                this.locator.addCityOrPlace(p);
            }
            this.locator.autofillCities();
        }
        for (MapPoint p : src.getPoints()) {
            if (!p.isCity() || p.getName() == null) continue;
            String countryStr = p.getCountry();
            Country thisCountry = countryStr != null ? lbl.createCountry(countryStr, this.locator.getCountryISOCode(countryStr)) : this.getDefaultCountry();
            String regionStr = p.getRegion();
            Region thisRegion = regionStr != null ? lbl.createRegion(thisCountry, regionStr, null) : this.getDefaultRegion(thisCountry);
            City thisCity = thisRegion != null ? lbl.createCity(thisRegion, p.getName(), true) : lbl.createCity(thisCountry, p.getName(), true);
            this.cityMap.put(p, thisCity);
        }
    }

    private void processRoads(uk.me.parabola.imgfmt.app.map.Map map, MapDataSource src) {
        LBLFile lbl = map.getLblFile();
        MapPoint searchPoint = new MapPoint();
        for (MapLine line : src.getLines()) {
            if (!line.isRoad()) continue;
            String cityName = line.getCity();
            String cityCountryName = line.getCountry();
            String cityRegionName = line.getRegion();
            String zipStr = line.getZip();
            if (cityName == null && this.locationAutofill.contains("nearest")) {
                searchPoint.setLocation(line.getLocation());
                MapPoint nextCity = this.locator.findNextPoint(searchPoint);
                if (nextCity != null) {
                    cityName = nextCity.getCity();
                    cityCountryName = nextCity.getCountry();
                    cityRegionName = nextCity.getRegion();
                    if (zipStr == null) {
                        zipStr = nextCity.getZip();
                    }
                }
            }
            MapRoad road = (MapRoad)line;
            road.resetImgData();
            City roadCity = this.calcCity(lbl, cityName, cityRegionName, cityCountryName);
            if (roadCity != null) {
                road.addRoadCity(roadCity);
            }
            if (zipStr != null) {
                road.addRoadZip(lbl.createZip(zipStr));
            }
            this.processRoadNumbers(road, lbl);
        }
    }

    private void processRoadNumbers(MapRoad road, LBLFile lbl) {
        List<Numbers> numbers = road.getRoadDef().getNumbersList();
        if (numbers == null) {
            return;
        }
        for (Numbers num : numbers) {
            for (int i = 0; i < 2; ++i) {
                CityInfo cityInfo;
                boolean leftRightFlag = i == 0;
                ZipCodeInfo zipInfo = num.getZipCodeInfo(leftRightFlag);
                if (zipInfo != null && zipInfo.getZipCode() != null) {
                    Zip zip = zipInfo.getImgZip();
                    if (zip == null) {
                        zip = lbl.createZip(zipInfo.getZipCode());
                        zipInfo.setImgZip(zip);
                    }
                    if (zip != null) {
                        road.addRoadZip(zip);
                    }
                }
                if ((cityInfo = num.getCityInfo(leftRightFlag)) == null) continue;
                City city = cityInfo.getImgCity();
                if (city == null) {
                    city = this.calcCity(lbl, cityInfo.getCity(), cityInfo.getRegion(), cityInfo.getCountry());
                    cityInfo.setImgCity(city);
                }
                if (city == null) continue;
                road.addRoadCity(city);
            }
        }
    }

    private City calcCity(LBLFile lbl, String city, String region, String country) {
        Region cr;
        if (city == null && region == null && country == null) {
            return null;
        }
        Country cc = country == null ? this.getDefaultCountry() : lbl.createCountry(this.locator.normalizeCountry(country), this.locator.getCountryISOCode(country));
        Region region2 = cr = region == null ? this.getDefaultRegion(cc) : lbl.createRegion(cc, region, null);
        if (city == null) {
            city = UNKNOWN_CITY_NAME;
        }
        if (cr != null) {
            return lbl.createCity(cr, city, false);
        }
        return lbl.createCity(cc, city, false);
    }

    private void processPOIs(uk.me.parabola.imgfmt.app.map.Map map, MapDataSource src) {
        LBLFile lbl = map.getLblFile();
        boolean checkedForPoiDispFlag = false;
        for (MapPoint p : src.getPoints()) {
            String phone;
            String houseNumber;
            if (p.isExit()) {
                this.processExit(map, (MapExitPoint)p);
                continue;
            }
            if (p.isCity() || p.hasExtendedType() || !this.poiAddresses) continue;
            String countryStr = p.getCountry();
            String regionStr = p.getRegion();
            String zipStr = p.getZip();
            String cityStr = p.getCity();
            if (this.locationAutofill.contains("nearest") && (countryStr == null || regionStr == null || zipStr == null && cityStr == null)) {
                MapPoint nextCity = this.locator.findNearbyCityByName(p);
                if (nextCity == null) {
                    nextCity = this.locator.findNextPoint(p);
                }
                if (nextCity != null) {
                    String cityZipStr;
                    if (countryStr == null) {
                        countryStr = nextCity.getCountry();
                    }
                    if (regionStr == null) {
                        regionStr = nextCity.getRegion();
                    }
                    if (zipStr == null && (cityZipStr = nextCity.getZip()) != null && cityZipStr.indexOf(44) < 0) {
                        zipStr = cityZipStr;
                    }
                    if (cityStr == null) {
                        cityStr = nextCity.getCity();
                    }
                }
            }
            if (countryStr != null && !checkedForPoiDispFlag) {
                this.poiDisplayFlags = this.locator.getPOIDispFlag(countryStr);
                checkedForPoiDispFlag = true;
            }
            POIRecord r = lbl.createPOI(p.getName());
            if (cityStr != null || regionStr != null || countryStr != null) {
                r.setCity(this.calcCity(lbl, cityStr, regionStr, countryStr));
            }
            if (zipStr != null) {
                Zip zip = lbl.createZip(zipStr);
                r.setZip(zip);
            }
            if (p.getStreet() != null) {
                Label streetName = lbl.newLabel(p.getStreet());
                r.setStreetName(streetName);
            }
            if ((houseNumber = p.getHouseNumber()) != null && !houseNumber.isEmpty() && !r.setSimpleStreetNumber(houseNumber)) {
                r.setComplexStreetNumber(lbl.newLabel(houseNumber));
            }
            if ((phone = p.getPhone()) != null && !phone.isEmpty() && !r.setSimplePhoneNumber(phone)) {
                r.setComplexPhoneNumber(lbl.newLabel(phone));
            }
            this.poimap.put(p, r);
        }
        lbl.allPOIsDone();
    }

    private void processExit(uk.me.parabola.imgfmt.app.map.Map map, MapExitPoint mep) {
        LBLFile lbl = map.getLblFile();
        String exitName = mep.getName();
        String ref = mep.getMotorwayRef();
        String osmId = mep.getOSMId();
        if (ref == null) {
            log.warn("Can't create exit", exitName, "(OSM id", osmId, ") doesn't have exit:road_ref tag");
        } else {
            Highway hw = this.highways.get(ref);
            if (hw == null) {
                String countryStr = mep.getCountry();
                Country thisCountry = countryStr != null ? lbl.createCountry(this.locator.normalizeCountry(countryStr), this.locator.getCountryISOCode(countryStr)) : this.getDefaultCountry();
                String regionStr = this.regionName != null ? this.regionName : mep.getRegion();
                Region thisRegion = regionStr != null ? lbl.createRegion(thisCountry, regionStr, null) : this.getDefaultRegion(thisCountry);
                hw = lbl.createHighway(thisRegion, ref);
                log.info("creating highway", ref, "region:", regionStr, "country:", countryStr, "for exit:", exitName);
                this.highways.put(ref, hw);
            }
            String exitTo = mep.getTo();
            Exit exit = new Exit(hw);
            String facilityDescription = mep.getFacilityDescription();
            log.info("Creating", ref, "exit", exitName, "(OSM id", osmId + ") to", exitTo, "with facility", facilityDescription == null ? "(none)" : facilityDescription);
            if (facilityDescription != null) {
                String[] atts = facilityDescription.split(",");
                int type = 0;
                if (atts.length > 0) {
                    type = Integer.decode(atts[0]);
                }
                char direction = ' ';
                if (atts.length > 1 && (direction = (char)atts[1].charAt(0)) == '\'' && atts[1].length() > 1) {
                    direction = atts[1].charAt(1);
                }
                int facilities = 0;
                if (atts.length > 2) {
                    facilities = Integer.decode(atts[2]);
                }
                String description = UNKNOWN_CITY_NAME;
                if (atts.length > 3) {
                    description = atts[3];
                }
                boolean last = true;
                ExitFacility ef = lbl.createExitFacility(type, direction, facilities, description, last);
                exit.addFacility(ef);
            }
            mep.setExit(exit);
            POIRecord r = lbl.createExitPOI(exitName, exit);
            if (exitTo != null) {
                Label ed = lbl.newLabel(exitTo);
                exit.setDescription(ed);
            }
            this.poimap.put(mep, r);
        }
    }

    private void makeMapAreas(uk.me.parabola.imgfmt.app.map.Map map, LoadableMapDataSource src) {
        Subdivision topdiv;
        LevelInfo[] levels = null;
        if (this.isOverviewCombined) {
            if (this.mergeShapes) {
                MapBuilder.prepShapesForMerge(src.getShapes());
            }
            levels = src.mapLevels();
        } else {
            levels = this.isOverviewComponent ? src.overviewMapLevels() : src.mapLevels();
        }
        if (levels == null) {
            throw new ExitException("no info about levels available.");
        }
        LevelInfo levelInfo = levels[0];
        if (levelInfo.isTop()) {
            levels = Arrays.copyOfRange(levels, 1, levels.length);
            Zoom zoom = map.createZoom(levelInfo.getLevel(), levelInfo.getBits());
            topdiv = MapBuilder.makeTopArea(src, map, zoom);
        } else {
            int maxBits = MapBuilder.getMaxBits(src);
            if (levelInfo.getBits() <= maxBits) {
                maxBits = levelInfo.getBits() - 1;
            }
            Zoom zoom = map.createZoom(levelInfo.getLevel() + 1, maxBits);
            topdiv = MapBuilder.makeTopArea(src, map, zoom);
        }
        List<SourceSubdiv> srcList = Collections.singletonList(new SourceSubdiv(src, topdiv));
        if (this.mergeShapes && this.improveOverview && this.isOverviewComponent) {
            this.recalcMultipolygons(src, levels);
        }
        src.getShapes().forEach(s -> s.setMpRel(null));
        for (LevelInfo linfo : levels) {
            ArrayList<SourceSubdiv> nextList = new ArrayList<SourceSubdiv>();
            Zoom zoom = map.createZoom(linfo.getLevel(), linfo.getBits());
            for (SourceSubdiv srcDivPair : srcList) {
                MapSplitter splitter = new MapSplitter(srcDivPair.getSource(), zoom);
                MapArea[] areas = splitter.split(this.orderByDecreasingArea);
                log.info("Map region", srcDivPair.getSource().getBounds(), "split into", areas.length, "areas at resolution", zoom.getResolution());
                for (MapArea area : areas) {
                    Subdivision parent = srcDivPair.getSubdiv();
                    Subdivision div = this.makeSubdivision(map, parent, area, zoom);
                    if (log.isDebugEnabled()) {
                        log.debug("ADD parent-subdiv", parent, srcDivPair.getSource(), ", z=", zoom, "new=", div);
                    }
                    nextList.add(new SourceSubdiv(area, div));
                }
                if (nextList.isEmpty()) continue;
                Subdivision lastdiv = ((SourceSubdiv)nextList.get(nextList.size() - 1)).getSubdiv();
                lastdiv.setLast(true);
            }
            srcList = nextList;
        }
    }

    private static void prepShapesForMerge(List<MapShape> shapes) {
        Long2ObjectOpenHashMap<Coord> coordMap = new Long2ObjectOpenHashMap<Coord>();
        for (MapShape s : shapes) {
            List<Coord> points = s.getPoints();
            int n = points.size();
            for (int i = 0; i < n; ++i) {
                Coord co = points.get(i);
                long key = Utils.coord2Long(co);
                Coord repl = (Coord)coordMap.get(key);
                if (repl == null) {
                    coordMap.put(key, co);
                    continue;
                }
                points.set(i, repl);
            }
        }
    }

    private static Subdivision makeTopArea(MapDataSource src, uk.me.parabola.imgfmt.app.map.Map map, Zoom zoom) {
        Subdivision topdiv = map.topLevelSubdivision(src.getBounds(), zoom);
        topdiv.setLast(true);
        return topdiv;
    }

    private Subdivision makeSubdivision(uk.me.parabola.imgfmt.app.map.Map map, Subdivision parent, MapArea ma, Zoom z) {
        List<MapPoint> points = ma.getPoints();
        List<MapLine> lines = ma.getLines();
        List<MapShape> shapes = ma.getShapes();
        Subdivision div = map.createSubdivision(parent, ma.getFullBounds(), z);
        if (ma.hasPoints()) {
            div.setHasPoints(true);
        }
        if (ma.hasIndPoints()) {
            div.setHasIndPoints(true);
        }
        if (ma.hasLines()) {
            div.setHasPolylines(true);
        }
        if (ma.hasShapes()) {
            div.setHasPolygons(true);
        }
        div.startDivision();
        this.processPoints(map, div, points);
        int res = z.getResolution();
        lines = lines.stream().filter(l -> l.getMinResolution() <= res).collect(Collectors.toList());
        shapes = shapes.stream().filter(s -> s.getMinResolution() <= res).collect(Collectors.toList());
        if (this.mergeLines) {
            LineMergeFilter merger = new LineMergeFilter();
            lines = merger.merge(lines, res, !this.hasNet, this.allowReverseMerge);
        }
        if (this.mergeShapes) {
            ShapeMergeFilter shapeMergeFilter = new ShapeMergeFilter(res, this.orderByDecreasingArea);
            shapes = shapeMergeFilter.merge(shapes);
        }
        shapes.forEach(e -> e.getPoints().forEach(p -> p.preserved(false)));
        if (z.getLevel() == 0 && this.hasNet) {
            lines.forEach(e -> e.getPoints().forEach(p -> p.preserved(p.isNumberNode())));
        } else {
            lines.forEach(e -> e.getPoints().forEach(p -> p.preserved(false)));
        }
        MapBuilder.preserveFirstLast(lines);
        if (res < 24) {
            MapBuilder.preserveHorizontalAndVerticalLines(res, shapes);
        }
        this.processLines(map, div, lines);
        this.processShapes(map, div, shapes);
        div.endDivision();
        return div;
    }

    private static void preserveFirstLast(List<MapLine> lines) {
        for (MapLine l : lines) {
            l.getPoints().get(0).preserved(true);
            l.getPoints().get(l.getPoints().size() - 1).preserved(true);
        }
    }

    protected void processOverviews(uk.me.parabola.imgfmt.app.map.Map map, MapDataSource src) {
        List<Overview> features = src.getOverviews();
        for (Overview ov : features) {
            switch (ov.getKind()) {
                case 1: {
                    map.addPointOverview((PointOverview)ov);
                    break;
                }
                case 2: {
                    map.addPolylineOverview((PolylineOverview)ov);
                    break;
                }
                case 3: {
                    map.addPolygonOverview((PolygonOverview)ov);
                    break;
                }
            }
        }
    }

    private void getMapInfo() {
        if (this.licenseFileName != null) {
            List<Object> licenseArray = new ArrayList();
            try {
                File file = new File(this.licenseFileName);
                licenseArray = Files.readAllLines(file.toPath(), StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                throw new ExitException("Error reading license file " + this.licenseFileName, e);
            }
            if (!licenseArray.isEmpty() && ((String)licenseArray.get(0)).startsWith("\ufeff")) {
                licenseArray.set(0, ((String)licenseArray.get(0)).substring(1));
            }
            UnaryOperator replaceVariables = s -> s.replace("$MKGMAP_VERSION$", Version.VERSION).replace("$JAVA_VERSION$", System.getProperty("java.version")).replace("$YEAR$", Integer.toString(now.getYear())).replace("$LONGDATE$", now.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.LONG))).replace("$SHORTDATE$", now.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT))).replace("$TIME$", now.toLocalTime().toString().substring(0, 5));
            licenseArray.replaceAll(replaceVariables);
            this.mapInfo.addAll(licenseArray);
        } else {
            this.mapInfo.add("Map data (c) OpenStreetMap and its contributors");
            this.mapInfo.add("http://www.openstreetmap.org/copyright");
            this.mapInfo.add(UNKNOWN_CITY_NAME);
            this.mapInfo.add("This map data is made available under the Open Database License:");
            this.mapInfo.add("http://opendatacommons.org/licenses/odbl/1.0/");
            this.mapInfo.add("Any rights in individual contents of the database are licensed under the");
            this.mapInfo.add("Database Contents License: http://opendatacommons.org/licenses/dbcl/1.0/");
            this.mapInfo.add(UNKNOWN_CITY_NAME);
            this.mapInfo.add("Map created with mkgmap-r" + String.format("%-10s", Version.VERSION));
            this.mapInfo.add("Program released under the GPL");
        }
    }

    public void setMapInfo(List<String> msgs) {
        this.mapInfo = msgs;
    }

    public void setCopyrights(List<String> msgs) {
        this.copyrights = msgs;
    }

    private void processInfo(uk.me.parabola.imgfmt.app.map.Map map, LoadableMapDataSource src) {
        map.setBounds(src.getBounds());
        if (!this.isOverviewCombined) {
            this.poiDisplayFlags |= 1;
        }
        this.poiDisplayFlags |= src.getPoiDispFlag();
        if (this.poiDisplayFlags != 0) {
            map.addPoiDisplayFlags(this.poiDisplayFlags);
        }
        StringBuilder info = new StringBuilder();
        for (String string : this.mapInfo) {
            info.append(string.trim()).append('\n');
        }
        if (info.length() > 0) {
            map.addInfo(info.toString());
        }
        if (this.copyrights.isEmpty()) {
            String[] copyrightMessages = src.copyrightMessages();
            if (copyrightMessages.length < 2) {
                map.addCopyright("program licenced under GPL v2");
            }
            for (String cm : copyrightMessages) {
                map.addCopyright(cm);
            }
        } else {
            for (String string : this.copyrights) {
                map.addCopyright(string);
            }
        }
    }

    private void processPoints(uk.me.parabola.imgfmt.app.map.Map map, Subdivision div, List<MapPoint> points) {
        Point p;
        String name;
        LBLFile lbl = map.getLblFile();
        div.startPoints();
        int res = div.getResolution();
        boolean haveIndPoints = false;
        int pointIndex = 1;
        for (MapPoint point : points) {
            if (!point.isCity() || point.getMinResolution() > res) continue;
            ++pointIndex;
            haveIndPoints = true;
        }
        for (MapPoint point : points) {
            ExtTypeAttributes eta;
            if (point.isCity() || point.getMinResolution() > res) continue;
            name = point.getName();
            p = div.createPoint(name);
            p.setType(point.getType());
            if (point.hasExtendedType() && (eta = point.getExtTypeAttributes()) != null) {
                eta.processLabels(lbl);
                p.setExtTypeAttributes(eta);
            }
            Coord coord = point.getLocation();
            try {
                p.setLatitude(coord.getLatitude());
                p.setLongitude(coord.getLongitude());
            }
            catch (AssertionError ae) {
                log.error((Object)("Problem with point of type 0x" + Integer.toHexString(point.getType()) + " at " + coord.toOSMURL()));
                log.error((Object)("  Subdivision shift is " + div.getShift() + " and its centre is at " + div.getCenter().toOSMURL()));
                log.error((Object)("  " + ((Throwable)((Object)ae)).getMessage()));
                continue;
            }
            POIRecord r = this.poimap.get(point);
            if (r != null) {
                p.setPOIRecord(r);
            }
            map.addMapObject(p);
            if (point.hasExtendedType()) continue;
            if (name != null && div.getZoom().getLevel() == 0) {
                if (pointIndex > 255) {
                    log.error("Too many POIs near location", div.getCenter().toOSMURL(), "-", name, "will be ignored");
                } else if (point.isExit()) {
                    Exit e = ((MapExitPoint)point).getExit();
                    if (e != null) {
                        e.getHighway().addExitPoint(name, pointIndex, div);
                    }
                } else if (this.makePOIIndex) {
                    lbl.createPOIIndex(name, pointIndex, div, point.getType());
                }
            }
            ++pointIndex;
        }
        if (haveIndPoints) {
            div.startIndPoints();
            pointIndex = 1;
            for (MapPoint point : points) {
                if (!point.isCity() || point.getMinResolution() > res) continue;
                name = point.getName();
                p = div.createPoint(name);
                int fullType = point.getType();
                assert ((fullType & 0xFF) == 0) : "indPoint " + GType.formatType(fullType) + " has subtype";
                p.setType(fullType);
                Coord coord = point.getLocation();
                try {
                    p.setLatitude(coord.getLatitude());
                    p.setLongitude(coord.getLongitude());
                }
                catch (AssertionError ae) {
                    log.error((Object)("Problem with point of type 0x" + Integer.toHexString(point.getType()) + " at " + coord.toOSMURL()));
                    log.error((Object)("  Subdivision shift is " + div.getShift() + " and its centre is at " + div.getCenter().toOSMURL()));
                    log.error((Object)("  " + ((Throwable)((Object)ae)).getMessage()));
                    continue;
                }
                map.addMapObject(p);
                if (name != null && div.getZoom().getLevel() == 0) {
                    City c = this.cityMap.get(point);
                    if (pointIndex > 255) {
                        log.error("Can't set city point index for", name, "(too many indexed points in division)\n");
                    } else {
                        c.setPointIndex(pointIndex);
                        c.setSubdivision(div);
                    }
                }
                ++pointIndex;
            }
        }
    }

    private void processLines(uk.me.parabola.imgfmt.app.map.Map map, Subdivision div, List<MapLine> lines) {
        div.startLines();
        int res = div.getResolution();
        FilterConfig config = new FilterConfig();
        config.setResolution(res);
        config.setLevel(div.getZoom().getLevel());
        config.setHasNet(this.hasNet);
        LayerFilterChain normalFilters = new LayerFilterChain(config);
        LayerFilterChain keepParallelFilters = new LayerFilterChain(config);
        DouglasPeuckerFilter dp = null;
        if (this.enableLineCleanFilters && res < 24) {
            RoundCoordsFilter rounder = new RoundCoordsFilter();
            SizeFilter sizeFilter = new SizeFilter(1);
            normalFilters.addFilter(rounder);
            normalFilters.addFilter(sizeFilter);
            double errorForRes = this.dpFilterLineResMap.ceilingEntry(res).getValue();
            if (errorForRes > 0.0) {
                dp = new DouglasPeuckerFilter(errorForRes);
                keepParallelFilters.addFilter(dp);
            }
            keepParallelFilters.addFilter(rounder);
            keepParallelFilters.addFilter(sizeFilter);
        }
        RemoveObsoletePointsFilter removeObsolete = new RemoveObsoletePointsFilter();
        normalFilters.addFilter(removeObsolete);
        keepParallelFilters.addFilter(removeObsolete);
        if (dp != null) {
            normalFilters.addFilter(dp);
        }
        for (MapFilter filter : Arrays.asList(new RemoveEmpty(), new LineSplitterFilter(), new LinePreparerFilter(div), new LineAddFilter(div, map))) {
            normalFilters.addFilter(filter);
            keepParallelFilters.addFilter(filter);
        }
        for (MapLine line : lines) {
            if (line.getMinResolution() > res) continue;
            if (GType.isContourLine(line) || this.isOverviewComponent) {
                keepParallelFilters.startFilter(line);
                continue;
            }
            normalFilters.startFilter(line);
        }
    }

    private void processShapes(uk.me.parabola.imgfmt.app.map.Map map, Subdivision div, List<MapShape> shapes) {
        div.startShapes();
        int res = div.getResolution();
        FilterConfig config = new FilterConfig();
        config.setResolution(res);
        config.setLevel(div.getZoom().getLevel());
        config.setHasNet(this.hasNet);
        if (this.orderByDecreasingArea && shapes.size() > 1) {
            shapes.sort((s1, s2) -> Long.compare(Math.abs(s2.getFullArea()), Math.abs(s1.getFullArea())));
        }
        LayerFilterChain filters = new LayerFilterChain(config);
        filters.addFilter(new PolygonSplitterFilter());
        if (this.enableLineCleanFilters && res < 24) {
            filters.addFilter(new RoundCoordsFilter());
        }
        filters.addFilter(new RemoveObsoletePointsFilter());
        if (this.enableLineCleanFilters && res < 24) {
            double errorForRes;
            int sizefilterVal = this.getMinSizePolygonForResolution(res);
            if (sizefilterVal > 0) {
                filters.addFilter(new SizeFilter(sizefilterVal));
            }
            if ((errorForRes = this.dpFilterShapeResMap.ceilingEntry(res).getValue().doubleValue()) > 0.0) {
                filters.addFilter(new DouglasPeuckerFilter(errorForRes));
            }
        }
        filters.addFilter(new RemoveEmpty());
        filters.addFilter(new LinePreparerFilter(div));
        filters.addFilter(new ShapeAddFilter(div, map));
        for (MapShape shape : shapes) {
            if (shape.getMinResolution() > res) continue;
            filters.startFilter(shape);
        }
    }

    private static void preserveHorizontalAndVerticalLines(int res, List<MapShape> shapes) {
        if (res == 24) {
            return;
        }
        for (MapShape shape : shapes) {
            if (shape.getMinResolution() > res) continue;
            List<Coord> points = shape.getPoints();
            int n = points.size();
            IdentityHashMap<Coord, Coord> coords = new IdentityHashMap<Coord, Coord>(n);
            Coord prev = points.get(0);
            for (int i = 1; i < n; ++i) {
                Coord last = points.get(i);
                if (coords.get(last) == null) {
                    coords.put(last, last);
                } else if (!last.preserved()) {
                    last.preserved(true);
                }
                if (last.getHighPrecLat() == prev.getHighPrecLat() || last.getHighPrecLon() == prev.getHighPrecLon()) {
                    last.preserved(true);
                    prev.preserved(true);
                }
                prev = last;
            }
        }
    }

    private static int getMaxBits(MapDataSource src) {
        int topshift = Integer.numberOfLeadingZeros(src.getBounds().getMaxDimension());
        int minShift = Math.max(17 - topshift, 0);
        return 24 - minShift;
    }

    public void setEnableLineCleanFilters(boolean enable) {
        this.enableLineCleanFilters = enable;
    }

    private int getMinSizePolygonForResolution(int res) {
        if (this.polygonSizeLimitsOpt == null) {
            return this.minSizePolygon;
        }
        if (this.polygonSizeLimits == null) {
            String[] desc;
            this.polygonSizeLimits = new TreeMap();
            for (String s : desc = this.polygonSizeLimitsOpt.split("[, \\t\\n]+")) {
                String[] keyVal = s.split("[=:]");
                if (keyVal == null || keyVal.length != 2) {
                    throw new ExitException("incorrect polygon-size-limits specification " + this.polygonSizeLimitsOpt);
                }
                try {
                    int key = Integer.parseInt(keyVal[0]);
                    int value = Integer.parseInt(keyVal[1]);
                    Integer testDup = this.polygonSizeLimits.put(key, value);
                    if (testDup == null) continue;
                    throw new ExitException("duplicate resolution value in polygon-size-limits specification " + this.polygonSizeLimitsOpt);
                }
                catch (NumberFormatException e) {
                    throw new ExitException("polygon-size-limits specification not all numbers: " + s);
                }
            }
            if (this.polygonSizeLimits.get(24) == null) {
                this.polygonSizeLimits.put(24, 0);
            }
        }
        return this.polygonSizeLimits.ceilingEntry(res).getValue();
    }

    private TreeMap<Integer, Double> parseLevelOption(EnhancedProperties props, String optionName, double defaultValue) {
        String option = props.getProperty(optionName);
        TreeMap<Integer, Double> levelMap = new TreeMap<Integer, Double>();
        if (option != null) {
            String[] desc;
            for (String s : desc = option.split("[, \\t\\n]+")) {
                String[] keyVal = s.split("[=:]");
                if (keyVal == null || keyVal.length != 2) {
                    throw new ExitException("incorrect " + optionName + " specification " + option + " at " + s);
                }
                try {
                    int key = Integer.parseInt(keyVal[0]);
                    double value = Double.parseDouble(keyVal[1]);
                    Double testDup = levelMap.put(key, value);
                    if (testDup == null) continue;
                    throw new ExitException("duplicate resolution value in " + optionName + " specification " + optionName);
                }
                catch (NumberFormatException e) {
                    throw new ExitException(optionName + " specification not all numbers: " + s);
                }
            }
        }
        if (levelMap.get(24) == null) {
            levelMap.put(24, defaultValue);
        }
        return levelMap;
    }

    private void recalcMultipolygons(LoadableMapDataSource src, LevelInfo[] levels) {
        int maxRes = levels[levels.length - 1].getBits();
        LinkedHashMap mpShapes = new LinkedHashMap();
        src.getShapes().stream().filter(s -> s.getMpRel() != null && s.getMinResolution() <= maxRes).forEach(s -> mpShapes.computeIfAbsent(s.getMpRel(), k -> new ArrayList()).add(s));
        if (mpShapes.isEmpty()) {
            return;
        }
        ShapeMergeFilter.MapShapeComparator comparator = new ShapeMergeFilter.MapShapeComparator(this.orderByDecreasingArea);
        for (Map.Entry e : mpShapes.entrySet()) {
            if (((MultiPolygonRelation)e.getKey()).isNoRecalc()) continue;
            MapShape pattern = (MapShape)((List)e.getValue()).get(0);
            boolean matches = true;
            for (MapShape s2 : (List)e.getValue()) {
                if (s2.getMinResolution() == pattern.getMinResolution() && s2.getMaxResolution() == pattern.getMaxResolution() && comparator.compare(s2, pattern) == 0) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            this.buildMPRing(src, maxRes, pattern, (MultiPolygonRelation)e.getKey());
            ((List)e.getValue()).forEach(s -> s.setMinResolution(maxRes + 1));
        }
    }

    private void buildMPRing(LoadableMapDataSource src, int res, MapShape pattern, MultiPolygonRelation origMp) {
        List<MultiPolygonRelation.JoinedWay> rings = origMp.getRings();
        Way largest = origMp.getLargestOuterRing();
        int shift = 24 - res;
        int minSize = this.getMinSizePolygonForResolution(res) * (1 << shift) / 2;
        GeneralRelation gr = new GeneralRelation(FakeIdGenerator.makeFakeId());
        LinkedHashMap<Long, Way> wayMap = new LinkedHashMap<Long, Way>();
        double dpError = this.dpFilterShapeResMap.ceilingEntry(res).getValue() * (double)(1 << shift);
        for (int i = 0; i < rings.size(); ++i) {
            boolean tooSmall;
            ArrayList<Coord> poly = new ArrayList<Coord>(((Way)rings.get(i)).getPoints());
            boolean isLargest = largest == rings.get(i);
            boolean bl = tooSmall = minSize > 0 && uk.me.parabola.imgfmt.app.Area.getBBox(poly).getMaxDimension() < minSize;
            if (isLargest && tooSmall && !pattern.isSkipSizeFilter()) {
                return;
            }
            if (tooSmall) continue;
            if (dpError > 0.0 && !isLargest) {
                DouglasPeuckerFilter.douglasPeucker(poly, 0, poly.size() - 1, dpError);
            }
            if (poly.size() <= 3) continue;
            Way w = new Way(FakeIdGenerator.makeFakeId(), poly);
            wayMap.put(w.getId(), w);
            gr.addElement(UNKNOWN_CITY_NAME, w);
        }
        ArrayList<List<Coord>> list = new ArrayList<List<Coord>>();
        if (gr.getElements().isEmpty()) {
            return;
        }
        if (gr.getElements().size() == 1) {
            list.addAll(ShapeSplitter.clipToBounds(largest.getPoints(), src.getBounds(), null));
        } else {
            String codeValue = GType.formatType(pattern.getType());
            gr.addTag("code", codeValue);
            gr.addTag("expect-self-intersection", "true");
            MultiPolygonRelation mp = new MultiPolygonRelation(gr, wayMap, src.getBounds());
            mp.processElements();
            for (Way w : wayMap.values()) {
                if (!"polygon".equals(w.getTag("mkgmap:stylefilter")) || !codeValue.equals(w.getTag("code"))) continue;
                if (src.getBounds().contains(uk.me.parabola.imgfmt.app.Area.getBBox(w.getPoints()))) {
                    list.add(w.getPoints());
                    continue;
                }
                list.addAll(ShapeSplitter.clipToBounds(w.getPoints(), src.getBounds(), null));
            }
        }
        for (int i = 0; i < list.size(); ++i) {
            List poly = (List)list.get(i);
            MapShape newShape = pattern.copy();
            newShape.setPoints(poly);
            newShape.setOsmid(FakeIdGenerator.makeFakeId());
            newShape.setMaxResolution(res);
            newShape.setMpRel(null);
            src.getShapes().add(newShape);
        }
    }

    private static class ShapeAddFilter
    extends BaseFilter
    implements MapFilter {
        private final Subdivision div;
        private final uk.me.parabola.imgfmt.app.map.Map map;

        ShapeAddFilter(Subdivision div, uk.me.parabola.imgfmt.app.map.Map map) {
            this.div = div;
            this.map = map;
        }

        @Override
        public void doFilter(MapElement element, MapFilterChain next) {
            ExtTypeAttributes eta;
            MapShape shape = (MapShape)element;
            assert (shape.getPoints().size() < 255) : "too many points";
            Polygon pg = this.div.createPolygon(shape.getName());
            pg.addCoords(shape.getPoints());
            pg.setType(shape.getType());
            if (element.hasExtendedType() && (eta = element.getExtTypeAttributes()) != null) {
                eta.processLabels(this.map.getLblFile());
                pg.setExtTypeAttributes(eta);
            }
            this.map.addMapObject(pg);
        }
    }

    private static class LineAddFilter
    extends BaseFilter
    implements MapFilter {
        private final Subdivision div;
        private final uk.me.parabola.imgfmt.app.map.Map map;

        LineAddFilter(Subdivision div, uk.me.parabola.imgfmt.app.map.Map map) {
            this.div = div;
            this.map = map;
        }

        @Override
        public void doFilter(MapElement element, MapFilterChain next) {
            MapLine line = (MapLine)element;
            assert (line.getPoints().size() < 255) : "too many points";
            Polyline pl = this.div.createLine(line.getLabels());
            if (element.hasExtendedType()) {
                ExtTypeAttributes eta = element.getExtTypeAttributes();
                if (eta != null) {
                    eta.processLabels(this.map.getLblFile());
                    pl.setExtTypeAttributes(eta);
                }
            } else {
                this.div.setPolylineNumber(pl);
            }
            pl.setDirection(line.isDirection());
            pl.addCoords(line.getPoints());
            pl.setType(line.getType());
            if (this.map.getNetFile() != null && line instanceof MapRoad) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("adding road def: " + line.getName()));
                }
                MapRoad road = (MapRoad)line;
                RoadDef roaddef = road.getRoadDef();
                pl.setRoadDef(roaddef);
                if (road.hasSegmentsFollowing()) {
                    pl.setLastSegment(false);
                }
                roaddef.addPolylineRef(pl);
            }
            this.map.addMapObject(pl);
        }
    }

    private static class SourceSubdiv {
        private final MapDataSource source;
        private final Subdivision subdiv;

        SourceSubdiv(MapDataSource ds, Subdivision subdiv) {
            this.source = ds;
            this.subdiv = subdiv;
        }

        public MapDataSource getSource() {
            return this.source;
        }

        public Subdivision getSubdiv() {
            return this.subdiv;
        }
    }
}

