/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.io;

import java.io.IOException;
import java.io.InputStream;
import uk.me.parabola.io.EndOfFileException;

public class StructuredInputStream
extends InputStream {
    private final InputStream in;
    private boolean eof;

    public StructuredInputStream(InputStream in) {
        this.in = in;
    }

    @Override
    public int read() throws IOException {
        int r = this.in.read();
        if (r == -1) {
            this.eof = true;
        }
        return r;
    }

    public int read2() throws IOException {
        int a = this.read() & 0xFF;
        int b = this.read() & 0xFF;
        if (this.isEof()) {
            throw new EndOfFileException();
        }
        return (b << 8) + a;
    }

    public int read4() throws IOException {
        int a = this.read() & 0xFF;
        int b = this.read() & 0xFF;
        int c = this.read() & 0xFF;
        int d = this.read() & 0xFF;
        return d << 24 | c << 16 | b << 8 | a;
    }

    public String readString() throws IOException {
        int b;
        StringBuffer name = new StringBuffer();
        while ((b = this.read()) != 0 && b != -1) {
            name.append((char)(b & 0xFF));
        }
        return name.toString();
    }

    boolean isEof() {
        return this.eof;
    }

    public boolean testEof() {
        assert (this.in.markSupported());
        this.in.mark(1);
        try {
            int b = this.in.read();
            if (b == -1) {
                this.eof = true;
            } else {
                this.in.reset();
            }
            return this.isEof();
        }
        catch (IOException e) {
            return true;
        }
    }
}

