/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.mdxfmt;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.mdxfmt.MapInfo;
import uk.me.parabola.log.Logger;

public class MdxFile {
    private final char familyId;
    private final char productId;
    private final List<MapInfo> maps = new ArrayList<MapInfo>();

    public MdxFile(int familyId, int productId) {
        this.familyId = (char)familyId;
        this.productId = (char)productId;
    }

    public void addMap(int name, int hexname, String filename) {
        MapInfo info = new MapInfo();
        info.setHexMapname(hexname);
        info.setMapname(name);
        info.setFamilyId(this.familyId);
        info.setProductId(this.productId);
        info.setFilename(filename);
        this.maps.add(info);
    }

    public void write(String filename) throws IOException {
        try (FileOutputStream stream = new FileOutputStream(filename);
             FileChannel chan = stream.getChannel();){
            ByteBuffer buf = ByteBuffer.allocate(1024);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            this.writeHeader(chan, buf);
            this.writeBody(chan, buf);
        }
    }

    private void writeHeader(WritableByteChannel chan, ByteBuffer buf) throws IOException {
        buf.put("Midx".getBytes(StandardCharsets.US_ASCII));
        buf.putChar('d');
        buf.putInt(12);
        buf.putInt(this.maps.size());
        buf.flip();
        chan.write(buf);
    }

    private void writeBody(WritableByteChannel chan, ByteBuffer buf) throws IOException {
        this.maps.sort((o1, o2) -> Integer.compare(o1.getHexMapname(), o2.getHexMapname()));
        for (MapInfo info : this.maps) {
            if (info.getHexMapname() == 0 || info.getMapname() == 0) {
                Logger.defaultLogger.error((Object)("Invalid mapname for " + info.getFilename() + ", perhaps it is not a .img file"));
            }
            buf.compact();
            info.write(buf);
            buf.flip();
            chan.write(buf);
        }
    }
}

