/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.net;

import java.util.HashMap;
import java.util.LinkedHashMap;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.net.RoadDef;
import uk.me.parabola.imgfmt.app.net.RouteArc;
import uk.me.parabola.log.Logger;

public class TableA {
    private static final Logger log = Logger.getLogger(TableA.class);
    private static final int ITEM_SIZE = 5;
    private int offset;
    private final HashMap<RoadDef, Integer> roundaboutArcs = new LinkedHashMap<RoadDef, Integer>();
    private final HashMap<RoadDef, Integer> unpavedArcs = new LinkedHashMap<RoadDef, Integer>();
    private final HashMap<RoadDef, Integer> ferryArcs = new LinkedHashMap<RoadDef, Integer>();
    private final HashMap<RoadDef, Integer> pavedArcs = new LinkedHashMap<RoadDef, Integer>();
    private static int count;
    private boolean frozen;

    public TableA() {
        log.debug("creating TableA", count);
        ++count;
    }

    public void addArc(RouteArc arc) {
        assert (!this.frozen) : "trying to add arc to Table A after it has been frozen";
        RoadDef rd = arc.getRoadDef();
        if (rd.isRoundabout()) {
            if (!this.roundaboutArcs.containsKey(rd)) {
                int i = this.roundaboutArcs.size();
                this.roundaboutArcs.put(rd, i);
                log.debug("added roundabout arc", count, rd, i);
            }
        } else if (rd.ferry()) {
            if (!this.ferryArcs.containsKey(rd)) {
                int i = this.ferryArcs.size();
                this.ferryArcs.put(rd, i);
                log.debug("added ferry arc", count, rd, i);
            }
        } else if (rd.paved()) {
            if (!this.pavedArcs.containsKey(rd)) {
                int i = this.pavedArcs.size();
                this.pavedArcs.put(rd, i);
                log.debug("added paved arc", count, rd, i);
            }
        } else if (!this.unpavedArcs.containsKey(rd)) {
            int i = this.unpavedArcs.size();
            this.unpavedArcs.put(rd, i);
            log.debug("added unpaved arc", count, rd, i);
        }
    }

    public int getIndex(RouteArc arc) {
        int i;
        this.frozen = true;
        RoadDef rd = arc.getRoadDef();
        if (rd.isRoundabout()) {
            assert (this.roundaboutArcs.containsKey(rd)) : "Trying to read Table A index for non-registered arc: " + count + " " + rd;
            i = this.roundaboutArcs.get(rd);
        } else if (rd.ferry()) {
            assert (this.ferryArcs.containsKey(rd)) : "Trying to read Table A index for non-registered arc: " + count + " " + rd;
            i = this.roundaboutArcs.size() + this.unpavedArcs.size() + this.ferryArcs.get(rd);
        } else if (rd.paved()) {
            assert (this.pavedArcs.containsKey(rd)) : "Trying to read Table A index for non-registered arc: " + count + " " + rd;
            i = this.roundaboutArcs.size() + this.unpavedArcs.size() + this.ferryArcs.size() + this.pavedArcs.get(rd);
        } else {
            assert (this.unpavedArcs.containsKey(rd)) : "Trying to read Table A index for non-registered arc: " + count + " " + rd;
            i = this.roundaboutArcs.size() + this.unpavedArcs.get(rd);
        }
        assert (i < 256) : "Table A index too large: " + rd;
        return i;
    }

    public int size() {
        return this.roundaboutArcs.size() + this.unpavedArcs.size() + this.ferryArcs.size() + this.pavedArcs.size();
    }

    public int numRoundaboutArcs() {
        return this.roundaboutArcs.size();
    }

    public int numUnpavedArcs() {
        return this.unpavedArcs.size();
    }

    public int numFerryArcs() {
        return this.ferryArcs.size();
    }

    public int getNumberOfItems() {
        assert (this.size() < 256) : "Table A too large";
        return this.size();
    }

    public void write(ImgFileWriter writer) {
        this.offset = writer.position();
        int size = this.size() * 5;
        log.debug("tab a offset", this.offset, "tab a size", size);
        for (int i = 0; i < size; ++i) {
            writer.put1u(0);
        }
    }

    public void writePost(ImgFileWriter writer) {
        writer.position(this.offset);
        for (RoadDef rd : this.roundaboutArcs.keySet()) {
            this.writePost(writer, rd);
        }
        for (RoadDef rd : this.unpavedArcs.keySet()) {
            this.writePost(writer, rd);
        }
        for (RoadDef rd : this.ferryArcs.keySet()) {
            this.writePost(writer, rd);
        }
        for (RoadDef rd : this.pavedArcs.keySet()) {
            this.writePost(writer, rd);
        }
    }

    public void writePost(ImgFileWriter writer, RoadDef rd) {
        int pos = rd.getOffsetNet1();
        int access = rd.getTabAAccess();
        int ACCESS_TOP_BITS = 49152;
        pos |= (access & 0xC000) << 8;
        writer.put3u(pos);
        writer.put1u(rd.getTabAInfo());
        writer.put1u(access &= 0xFFFF3FFF);
    }
}

