/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.net;

import uk.me.parabola.imgfmt.app.CommonHeader;
import uk.me.parabola.imgfmt.app.ImgFileReader;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.Section;
import uk.me.parabola.imgfmt.app.SectionWriter;

public class NETHeader
extends CommonHeader {
    public static final int HEADER_LEN = 55;
    private static final char SORTED_ROAD_RECSIZE = '\u0003';
    private final Section roadDefinitions = new Section();
    private final Section segmentedRoads = new Section(this.roadDefinitions);
    private final Section sortedRoads = new Section(this.segmentedRoads, 3);
    private int roadShift;
    private int segmentShift;

    public NETHeader() {
        super(55, "GARMIN NET");
    }

    @Override
    protected void readFileHeader(ImgFileReader reader) {
        this.roadDefinitions.readSectionInfo(reader, false);
        this.roadShift = reader.get1u();
        this.segmentedRoads.readSectionInfo(reader, false);
        this.segmentShift = reader.get1u();
        this.sortedRoads.readSectionInfo(reader, true);
        reader.get4();
        reader.get();
        reader.get();
    }

    @Override
    protected void writeFileHeader(ImgFileWriter writer) {
        this.roadDefinitions.writeSectionInfo(writer);
        writer.put1u(this.roadShift);
        this.segmentedRoads.writeSectionInfo(writer);
        writer.put1u(this.segmentShift);
        this.sortedRoads.writeSectionInfo(writer);
        writer.put4(0);
        writer.put1u(1);
        writer.put1u(0);
    }

    ImgFileWriter makeRoadWriter(ImgFileWriter writer) {
        this.roadDefinitions.setPosition(writer.position());
        return new SectionWriter(writer, this.roadDefinitions);
    }

    ImgFileWriter makeSortedRoadWriter(ImgFileWriter writer) {
        this.sortedRoads.setPosition(writer.position());
        return new SectionWriter(writer, this.sortedRoads);
    }

    public int getRoadDefinitionsStart() {
        return this.roadDefinitions.getPosition();
    }

    public int getSortedRoadsStart() {
        return this.sortedRoads.getPosition();
    }

    public int getSortedRoadsEnd() {
        return this.sortedRoads.getEndPos();
    }

    public int getRoadShift() {
        return this.roadShift;
    }
}

