/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.mdr.HasHeaderFlags;
import uk.me.parabola.imgfmt.app.mdr.Mdr7Record;
import uk.me.parabola.imgfmt.app.mdr.MdrMapSection;

public abstract class Mdr2x
extends MdrMapSection
implements HasHeaderFlags {
    protected List<Mdr7Record> streets = new ArrayList<Mdr7Record>();
    protected static final int HAS_LABEL = 2;
    protected static final int HAS_NAME_OFFSET = 4;

    @Override
    public void writeSectData(ImgFileWriter writer) {
        Mdr7Record prev = null;
        Collator collator = this.getConfig().getSort().getCollator();
        collator.setStrength(1);
        int size = this.getSizes().getStreetSizeFlagged();
        int magic = this.getExtraValue();
        boolean writeLabel = (magic & 2) != 0;
        boolean writeNameOffset = (magic & 4) != 0;
        int partialInfoSize = magic >> 3 & 7;
        int recordNumber = 0;
        for (Mdr7Record street : this.streets) {
            int rr;
            assert (street.getMapIndex() == street.getCity().getMapIndex()) : street.getMapIndex() + "/" + street.getCity().getMapIndex();
            this.addIndexPointer(street.getMapIndex(), ++recordNumber);
            int repeat = 1;
            if (writeLabel) {
                rr = street.checkRepeat(prev, collator);
                this.putMapIndex(writer, street.getMapIndex());
                int offset = street.getLabelOffset();
                if (rr == 3 && this.sameGroup(street, prev)) {
                    repeat = 0;
                }
                if (repeat != 0) {
                    offset |= 0x800000;
                }
                writer.put3u(offset);
                if (writeNameOffset) {
                    writer.put1u(street.getOutNameOffset());
                }
                if (partialInfoSize > 0) {
                    int trailingFlags = (rr & 1) == 0 ? 1 : 0;
                    writer.putNu(partialInfoSize, trailingFlags);
                }
            } else {
                rr = street.checkFullRepeat(prev, collator);
                if (rr == 2 && this.sameGroup(street, prev)) {
                    repeat = 0;
                }
                int index = street.getIndex();
                writer.putNu(size, index << 1 | repeat);
            }
            prev = street;
        }
    }

    @Override
    public int getItemSize() {
        int magic = this.getExtraValue();
        int partialInfoSize = magic >> 3 & 7;
        int size = this.isForDevice() ? this.getSizes().getMapSize() + 3 + 1 + partialInfoSize : this.getSizes().getStreetSizeFlagged();
        return size;
    }

    @Override
    protected int numberOfItems() {
        return this.streets.size();
    }

    @Override
    protected void releaseMemory() {
        this.streets = null;
    }

    protected abstract boolean sameGroup(Mdr7Record var1, Mdr7Record var2);
}

