/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.mdr.Mdr13Record;
import uk.me.parabola.imgfmt.app.mdr.MdrConfig;
import uk.me.parabola.imgfmt.app.mdr.MdrSection;
import uk.me.parabola.imgfmt.app.mdr.MdrUtils;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.imgfmt.app.srt.SortKey;

public class Mdr23
extends MdrSection {
    private final List<Mdr13Record> regions = new ArrayList<Mdr13Record>();

    public Mdr23(MdrConfig config) {
        this.setConfig(config);
    }

    public void sortRegions(List<Mdr13Record> list) {
        Sort sort = this.getConfig().getSort();
        List<SortKey<Mdr13Record>> keys = MdrUtils.sortList(sort, list);
        String lastName = null;
        int lastMapIndex = 0;
        int record = 0;
        for (SortKey<Mdr13Record> key : keys) {
            Mdr13Record reg = key.getObject();
            String name = reg.getName();
            if (reg.getMapIndex() == lastMapIndex && name.equals(lastName)) continue;
            reg.getMdr28().setMdr23(++record);
            this.regions.add(reg);
            lastName = name;
            lastMapIndex = reg.getMapIndex();
        }
    }

    @Override
    public void writeSectData(ImgFileWriter writer) {
        String lastName = null;
        for (Mdr13Record reg : this.regions) {
            this.putMapIndex(writer, reg.getMapIndex());
            int flag = 0;
            String name = reg.getName();
            if (!name.equals(lastName)) {
                flag = 0x800000;
                lastName = name;
            }
            writer.put2u(reg.getRegionIndex());
            writer.put2u(reg.getCountryIndex());
            writer.put3u(reg.getLblOffset() | flag);
        }
    }

    @Override
    public int getItemSize() {
        MdrSection.PointerSizes sizes = this.getSizes();
        return sizes.getMapSize() + 2 + 2 + 3;
    }

    @Override
    protected int numberOfItems() {
        return this.regions.size();
    }
}

