/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.mdr.HasHeaderFlags;
import uk.me.parabola.imgfmt.app.mdr.Mdr14Record;
import uk.me.parabola.imgfmt.app.mdr.MdrConfig;
import uk.me.parabola.imgfmt.app.mdr.MdrSection;

public class Mdr14
extends MdrSection
implements HasHeaderFlags {
    private final List<Mdr14Record> countries = new ArrayList<Mdr14Record>();

    public Mdr14(MdrConfig config) {
        this.setConfig(config);
    }

    @Override
    public void writeSectData(ImgFileWriter writer) {
        this.countries.sort(null);
        for (Mdr14Record country : this.countries) {
            this.putMapIndex(writer, country.getMapIndex());
            writer.put2u(country.getCountryIndex());
            this.putStringOffset(writer, country.getStrOff());
        }
    }

    public void addCountry(Mdr14Record country) {
        this.countries.add(country);
    }

    @Override
    public int getItemSize() {
        MdrSection.PointerSizes sizes = this.getSizes();
        return sizes.getMapSize() + 2 + sizes.getStrOffSize();
    }

    @Override
    protected int numberOfItems() {
        return this.countries.size();
    }

    @Override
    public int getExtraValue() {
        return 0;
    }

    public List<Mdr14Record> getCountries() {
        return this.countries;
    }
}

