/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.lbl;

import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.Label;
import uk.me.parabola.imgfmt.app.lbl.Region;
import uk.me.parabola.imgfmt.app.trergn.Subdivision;

public class Highway {
    private final int index;
    private final Region region;
    private final List<ExitPoint> exits = new ArrayList<ExitPoint>();
    private Label label;
    private int extraDataOffset;

    public Highway(Region region, int index) {
        this.region = region;
        this.index = index;
    }

    void write(ImgFileWriter writer, boolean extraData) {
        if (extraData) {
            writer.put1u(0);
            writer.put2u(this.region == null ? 0 : this.region.getIndex());
            this.exits.sort(null);
            for (ExitPoint ep : this.exits) {
                writer.put1u(ep.index);
                writer.put2u(ep.div.getNumber());
            }
        } else {
            assert (this.extraDataOffset != 0);
            writer.put3u(this.label.getOffset());
            writer.put2u(this.extraDataOffset);
            writer.put1u(0);
        }
    }

    public int getIndex() {
        return this.index;
    }

    public void setLabel(Label label) {
        this.label = label;
    }

    public void setExtraDataOffset(int extraDataOffset) {
        this.extraDataOffset = extraDataOffset / 3 + 1;
    }

    public int getExtraDataSize() {
        return (1 + this.exits.size()) * 3;
    }

    public void addExitPoint(String name, int index, Subdivision div) {
        this.exits.add(new ExitPoint(name, index, div));
    }

    class ExitPoint
    implements Comparable<ExitPoint> {
        final String name;
        final int index;
        final Subdivision div;

        public ExitPoint(String name, int index, Subdivision div) {
            this.name = name;
            this.index = index;
            this.div = div;
        }

        @Override
        public int compareTo(ExitPoint o) {
            return this.name.compareTo(o.name);
        }
    }
}

