/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.dem;

import java.util.List;
import uk.me.parabola.imgfmt.ExitException;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.BufferedImgFileReader;
import uk.me.parabola.imgfmt.app.BufferedImgFileWriter;
import uk.me.parabola.imgfmt.app.ImgFile;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.dem.DEMHeader;
import uk.me.parabola.imgfmt.app.dem.DEMSection;
import uk.me.parabola.imgfmt.fs.ImgChannel;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.reader.hgt.HGTConverter;

public class DEMFile
extends ImgFile {
    private static final Logger log = Logger.getLogger(DEMFile.class);
    public static final double EXTRA = 0.1;
    protected static final double FACTOR = 8.381903171539307E-8;
    private final DEMHeader demHeader = new DEMHeader();

    public DEMFile(ImgChannel chan, boolean write) {
        this.setHeader(this.demHeader);
        if (write) {
            this.setWriter(new BufferedImgFileWriter(chan, "DEM"));
            this.position(41L);
        } else {
            this.setReader(new BufferedImgFileReader(chan));
            this.demHeader.readHeader(this.getReader());
        }
    }

    public Area calc(Area area, java.awt.geom.Area demPolygonMapUnits, String pathsToHGT, List<Integer> pointDistances, short outsidePolygonHeight, HGTConverter.InterpolationMethod interpolationMethod) {
        HGTConverter hgtConverter = new HGTConverter(pathsToHGT, area, demPolygonMapUnits, 0.1);
        hgtConverter.setInterpolationMethod(interpolationMethod);
        hgtConverter.setOutsidePolygonHeight(outsidePolygonHeight);
        log.info("orig bounds", area);
        int alignment = 4;
        Area treArea = this.calcTREBounds(area, alignment);
        log.info("TRE bounds", treArea);
        int top = treArea.getMaxLat() * 256;
        int bottom = treArea.getMinLat() * 256;
        int left = treArea.getMinLong() * 256;
        int right = treArea.getMaxLong() * 256;
        int zoom = 0;
        int lastDist = pointDistances.get(pointDistances.size() - 1);
        for (int pointDist : pointDistances) {
            int distance = pointDist;
            if (distance == -1) {
                int res = hgtConverter.getHighestRes() > 0 ? hgtConverter.getHighestRes() : 1200;
                distance = (int)Math.round(5.36870912E8 / ((double)res * 45.0));
            }
            if ((distance = (distance + 8) / 16 * 16) == 0) {
                throw new ExitException("DEM distance is zero");
            }
            int xTop = top;
            int xLeft = left;
            if (distance < (int)Math.floor(1193046.471111111)) {
                xTop = this.moveUp(top, distance);
                xLeft = this.moveLeft(left, distance);
            }
            DEMSection section = new DEMSection(zoom++, xTop, xLeft, xTop - bottom, right - xLeft, hgtConverter, distance, pointDist == lastDist);
            this.demHeader.addSection(section);
        }
        return treArea;
    }

    private Area calcTREBounds(Area area, int alignment) {
        int treTop = area.getMaxLat() + 1;
        int treLeft = area.getMinLong() - 1;
        int treBottom = area.getMinLat() + 1;
        int treRight = area.getMaxLong() - 1;
        while (treTop % alignment != 0) {
            ++treTop;
        }
        while (treLeft % alignment != 0) {
            --treLeft;
        }
        while (treBottom % alignment != 0) {
            ++treBottom;
        }
        while (treRight % alignment != 0) {
            --treRight;
        }
        treBottom -= alignment;
        treRight += alignment;
        treRight = Math.min(treRight, Utils.MAX_LON_MAP_UNITS);
        treLeft = Math.max(treLeft, Utils.MIN_LON_MAP_UNITS);
        treTop = Math.min(treTop, Utils.MAX_LAT_MAP_UNITS);
        treBottom = Math.max(treBottom, Utils.MIN_LAT_MAP_UNITS);
        Area treArea = new Area(treBottom, treLeft, treTop, treRight);
        return treArea;
    }

    int moveUp(int origLat32, int distance) {
        int moved = origLat32;
        if (moved >= 0) {
            if ((moved -= moved % distance) < 0x3FFFFFFF - distance) {
                moved += distance;
            }
        } else {
            moved -= moved % distance;
        }
        return moved;
    }

    int moveLeft(int origLon32, int distance) {
        int moved = origLon32;
        if (moved >= 0) {
            moved -= moved % distance;
        } else if ((moved -= moved % distance) > Integer.MIN_VALUE + distance) {
            moved -= distance;
        }
        return moved;
    }

    public void write() {
        ImgFileWriter w = this.getWriter();
        if (w instanceof BufferedImgFileWriter) {
            ((BufferedImgFileWriter)w).setMaxSize(0xFFFFFFFL);
        }
        this.getHeader().writeHeader(this.getWriter());
    }
}

