/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.bucketing;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.optimizer.BuildLeft$;
import org.apache.spark.sql.catalyst.optimizer.BuildSide;
import org.apache.spark.sql.catalyst.plans.physical.HashPartitioning;
import org.apache.spark.sql.catalyst.plans.physical.Partitioning;
import org.apache.spark.sql.catalyst.plans.physical.PartitioningCollection;
import org.apache.spark.sql.execution.FileSourceScanExec;
import org.apache.spark.sql.execution.FilterExec;
import org.apache.spark.sql.execution.ProjectExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.joins.BroadcastHashJoinExec;
import org.apache.spark.sql.execution.joins.BroadcastNestedLoopJoinExec;
import org.apache.spark.sql.execution.joins.ShuffledJoin;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class ExtractJoinWithBuckets$ {
    public static final ExtractJoinWithBuckets$ MODULE$ = new ExtractJoinWithBuckets$();

    private boolean hasScanOperation(SparkPlan plan) {
        SparkPlan sparkPlan;
        while (true) {
            if ((sparkPlan = plan) instanceof FilterExec) {
                FilterExec filterExec = (FilterExec)sparkPlan;
                plan = filterExec.child();
                continue;
            }
            if (sparkPlan instanceof ProjectExec) {
                ProjectExec projectExec = (ProjectExec)sparkPlan;
                plan = projectExec.child();
                continue;
            }
            if (sparkPlan instanceof BroadcastHashJoinExec) {
                BroadcastHashJoinExec broadcastHashJoinExec = (BroadcastHashJoinExec)sparkPlan;
                BuildSide buildSide = broadcastHashJoinExec.buildSide();
                BuildLeft$ buildLeft$ = BuildLeft$.MODULE$;
                if (!(buildSide != null ? !buildSide.equals(buildLeft$) : buildLeft$ != null)) {
                    plan = broadcastHashJoinExec.right();
                    continue;
                }
                plan = broadcastHashJoinExec.left();
                continue;
            }
            if (!(sparkPlan instanceof BroadcastNestedLoopJoinExec)) break;
            BroadcastNestedLoopJoinExec broadcastNestedLoopJoinExec = (BroadcastNestedLoopJoinExec)sparkPlan;
            BuildSide buildSide = broadcastNestedLoopJoinExec.buildSide();
            BuildLeft$ buildLeft$ = BuildLeft$.MODULE$;
            if (!(buildSide != null ? !buildSide.equals(buildLeft$) : buildLeft$ != null)) {
                plan = broadcastNestedLoopJoinExec.right();
                continue;
            }
            plan = broadcastNestedLoopJoinExec.left();
        }
        if (sparkPlan instanceof FileSourceScanExec) {
            FileSourceScanExec fileSourceScanExec = (FileSourceScanExec)sparkPlan;
            return fileSourceScanExec.relation().bucketSpec().nonEmpty();
        }
        return false;
    }

    private Option<BucketSpec> getBucketSpec(SparkPlan plan) {
        return plan.collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                FileSourceScanExec fileSourceScanExec;
                A1 A1 = x1;
                if (A1 instanceof FileSourceScanExec && (fileSourceScanExec = (FileSourceScanExec)A1).relation().bucketSpec().nonEmpty() && fileSourceScanExec.optionalNumCoalescedBuckets().isEmpty()) {
                    return (B1)fileSourceScanExec.relation().bucketSpec().get();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                FileSourceScanExec fileSourceScanExec;
                SparkPlan sparkPlan = x1;
                return sparkPlan instanceof FileSourceScanExec && (fileSourceScanExec = (FileSourceScanExec)sparkPlan).relation().bucketSpec().nonEmpty() && fileSourceScanExec.optionalNumCoalescedBuckets().isEmpty();
            }
        });
    }

    private boolean satisfiesOutputPartitioning(Seq<Expression> keys, Partitioning partitioning2) {
        HashPartitioning hashPartitioning;
        Seq exprs;
        Partitioning partitioning3 = partitioning2;
        if (partitioning3 instanceof HashPartitioning && (exprs = (hashPartitioning = (HashPartitioning)partitioning3).expressions()).length() == keys.length()) {
            return exprs.forall((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)keys.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.semanticEquals(e)))));
        }
        if (partitioning3 instanceof PartitioningCollection) {
            PartitioningCollection partitioningCollection = (PartitioningCollection)partitioning3;
            Seq partitionings = partitioningCollection.partitionings();
            return partitionings.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ExtractJoinWithBuckets$.MODULE$.satisfiesOutputPartitioning((Seq<Expression>)keys, x$2)));
        }
        return false;
    }

    private boolean isApplicable(ShuffledJoin j) {
        return this.hasScanOperation((SparkPlan)j.left()) && this.hasScanOperation((SparkPlan)j.right()) && this.satisfiesOutputPartitioning(j.leftKeys(), ((SparkPlan)j.left()).outputPartitioning()) && this.satisfiesOutputPartitioning(j.rightKeys(), ((SparkPlan)j.right()).outputPartitioning());
    }

    private boolean isDivisible(int numBuckets1, int numBuckets2) {
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(package$.MODULE$.min(numBuckets1, numBuckets2), package$.MODULE$.max(numBuckets1, numBuckets2));
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        int small = sp2._1$mcI$sp();
        int large = sp2._2$mcI$sp();
        Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(small, large);
        int small2 = sp3._1$mcI$sp();
        int large2 = sp3._2$mcI$sp();
        return numBuckets1 != numBuckets2 && large2 % small2 == 0;
    }

    public Option<Tuple3<ShuffledJoin, Object, Object>> unapply(SparkPlan plan) {
        ShuffledJoin shuffledJoin;
        SparkPlan sparkPlan = plan;
        if (sparkPlan instanceof ShuffledJoin && this.isApplicable(shuffledJoin = (ShuffledJoin)((Object)sparkPlan))) {
            Option<BucketSpec> leftBucket = this.getBucketSpec((SparkPlan)shuffledJoin.left());
            Option<BucketSpec> rightBucket = this.getBucketSpec((SparkPlan)shuffledJoin.right());
            if (leftBucket.isDefined() && rightBucket.isDefined() && this.isDivisible(((BucketSpec)leftBucket.get()).numBuckets(), ((BucketSpec)rightBucket.get()).numBuckets())) {
                return new Some((Object)new Tuple3((Object)shuffledJoin, (Object)BoxesRunTime.boxToInteger((int)((BucketSpec)leftBucket.get()).numBuckets()), (Object)BoxesRunTime.boxToInteger((int)((BucketSpec)rightBucket.get()).numBuckets())));
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    private ExtractJoinWithBuckets$() {
    }
}

